/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.federated.monitoring.models;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.CoordinatorConnectionModel;
import org.apache.sysds.runtime.controlprogram.federated.monitoring.models.EventStageModel;

public class EventModel
extends CoordinatorConnectionModel {
    private static final long serialVersionUID = -5597621916956632690L;
    public Long workerId;
    private String coordinatorName;
    public List<EventStageModel> stages;
    private static final String JsonFormat = "{\"coordinatorName\": \"%s\",\"stages\": [%s]}";

    public EventModel() {
        this(-1L);
    }

    private EventModel(Long id) {
        this.id = id;
        this.stages = new ArrayList<EventStageModel>();
    }

    public EventModel(Long workerId, Long coordinatorId) {
        this(-1L, workerId, coordinatorId);
    }

    public EventModel(Long id, Long workerId, Long coordinatorId) {
        this.id = id;
        this.workerId = workerId;
        this.coordinatorId = coordinatorId;
        this.stages = new ArrayList<EventStageModel>();
    }

    public void setCoordinatorName(String name) {
        this.coordinatorName = name;
    }

    public String toString() {
        String stagesStr = this.stages.stream().map(EventStageModel::toString).collect(Collectors.joining(","));
        return String.format(JsonFormat, this.coordinatorName, stagesStr);
    }
}

