/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.resource.enumeration;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import org.apache.sysds.resource.CloudInstance;

public class EnumerationUtils {

    public static class SolutionPoint
    extends ConfigurationPoint {
        double timeCost;
        double monetaryCost;

        public SolutionPoint(ConfigurationPoint inputPoint, double timeCost, double monetaryCost) {
            super(inputPoint.driverInstance, inputPoint.executorInstance, inputPoint.numberExecutors);
            this.timeCost = timeCost;
            this.monetaryCost = monetaryCost;
        }

        public void update(ConfigurationPoint point, double timeCost, double monetaryCost) {
            this.driverInstance = point.driverInstance;
            this.executorInstance = point.executorInstance;
            this.numberExecutors = point.numberExecutors;
            this.timeCost = timeCost;
            this.monetaryCost = monetaryCost;
        }

        public double getTimeCost() {
            return this.timeCost;
        }

        public double getMonetaryCost() {
            return this.monetaryCost;
        }
    }

    public static class ConfigurationPoint {
        public CloudInstance driverInstance;
        public CloudInstance executorInstance;
        public int numberExecutors;

        public ConfigurationPoint(CloudInstance driverInstance) {
            this.driverInstance = driverInstance;
            this.executorInstance = null;
            this.numberExecutors = 0;
        }

        public ConfigurationPoint(CloudInstance driverInstance, CloudInstance executorInstance, int numberExecutors) {
            this.driverInstance = driverInstance;
            this.executorInstance = executorInstance;
            this.numberExecutors = numberExecutors;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Driver: ").append(this.driverInstance.getInstanceName());
            builder.append("\n\tmem: ").append((double)this.driverInstance.getMemory() / 1.073741824E9);
            builder.append(", v. cores: ").append(this.driverInstance.getVCPUs());
            builder.append("\nExecutors: ");
            if (this.numberExecutors > 0) {
                builder.append(this.numberExecutors).append(" x ").append(this.executorInstance.getInstanceName());
                builder.append("\n\tmem: ").append((double)this.executorInstance.getMemory() / 1.073741824E9);
                builder.append(", v. cores: ").append(this.executorInstance.getVCPUs());
            } else {
                builder.append("-");
            }
            return builder.toString();
        }
    }

    public static class InstanceSearchSpace
    extends TreeMap<Long, TreeMap<Integer, LinkedList<CloudInstance>>> {
        private static final long serialVersionUID = -8855424955793322839L;

        public void initSpace(HashMap<String, CloudInstance> instances) {
            for (CloudInstance instance : instances.values()) {
                long currentMemory = instance.getMemory();
                this.putIfAbsent(currentMemory, new TreeMap());
                TreeMap currentSubTree = (TreeMap)this.get(currentMemory);
                currentSubTree.putIfAbsent(instance.getVCPUs(), new LinkedList());
                LinkedList currentList = (LinkedList)currentSubTree.get(instance.getVCPUs());
                currentList.add(instance);
                currentList.sort(Comparator.comparingDouble(CloudInstance::getPrice));
            }
        }
    }
}

