/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopsException;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class BinaryM
extends Lop {
    private Types.OpOp2 _operation;
    private VectorType _vectorType = null;

    public BinaryM(Lop input1, Lop input2, Types.OpOp2 op, Types.DataType dt, Types.ValueType vt, Types.ExecType et, boolean colVector) {
        super(Lop.Type.Binary, dt, vt);
        this._operation = op;
        this._vectorType = colVector ? VectorType.COL_VECTOR : VectorType.ROW_VECTOR;
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        if (et != Types.ExecType.SPARK) {
            throw new LopsException("Incorrect execution type for BinaryM lop:" + et.name());
        }
        this.lps.setProperties(this.inputs, Types.ExecType.SPARK);
    }

    @Override
    public String toString() {
        return " Operation: " + this._operation;
    }

    @Override
    public Lop getBroadcastInput() {
        if (this.getExecType() != Types.ExecType.SPARK) {
            return null;
        }
        return (Lop)this.inputs.get(1);
    }

    public Types.OpOp2 getOperationType() {
        return this._operation;
    }

    private String getOpcode() {
        return BinaryM.getOpcode(this._operation);
    }

    public static String getOpcode(Types.OpOp2 op) {
        return "map" + op.toString();
    }

    public static boolean isOpcode(String opcode) {
        return opcode.equals(Opcodes.MAPPLUS.toString()) || opcode.equals(Opcodes.MAPMINUS.toString()) || opcode.equals(Opcodes.MAPMULT.toString()) || opcode.equals(Opcodes.MAPDIV.toString()) || opcode.equals(Opcodes.MAPMOD.toString()) || opcode.equals(Opcodes.MAPINTDIV.toString()) || opcode.equals(Opcodes.MAPLT.toString()) || opcode.equals(Opcodes.MAPLE.toString()) || opcode.equals(Opcodes.MAPGT.toString()) || opcode.equals(Opcodes.MAPGE.toString()) || opcode.equals(Opcodes.MAPEQ.toString()) || opcode.equals(Opcodes.MAPNEQ.toString()) || opcode.equals(Opcodes.MAPAND.toString()) || opcode.equals(Opcodes.MAPOR.toString()) || opcode.equals(Opcodes.MAPMIN.toString()) || opcode.equals(Opcodes.MAPMAX.toString()) || opcode.equals(Opcodes.MAPPOW.toString()) || opcode.equals(Opcodes.MAPMINUS1_MULT.toString());
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        return InstructionUtils.concatOperands(this.getExecType().name(), this.getOpcode(), this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.prepOutputOperand(output), "RIGHT", this._vectorType.name());
    }

    public static enum VectorType {
        COL_VECTOR,
        ROW_VECTOR;

    }
}

