/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class AppendM
extends Lop {
    public static final String OPCODE = Opcodes.MAPPEND.toString();
    private boolean _cbind = true;

    public AppendM(Lop input1, Lop input2, Lop input3, Types.DataType dt, Types.ValueType vt, boolean cbind, boolean partitioned, Types.ExecType et) {
        super(Lop.Type.Append, dt, vt);
        this.init(input1, input2, input3, dt, vt, et);
        this._cbind = cbind;
    }

    public void init(Lop input1, Lop input2, Lop input3, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        this.addInput(input1);
        input1.addOutput(this);
        this.addInput(input2);
        input2.addOutput(this);
        this.addInput(input3);
        input3.addOutput(this);
        this.lps.setProperties(this.inputs, Types.ExecType.SPARK);
    }

    @Override
    public Lop getBroadcastInput() {
        if (this.getExecType() != Types.ExecType.SPARK) {
            return null;
        }
        return this.getInputs().get(1);
    }

    @Override
    public String toString() {
        return "Operation = AppendM";
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        return InstructionUtils.concatOperands(this.getExecType().name(), OPCODE, this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.getInputs().get(2).prepScalarInputOperand(this.getExecType()), this.prepOutputOperand(output), String.valueOf(this._cbind));
    }

    public static enum CacheType {
        RIGHT,
        RIGHT_PART;

    }
}

