/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.lops;

import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.LopsException;
import org.apache.sysds.runtime.instructions.InstructionUtils;

public class CumulativePartialAggregate
extends Lop {
    private Types.AggOp _op;

    public CumulativePartialAggregate(Lop input, Types.DataType dt, Types.ValueType vt, Types.AggOp op, Types.ExecType et) {
        super(Lop.Type.CumulativePartialAggregate, dt, vt);
        if (op != Types.AggOp.SUM && op != Types.AggOp.PROD && op != Types.AggOp.SUM_PROD && op != Types.AggOp.MIN && op != Types.AggOp.MAX) {
            throw new LopsException("Unsupported aggregate operation type: " + op);
        }
        this._op = op;
        this.init(input, dt, vt, et);
    }

    private void init(Lop input, Types.DataType dt, Types.ValueType vt, Types.ExecType et) {
        this.addInput(input);
        input.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return "CumulativePartialAggregate";
    }

    private String getOpcode() {
        switch (this._op) {
            case SUM: {
                return Opcodes.UCUMACKP.toString();
            }
            case PROD: {
                return Opcodes.UCUMACM.toString();
            }
            case SUM_PROD: {
                return Opcodes.UCUMACPM.toString();
            }
            case MIN: {
                return Opcodes.UCUMACMIN.toString();
            }
            case MAX: {
                return Opcodes.UCUMACMAX.toString();
            }
        }
        return null;
    }

    @Override
    public String getInstructions(String input, String output) {
        return InstructionUtils.concatOperands(this.getExecType().name(), this.getOpcode(), this.getInputs().get(0).prepInputOperand(input), this.prepOutputOperand(output));
    }
}

