/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Map;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.internal.services.ComponentModelSource;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.services.ComponentClasses;
import org.apache.tapestry5.services.InvalidationEventHub;
import org.apache.tapestry5.services.MetaDataLocator;

public class MetaDataLocatorImpl
implements MetaDataLocator {
    private final SymbolSource symbolSource;
    private final TypeCoercer typeCoercer;
    private final ComponentModelSource modelSource;
    private final Map<String, Map<String, String>> defaultsByFolder = CollectionFactory.newCaseInsensitiveMap();
    private final Map<String, String> cache = CollectionFactory.newConcurrentMap();

    public MetaDataLocatorImpl(SymbolSource symbolSource, TypeCoercer typeCoercer, ComponentModelSource modelSource, Map<String, String> configuration) {
        this.symbolSource = symbolSource;
        this.typeCoercer = typeCoercer;
        this.modelSource = modelSource;
        this.loadDefaults(configuration);
    }

    @PostInjection
    public void setupInvalidation(@ComponentClasses InvalidationEventHub invalidationEventHub) {
        invalidationEventHub.clearOnInvalidation(this.cache);
    }

    private void loadDefaults(Map<String, String> configuration) {
        for (Map.Entry<String, String> e : configuration.entrySet()) {
            String key = e.getKey();
            int colonx = key.indexOf(58);
            String folderKey = colonx < 0 ? "" : key.substring(0, colonx);
            Map forFolder = this.defaultsByFolder.get(folderKey);
            if (forFolder == null) {
                forFolder = CollectionFactory.newCaseInsensitiveMap();
                this.defaultsByFolder.put(folderKey, forFolder);
            }
            String defaultKey = colonx < 0 ? key : key.substring(colonx + 1);
            forFolder.put(defaultKey, e.getValue());
        }
    }

    @Override
    public <T> T findMeta(String key, final ComponentResources resources, Class<T> expectedType) {
        String value = this.getSymbolExpandedValueFromCache(key, resources.getCompleteId() + "/" + key, new ValueLocator(){

            @Override
            public String valueForKey(String key) {
                return MetaDataLocatorImpl.this.locate(key, resources);
            }
        });
        return (T)this.typeCoercer.coerce((Object)value, expectedType);
    }

    @Override
    public <T> T findMeta(String key, final String pageName, Class<T> expectedType) {
        String value = this.getSymbolExpandedValueFromCache(key, pageName + "/" + key, new ValueLocator(){

            @Override
            public String valueForKey(String key) {
                String result = MetaDataLocatorImpl.this.modelSource.getPageModel(pageName).getMeta(key);
                return result != null ? result : MetaDataLocatorImpl.this.locateInDefaults(key, pageName);
            }
        });
        return (T)this.typeCoercer.coerce((Object)value, expectedType);
    }

    private String getSymbolExpandedValueFromCache(String key, String cacheKey, ValueLocator valueLocator) {
        if (this.cache.containsKey(cacheKey)) {
            return this.cache.get(cacheKey);
        }
        String value = valueLocator.valueForKey(key);
        value = value == null ? this.symbolSource.valueForSymbol(key) : this.symbolSource.expandSymbols(value);
        this.cache.put(cacheKey, value);
        return value;
    }

    private String locate(String key, ComponentResources resources) {
        ComponentResources cursor = resources;
        String value;
        while ((value = cursor.getComponentModel().getMeta(key)) == null) {
            ComponentResources next = cursor.getContainerResources();
            if (next == null) {
                return this.locateInDefaults(key, cursor.getPageName());
            }
            cursor = next;
        }
        return value;
    }

    private String locateInDefaults(String key, String pageName) {
        String path = pageName;
        while (true) {
            int lastSlashx;
            String folderKey;
            Map<String, String> forFolder;
            if ((forFolder = this.defaultsByFolder.get(folderKey = (lastSlashx = path.lastIndexOf(47)) < 0 ? "" : path.substring(0, lastSlashx))) != null && forFolder.containsKey(key)) {
                return forFolder.get(key);
            }
            if (lastSlashx < 0) break;
            path = path.substring(0, lastSlashx);
        }
        return null;
    }

    private static interface ValueLocator {
        public String valueForKey(String var1);
    }
}

