/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.services;

import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.internal.TapestryInternalUtils;

public class PageRenderRequestParameters {
    private final String logicalPageName;
    private final EventContext activationContext;
    private final boolean loopback;

    public PageRenderRequestParameters(String logicalPageName, EventContext activationContext) {
        this(logicalPageName, activationContext, false);
    }

    public PageRenderRequestParameters(String logicalPageName, EventContext activationContext, boolean loopback) {
        assert (logicalPageName != null);
        assert (activationContext != null);
        this.logicalPageName = logicalPageName;
        this.activationContext = activationContext;
        this.loopback = loopback;
    }

    public String getLogicalPageName() {
        return this.logicalPageName;
    }

    public EventContext getActivationContext() {
        return this.activationContext;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PageRenderRequestParameters other = (PageRenderRequestParameters)obj;
        return this.loopback == other.loopback && this.logicalPageName.equals(other.logicalPageName) && TapestryInternalUtils.isEqual(this.activationContext, other.activationContext);
    }

    public boolean isLoopback() {
        return this.loopback;
    }

    public String toString() {
        return String.format("PageRenderRequestParameters[%s]", this.logicalPageName);
    }
}

