/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.commons.services.InvalidationEventHub;
import org.apache.tapestry5.commons.services.PlasticProxyFactory;
import org.apache.tapestry5.commons.services.TypeCoercer;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.internal.services.ComponentClassCache;
import org.apache.tapestry5.ioc.annotations.ComponentClasses;
import org.apache.tapestry5.ioc.annotations.ComponentLayer;
import org.apache.tapestry5.ioc.annotations.PostInjection;

public class ComponentClassCacheImpl
implements ComponentClassCache {
    private final Map<String, Class> cache = CollectionFactory.newConcurrentMap();
    private final PlasticProxyFactory plasticFactory;
    private final TypeCoercer typeCoercer;

    public ComponentClassCacheImpl(@ComponentLayer PlasticProxyFactory plasticFactory, TypeCoercer typeCoercer) {
        this.plasticFactory = plasticFactory;
        this.typeCoercer = typeCoercer;
    }

    @PostInjection
    public void setupInvalidation(@ComponentClasses InvalidationEventHub hub) {
        hub.addInvalidationCallback(this::listen);
    }

    private List<String> listen(List<String> resources) {
        if (resources.isEmpty()) {
            this.cache.clear();
        } else {
            Iterator<Map.Entry<String, Class>> iterator = this.cache.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Class> entry = iterator.next();
                if (!resources.contains(entry.getKey())) continue;
                iterator.remove();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Object defaultValueForType(String className) {
        Class clazz = this.forName(className);
        if (!clazz.isPrimitive()) {
            return null;
        }
        return this.typeCoercer.coerce((Object)0, clazz);
    }

    @Override
    public Class forName(String className) {
        Class result = this.cache.get(className);
        if (result == null) {
            result = this.lookupClassForType(className);
            this.cache.put(className, result);
        }
        return result;
    }

    private Class lookupClassForType(String className) {
        ClassLoader componentLoader = this.plasticFactory.getProxyFactory(className).getClassLoader();
        try {
            return PlasticInternalUtils.toClass((ClassLoader)componentLoader, (String)className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }
}

