/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.MethodAlreadyExistsException;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PropertyAccessType;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class PropertyWorker
implements ComponentClassTransformWorker2 {
    private final boolean multipleClassloaders;

    public PropertyWorker(@Symbol(value="tapestry.multiple-classloaders") boolean multipleClassloaders) {
        this.multipleClassloaders = multipleClassloaders;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (PlasticField field : plasticClass.getFieldsWithAnnotation(Property.class)) {
            try {
                this.createAccessorsForField(field);
            }
            catch (MethodAlreadyExistsException e) {
                if (this.multipleClassloaders) continue;
                throw e;
            }
        }
    }

    private void createAccessorsForField(PlasticField field) {
        PropertyAccessType accessType = this.toType(field);
        field.createAccessors(accessType);
    }

    private PropertyAccessType toType(PlasticField field) {
        Property annotation = (Property)field.getAnnotation(Property.class);
        boolean read = annotation.read();
        boolean write = annotation.write();
        if (read && write) {
            return PropertyAccessType.READ_WRITE;
        }
        if (read) {
            return PropertyAccessType.READ_ONLY;
        }
        if (write) {
            return PropertyAccessType.WRITE_ONLY;
        }
        throw new IllegalArgumentException(String.format("@Property annotation on %s.%s should have either read() or write() enabled.", field.getPlasticClass().getClassName(), field.getName()));
    }
}

