/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import jakarta.xml.bind.Marshaller;
import java.lang.reflect.Method;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public class MarshalCallback {
    private Class<?> domainClass;
    private String domainClassName;
    private Method beforeMarshalCallback;
    private Method afterMarshalCallback;
    private boolean hasBeforeMarshalCallback = false;
    private boolean hasAfterMarshalCallback = false;

    public Method getAfterMarshalCallback() {
        return this.afterMarshalCallback;
    }

    public Method getBeforeMarshalCallback() {
        return this.beforeMarshalCallback;
    }

    public Class<?> getDomainClass() {
        return this.domainClass;
    }

    public void initialize(ClassLoader loader) {
        try {
            this.domainClass = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(this.domainClassName, true, loader));
        }
        catch (ClassNotFoundException ex) {
            return;
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Failed initialization of %s class", this.domainClassName), ex);
        }
        Class[] params = new Class[]{Marshaller.class};
        if (this.hasBeforeMarshalCallback) {
            try {
                Method beforeMarshal = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getMethod(this.domainClass, "beforeMarshal", params, false));
                this.setBeforeMarshalCallback(beforeMarshal);
            }
            catch (NoSuchMethodException beforeMarshal) {
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Failed initialization of beforeMarshal method of %s class", this.domainClassName), ex);
            }
        }
        if (this.hasAfterMarshalCallback) {
            try {
                Method afterMarshal = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getMethod(this.domainClass, "afterMarshal", params, false));
                this.setAfterMarshalCallback(afterMarshal);
            }
            catch (NoSuchMethodException afterMarshal) {
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Failed initialization of afterMarshal method of %s class", this.domainClassName), ex);
            }
        }
    }

    public void setAfterMarshalCallback(Method method) {
        this.afterMarshalCallback = method;
    }

    public void setHasAfterMarshalCallback() {
        this.hasAfterMarshalCallback = true;
    }

    public void setBeforeMarshalCallback(Method method) {
        this.beforeMarshalCallback = method;
    }

    public void setHasBeforeMarshalCallback() {
        this.hasBeforeMarshalCallback = true;
    }

    public void setDomainClass(Class<?> clazz) {
        this.domainClass = clazz;
        this.setDomainClassName(clazz.getName());
    }

    public void setDomainClassName(String className) {
        this.domainClassName = className;
    }
}

