/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class KMPSearchAlgorithm {
    public static int[] computeTable(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("pattern must not be null.");
        }
        if (byArray.length < 2) {
            throw new IllegalArgumentException("pattern.length must be > 1.");
        }
        int[] nArray = new int[byArray.length];
        int n = 2;
        int n2 = 0;
        nArray[0] = -1;
        nArray[1] = 0;
        while (n < byArray.length) {
            if (byArray[n - 1] == byArray[n2]) {
                nArray[n] = n2 + 1;
                ++n2;
                ++n;
                continue;
            }
            if (n2 > 0) {
                n2 = nArray[n2];
                continue;
            }
            nArray[n] = 0;
            ++n;
            n2 = 0;
        }
        return nArray;
    }

    public static int[] computeTable(char[] cArray) {
        if (cArray == null) {
            throw new IllegalArgumentException("pattern must  not be null.");
        }
        if (cArray.length < 2) {
            throw new IllegalArgumentException("pattern.length must be > 1.");
        }
        int[] nArray = new int[cArray.length];
        int n = 2;
        int n2 = 0;
        nArray[0] = -1;
        nArray[1] = 0;
        while (n < cArray.length) {
            if (cArray[n - 1] == cArray[n2]) {
                nArray[n] = n2 + 1;
                ++n2;
                ++n;
                continue;
            }
            if (n2 > 0) {
                n2 = nArray[n2];
                continue;
            }
            nArray[n] = 0;
            ++n;
            n2 = 0;
        }
        return nArray;
    }

    public static int[] computeTable(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Pattern must  not be null.");
        }
        if (string.length() < 2) {
            throw new IllegalArgumentException("Pattern length must be > 1.");
        }
        int n = string.length();
        int[] nArray = new int[n];
        int n2 = 2;
        int n3 = 0;
        nArray[0] = -1;
        nArray[1] = 0;
        while (n2 < n) {
            if (string.charAt(n2 - 1) == string.charAt(n3)) {
                nArray[n2] = n3 + 1;
                ++n3;
                ++n2;
                continue;
            }
            if (n3 > 0) {
                n3 = nArray[n3];
                continue;
            }
            nArray[n2] = 0;
            ++n2;
            n3 = 0;
        }
        return nArray;
    }

    public static long search(InputStream inputStream, byte[] byArray, int[] nArray) throws IOException {
        if (inputStream == null || byArray == null) {
            return -1L;
        }
        int n = byArray.length;
        if (n == 0) {
            return 0L;
        }
        long l = -1L;
        if (n == 1) {
            byte by = byArray[0];
            int n2 = inputStream.read();
            while (-1 != n2) {
                ++l;
                if (n2 == by) {
                    return l;
                }
                n2 = inputStream.read();
            }
            return -1L;
        }
        int n3 = 0;
        int[] nArray2 = nArray == null ? KMPSearchAlgorithm.computeTable(byArray) : nArray;
        int n4 = inputStream.read();
        while (-1 != n4) {
            ++l;
            if (n4 == byArray[n3]) {
                ++n3;
            } else if (n3 > 0) {
                n3 = nArray2[n3];
                ++n3;
            }
            if (n3 == n) {
                return l - (long)(n - 1);
            }
            n4 = inputStream.read();
        }
        return -1L;
    }

    public static long search(Reader reader, char[] cArray, int[] nArray) throws IOException {
        if (reader == null || cArray == null) {
            return -1L;
        }
        int n = cArray.length;
        if (n == 0) {
            return 0L;
        }
        long l = -1L;
        if (n == 1) {
            char c = cArray[0];
            int n2 = reader.read();
            while (-1 != n2) {
                ++l;
                if (n2 == c) {
                    return l;
                }
                n2 = reader.read();
            }
            return -1L;
        }
        int[] nArray2 = nArray == null ? KMPSearchAlgorithm.computeTable(cArray) : nArray;
        int n3 = 0;
        int n4 = reader.read();
        while (-1 != n4) {
            ++l;
            if (n4 == cArray[n3]) {
                ++n3;
            } else if (n3 > 0) {
                n3 = nArray2[n3];
                ++n3;
            }
            if (n3 == n) {
                return l - (long)(n - 1);
            }
            n4 = reader.read();
        }
        return -1L;
    }

    public static long search(Reader reader, String string, int[] nArray) throws IOException {
        if (reader == null || string == null) {
            return -1L;
        }
        int n = string.length();
        if (n == 0) {
            return 0L;
        }
        long l = -1L;
        if (n == 1) {
            char c = string.charAt(0);
            int n2 = reader.read();
            while (-1 != n2) {
                ++l;
                if (n2 == c) {
                    return l;
                }
                n2 = reader.read();
            }
            return -1L;
        }
        int[] nArray2 = nArray == null ? KMPSearchAlgorithm.computeTable(string) : nArray;
        int n3 = 0;
        int n4 = reader.read();
        while (-1 != n4) {
            ++l;
            if (n4 == string.charAt(n3)) {
                ++n3;
            } else if (n3 > 0) {
                n3 = nArray2[n3];
                ++n3;
            }
            if (n3 == n) {
                return l - (long)(n - 1);
            }
            n4 = reader.read();
        }
        return -1L;
    }

    public static int search(byte[] byArray, byte[] byArray2, int[] nArray, int n) {
        int[] nArray2;
        int n2;
        if (byArray == null || byArray2 == null) {
            return -1;
        }
        int n3 = byArray.length;
        int n4 = byArray2.length;
        if (n4 == 0) {
            return n > n3 ? -1 : n;
        }
        if (n4 == 1) {
            byte by = byArray2[0];
            for (n2 = n; n2 < n3; ++n2) {
                if (byArray[n2] != by) continue;
                return n2;
            }
            return -1;
        }
        int n5 = n;
        int n6 = 0;
        int[] nArray3 = nArray2 = nArray == null ? KMPSearchAlgorithm.computeTable(byArray2) : nArray;
        while (n2 < n3 && n6 < n4) {
            if (byArray[n2] == byArray2[n6]) {
                ++n6;
            } else {
                int n7 = nArray2[n6];
                n5 += n6 - n7;
                if (n6 > 0) {
                    n6 = n7;
                }
                ++n6;
            }
            n2 = n5 + n6;
        }
        if (n6 == n4) {
            return n5;
        }
        return -1;
    }

    public static int search(char[] cArray, char[] cArray2, int[] nArray, int n) {
        int[] nArray2;
        int n2;
        if (cArray == null || cArray2 == null) {
            return -1;
        }
        int n3 = cArray.length;
        int n4 = cArray2.length;
        if (n4 == 0) {
            return n > n3 ? -1 : n;
        }
        if (n4 == 1) {
            char c = cArray2[0];
            for (n2 = n; n2 < n3; ++n2) {
                if (cArray[n2] != c) continue;
                return n2;
            }
            return -1;
        }
        int n5 = n;
        int n6 = 0;
        int[] nArray3 = nArray2 = nArray == null ? KMPSearchAlgorithm.computeTable(cArray2) : nArray;
        while (n2 < n3 && n6 < n4) {
            if (cArray[n2] == cArray2[n6]) {
                ++n6;
            } else {
                int n7 = nArray2[n6];
                n5 += n6 - n7;
                if (n6 > 0) {
                    n6 = n7;
                }
                ++n6;
            }
            n2 = n5 + n6;
        }
        if (n6 == n4) {
            return n5;
        }
        return -1;
    }

    public static int search(String string, String string2, int[] nArray, int n) {
        int[] nArray2;
        if (string == null || string2 == null) {
            return -1;
        }
        int n2 = string2.length();
        int n3 = string.length();
        if (n2 == 0) {
            return n > n3 ? -1 : n;
        }
        if (n2 == 1) {
            return string.indexOf(string2, n);
        }
        int n4 = n;
        int n5 = n;
        int n6 = 0;
        int[] nArray3 = nArray2 = nArray == null ? KMPSearchAlgorithm.computeTable(string2) : nArray;
        while (n5 < n3 && n6 < n2) {
            if (string.charAt(n5) == string2.charAt(n6)) {
                ++n6;
            } else {
                int n7 = nArray2[n6];
                n4 += n6 - n7;
                if (n6 > 0) {
                    n6 = n7;
                }
                ++n6;
            }
            n5 = n4 + n6;
        }
        if (n6 == n2) {
            return n4;
        }
        return -1;
    }

    private KMPSearchAlgorithm() {
        assert (false) : "Pure Utility Class";
    }
}

