package org.apache.stratum.scheduler;

/*
 * Copyright 2001-2005 The Apache Software Foundation or its licensors,
 * as applicable.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This bean represents the settings used to create a Trigger object for use in the Quartz scheduler
 * <pre>
 *  This trigger is a Quartz trigger that uses a "Cron-Expression" which
 *  is a string comprised of 6 fields separated by white space. The 6
 *  fields are as follows:
 *   Field Name   Allowed Values   Allowed Special Characters
 *  seconds      0-59             , - * /
 *  minutes      0-59             , - * /
 *  hours        0-23             , - * /
 *  dayOfMonth   0-31             , - * ? / L C
 *  month        1-12 or JAN-DEC  , - * /
 *  dayOfWeek    1-7 or SUN-SAT   , - * ? / L C
 *    -The '*' character is used to specify all values. For example, "*" in
 *    the minute field means "every minute".
 *    -The '?' character is allowed for the day-of-month and day-of-week
 *    fields. It is used to specify 'no specific value'. This is useful when
 *    you need to specify something in one of the two fileds, but not the
 *    other. See the examples below for clarification.
 *    -The '-' character is used to specify ranges For example "10-12" in
 *    the hour field means "the hours 10, 11 and 12".
 *    -The ',' character is used to specify additional values. For example
 *    "MON,WED,FRI" in the day-of-week field means "the days Monday,
 *    Wednesday, and Friday".
 *    -The '/' character is used to specify increments. For example "0/15"
 *    in the seconds field means "the seconds 0, 15, 30, and 45". And "5/15"
 *    in the seconds field means "the seconds 5, 20, 35, and 50". You can \
 *    also specify '/' after the '*' character - in this case '*' is
 *    equivalent to having '0' before the '/'.
 *    -The 'L' character is allowed for the day-of-month and day-of-week
 *    fields. This character is short-hand for "last", but it has different
 *    meaning in each of the two fields. For example, the value "L" in the
 *    day-of-month field means "the last day of the month" - day 31 for
 *    January, day 28 for February on non-leap years. If used in the
 *    day-of-week field by itself, it simply means "7" or "SAT". But if
 *    used in the day-of-week field after another value, it means "the
 *    last xxx day of the month" - for example "6L" or "FRIL" both mean
 *    "the last friday of the month". When using the 'L' option, it is
 *    important not to specify lists, or ranges of values, as you'll get
 *    confusing results.
 *    -The 'C' character is allowed for the day-of-month and day-of-week
 *    fields. This character is short-hand for "calendar". This means values
 *    are calculated against the associated calendar, if any. If no calendar
 *    is associated, then it is equivalent to having an all-inclusive
 *    calendar. A value of "5C" in the day-of-month field means "the first
 *    day included by the calendar on or after the 5th". A value of "1C" in
 *    the day-of-week field means "the first day included by the calendar on
 *    or after sunday".
 * </pre>
 *
 * @author <a href="mailto:john@zenplex.com">John Thorhauer</a>
 * @version $Id: TriggerConfig.java 264191 2005-08-29 18:07:52Z henning $
 */
public class TriggerConfig
{
    /** The name of the trigger */
    private String name;

    /** The name of the job to associate with this this trigger. */
    private String jobName;

    /** The name of the group to associate this trigger with */
    private String group;

    /**  */

    /** TODO: DOCUMENT ME! */
    private String seconds = "*";

    /**  */

    /** TODO: DOCUMENT ME! */
    private String minutes = "*";

    /**  */

    /** TODO: DOCUMENT ME! */
    private String hours = "*";

    /**  */

    /** TODO: DOCUMENT ME! */
    private String dayOfMonth = "*";

    /**  */

    /** TODO: DOCUMENT ME! */
    private String month = "*";

    /**  */

    /** TODO: DOCUMENT ME! */
    private String dayOfWeek = "*";

    /**
     * Default contructor
     */
    public TriggerConfig()
    {
    }

    /**
     * This is the name of the trigger
     *
     * @param s trigger name
     */
    public void setName(String s)
    {
        this.name = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @return the name of the trigger
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * This is the name of group that the trigger is associated with
     *
     * @param s group name
     */
    public void setGroup(String s)
    {
        this.group = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @return the group name
     */
    public String getGroup()
    {
        return this.group;
    }

    /**
     * This is the name of job that the trigger is associated with
     *
     * @param s job name
     */
    public void setJobName(String s)
    {
        this.jobName = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @return the job name
     */
    public String getJobName()
    {
        return this.jobName;
    }

    /**
     * <pre>
     *  Field Name   Allowed Values   Allowed Special Characters
     *  seconds      0-59             , - * /
     * </pre>
     *
     * @param s seconds
     */
    public void setSeconds(String s)
    {
        this.seconds = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @return seconds
     */
    public String getSeconds()
    {
        return this.seconds;
    }

    /**
     * <pre>
     *  Field Name   Allowed Values   Allowed Special Characters
     *  minutes      0-59             , - * /
     * </pre>
     *
     * @param s minutes
     */
    public void setMinutes(String s)
    {
        this.minutes = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @return mintutes
     */
    public String getMinutes()
    {
        return this.minutes;
    }

    /**
     * <pre>
     *  Field Name   Allowed Values   Allowed Special Characters
     *  hours        0-23             , - * /
     * </pre>
     *
     * @param s hours
     */
    public void setHours(String s)
    {
        this.hours = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @return hours
     */
    public String getHours()
    {
        return this.hours;
    }

    /**
     * <pre>
     *  Field Name   Allowed Values   Allowed Special Characters
     *  dayOfMonth   0-31             , - * ? / L C
     * </pre>
     *
     * @param s day of month
     */
    public void setDayOfMonth(String s)
    {
        this.dayOfMonth = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @return day of month
     */
    public String getDayOfMonth()
    {
        return this.dayOfMonth;
    }

    /**
     * <pre>
     *  Field Name   Allowed Values   Allowed Special Characters
     *  month        1-12 or JAN-DEC  , - * /
     * </pre>
     *
     * @param s month
     */
    public void setMonth(String s)
    {
        this.month = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @return month
     */
    public String getMonth()
    {
        return this.month;
    }

    /**
     * <pre>
     *  Field Name   Allowed Values   Allowed Special Characters
     *  dayOfWeek    1-7 or SUN-SAT   , - * ? / L C
     * </pre>
     *
     * @param s day of the week
     */
    public void setDayOfWeek(String s)
    {
        this.dayOfWeek = s;
    }

    /**
     * DOCUMENT ME!
     *
     * @return day of the week
     */
    public String getDayOfWeek()
    {
        return this.dayOfWeek;
    }
}
