/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.trabal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.ruta.textruler.core.TextRulerBasicLearner;
import org.apache.uima.ruta.textruler.core.TextRulerExample;
import org.apache.uima.ruta.textruler.core.TextRulerExampleDocument;
import org.apache.uima.ruta.textruler.core.TextRulerExampleDocumentSet;
import org.apache.uima.ruta.textruler.core.TextRulerStatisticsCollector;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.extension.TextRulerLearner;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerDelegate;
import org.apache.uima.ruta.textruler.learner.trabal.AnnotationError;
import org.apache.uima.ruta.textruler.learner.trabal.AnnotationErrorType;
import org.apache.uima.ruta.textruler.learner.trabal.AnnotationRule;
import org.apache.uima.ruta.textruler.learner.trabal.Condition;
import org.apache.uima.ruta.textruler.learner.trabal.ConditionType;
import org.apache.uima.ruta.textruler.learner.trabal.CorrectionRule;
import org.apache.uima.ruta.textruler.learner.trabal.DeletionRule;
import org.apache.uima.ruta.textruler.learner.trabal.ExpansionRule;
import org.apache.uima.ruta.textruler.learner.trabal.RankedList;
import org.apache.uima.ruta.textruler.learner.trabal.ShiftAllRule;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalAnnotation;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalRule;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalRuleItem;
import org.apache.uima.util.CasCopier;

public class TrabalLearner
extends TextRulerBasicLearner {
    public static final String ANNOTATION_TYPE_BASIC = "org.apache.uima.ruta.type.RutaBasic";
    public static final String ANNOTATION_TYPE_ANY = "org.apache.uima.ruta.type.ANY";
    public static final String ANNOTATION_TYPE_FRAME = "org.apache.uima.ruta.type.RutaFrame";
    public static final String PACKAGE = "org.apache.uima";
    public static final String TYPESYSTEM = "de.uniwue.tm.citie.CompleteTypeSystemTypeSystem";
    public static final List<String> FILTERED_FEATURES;
    public static final String MAX_NUMBER_OF_BASIC_RULES_KEY = "maxNumberOfBasicRules";
    public static final String MAX_NUMBER_OF_RULES_KEY = "maxNumberOfRules";
    public static final String MAX_NUMBER_OF_ITERATIONS_KEY = "maxNumberOfIterations";
    public static final String ALGORITHM_ITERATIONS_KEY = "algorithmIterations";
    public static final String MAX_ERROR_RATE_KEY = "maxErrorRate";
    public static final String ENABLE_FEATURES_KEY = "enableFeatures";
    public static final int MAX_NUMBER_OF_BASIC_RULES = 80;
    public static final int MAX_NUMBER_OF_RULES = 150;
    public static final int MAX_NUMBER_OF_ITERATIONS = 2;
    public static final int ALGORITHM_ITERATIONS = 3;
    public static final double MAX_ERROR_RATE = 0.4;
    public static final boolean ENABLE_FEATURES = false;
    private int maxNumberOfBasicRules = 80;
    private int maxNumberOfRules = 150;
    private int maxNumberOfIterations = 2;
    private int algorithmIterations = 3;
    private double maxErrorRate = 0.4;
    public boolean enableFeatures = false;
    private String result = "";
    private String actualResult = "";
    private List<TrabalRule> bestRulesForStatus = new ArrayList<TrabalRule>();
    private String inputDirectory;
    private String additionalFolderPath;
    private TextRulerExampleDocumentSet additionalDocuments;
    private List<AnnotationError> errors;
    private Map<String, RankedList> positiveExamples;
    private Map<String, Double> idf;
    private Map<String, TextRulerStatisticsCollector> inducedRules = new TreeMap<String, TextRulerStatisticsCollector>();
    protected Comparator<TrabalRule> basicComparator = new Comparator<TrabalRule>(){

        @Override
        public int compare(TrabalRule o1, TrabalRule o2) {
            if (o1.getCoveringStatistics().getCoveredPositivesCount() > o2.getCoveringStatistics().getCoveredPositivesCount()) {
                return -1;
            }
            if (o1.getCoveringStatistics().getCoveredPositivesCount() < o2.getCoveringStatistics().getCoveredPositivesCount()) {
                return 1;
            }
            if (o1.getCoveringStatistics().getCoveredNegativesCount() < o2.getCoveringStatistics().getCoveredNegativesCount()) {
                return -1;
            }
            if (o1.getCoveringStatistics().getCoveredNegativesCount() > o2.getCoveringStatistics().getCoveredNegativesCount()) {
                return 1;
            }
            if (o1.getConditions().size() < o2.getConditions().size()) {
                return -1;
            }
            if (o1.getConditions().size() > o2.getConditions().size()) {
                return 1;
            }
            return o1.getRuleString().compareTo(o2.getRuleString());
        }
    };
    protected Comparator<TrabalRule> enhancedComparator = new Comparator<TrabalRule>(){

        @Override
        public int compare(TrabalRule o1, TrabalRule o2) {
            if (o1.getCoveringStatistics().getCoveredPositivesCount() - o1.getCoveringStatistics().getCoveredNegativesCount() > o2.getCoveringStatistics().getCoveredPositivesCount() - o2.getCoveringStatistics().getCoveredNegativesCount()) {
                return -1;
            }
            if (o1.getCoveringStatistics().getCoveredPositivesCount() - o1.getCoveringStatistics().getCoveredNegativesCount() < o2.getCoveringStatistics().getCoveredPositivesCount() - o2.getCoveringStatistics().getCoveredNegativesCount()) {
                return 1;
            }
            if (o1.getCoveringStatistics().getCoveredPositivesCount() > o2.getCoveringStatistics().getCoveredPositivesCount()) {
                return -1;
            }
            if (o1.getCoveringStatistics().getCoveredPositivesCount() < o2.getCoveringStatistics().getCoveredPositivesCount()) {
                return 1;
            }
            if (o1.getCoveringStatistics().getCoveredNegativesCount() < o2.getCoveringStatistics().getCoveredNegativesCount()) {
                return -1;
            }
            if (o1.getCoveringStatistics().getCoveredNegativesCount() > o2.getCoveringStatistics().getCoveredNegativesCount()) {
                return 1;
            }
            if (o1.getConditions().size() < o2.getConditions().size()) {
                return -1;
            }
            if (o1.getConditions().size() > o2.getConditions().size()) {
                return 1;
            }
            return o1.getRuleString().compareTo(o2.getRuleString());
        }
    };

    public TrabalLearner(String inputFolderPath, String additionalFolderPath, String preprocessorTMfile, String tempFolderPath, String[] fullSlotTypeNames, Set<String> filterSet, boolean skip, TextRulerLearnerDelegate delegate) {
        super(inputFolderPath, preprocessorTMfile, tempFolderPath, fullSlotTypeNames, filterSet, skip, delegate);
        this.inputDirectory = inputFolderPath;
        this.additionalFolderPath = additionalFolderPath;
    }

    @Override
    protected void doRun() {
        try {
            Map<String, List<AnnotationError>> errorGrps;
            this.getAnalysisEngine();
            this.getAdditionalDocuments();
            if (this.additionalDocuments == null) {
                throw new Exception("Error: Additional data is missing!");
            }
            if (this.exampleDocuments.getDocuments().size() != this.additionalDocuments.getDocuments().size()) {
                throw new Exception("Error: Training data doesn't match additional data!");
            }
            this.sendStatusUpdateToDelegate("Loading documents...", TextRulerLearner.TextRulerLearnerState.ML_INITIALIZING, true);
            this.sendStatusUpdateToDelegate("Comparing documents...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
            for (int i = 0; i < this.algorithmIterations; ++i) {
                this.actualResult = this.actualResult + "BLOCK(Iteration_" + (i + 1) + ") Document{} {\n";
                this.sendStatusUpdateToDelegate("Comparing documents...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
                this.idf = this.createIDF();
                Map<String, List<AnnotationError>> errorGrps2 = this.createErrorGroups();
                List<TrabalRule> rules = this.runAlgorithm(errorGrps2);
                if (rules.size() == 0) {
                    this.actualResult = this.actualResult.replace("BLOCK(Iteration_" + (i + 1) + ") Document{} {", "");
                    break;
                }
                this.result = this.actualResult = this.actualResult + "}\n\n";
                this.sendStatusUpdateToDelegate("Finished " + (i + 1) + ". iteration.", TextRulerLearner.TextRulerLearnerState.ML_DONE, true);
            }
            if ((errorGrps = this.createErrorGroups()).size() > 0) {
                this.actualResult = this.actualResult + "// Remaining errors \n";
                for (List<AnnotationError> list : errorGrps.values()) {
                    for (AnnotationError err : list) {
                        this.actualResult = this.actualResult + "\n// " + err;
                    }
                }
            }
            if (new File(this.tempDirectory).isDirectory()) {
                new File(this.tempDirectory).delete();
            }
            this.result = this.actualResult;
            this.sendStatusUpdateToDelegate("Done!", TextRulerLearner.TextRulerLearnerState.ML_DONE, true);
        }
        catch (Exception e) {
            this.sendStatusUpdateToDelegate(e.getLocalizedMessage(), TextRulerLearner.TextRulerLearnerState.ML_ERROR, true);
            e.printStackTrace();
        }
    }

    private void removeBasics() {
        for (TextRulerExampleDocument doc : this.additionalDocuments.getDocuments()) {
            CAS cas = doc.getCAS();
            ArrayList<AnnotationFS> basics = new ArrayList<AnnotationFS>();
            for (AnnotationFS a : cas.getAnnotationIndex()) {
                if (!a.getType().getName().equals(ANNOTATION_TYPE_BASIC)) continue;
                basics.add(a);
            }
            for (AnnotationFS a : basics) {
                cas.removeFsFromIndexes((FeatureStructure)a);
            }
        }
    }

    private void removeBasics(CAS cas) {
        ArrayList<AnnotationFS> basics = new ArrayList<AnnotationFS>();
        for (AnnotationFS a : cas.getAnnotationIndex()) {
            if (!a.getType().getName().equals(ANNOTATION_TYPE_BASIC)) continue;
            basics.add(a);
        }
        for (AnnotationFS a : basics) {
            cas.removeFsFromIndexes((FeatureStructure)a);
        }
    }

    private Map<String, Double> createIDF() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        List<TextRulerExampleDocument> documents = this.additionalDocuments.getDocuments();
        HashMap<String, Integer> annotations = new HashMap<String, Integer>();
        for (int i = 0; i < documents.size(); ++i) {
            AnnotationIndex index = documents.get(i).getCAS().getAnnotationIndex();
            FSIterator iterator = index.iterator();
            while (iterator.isValid()) {
                AnnotationFS annotation = (AnnotationFS)iterator.next();
                if (!this.isSlotType(annotation.getType())) continue;
                TrabalAnnotation a = new TrabalAnnotation(annotation, this.enableFeatures);
                if (annotations.containsKey(a.getType().getShortName())) {
                    annotations.put(a.getType().getShortName(), new Integer((Integer)annotations.get(a.getType().getShortName()) + 1));
                    continue;
                }
                annotations.put(a.getType().getShortName(), new Integer(1));
            }
            for (String key : annotations.keySet()) {
                double d = ((Integer)annotations.get(key)).doubleValue();
                result.put(key, new Double(1.0 / d));
            }
        }
        return result;
    }

    private Map<String, List<AnnotationError>> createErrorGroups() {
        this.errors = this.createErrorList();
        Collections.sort(this.errors);
        HashMap<String, List<AnnotationError>> result = new HashMap<String, List<AnnotationError>>();
        for (AnnotationError error : this.errors) {
            String key;
            String truthFeatures = "";
            String errorFeatures = "";
            if (error.getError() != null && error.getTruth() != null) {
                if (this.enableFeatures) {
                    truthFeatures = this.listFeatures(error.getTruth());
                    errorFeatures = this.listFeatures(error.getError());
                }
                if (result.get(key = (Object)((Object)error.getType()) + "_" + error.getError().getAnnotation().getType().toString() + errorFeatures + "_" + error.getTruth().getAnnotation().getType().toString() + truthFeatures) == null) {
                    result.put(key, new ArrayList());
                }
                ((List)result.get(key)).add(error);
                continue;
            }
            if (error.getTruth() != null) {
                if (this.enableFeatures) {
                    truthFeatures = this.listFeatures(error.getTruth());
                }
                if (result.get(key = (Object)((Object)error.getType()) + "_" + error.getTruth().getAnnotation().getType().toString() + truthFeatures) == null) {
                    result.put(key, new ArrayList());
                }
                ((List)result.get(key)).add(error);
                continue;
            }
            if (this.enableFeatures) {
                errorFeatures = this.listFeatures(error.getError());
            }
            if (result.get(key = (Object)((Object)error.getType()) + "_" + error.getError().getAnnotation().getType().toString() + errorFeatures) == null) {
                result.put(key, new ArrayList());
            }
            ((List)result.get(key)).add(error);
        }
        return result;
    }

    private String listFeatures(TextRulerExample example) {
        String result = "";
        for (Feature f : example.getAnnotation().getType().getFeatures()) {
            if (FILTERED_FEATURES.contains(f.getShortName())) continue;
            result = result + "_" + f.toString();
        }
        return result;
    }

    private List<AnnotationError> createErrorList() {
        this.positiveExamples = new HashMap<String, RankedList>();
        ArrayList<AnnotationError> result = new ArrayList<AnnotationError>();
        List<TextRulerExampleDocument> documents = this.additionalDocuments.getDocuments();
        List<TextRulerExampleDocument> goldStandard = this.exampleDocuments.getDocuments();
        for (int i = 0; i < goldStandard.size() && !this.shouldAbort(); ++i) {
            int end2;
            AnnotationError err;
            TextRulerTarget target;
            ArrayList<AnnotationError> tempErrors;
            ArrayList<TrabalAnnotation> matches = new ArrayList<TrabalAnnotation>();
            AnnotationIndex index = goldStandard.get(i).getCAS().getAnnotationIndex();
            ArrayList<TrabalAnnotation> gold = new ArrayList<TrabalAnnotation>();
            ArrayList<TrabalAnnotation> docs = new ArrayList<TrabalAnnotation>();
            for (AnnotationFS annotationFS : index) {
                if (!this.isSlotType(annotationFS.getType())) continue;
                gold.add(new TrabalAnnotation(annotationFS, goldStandard.get(i), this.enableFeatures));
            }
            AnnotationIndex docIndex = documents.get(i).getCAS().getAnnotationIndex();
            for (AnnotationFS annotationFS : docIndex) {
                if (!this.isSlotType(annotationFS.getType())) continue;
                docs.add(new TrabalAnnotation(annotationFS, documents.get(i), this.enableFeatures));
            }
            Iterator iterator = gold.iterator();
            Iterator docIterator = docs.iterator();
            int exampleIndex = 0;
            block3: while (iterator.hasNext() && !this.shouldAbort()) {
                this.sendStatusUpdateToDelegate("Comparing documents " + (i + 1) + " of " + goldStandard.size() + ": example " + ++exampleIndex + " of " + gold.size(), TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
                TrabalAnnotation trabalAnnotation = (TrabalAnnotation)iterator.next();
                for (TrabalAnnotation trabalAnnotation2 : docs) {
                    RankedList list;
                    if (!trabalAnnotation2.equals(trabalAnnotation)) continue;
                    matches.add(trabalAnnotation);
                    matches.add(trabalAnnotation2);
                    if (this.positiveExamples.containsKey(trabalAnnotation.getType().getShortName())) {
                        list = this.positiveExamples.get(trabalAnnotation.getType().getShortName());
                        list.addAll(this.createConditions(trabalAnnotation));
                        this.positiveExamples.put(trabalAnnotation.getType().getShortName(), list);
                        continue block3;
                    }
                    list = new RankedList(this.idf);
                    list.addAll(this.createConditions(trabalAnnotation));
                    this.positiveExamples.put(trabalAnnotation.getType().getShortName(), list);
                    continue block3;
                }
            }
            iterator = gold.iterator();
            docIterator = docs.iterator();
            block5: while (iterator.hasNext()) {
                TrabalAnnotation trabalAnnotation = (TrabalAnnotation)iterator.next();
                docIterator = docs.iterator();
                while (!matches.contains(trabalAnnotation) && docIterator.hasNext()) {
                    TrabalAnnotation trabalAnnotation3 = (TrabalAnnotation)docIterator.next();
                    if (matches.contains(trabalAnnotation3) || trabalAnnotation3.getBegin() != trabalAnnotation.getBegin() || trabalAnnotation3.getEnd() != trabalAnnotation.getEnd()) continue;
                    TextRulerTarget target2 = new TextRulerTarget(trabalAnnotation3.getType().getName(), (TextRulerBasicLearner)this);
                    TextRulerExample error = new TextRulerExample(trabalAnnotation3.getDocument(), trabalAnnotation3, false, target2);
                    TextRulerExample truth = new TextRulerExample(trabalAnnotation.getDocument(), trabalAnnotation, true, target2);
                    result.add(new AnnotationError(error, truth, AnnotationErrorType.CORRECTION));
                    matches.add(trabalAnnotation);
                    matches.add(trabalAnnotation3);
                    continue block5;
                }
            }
            iterator = gold.iterator();
            docIterator = docs.iterator();
            while (iterator.hasNext()) {
                TrabalAnnotation trabalAnnotation = (TrabalAnnotation)iterator.next();
                docIterator = docs.iterator();
                tempErrors = new ArrayList<AnnotationError>();
                while (!matches.contains(trabalAnnotation) && docIterator.hasNext()) {
                    AnnotationErrorType type;
                    TextRulerExample truth;
                    TrabalAnnotation trabalAnnotation4 = (TrabalAnnotation)docIterator.next();
                    if (matches.contains(trabalAnnotation4) || !trabalAnnotation4.getType().getShortName().equals(trabalAnnotation.getType().getShortName()) || trabalAnnotation4.getEnd() < trabalAnnotation.getBegin() || trabalAnnotation4.getBegin() > trabalAnnotation.getEnd()) continue;
                    target = new TextRulerTarget(trabalAnnotation.getType().getName(), (TextRulerBasicLearner)this);
                    TextRulerExample error = new TextRulerExample(trabalAnnotation4.getDocument(), trabalAnnotation4, false, target);
                    AnnotationError err2 = new AnnotationError(error, truth = new TextRulerExample(trabalAnnotation.getDocument(), trabalAnnotation, true, target), type = trabalAnnotation4.getBegin() == trabalAnnotation.getBegin() && trabalAnnotation4.getEnd() < trabalAnnotation.getEnd() || trabalAnnotation4.getBegin() > trabalAnnotation.getBegin() && trabalAnnotation4.getEnd() == trabalAnnotation.getEnd() ? AnnotationErrorType.EXPANSION : (trabalAnnotation4.getBegin() > trabalAnnotation.getBegin() || trabalAnnotation4.getEnd() > trabalAnnotation.getEnd() ? AnnotationErrorType.SHIFTING_LEFT : AnnotationErrorType.SHIFTING_RIGHT));
                    if (tempErrors.contains(err2)) continue;
                    tempErrors.add(err2);
                }
                if (tempErrors.size() <= 0) continue;
                err = (AnnotationError)tempErrors.get(0);
                int begin = err.getError().getAnnotation().getBegin();
                int end = err.getError().getAnnotation().getEnd();
                int distance = Math.abs(begin - trabalAnnotation.getBegin()) + Math.abs(end - trabalAnnotation.getEnd());
                for (int j = 1; j < tempErrors.size(); ++j) {
                    int begin2 = ((AnnotationError)tempErrors.get(j)).getError().getAnnotation().getBegin();
                    end2 = ((AnnotationError)tempErrors.get(j)).getError().getAnnotation().getEnd();
                    if (Math.abs(begin2 - trabalAnnotation.getBegin()) + Math.abs(end2 - trabalAnnotation.getEnd()) >= distance) continue;
                    distance = Math.abs(begin2 - trabalAnnotation.getBegin()) + Math.abs(end2 - trabalAnnotation.getEnd());
                    err = (AnnotationError)tempErrors.get(j);
                }
                result.add(err);
                matches.add((TrabalAnnotation)err.getTruth().getAnnotation());
                matches.add((TrabalAnnotation)err.getError().getAnnotation());
            }
            iterator = gold.iterator();
            docIterator = docs.iterator();
            while (iterator.hasNext()) {
                TrabalAnnotation trabalAnnotation = (TrabalAnnotation)iterator.next();
                docIterator = docs.iterator();
                tempErrors = new ArrayList();
                while (!matches.contains(trabalAnnotation) && docIterator.hasNext()) {
                    AnnotationErrorType type;
                    TextRulerExample truth;
                    TrabalAnnotation trabalAnnotation5 = (TrabalAnnotation)docIterator.next();
                    if (matches.contains(trabalAnnotation5) || trabalAnnotation5.getEnd() < trabalAnnotation.getBegin() || trabalAnnotation5.getBegin() > trabalAnnotation.getEnd()) continue;
                    target = new TextRulerTarget(trabalAnnotation5.getType().getName(), (TextRulerBasicLearner)this);
                    TextRulerExample error = new TextRulerExample(trabalAnnotation5.getDocument(), trabalAnnotation5, false, target);
                    AnnotationError err2 = new AnnotationError(error, truth = new TextRulerExample(trabalAnnotation.getDocument(), trabalAnnotation, true, target), type = trabalAnnotation5.getBegin() == trabalAnnotation.getBegin() && trabalAnnotation5.getEnd() < trabalAnnotation.getEnd() || trabalAnnotation5.getBegin() > trabalAnnotation.getBegin() && trabalAnnotation5.getEnd() == trabalAnnotation.getEnd() ? AnnotationErrorType.EXPANSION : (trabalAnnotation5.getBegin() > trabalAnnotation.getBegin() || trabalAnnotation5.getEnd() > trabalAnnotation.getEnd() ? AnnotationErrorType.SHIFTING_LEFT : AnnotationErrorType.SHIFTING_RIGHT));
                    if (tempErrors.contains(err2)) continue;
                    tempErrors.add(err2);
                }
                if (tempErrors.size() <= 0) continue;
                err = (AnnotationError)tempErrors.get(0);
                int begin = err.getError().getAnnotation().getBegin();
                int end = err.getError().getAnnotation().getEnd();
                int distance = Math.abs(begin - trabalAnnotation.getBegin()) + Math.abs(end - trabalAnnotation.getEnd());
                for (int j = 1; j < tempErrors.size(); ++j) {
                    int begin2 = ((AnnotationError)tempErrors.get(j)).getError().getAnnotation().getBegin();
                    end2 = ((AnnotationError)tempErrors.get(j)).getError().getAnnotation().getEnd();
                    if (Math.abs(begin2 - trabalAnnotation.getBegin()) + Math.abs(end2 - trabalAnnotation.getEnd()) >= distance) continue;
                    distance = Math.abs(begin2 - trabalAnnotation.getBegin()) + Math.abs(end2 - trabalAnnotation.getEnd());
                    err = (AnnotationError)tempErrors.get(j);
                }
                result.add(err);
                matches.add((TrabalAnnotation)err.getTruth().getAnnotation());
                matches.add((TrabalAnnotation)err.getError().getAnnotation());
            }
            for (TrabalAnnotation trabalAnnotation : docs) {
                if (matches.contains(trabalAnnotation)) continue;
                target = new TextRulerTarget(trabalAnnotation.getType().getName(), (TextRulerBasicLearner)this);
                TextRulerExample error = new TextRulerExample(trabalAnnotation.getDocument(), trabalAnnotation, false, target);
                result.add(new AnnotationError(error, null, AnnotationErrorType.DELETION));
                matches.add(trabalAnnotation);
            }
            for (TrabalAnnotation trabalAnnotation : gold) {
                if (matches.contains(trabalAnnotation)) continue;
                target = new TextRulerTarget(trabalAnnotation.getType().getName(), (TextRulerBasicLearner)this);
                TextRulerExample truth = new TextRulerExample(trabalAnnotation.getDocument(), trabalAnnotation, true, target);
                result.add(new AnnotationError(null, truth, AnnotationErrorType.ANNOTATION));
                matches.add(trabalAnnotation);
            }
        }
        return result;
    }

    private List<TrabalRule> runAlgorithm(Map<String, List<AnnotationError>> errorGrps) {
        this.removeBasics();
        this.inducedRules.clear();
        ArrayList<TrabalRule> rules = new ArrayList<TrabalRule>();
        this.bestRulesForStatus.clear();
        int i = 1;
        for (List<AnnotationError> each : errorGrps.values()) {
            if (this.shouldAbort()) break;
            Collections.sort(each);
            String status = each.get(0).toString();
            this.sendStatusUpdateToDelegate("Creating basic rules: " + status, TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
            List<TrabalRule> basicRules = TrabalLearner.removeDuplicateRules(this.createBasicRules(each));
            if (basicRules.size() > this.maxNumberOfBasicRules) {
                basicRules = basicRules.subList(0, this.maxNumberOfBasicRules);
            }
            this.sendStatusUpdateToDelegate("Testing basic rules: " + status, TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
            basicRules = this.testTrabalRulesOnDocumentSet(basicRules, this.exampleDocuments, this.additionalDocuments, "basic rules (" + i + " of " + errorGrps.size() + ")");
            if (basicRules.size() > 0) {
                Collections.sort(basicRules, this.basicComparator);
                this.bestRulesForStatus.add(basicRules.get(0));
            }
            this.result = this.actualResult + TrabalLearner.getRuleStrings(this.bestRulesForStatus);
            this.sendStatusUpdateToDelegate("Testing basic rules: " + status, TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
            List<TrabalRule> learntRules = new ArrayList<TrabalRule>();
            for (TrabalRule rule : basicRules) {
                if (rule.getCoveringStatistics().getCoveredPositivesCount() <= 0 || rule.getCoveringStatistics().getCoveredNegativesCount() != 0) continue;
                learntRules.add(rule);
            }
            List<TrabalRule> enhancedRules = new ArrayList<TrabalRule>();
            int rank = 1;
            for (TrabalRule rule : basicRules) {
                if (rule.getCoveringStatistics().getCoveredPositivesCount() <= 0 || rule.getCoveringStatistics().getCoveredNegativesCount() <= 0) continue;
                if (learntRules.size() > 0) {
                    if (rule.getCoveringStatistics().getCoveredPositivesCount() <= ((TrabalRule)learntRules.get(0)).getCoveringStatistics().getCoveredPositivesCount()) continue;
                    rule.setRating(rank);
                    enhancedRules.add(rule);
                    ++rank;
                    continue;
                }
                rule.setRating(rank);
                enhancedRules.add(rule);
                ++rank;
            }
            basicRules.clear();
            try {
                enhancedRules = this.enhanceRules(enhancedRules, this.maxNumberOfIterations, new RankedList(this.idf));
                Collections.sort(enhancedRules);
                if (enhancedRules.size() > this.maxNumberOfRules) {
                    enhancedRules = enhancedRules.subList(0, this.maxNumberOfRules);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.sendStatusUpdateToDelegate("Testing enhanced rules: " + status, TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
            enhancedRules = this.testTrabalRulesOnDocumentSet(enhancedRules, this.exampleDocuments, this.additionalDocuments, "enhanced rules (" + i + " of " + errorGrps.size() + ")");
            for (TrabalRule rule : enhancedRules) {
                if (!((double)rule.getErrorRate() <= this.maxErrorRate)) continue;
                learntRules.add(rule);
            }
            enhancedRules.clear();
            learntRules = TrabalLearner.removeDuplicateRules(learntRules);
            if (learntRules.size() > 0) {
                Collections.sort(learntRules, this.enhancedComparator);
                this.bestRulesForStatus.remove(this.bestRulesForStatus.size() - 1);
                this.bestRulesForStatus.add(learntRules.get(0));
                this.result = this.actualResult + TrabalLearner.getRuleStrings(this.bestRulesForStatus);
            }
            this.sendStatusUpdateToDelegate("Testing optimized rules: " + status, TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
            if (learntRules.size() > this.maxNumberOfRules) {
                learntRules = learntRules.subList(0, this.maxNumberOfRules);
            }
            rules.addAll(learntRules);
            ++i;
        }
        return this.getBest(rules);
    }

    private List<TrabalRule> enhanceRules(List<TrabalRule> learntRules, int iterations, RankedList conditions) throws Exception {
        if (this.shouldAbort() || learntRules.size() == 0) {
            return learntRules;
        }
        this.sendStatusUpdateToDelegate("Adding conditions to rules (" + iterations + ". Iteration)... ", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        if (iterations > 0) {
            ArrayList<TrabalRule> rules = new ArrayList<TrabalRule>();
            ArrayList<TrabalRule> newRules = new ArrayList<TrabalRule>();
            if (conditions.size() == 0) {
                conditions = this.createConditions(learntRules);
            }
            for (int i = 0; i < learntRules.size(); ++i) {
                rules.add(learntRules.get(i));
                for (int j = 0; j < conditions.size() && j < 50; ++j) {
                    TrabalRule newRule = learntRules.get(i).copy();
                    if (newRule.getConditions().contains(conditions.get(j))) continue;
                    newRule.addCondition(conditions.get(j), j + 1);
                    newRule.getRuleString();
                    newRules.add(newRule);
                }
            }
            rules.addAll(this.enhanceRules(newRules, iterations - 1, conditions));
            return rules;
        }
        return learntRules;
    }

    private List<TrabalRule> getBest(List<TrabalRule> rules) {
        ArrayList<TrabalRule> result = new ArrayList<TrabalRule>();
        Collections.sort(rules, this.enhancedComparator);
        while (rules.size() > 0) {
            List<TrabalRule> testRules = new ArrayList<TrabalRule>();
            ArrayList<TrabalRule> newRules = new ArrayList<TrabalRule>();
            TrabalRule bestRule = rules.get(0);
            if ((double)bestRule.getErrorRate() > this.maxErrorRate) {
                rules.remove(0);
                continue;
            }
            if (bestRule.getCoveringStatistics().getCoveredPositivesCount() == 0) break;
            this.sendStatusUpdateToDelegate("Chosen rule: " + bestRule, TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
            result.add(bestRule);
            rules.remove(0);
            Set<TextRulerExample> coveredExamples = bestRule.getCoveringStatistics().getCoveredPositiveExamples();
            for (TrabalRule rule : rules) {
                TextRulerStatisticsCollector collector = rule.getCoveringStatistics();
                for (TextRulerExample example : coveredExamples) {
                    if (collector.getCoveredPositiveExamples().contains(example)) {
                        collector.getCoveredPositiveExamples().remove(example);
                        collector.incCoveredPositives(-1);
                    }
                    if (collector.getCoveredPositivesCount() > 0) continue;
                    break;
                }
                if ((double)rule.getErrorRate() > this.maxErrorRate || rule.getCoveringStatistics().getCoveredPositivesCount() <= 0) {
                    if (this.bestRulesForStatus.contains(rule)) {
                        this.bestRulesForStatus.remove(rule);
                    }
                    this.result = this.actualResult + TrabalLearner.getRuleStrings(this.bestRulesForStatus);
                    continue;
                }
                if (rule.contains(bestRule.getAnnotation()) || rule.contains(bestRule.getTargetAnnotation())) {
                    testRules.add(rule.copy());
                    continue;
                }
                newRules.add(rule);
            }
            rules = new ArrayList<TrabalRule>();
            this.updateDocumentData(bestRule);
            this.removeBasics();
            testRules = this.testTrabalRulesOnDocumentSet(testRules, this.exampleDocuments, this.additionalDocuments, "final rules ");
            for (TrabalRule rule : testRules) {
                if (!((double)rule.getErrorRate() <= this.maxErrorRate) || rule.getCoveringStatistics().getCoveredPositivesCount() <= 0) continue;
                rules.add(rule);
            }
            rules.addAll(newRules);
            Collections.sort(rules, this.enhancedComparator);
        }
        this.result = this.actualResult;
        return result;
    }

    private void updateDocumentData(TrabalRule rule) {
        try {
            this.sendStatusUpdateToDelegate("Writing rules...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
            rule.saveToRulesFile(this.getTempRulesFileName());
            for (TextRulerExampleDocument doc : this.additionalDocuments.getDocuments()) {
                this.ae.process(doc.getCAS());
            }
            if (this.bestRulesForStatus.contains(rule)) {
                this.bestRulesForStatus.remove(rule);
            }
            this.actualResult = this.actualResult + rule.toString();
            this.result = this.actualResult + TrabalLearner.getRuleStrings(this.bestRulesForStatus);
            this.sendStatusUpdateToDelegate("Writing rules...", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<TrabalRule> createBasicRules(List<AnnotationError> errors) {
        ArrayList<TrabalRule> result = new ArrayList<TrabalRule>();
        for (AnnotationError each : errors) {
            switch (each.getType()) {
                case SHIFTING_LEFT: 
                case SHIFTING_RIGHT: 
                case EXPANSION: {
                    result.addAll(this.createShiftingRules(each));
                    break;
                }
                case CORRECTION: {
                    result.addAll(this.createCorrectionRules(each));
                    break;
                }
                case ANNOTATION: {
                    result.addAll(this.createAnnotationRules(each));
                    break;
                }
                case DELETION: {
                    result.addAll(this.createDeletionRules(each));
                }
            }
        }
        return this.getBestBasicRule(result);
    }

    private List<TrabalRule> getBestBasicRule(List<TrabalRule> rules) {
        if (rules.size() < this.maxNumberOfBasicRules) {
            return rules;
        }
        ArrayList<TrabalRule> result = new ArrayList<TrabalRule>();
        this.sendStatusUpdateToDelegate("Choosing basic rules... ", TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
        HashMap<Integer, Integer> distribution = new HashMap<Integer, Integer>();
        for (TrabalRule rule : rules) {
            Integer key = new Integer(rule.hashCode());
            if (distribution.containsKey(key)) {
                distribution.put(key, new Integer((Integer)distribution.get(key) + 1));
                continue;
            }
            distribution.put(key, new Integer(1));
        }
        while (result.size() < this.maxNumberOfBasicRules && distribution.size() > 0 && !this.shouldAbort()) {
            int max = 0;
            Integer maxKey = new Integer(0);
            for (Integer key : distribution.keySet()) {
                if ((Integer)distribution.get(key) <= max) continue;
                max = (Integer)distribution.get(key);
                maxKey = key;
            }
            distribution.remove(maxKey);
            ArrayList<TrabalRule> newRules = new ArrayList<TrabalRule>();
            TrabalRule example = null;
            for (TrabalRule rule : rules) {
                Integer key = new Integer(rule.hashCode());
                if (!distribution.containsKey(key) || (Integer)distribution.get(key) != max) continue;
                result.add(rule);
                if (example != null) continue;
                example = rule;
            }
            for (TrabalRule rule : rules) {
                newRules.add(rule);
            }
            rules = newRules;
        }
        if (result.size() > this.maxNumberOfBasicRules) {
            return result.subList(0, this.maxNumberOfBasicRules);
        }
        return result;
    }

    private List<TrabalRule> createShiftingRules(AnnotationError each) {
        ArrayList<TrabalRule> result = new ArrayList<TrabalRule>();
        TextRulerExample error = each.getError();
        TextRulerExample truth = each.getTruth();
        int errorBegin = error.getAnnotation().getBegin();
        int errorEnd = error.getAnnotation().getEnd();
        int truthBegin = truth.getAnnotation().getBegin();
        int truthEnd = truth.getAnnotation().getEnd();
        if (errorBegin > truthBegin && errorEnd > truthEnd || errorBegin < truthBegin && errorEnd < truthEnd) {
            result.addAll(this.createShiftAllRules(error, truth));
        } else if (errorBegin > truthBegin || errorEnd < truthEnd) {
            result.addAll(this.createExpansionRules(error, truth));
        } else {
            result.addAll(this.createShiftAllRules(error, truth));
        }
        return result;
    }

    private List<TrabalRule> createShiftAllRules(TextRulerExample error, TextRulerExample truth) {
        ArrayList<TrabalRule> result = new ArrayList<TrabalRule>();
        TextRulerExampleDocument document = error.getDocument();
        CAS cas = error.getDocumentCAS();
        List<TrabalRuleItem> truthLeftBorder = this.getBorderOfExample(truth, document, cas, true);
        List<TrabalRuleItem> truthRightBorder = this.getBorderOfExample(truth, document, cas, false);
        List<TrabalRuleItem> errorLeftBorder = this.getBorderOfExample(error, document, cas, true);
        TextRulerTarget target = error.getTarget();
        TrabalAnnotation errorAnnotation = (TrabalAnnotation)error.getAnnotation();
        TrabalAnnotation truthAnnotation = (TrabalAnnotation)truth.getAnnotation();
        for (TrabalRuleItem a : truthLeftBorder) {
            for (TrabalRuleItem b : errorLeftBorder) {
                for (TrabalRuleItem c : truthRightBorder) {
                    ShiftAllRule newRule = truth.getAnnotation().getEnd() < error.getAnnotation().getEnd() ? new ShiftAllRule(this, target, errorAnnotation, truthAnnotation, AnnotationErrorType.SHIFTING_LEFT) : new ShiftAllRule(this, target, errorAnnotation, truthAnnotation, AnnotationErrorType.SHIFTING_RIGHT);
                    newRule.setFrontBoundaryItem(a);
                    if (b.getAnnotation().getBegin() != a.getAnnotation().getBegin()) {
                        newRule.setErrorBoundaryItem(b);
                    }
                    newRule.setRearBoundaryItem(c);
                    result.add(newRule);
                }
            }
        }
        return result;
    }

    private List<TrabalRule> createExpansionRules(TextRulerExample error, TextRulerExample truth) {
        ArrayList<TrabalRule> result = new ArrayList<TrabalRule>();
        TextRulerExampleDocument document = error.getDocument();
        CAS cas = error.getDocumentCAS();
        boolean shiftToLeft = error.getAnnotation().getBegin() > truth.getAnnotation().getBegin();
        List<TrabalRuleItem> border = shiftToLeft ? this.getBorderOfExample(truth, document, cas, true) : this.getBorderOfExample(truth, document, cas, false);
        for (TrabalRuleItem item : border) {
            ExpansionRule newRule = new ExpansionRule(this, error.getTarget(), (TrabalAnnotation)error.getAnnotation(), (TrabalAnnotation)truth.getAnnotation(), AnnotationErrorType.EXPANSION);
            if (shiftToLeft) {
                newRule.setFrontBoundaryItem(item);
            } else {
                newRule.setRearBoundaryItem(item);
            }
            if (result.contains(newRule)) continue;
            result.add(newRule);
        }
        return result;
    }

    private List<TrabalRule> createAnnotationRules(AnnotationError each) {
        ArrayList<TrabalRule> result = new ArrayList<TrabalRule>();
        TextRulerExample truth = each.getTruth();
        TextRulerExampleDocument document = this.additionalDocuments.getDocuments().get(this.exampleDocuments.getDocuments().indexOf(truth.getDocument()));
        CAS cas = document.getCAS();
        List<TrabalRuleItem> truthLeftBorder = this.getBorderOfExample(truth, document, cas, true);
        List<TrabalRuleItem> truthRightBorder = this.getBorderOfExample(truth, document, cas, false);
        TextRulerTarget target = truth.getTarget();
        TrabalAnnotation truthAnnotation = (TrabalAnnotation)truth.getAnnotation();
        for (TrabalRuleItem front : truthLeftBorder) {
            for (TrabalRuleItem rear : truthRightBorder) {
                AnnotationRule newRule = new AnnotationRule(this, target, truthAnnotation);
                newRule.setFrontBoundary(front);
                newRule.setRearBoundary(rear);
                if (result.contains(newRule)) continue;
                result.add(newRule);
            }
        }
        return result;
    }

    private List<TrabalRule> createDeletionRules(AnnotationError each) {
        ArrayList<TrabalRule> result = new ArrayList<TrabalRule>();
        TextRulerExample error = each.getError();
        DeletionRule blankRule = new DeletionRule(this, error.getTarget(), (TrabalAnnotation)error.getAnnotation());
        result.add(blankRule);
        return result;
    }

    private List<TrabalRule> createCorrectionRules(AnnotationError each) {
        ArrayList<TrabalRule> result = new ArrayList<TrabalRule>();
        TextRulerExample error = each.getError();
        TextRulerExample truth = each.getTruth();
        CorrectionRule blankRule = new CorrectionRule(this, error.getTarget(), (TrabalAnnotation)error.getAnnotation(), (TrabalAnnotation)truth.getAnnotation());
        result.add(blankRule);
        return result;
    }

    private List<TrabalRuleItem> getBorderOfExample(TextRulerExample example, TextRulerExampleDocument document, CAS cas, boolean examineLeftBorder) {
        ArrayList<TrabalRuleItem> result = new ArrayList<TrabalRuleItem>();
        int begin = example.getAnnotation().getBegin();
        int end = example.getAnnotation().getEnd();
        TrabalRuleItem ruleItem = new TrabalRuleItem(begin, end, cas, this.enableFeatures);
        Type frameType = cas.getTypeSystem().getType(ANNOTATION_TYPE_FRAME);
        AnnotationFS pointer = cas.createAnnotation(frameType, begin, end);
        FSIterator iterator = cas.getAnnotationIndex().subiterator(pointer);
        if (examineLeftBorder) {
            result.addAll(this.getTermsBefore(ruleItem, document));
            iterator.moveToFirst();
            while (iterator.isValid()) {
                FeatureStructure fs = iterator.get();
                AnnotationFS a = (AnnotationFS)fs;
                if (a.getBegin() == begin && a.getEnd() < end) {
                    if (!this.filterSet.contains(a.getType().getName()) && !a.getType().getName().equals(ANNOTATION_TYPE_BASIC)) {
                        result.add(new TrabalRuleItem(new TrabalAnnotation(a, document, this.enableFeatures)));
                    }
                } else if (a.getBegin() > begin) break;
                iterator.moveToNext();
            }
        } else {
            FeatureStructure fs;
            AnnotationFS a;
            iterator.moveToLast();
            while (iterator.isValid() && (a = (AnnotationFS)(fs = iterator.get())).getBegin() > begin && a.getEnd() == end) {
                if (!this.filterSet.contains(a.getType().getName()) && !a.getType().getName().equals(ANNOTATION_TYPE_BASIC)) {
                    result.add(new TrabalRuleItem(new TrabalAnnotation(a, document, this.enableFeatures)));
                }
                iterator.moveToPrevious();
            }
            result.addAll(this.getTermsAfter(ruleItem, document));
        }
        return result;
    }

    public RankedList createConditions(List<TrabalRule> rules) {
        if (rules.size() == 0) {
            return new RankedList(this.idf);
        }
        RankedList error = new RankedList(this.idf);
        RankedList truth = new RankedList(this.idf);
        switch (rules.get(0).getErrorType()) {
            case SHIFTING_LEFT: 
            case SHIFTING_RIGHT: 
            case EXPANSION: {
                for (TrabalRule rule : rules) {
                    error.addAll(this.createConditions(rule.getAnnotation()));
                    truth.addAll(this.createConditions(rule.getTargetAnnotation()));
                }
                RankedList result = error.subtract(truth.unite(this.getPositiveExamplesFor(rules.get(0).getTargetAnnotation().getType())));
                this.setNegative(result);
                result.addAll(truth.cut(this.getPositiveExamplesFor(rules.get(0).getTargetAnnotation().getType())).subtract(error));
                return result;
            }
            case CORRECTION: {
                for (TrabalRule rule : rules) {
                    truth.addAll(this.createConditions(rule.getAnnotation()));
                }
                RankedList result = this.getPositiveExamplesFor(rules.get(0).getAnnotation().getType()).subtract(truth.unite(this.getPositiveExamplesFor(rules.get(0).getTargetAnnotation().getType())));
                this.setNegative(result);
                if (this.getPositiveExamplesFor(rules.get(0).getTargetAnnotation().getType()).size() > 0) {
                    result.addAll(truth.cut(this.getPositiveExamplesFor(rules.get(0).getTargetAnnotation().getType())).subtract(this.getPositiveExamplesFor(rules.get(0).getAnnotation().getType())));
                } else {
                    result.addAll(truth);
                }
                return result;
            }
            case ANNOTATION: {
                for (TrabalRule rule : rules) {
                    truth.addAll(this.createConditions(rule.getFrontBoundary(), rule.getRearBoundary(), rule.getTargetAnnotation()));
                }
                if (this.getPositiveExamplesFor(rules.get(0).getTargetAnnotation().getType()).size() > 0) {
                    return truth.cut(this.getPositiveExamplesFor(rules.get(0).getTargetAnnotation().getType()));
                }
                return truth;
            }
            case DELETION: {
                for (TrabalRule rule : rules) {
                    error.addAll(this.createConditions(rule.getAnnotation()));
                }
                RankedList result = this.getPositiveExamplesFor(rules.get(0).getAnnotation().getType()).subtract(error);
                this.setNegative(result);
                result.addAll(this.createConditions(rules.get(0).getAnnotation()).subtract(this.getPositiveExamplesFor(rules.get(0).getAnnotation().getType())));
                return result;
            }
        }
        return null;
    }

    public RankedList getPositiveExamplesFor(Type type) {
        if (this.positiveExamples.containsKey(type.getShortName())) {
            return this.positiveExamples.get(type.getShortName());
        }
        return new RankedList(this.idf);
    }

    public void setNegative(RankedList list) {
        for (Condition element : list.getRanking().keySet()) {
            element.setNegative();
        }
        for (Condition element : list) {
            element.setNegative();
        }
    }

    private RankedList createConditions(TrabalRuleItem frontBoundary, TrabalRuleItem rearBoundary, TrabalAnnotation truth) {
        RankedList result = new RankedList(this.idf);
        TextRulerExampleDocument doc = this.additionalDocuments.getDocuments().get(this.exampleDocuments.getDocuments().indexOf(truth.getDocument()));
        CAS cas = doc.getCAS();
        for (TrabalRuleItem trabalRuleItem : this.getTermsBefore(frontBoundary, doc)) {
            result.add(new Condition(ConditionType.AFTER, trabalRuleItem));
        }
        for (TrabalRuleItem trabalRuleItem : this.getTermsAfter(rearBoundary, doc)) {
            result.add(new Condition(ConditionType.BEFORE, trabalRuleItem));
        }
        for (TrabalRuleItem trabalRuleItem : this.getConsumingTerms(frontBoundary, doc)) {
            if (trabalRuleItem.getAnnotation().getType().equals(cas.getDocumentAnnotation().getType())) continue;
            result.add(new Condition(ConditionType.PARTOF, trabalRuleItem));
        }
        if (frontBoundary.getAnnotation().getBegin() < truth.getBegin()) {
            for (TrabalRuleItem trabalRuleItem : this.getTermsAfter(frontBoundary, doc)) {
                result.add(new Condition(ConditionType.STARTSWITH, trabalRuleItem));
            }
        } else {
            for (List list : this.getFirstTermsWithinBounds(frontBoundary.getAnnotation().getBegin(), rearBoundary.getAnnotation().getEnd(), doc, cas, 1)) {
                result.add(new Condition(ConditionType.STARTSWITH, (TrabalRuleItem)list.get(0)));
            }
        }
        if (rearBoundary.getAnnotation().getEnd() > truth.getEnd()) {
            for (TrabalRuleItem trabalRuleItem : this.getTermsBefore(rearBoundary, doc)) {
                result.add(new Condition(ConditionType.ENDSWITH, trabalRuleItem));
            }
        } else {
            for (List list : this.getLastTermsWithinBounds(rearBoundary.getAnnotation().getBegin(), frontBoundary.getAnnotation().getEnd(), doc, cas, 1)) {
                result.add(new Condition(ConditionType.ENDSWITH, (TrabalRuleItem)list.get(0)));
            }
        }
        return result;
    }

    private RankedList createConditions(TrabalAnnotation annotation) {
        RankedList result = new RankedList(this.idf);
        TrabalRuleItem ruleItem = new TrabalRuleItem(annotation);
        TextRulerExampleDocument doc = annotation.getDocument();
        CAS cas = doc.getCAS();
        for (TrabalRuleItem trabalRuleItem : this.getTermsBefore(ruleItem, doc)) {
            result.add(new Condition(ConditionType.AFTER, trabalRuleItem));
        }
        for (TrabalRuleItem trabalRuleItem : this.getTermsAfter(ruleItem, doc)) {
            result.add(new Condition(ConditionType.BEFORE, trabalRuleItem));
        }
        for (TrabalRuleItem trabalRuleItem : this.getConsumingTerms(ruleItem, doc)) {
            if (trabalRuleItem.getAnnotation().getType().equals(cas.getDocumentAnnotation().getType())) continue;
            result.add(new Condition(ConditionType.PARTOF, trabalRuleItem));
        }
        for (List list : this.getFirstTermsWithinBounds(ruleItem.getAnnotation().getBegin(), ruleItem.getAnnotation().getEnd(), doc, cas, 1)) {
            result.add(new Condition(ConditionType.STARTSWITH, (TrabalRuleItem)list.get(0)));
        }
        for (List list : this.getLastTermsWithinBounds(ruleItem.getAnnotation().getBegin(), ruleItem.getAnnotation().getEnd(), doc, cas, 1)) {
            result.add(new Condition(ConditionType.ENDSWITH, (TrabalRuleItem)list.get(0)));
        }
        for (TrabalRuleItem trabalRuleItem : this.getSingleTermsWithinBounds(ruleItem.getAnnotation().getBegin(), ruleItem.getAnnotation().getEnd(), doc, cas)) {
            result.add(new Condition(ConditionType.CONTAINS, trabalRuleItem));
        }
        return result;
    }

    private List<TrabalRuleItem> getTermsBefore(TrabalRuleItem ruleItem, TextRulerExampleDocument document) {
        ArrayList<TrabalRuleItem> result = new ArrayList<TrabalRuleItem>();
        int begin = ruleItem.getAnnotation().getBegin();
        CAS cas = document.getCAS();
        Type frameType = cas.getTypeSystem().getType(ANNOTATION_TYPE_FRAME);
        AnnotationFS pointer = cas.createAnnotation(frameType, begin, begin);
        FSIterator iterator = cas.getAnnotationIndex().iterator((FeatureStructure)pointer);
        int nextEnd = -1;
        while (iterator.isValid()) {
            AnnotationFS a;
            FeatureStructure fs = iterator.get();
            if (fs instanceof AnnotationFS && !this.filterSet.contains((a = (AnnotationFS)fs).getType().getName()) && !a.getType().getName().equals(ANNOTATION_TYPE_BASIC)) {
                if (a.getEnd() > begin) {
                    iterator.moveToPrevious();
                    continue;
                }
                if (nextEnd == -1) {
                    nextEnd = a.getEnd();
                }
                if (a.getEnd() >= nextEnd && a.getEnd() <= begin) {
                    TrabalRuleItem term = new TrabalRuleItem(new TrabalAnnotation(a, document, this.enableFeatures));
                    result.add(term);
                }
            }
            iterator.moveToPrevious();
        }
        return result;
    }

    private List<TrabalRuleItem> getTermsAfter(TrabalRuleItem ruleItem, TextRulerExampleDocument document) {
        ArrayList<TrabalRuleItem> result = new ArrayList<TrabalRuleItem>();
        int end = ruleItem.getAnnotation().getEnd();
        CAS cas = document.getCAS();
        Type frameType = cas.getTypeSystem().getType(ANNOTATION_TYPE_FRAME);
        AnnotationFS pointer = cas.createAnnotation(frameType, end, Integer.MAX_VALUE);
        FSIterator iterator = cas.getAnnotationIndex().iterator((FeatureStructure)pointer);
        int nextBegin = -1;
        while (iterator.isValid()) {
            AnnotationFS a;
            FeatureStructure fs = iterator.get();
            if (fs instanceof AnnotationFS && !this.filterSet.contains((a = (AnnotationFS)fs).getType().getName()) && !a.getType().getName().equals(ANNOTATION_TYPE_BASIC)) {
                if (nextBegin == -1) {
                    nextBegin = a.getBegin();
                }
                if (a.getBegin() <= nextBegin && a.getBegin() >= end) {
                    TrabalRuleItem term = new TrabalRuleItem(new TrabalAnnotation(a, document, this.enableFeatures));
                    result.add(term);
                }
            }
            iterator.moveToNext();
        }
        return result;
    }

    private List<List<TrabalRuleItem>> getFirstTermsWithinBounds(int startPos, int endPos, TextRulerExampleDocument document, CAS cas, int numberOfSideItems) {
        List<List<TrabalRuleItem>> preItems = new ArrayList<List<TrabalRuleItem>>();
        Type frameType = cas.getTypeSystem().getType(ANNOTATION_TYPE_FRAME);
        AnnotationFS pointer = cas.createAnnotation(frameType, startPos, endPos);
        FSIterator iterator = cas.getAnnotationIndex().iterator((FeatureStructure)pointer);
        ArrayList<AnnotationFS> startAs = new ArrayList<AnnotationFS>();
        int firstBegin = -1;
        while (iterator.isValid()) {
            FeatureStructure fs = iterator.get();
            AnnotationFS a = (AnnotationFS)fs;
            if (a.getBegin() >= startPos && a.getEnd() <= endPos) {
                if (!this.filterSet.contains(a.getType().getName()) && !a.getType().getName().equals(ANNOTATION_TYPE_BASIC)) {
                    if (firstBegin == -1) {
                        firstBegin = a.getBegin();
                    }
                    if (a.getBegin() == firstBegin) {
                        startAs.add(a);
                    }
                }
                iterator.moveToNext();
                continue;
            }
            iterator.moveToNext();
        }
        for (AnnotationFS each : startAs) {
            ArrayList<TrabalRuleItem> startList = new ArrayList<TrabalRuleItem>();
            TrabalRuleItem term = new TrabalRuleItem(new TrabalAnnotation(each, document, this.enableFeatures));
            startList.add(term);
            preItems.add(startList);
        }
        preItems = this.addFollowing(preItems, endPos, document, cas, 1, numberOfSideItems);
        return preItems;
    }

    private List<List<TrabalRuleItem>> getLastTermsWithinBounds(int startPos, int endPos, TextRulerExampleDocument document, CAS cas, int numberOfSideItems) {
        List<List<TrabalRuleItem>> postItems = new ArrayList<List<TrabalRuleItem>>();
        Type frameType = cas.getTypeSystem().getType(ANNOTATION_TYPE_FRAME);
        AnnotationFS pointer = cas.createAnnotation(frameType, startPos, endPos);
        FSIterator iterator = cas.getAnnotationIndex().iterator((FeatureStructure)pointer);
        iterator.moveToLast();
        ArrayList<AnnotationFS> endAs = new ArrayList<AnnotationFS>();
        int lastEnd = -1;
        while (iterator.isValid()) {
            FeatureStructure fs = iterator.get();
            AnnotationFS a = (AnnotationFS)fs;
            if (a.getEnd() <= endPos && a.getBegin() >= startPos) {
                if (!this.filterSet.contains(a.getType().getName()) && !a.getType().getName().equals(ANNOTATION_TYPE_BASIC)) {
                    if (lastEnd == -1) {
                        lastEnd = a.getEnd();
                    }
                    if (a.getEnd() == lastEnd) {
                        endAs.add(a);
                    }
                }
                iterator.moveToPrevious();
                continue;
            }
            iterator.moveToPrevious();
        }
        for (AnnotationFS each : endAs) {
            ArrayList<TrabalRuleItem> endList = new ArrayList<TrabalRuleItem>();
            TrabalRuleItem term = new TrabalRuleItem(new TrabalAnnotation(each, document, this.enableFeatures));
            endList.add(term);
            postItems.add(endList);
        }
        postItems = this.addPreceding(postItems, startPos, document, cas, 1, numberOfSideItems);
        return postItems;
    }

    private List<List<TrabalRuleItem>> addPreceding(List<List<TrabalRuleItem>> lists, int till, TextRulerExampleDocument document, CAS cas, int index, int maxNumberOfItems) {
        if (index >= maxNumberOfItems) {
            return lists;
        }
        ArrayList<List<TrabalRuleItem>> result = new ArrayList<List<TrabalRuleItem>>();
        for (List<TrabalRuleItem> list : lists) {
            if (this.shouldAbort()) break;
            List<List<TrabalRuleItem>> newLists = new ArrayList<List<TrabalRuleItem>>();
            TrabalRuleItem first = list.get(0);
            List<TrabalRuleItem> termsBefore = this.getTermsBefore(first, document);
            if (termsBefore.isEmpty()) continue;
            for (TrabalRuleItem eachBefore : termsBefore) {
                if (eachBefore.getAnnotation().getBegin() < till) continue;
                ArrayList<TrabalRuleItem> newList = new ArrayList<TrabalRuleItem>();
                newList.addAll(list);
                newList.add(0, eachBefore);
                newLists.add(newList);
                newLists = this.addPreceding(newLists, till, document, cas, index + 1, maxNumberOfItems);
            }
            result.addAll(newLists);
        }
        if (result.isEmpty()) {
            return lists;
        }
        return result;
    }

    private List<List<TrabalRuleItem>> addFollowing(List<List<TrabalRuleItem>> lists, int till, TextRulerExampleDocument document, CAS cas, int index, int maxNumberOfItems) {
        if (index >= maxNumberOfItems) {
            return lists;
        }
        ArrayList<List<TrabalRuleItem>> result = new ArrayList<List<TrabalRuleItem>>();
        for (List<TrabalRuleItem> list : lists) {
            if (this.shouldAbort()) break;
            List<List<TrabalRuleItem>> newLists = new ArrayList<List<TrabalRuleItem>>();
            TrabalRuleItem last = list.get(list.size() - 1);
            List<TrabalRuleItem> termsAfter = this.getTermsAfter(last, document);
            if (termsAfter.isEmpty()) continue;
            for (TrabalRuleItem eachAfter : termsAfter) {
                if (eachAfter.getAnnotation().getEnd() > till) continue;
                ArrayList<TrabalRuleItem> newList = new ArrayList<TrabalRuleItem>();
                newList.addAll(list);
                newList.add(eachAfter);
                newLists.add(newList);
                newLists = this.addFollowing(newLists, till, document, cas, index + 1, maxNumberOfItems);
            }
            result.addAll(newLists);
        }
        if (result.isEmpty()) {
            return lists;
        }
        return result;
    }

    private List<TrabalRuleItem> getConsumingTerms(TrabalRuleItem ruleItem, TextRulerExampleDocument document) {
        TrabalAnnotation annotation;
        CAS cas = document.getCAS();
        ArrayList<TrabalRuleItem> result = new ArrayList<TrabalRuleItem>();
        int begin = ruleItem.getAnnotation().getBegin();
        Type frameType = cas.getTypeSystem().getType(ANNOTATION_TYPE_FRAME);
        AnnotationFS pointer = cas.createAnnotation(frameType, 0, begin);
        FSIterator iterator = cas.getAnnotationIndex().iterator((FeatureStructure)pointer);
        while (iterator.hasNext() && (annotation = new TrabalAnnotation((AnnotationFS)iterator.next(), this.enableFeatures)).getBegin() < begin) {
            if (annotation.getEnd() < ruleItem.getAnnotation().getEnd()) continue;
            result.add(new TrabalRuleItem(annotation));
        }
        return result;
    }

    private List<TrabalRuleItem> getSingleTermsWithinBounds(int begin, int end, TextRulerExampleDocument doc, CAS cas) {
        TrabalAnnotation annotation;
        HashSet<TrabalRuleItem> result = new HashSet<TrabalRuleItem>();
        Type frameType = cas.getTypeSystem().getType(ANNOTATION_TYPE_FRAME);
        AnnotationFS pointer = cas.createAnnotation(frameType, begin, end);
        FSIterator iterator = cas.getAnnotationIndex().iterator((FeatureStructure)pointer);
        while (iterator.hasNext() && (annotation = new TrabalAnnotation((AnnotationFS)iterator.next(), this.enableFeatures)).getBegin() <= end) {
            if (this.filterSet.contains(annotation.getType().getName()) || annotation.getType().getName().equals(ANNOTATION_TYPE_BASIC)) continue;
            result.add(new TrabalRuleItem(annotation));
        }
        return new ArrayList<TrabalRuleItem>(result);
    }

    public List<TrabalRule> testTrabalRulesOnDocumentSet(List<TrabalRule> rules, TextRulerExampleDocumentSet documents, TextRulerExampleDocumentSet additionalDocuments, String ruleSet) {
        if (rules.isEmpty()) {
            return rules;
        }
        ArrayList<TextRulerStatisticsCollector> sums = new ArrayList<TextRulerStatisticsCollector>();
        for (TrabalRule each : rules) {
            sums.add(new TextRulerStatisticsCollector());
        }
        List<TextRulerExampleDocument> goldDocs = documents.getDocuments();
        List<TextRulerExampleDocument> additionalDocs = additionalDocuments.getDocuments();
        CAS theTestCAS = this.getTestCAS();
        int counter = 0;
        for (TrabalRule rule : rules) {
            ++counter;
            String ruleString = rule.getRuleString();
            String ruleInfo = this.getRuleInfo(rule);
            System.out.println("testing: " + ruleString);
            if (this.inducedRules.containsKey(ruleString)) {
                rule.setCoveringStatistics(this.inducedRules.get(ruleString));
                System.out.println("skipped with " + this.inducedRules.get(ruleString));
                continue;
            }
            for (int i = 0; i < goldDocs.size(); ++i) {
                int p;
                TextRulerExampleDocument goldDoc = goldDocs.get(i);
                TextRulerExampleDocument additionalDoc = additionalDocs.get(i);
                this.sendStatusUpdateToDelegate("Testing " + ruleSet + ruleInfo + " on document " + (i + 1) + " of " + goldDocs.size() + " : rule " + counter + " of " + rules.size(), TextRulerLearner.TextRulerLearnerState.ML_RUNNING, false);
                TextRulerStatisticsCollector sumC = new TextRulerStatisticsCollector();
                this.prepareTestCas(theTestCAS, goldDoc, additionalDoc);
                this.testRuleOnDocument(rule, goldDoc, additionalDoc, sumC, theTestCAS);
                ((TextRulerStatisticsCollector)sums.get(counter - 1)).add(sumC);
                int n = sumC.getCoveredNegativesCount();
                int pnorm = p = sumC.getCoveredPositivesCount();
                if (pnorm == 0) {
                    pnorm = 1;
                }
                if ((double)(n / pnorm) > this.maxErrorRate) {
                    System.out.println("stopped:" + sumC);
                    break;
                }
                if (!this.shouldAbort()) continue;
                return rules;
            }
            TextRulerStatisticsCollector c = (TextRulerStatisticsCollector)sums.get(counter - 1);
            rule.setCoveringStatistics((TextRulerStatisticsCollector)sums.get(counter - 1));
            this.inducedRules.put(ruleString, c);
        }
        for (int ruleIndex = 0; ruleIndex < rules.size(); ++ruleIndex) {
            rules.get(ruleIndex).setCoveringStatistics((TextRulerStatisticsCollector)sums.get(ruleIndex));
        }
        sums.clear();
        return rules;
    }

    private String getRuleInfo(TrabalRule rule) {
        String ruleInfo = rule.getAnnotation() != null && rule.getTargetAnnotation() != null ? " " + rule.getAnnotation().getType().getShortName() + "(" + rule.getAnnotation().getBegin() + "," + rule.getAnnotation().getEnd() + ") -> " + rule.getTargetAnnotation().getType().getShortName() + "(" + rule.getTargetAnnotation().getBegin() + "," + rule.getTargetAnnotation().getEnd() + ")" : (rule.getTargetAnnotation() != null ? " Annotate " + rule.getTargetAnnotation().getType().getShortName() + "(" + rule.getTargetAnnotation().getBegin() + "," + rule.getTargetAnnotation().getEnd() + ")" : " Delete " + rule.getAnnotation().getType().getShortName() + "(" + rule.getAnnotation().getBegin() + "," + rule.getAnnotation().getEnd() + ")");
        return ruleInfo;
    }

    private void prepareTestCas(CAS testCas, TextRulerExampleDocument goldDoc, TextRulerExampleDocument additionalDoc) {
        testCas.reset();
        CAS goldCas = goldDoc.getCAS();
        CAS additionalCas = additionalDoc.getCAS();
        testCas.setDocumentText(goldCas.getDocumentText());
        CasCopier.copyCas((CAS)additionalCas, (CAS)testCas, (testCas.getDocumentText() == null ? 1 : 0) != 0);
    }

    private void testRuleOnDocument(TrabalRule rule, TextRulerExampleDocument goldDoc, TextRulerExampleDocument additionalDoc, TextRulerStatisticsCollector c, CAS testCas) {
        try {
            rule.saveToRulesFile(this.getTempRulesFileName());
            this.ae.process(testCas);
            this.removeBasics(testCas);
            if (rule.getAnnotation() != null && rule.getTargetAnnotation() != null) {
                this.compareOriginalDocumentWithTestCAS(goldDoc, additionalDoc, testCas, new TextRulerTarget(rule.getAnnotation().getType().getName(), (TextRulerBasicLearner)this), c, false);
                if (rule.getAnnotation().getType() != rule.getTargetAnnotation().getType()) {
                    this.compareOriginalDocumentWithTestCAS(goldDoc, additionalDoc, testCas, new TextRulerTarget(rule.getTargetAnnotation().getType().getName(), (TextRulerBasicLearner)this), c, false);
                }
            } else if (rule.getTargetAnnotation() != null) {
                this.compareOriginalDocumentWithTestCAS(goldDoc, additionalDoc, testCas, new TextRulerTarget(rule.getTargetAnnotation().getType().getName(), (TextRulerBasicLearner)this), c, false);
            } else {
                this.compareOriginalDocumentWithTestCAS(goldDoc, additionalDoc, testCas, new TextRulerTarget(rule.getAnnotation().getType().getName(), (TextRulerBasicLearner)this), c, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void compareOriginalDocumentWithTestCAS(TextRulerExampleDocument goldDoc, TextRulerExampleDocument additionalDoc, CAS testCas, TextRulerTarget target, TextRulerStatisticsCollector c, boolean collectNegativeExamples) {
        TextRulerExample example;
        List<TextRulerExample> goldPositives = goldDoc.createSlotInstancesForCAS(goldDoc.getCAS(), target, true);
        List<TextRulerExample> additionalPositives = additionalDoc.createSlotInstancesForCAS(additionalDoc.getCAS(), target, true);
        List<TextRulerExample> testPositives = goldDoc.createSlotInstancesForCAS(testCas, target, false);
        ArrayList<TextRulerExample> baseFP = new ArrayList<TextRulerExample>();
        for (TextRulerExample e : additionalPositives) {
            TextRulerExample example2 = TextRulerToolkit.exampleListContainsAnnotation(goldPositives, e.getAnnotation());
            if (example2 != null) continue;
            baseFP.add(e);
        }
        ArrayList<TextRulerExample> baseFN = new ArrayList<TextRulerExample>();
        for (TextRulerExample e : goldPositives) {
            TextRulerExample example3 = TextRulerToolkit.exampleListContainsAnnotation(additionalPositives, e.getAnnotation());
            if (example3 != null) continue;
            baseFN.add(e);
        }
        ArrayList<TextRulerExample> testFP = new ArrayList<TextRulerExample>();
        for (TextRulerExample e : testPositives) {
            TextRulerExample example4 = TextRulerToolkit.exampleListContainsAnnotation(goldPositives, e.getAnnotation());
            if (example4 != null) continue;
            testFP.add(e);
        }
        ArrayList<TextRulerExample> testFN = new ArrayList<TextRulerExample>();
        for (TextRulerExample e : goldPositives) {
            example = TextRulerToolkit.exampleListContainsAnnotation(testPositives, e.getAnnotation());
            if (example != null) continue;
            testFN.add(e);
        }
        for (TextRulerExample e : baseFP) {
            example = TextRulerToolkit.exampleListContainsAnnotation(testFP, e.getAnnotation());
            if (example != null) continue;
            c.addCoveredPositive(e);
        }
        for (TextRulerExample e : baseFN) {
            example = TextRulerToolkit.exampleListContainsAnnotation(testFN, e.getAnnotation());
            TextRulerExample coveredExample = TextRulerToolkit.exampleListContainsAnnotation(goldPositives, e.getAnnotation());
            if (example != null) continue;
            c.addCoveredPositive(coveredExample);
        }
        for (TextRulerExample e : testFN) {
            example = TextRulerToolkit.exampleListContainsAnnotation(baseFN, e.getAnnotation());
            if (example != null) continue;
            if (collectNegativeExamples) {
                e.setPositive(false);
                c.addCoveredNegative(e);
                continue;
            }
            c.incCoveredNegatives(1);
        }
        for (TextRulerExample e : testFP) {
            example = TextRulerToolkit.exampleListContainsAnnotation(baseFP, e.getAnnotation());
            if (example != null) continue;
            c.incCoveredNegatives(1);
        }
    }

    public static List<TrabalRule> removeDuplicateRules(List<TrabalRule> rules) {
        return new ArrayList<TrabalRule>(new HashSet<TrabalRule>(rules));
    }

    public static String getRuleStrings(List<TrabalRule> rules) {
        String result = "";
        for (TrabalRule r : rules) {
            result = result + r.toString();
        }
        return result;
    }

    public boolean isSlotType(Type type) {
        for (String slot : this.slotNames) {
            if (!slot.equals(type.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean collectNegativeCoveredInstancesWhenTesting() {
        return false;
    }

    @Override
    public String getResultString() {
        return this.getFileHeaderString(true) + this.result;
    }

    public TextRulerExampleDocumentSet getAdditionalDocuments() {
        if (this.additionalDocuments == null && !StringUtils.isBlank((CharSequence)this.additionalFolderPath)) {
            this.additionalDocuments = new TextRulerExampleDocumentSet(this.additionalFolderPath, this.casCache);
        }
        return this.additionalDocuments;
    }

    public boolean getEnableFeatures() {
        return this.enableFeatures;
    }

    @Override
    public void setParameters(Map<String, Object> params) {
        if (params.containsKey(MAX_NUMBER_OF_BASIC_RULES_KEY)) {
            this.maxNumberOfBasicRules = (Integer)params.get(MAX_NUMBER_OF_BASIC_RULES_KEY);
        }
        if (params.containsKey(MAX_NUMBER_OF_RULES_KEY)) {
            this.maxNumberOfRules = (Integer)params.get(MAX_NUMBER_OF_RULES_KEY);
        }
        if (params.containsKey(MAX_NUMBER_OF_ITERATIONS_KEY)) {
            this.maxNumberOfIterations = (Integer)params.get(MAX_NUMBER_OF_ITERATIONS_KEY);
        }
        if (params.containsKey(ALGORITHM_ITERATIONS_KEY)) {
            this.algorithmIterations = (Integer)params.get(ALGORITHM_ITERATIONS_KEY);
        }
        if (params.containsKey(MAX_ERROR_RATE_KEY)) {
            this.maxErrorRate = (Double)params.get(MAX_ERROR_RATE_KEY);
        }
        if (params.containsKey(ENABLE_FEATURES_KEY)) {
            this.enableFeatures = (Boolean)params.get(ENABLE_FEATURES_KEY);
        }
    }

    public void getErrorsAsCSV(String filePath) throws Exception {
        String result = "";
        if (this.exampleDocuments == null) {
            this.exampleDocuments = new TextRulerExampleDocumentSet(this.inputDirectory, this.casCache);
        }
        this.getAdditionalDocuments();
        this.errors = this.createErrorList();
        result = result + "'ErrorType';'FileName';'AnnotationType';'Annotation';'TargetAnnotationType';'TargetAnnotation';\n";
        for (AnnotationError each : this.errors) {
            if (each.getAnnotation() != null && each.getTargetAnnotation() != null) {
                result = result + "'" + (Object)((Object)each.getType()) + "';'" + new File(each.getAnnotation().getDocument().getCasFileName()).getName() + "';'" + each.getAnnotation().getType().getShortName() + "';'" + each.getAnnotation().getCoveredText() + "';'" + each.getTargetAnnotation().getType().getShortName() + "';'" + each.getTargetAnnotation().getCoveredText() + "';\n";
                continue;
            }
            if (each.getAnnotation() != null) {
                result = result + "'" + (Object)((Object)each.getType()) + "';'" + new File(each.getAnnotation().getDocument().getCasFileName()).getName() + "';'" + each.getAnnotation().getType().getShortName() + "';'" + each.getAnnotation().getCoveredText() + "';'';'';\n";
                continue;
            }
            result = result + "'" + (Object)((Object)each.getType()) + "';'" + new File(each.getTargetAnnotation().getDocument().getCasFileName()).getName() + "';'';'';'" + each.getTargetAnnotation().getType().getShortName() + "';'" + each.getTargetAnnotation().getCoveredText() + "';\n";
        }
        if (this.errors.size() > 0) {
            File csv = new File(filePath);
            FileWriter fstream = new FileWriter(csv);
            BufferedWriter out = new BufferedWriter(fstream);
            out.write(result);
            out.close();
        }
    }

    static {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add("sofa");
        tmp.add("begin");
        tmp.add("end");
        FILTERED_FEATURES = tmp;
    }
}

