/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.IntArrayFSImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.CommonPrimitiveArray;
import org.apache.uima.jcas.cas.TOP;

public final class IntegerArray
extends TOP
implements CommonPrimitiveArray<Integer>,
IntArrayFSImpl,
Iterable<Integer> {
    public static final String _TypeName = "uima.cas.IntegerArray";
    public static final int typeIndexID;
    public static final int type;
    private final int[] theArray;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    private IntegerArray() {
        this.theArray = null;
    }

    public IntegerArray(JCas jcas, int length) {
        super(jcas);
        this.theArray = new int[length];
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
        if (this._casView.isId2Fs()) {
            this._casView.adjustLastFsV2Size_arrays(length);
        }
    }

    public IntegerArray(TypeImpl t, CASImpl c, int length) {
        super(t, c);
        this.theArray = new int[length];
        if (CASImpl.traceFSs) {
            this._casView.traceFSCreate(this);
        }
        if (this._casView.isId2Fs()) {
            this._casView.adjustLastFsV2Size_arrays(length);
        }
    }

    @Override
    public int get(int i) {
        return this.theArray[i];
    }

    @Override
    public void set(int i, int v) {
        this.theArray[i] = v;
        this._casView.maybeLogArrayUpdate(this, null, i);
    }

    @Override
    public void copyFromArray(int[] src, int srcPos, int destPos, int length) {
        System.arraycopy(src, srcPos, this.theArray, destPos, length);
        this._casView.maybeLogArrayUpdates(this, destPos, length);
    }

    @Override
    public void copyToArray(int srcPos, int[] dest, int destPos, int length) {
        System.arraycopy(this.theArray, srcPos, dest, destPos, length);
    }

    @Override
    public int[] toArray() {
        return Arrays.copyOf(this.theArray, this.theArray.length);
    }

    @Override
    public int size() {
        return this.theArray.length;
    }

    @Override
    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        this._casView.checkArrayBounds(this.theArray.length, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = Integer.toString(this.theArray[i + srcOffset]);
        }
    }

    @Override
    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        this._casView.checkArrayBounds(this.theArray.length, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            this.set(i + destOffset, Integer.parseInt(src[i + srcOffset]));
        }
    }

    public int[] _getTheArray() {
        return this.theArray;
    }

    @Override
    public void copyValuesFrom(CommonArrayFS v) {
        IntegerArray bv = (IntegerArray)v;
        System.arraycopy(bv.theArray, 0, this.theArray, 0, this.theArray.length);
        this._casView.maybeLogArrayUpdates(this, 0, this.size());
    }

    @Override
    public void setArrayValueFromString(int i, String v) {
        this.set(i, Integer.parseInt(v));
    }

    public Spliterator.OfInt spliterator() {
        return Arrays.spliterator(this.theArray);
    }

    public PrimitiveIterator.OfInt iterator() {
        return new PrimitiveIterator.OfInt(){
            int i = 0;

            @Override
            public void forEachRemaining(IntConsumer action) {
                int sz = IntegerArray.this.size();
                while (this.i < sz) {
                    action.accept(IntegerArray.this.theArray[this.i]);
                    ++this.i;
                }
            }

            @Override
            public boolean hasNext() {
                return this.i < IntegerArray.this.size();
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return IntegerArray.this.get(this.i++);
            }

            @Override
            public int nextInt() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return IntegerArray.this.get(this.i++);
            }
        };
    }

    public IntStream stream() {
        return Arrays.stream(this.theArray);
    }

    public static IntegerArray create(JCas jcas, int[] a) {
        IntegerArray intArray = new IntegerArray(jcas, a.length);
        intArray.copyFromArray(a, 0, 0, a.length);
        return intArray;
    }

    public void forEach(IntConsumer action) {
        for (int d : this.theArray) {
            action.accept(d);
        }
    }

    public boolean contains(int item) {
        for (int b : this.theArray) {
            if (b != item) continue;
            return true;
        }
        return false;
    }

    static {
        type = typeIndexID = JCasRegistry.register(IntegerArray.class);
    }
}

