/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;

public abstract class ClassAttributeModifier
extends AttributeAppender {
    private static final Pattern SPLITTER = Pattern.compile("\\s+");

    public ClassAttributeModifier() {
        super("class", (IModel<?>)null, " ");
    }

    @Override
    protected Serializable newValue(String currentValue, String appendValue) {
        String[] classes = Strings.isEmpty((String)currentValue) ? new String[]{} : SPLITTER.split(currentValue.trim());
        TreeSet<String> oldClasses = new TreeSet<String>();
        Collections.addAll(oldClasses, classes);
        Set<String> newClasses = this.update(oldClasses);
        String separator = this.getSeparator();
        StringBuilder result = new StringBuilder();
        for (String cls : newClasses) {
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(cls);
        }
        return result.length() > 0 ? result.toString() : VALUELESS_ATTRIBUTE_REMOVE;
    }

    protected abstract Set<String> update(Set<String> var1);
}

