/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.axiom.core.util.EdgeRelation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TopologicalSort {
    private TopologicalSort() {
    }

    private static <T> void visit(Collection<T> vertices, EdgeRelation<? super T> edgeRelation, List<T> result, Set<T> visited, T vertex) {
        if (visited.add(vertex)) {
            for (T vertex2 : vertices) {
                if (vertex2 == vertex || !edgeRelation.isEdge(vertex, vertex2)) continue;
                TopologicalSort.visit(vertices, edgeRelation, result, visited, vertex2);
            }
            result.add(vertex);
        }
    }

    public static <T> List<T> sort(Collection<T> vertices, EdgeRelation<? super T> edgeRelation) {
        ArrayList result = new ArrayList(vertices.size());
        HashSet visited = new HashSet();
        for (T vertex : vertices) {
            TopologicalSort.visit(vertices, edgeRelation, result, visited, vertex);
        }
        return result;
    }
}

