/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.common.factory;

import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.core.NodeFactory;
import org.apache.axiom.mime.MultipartBody;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.OMMetaFactorySPI;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.common.factory.BuilderFactory;
import org.apache.axiom.om.impl.common.factory.BuilderSpec;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class AbstractOMMetaFactory
implements OMMetaFactorySPI {
    private final NodeFactory nodeFactory;

    public AbstractOMMetaFactory(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public OMXMLParserWrapper createStAXOMBuilder(XMLStreamReader parser) {
        return BuilderFactory.OM.createBuilder(this.nodeFactory, BuilderSpec.from(parser));
    }

    public OMXMLParserWrapper createOMBuilder(StAXParserConfiguration configuration, InputSource is) {
        return BuilderFactory.OM.createBuilder(this.nodeFactory, BuilderSpec.from(configuration, is));
    }

    public OMXMLParserWrapper createOMBuilder(Source source) {
        return BuilderFactory.OM.createBuilder(this.nodeFactory, BuilderSpec.from(StAXParserConfiguration.DEFAULT, source));
    }

    public OMXMLParserWrapper createOMBuilder(Node node, boolean expandEntityReferences) {
        return BuilderFactory.OM.createBuilder(this.nodeFactory, BuilderSpec.from(node, expandEntityReferences));
    }

    public OMXMLParserWrapper createOMBuilder(SAXSource source, boolean expandEntityReferences) {
        return BuilderFactory.OM.createBuilder(this.nodeFactory, BuilderSpec.from(source, expandEntityReferences));
    }

    public OMXMLParserWrapper createOMBuilder(StAXParserConfiguration configuration, MultipartBody message) {
        return BuilderFactory.OM.createBuilder(this.nodeFactory, BuilderSpec.from(configuration, message));
    }

    public OMXMLParserWrapper createOMBuilder(Source rootPart, OMAttachmentAccessor attachmentAccessor) {
        return BuilderFactory.OM.createBuilder(this.nodeFactory, BuilderSpec.from(StAXParserConfiguration.DEFAULT, rootPart, attachmentAccessor));
    }

    public SOAPModelBuilder createStAXSOAPModelBuilder(XMLStreamReader parser) {
        return BuilderFactory.SOAP.createBuilder(this.nodeFactory, BuilderSpec.from(parser));
    }

    public SOAPModelBuilder createSOAPModelBuilder(InputSource is) {
        return BuilderFactory.SOAP.createBuilder(this.nodeFactory, BuilderSpec.from(StAXParserConfiguration.SOAP, is));
    }

    public SOAPModelBuilder createSOAPModelBuilder(Source source) {
        return BuilderFactory.SOAP.createBuilder(this.nodeFactory, BuilderSpec.from(StAXParserConfiguration.SOAP, source));
    }

    public SOAPModelBuilder createSOAPModelBuilder(MultipartBody message) {
        return BuilderFactory.SOAP.createBuilder(this.nodeFactory, BuilderSpec.from(StAXParserConfiguration.SOAP, message));
    }

    public SOAPModelBuilder createSOAPModelBuilder(Source rootPart, OMAttachmentAccessor attachmentAccessor) {
        return BuilderFactory.SOAP.createBuilder(this.nodeFactory, BuilderSpec.from(StAXParserConfiguration.SOAP, rootPart, attachmentAccessor));
    }
}

