<?xml version="1.0" encoding="UTF-8" ?>
<!--
/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
-->

<!--
* ====================================================================
* wsdl-viewer-global.xsl
* Author: tomi vanek
* ====================================================================
* Description:
* 		Global params and variables
* ====================================================================
-->

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:ws="http://schemas.xmlsoap.org/wsdl/"
	xmlns:ws2="http://www.w3.org/ns/wsdl"
	xmlns:xsd="http://www.w3.org/2001/XMLSchema"
	xmlns:soap="http://schemas.xmlsoap.org/wsdl/soap/"
	xmlns:local="http://tomi.vanek.sk/xml/wsdl-viewer"
	exclude-result-prefixes="ws ws2 xsd soap local">

<!--
==================================================================
	Rendering detail customization
	The rendered information blocks can be switched on/off
==================================================================
-->
<xsl:param name="ENABLE-SERVICE-PARAGRAPH" select="true()"/>
<xsl:param name="ENABLE-OPERATIONS-PARAGRAPH" select="true()"/>
<xsl:param name="ENABLE-SRC-CODE-PARAGRAPH" select="true()"/>
<xsl:param name="ENABLE-ABOUT-PARAGRAPH" select="true()"/>
<xsl:param name="ENABLE-OPERATIONS-TYPE" select="true()"/>
<xsl:param name="ENABLE-LINK" select="true()"/>
<xsl:param name="ENABLE-INOUTFAULT" select="true()"/>
<xsl:param name="ENABLE-STYLEOPTYPEPATH" select="true()"/>
<xsl:param name="ENABLE-DESCRIPTION" select="true()"/>
<xsl:param name="ENABLE-PORTTYPE-NAME" select="true()"/>

<xsl:param name="ENABLE-ANTIRECURSION-PROTECTION" select="true()"/>
<xsl:param name="ANTIRECURSION-DEPTH">3</xsl:param>

<!--
==================================================================
	Constants
==================================================================
-->
<xsl:variable name="GENERATED-BY">Generated by wsdl-viewer.xsl</xsl:variable>
<xsl:variable name="PORT-TYPE-TEXT">Port type</xsl:variable>
<xsl:variable name="IFACE-TEXT">Interface</xsl:variable>
<xsl:variable name="SOURCE-CODE-TEXT">Source code</xsl:variable>
<xsl:variable name="RECURSIVE"> ... is recursive</xsl:variable>

<xsl:variable name="SRC-PREFIX">src.</xsl:variable>
<xsl:variable name="SRC-FILE-PREFIX">src.file.</xsl:variable>
<xsl:variable name="OPERATIONS-PREFIX">op.</xsl:variable>
<xsl:variable name="PORT-PREFIX">port.</xsl:variable>
<xsl:variable name="IFACE-PREFIX">iface.</xsl:variable>

<!--
==================================================================
	Global variables
==================================================================
-->

<xsl:variable name="global.wsdl-name" select="/*/*[(local-name() = 'import' or local-name() = 'include') and @location][1]/@location"/>
<xsl:variable name="consolidated-wsdl" select="/* | document($global.wsdl-name)/*"/>

<xsl:variable name="global.xsd-name" select="($consolidated-wsdl/*[local-name() = 'types']//xsd:import[@schemaLocation] | $consolidated-wsdl/*[local-name() = 'types']//xsd:include[@schemaLocation])[1]/@schemaLocation"/>
<xsl:variable name="consolidated-xsd" select="(document($global.xsd-name)/xsd:schema/xsd:*|/*/*[local-name() = 'types']/xsd:schema/xsd:*)[local-name() = 'complexType' or local-name() = 'element' or local-name() = 'simpleType']"/>
<xsl:variable name="global.service-name" select="concat($consolidated-wsdl/ws:service/@name, $consolidated-wsdl/ws2:service/@name)" />
<xsl:variable name="global.binding-name" select="concat($consolidated-wsdl/ws:binding/@name, $consolidated-wsdl/ws2:binding/@name)" />

<xsl:variable name="html-title">
	<xsl:apply-templates select="/*" mode="html-title.render"/>
</xsl:variable>

</xsl:stylesheet>
