/* tables.c

   Tables of information... */

/*
 * Copyright (c) 1996-1999 Internet Software Consortium.
 * Use is subject to license terms which appear in the file named
 * ISC-LICENSE that should have accompanied this file when you
 * received it.   If a file named ISC-LICENSE did not accompany this
 * file, or you are not sure the one you have is correct, you may
 * obtain an applicable copy of the license at:
 *
 *             http://www.isc.org/isc-license-1.0.html. 
 *
 * This file is part of the ISC DHCP distribution.   The documentation
 * associated with this file is listed in the file DOCUMENTATION,
 * included in the top-level directory of this release.
 *
 * Support and other services are available for ISC products - see
 * http://www.isc.org for more information.
 */

#ifndef lint
static char copyright[] =
"$Id: tables.c,v 1.28 1999/07/01 19:00:13 mellon Exp $ Copyright (c) 1995, 1996, 1998, 1999 The Internet Software Consortium.  All rights reserved.\n";
#endif /* not lint */

#include "dhcpd.h"

/* DHCP Option names, formats and codes, from RFC1533.

   Format codes:

   e - end of data
   I - IP address
   l - 32-bit signed integer
   L - 32-bit unsigned integer
   s - 16-bit signed integer
   S - 16-bit unsigned integer
   b - 8-bit signed integer
   B - 8-bit unsigned integer
   t - ASCII text
   f - flag (true or false)
   A - array of whatever precedes (e.g., IA means array of IP addresses)
   U - name of an option space (universe)
*/

struct universe dhcp_universe;
struct option dhcp_options [256] = {
	{ "pad", "",					&dhcp_universe, 0 },
	{ "subnet-mask", "I",				&dhcp_universe, 1 },
	{ "time-offset", "l",				&dhcp_universe, 2 },
	{ "routers", "IA",				&dhcp_universe, 3 },
	{ "time-servers", "IA",				&dhcp_universe, 4 },
	{ "ien116-name-servers", "IA",			&dhcp_universe, 5 },
	{ "domain-name-servers", "IA",			&dhcp_universe, 6 },
	{ "log-servers", "IA",				&dhcp_universe, 7 },
	{ "cookie-servers", "IA",			&dhcp_universe, 8 },
	{ "lpr-servers", "IA",				&dhcp_universe, 9 },
	{ "impress-servers", "IA",			&dhcp_universe, 10 },
	{ "resource-location-servers", "IA",		&dhcp_universe, 11 },
	{ "host-name", "X",				&dhcp_universe, 12 },
	{ "boot-size", "S",				&dhcp_universe, 13 },
	{ "merit-dump", "t",				&dhcp_universe, 14 },
	{ "domain-name", "t",				&dhcp_universe, 15 },
	{ "swap-server", "I",				&dhcp_universe, 16 },
	{ "root-path", "t",				&dhcp_universe, 17 },
	{ "extensions-path", "t",			&dhcp_universe, 18 },
	{ "ip-forwarding", "f",				&dhcp_universe, 19 },
	{ "non-local-source-routing", "f",		&dhcp_universe, 20 },
	{ "policy-filter", "IIA",			&dhcp_universe, 21 },
	{ "max-dgram-reassembly", "S",			&dhcp_universe, 22 },
	{ "default-ip-ttl", "B",			&dhcp_universe, 23 },
	{ "path-mtu-aging-timeout", "L",		&dhcp_universe, 24 },
	{ "path-mtu-plateau-table", "SA",		&dhcp_universe, 25 },
	{ "interface-mtu", "S",				&dhcp_universe, 26 },
	{ "all-subnets-local", "f",			&dhcp_universe, 27 },
	{ "broadcast-address", "I",			&dhcp_universe, 28 },
	{ "perform-mask-discovery", "f",		&dhcp_universe, 29 },
	{ "mask-supplier", "f",				&dhcp_universe, 30 },
	{ "router-discovery", "f",			&dhcp_universe, 31 },
	{ "router-solicitation-address", "I",		&dhcp_universe, 32 },
	{ "static-routes", "IIA",			&dhcp_universe, 33 },
	{ "trailer-encapsulation", "f",			&dhcp_universe, 34 },
	{ "arp-cache-timeout", "L",			&dhcp_universe, 35 },
	{ "ieee802-3-encapsulation", "f",		&dhcp_universe, 36 },
	{ "default-tcp-ttl", "B",			&dhcp_universe, 37 },
	{ "tcp-keepalive-interval", "L",		&dhcp_universe, 38 },
	{ "tcp-keepalive-garbage", "f",			&dhcp_universe, 39 },
	{ "nis-domain", "t",				&dhcp_universe, 40 },
	{ "nis-servers", "IA",				&dhcp_universe, 41 },
	{ "ntp-servers", "IA",				&dhcp_universe, 42 },
	{ "vendor-encapsulated-options", "X",		&dhcp_universe, 43 },
	{ "netbios-name-servers", "IA",			&dhcp_universe, 44 },
	{ "netbios-dd-server", "IA",			&dhcp_universe, 45 },
	{ "netbios-node-type", "B",			&dhcp_universe, 46 },
	{ "netbios-scope", "t",				&dhcp_universe, 47 },
	{ "font-servers", "IA",				&dhcp_universe, 48 },
	{ "x-display-manager", "IA",			&dhcp_universe, 49 },
	{ "dhcp-requested-address", "I",		&dhcp_universe, 50 },
	{ "dhcp-lease-time", "L",			&dhcp_universe, 51 },
	{ "dhcp-option-overload", "B",			&dhcp_universe, 52 },
	{ "dhcp-message-type", "B",			&dhcp_universe, 53 },
	{ "dhcp-server-identifier", "I",		&dhcp_universe, 54 },
	{ "dhcp-parameter-request-list", "BA",		&dhcp_universe, 55 },
	{ "dhcp-message", "t",				&dhcp_universe, 56 },
	{ "dhcp-max-message-size", "S",			&dhcp_universe, 57 },
	{ "dhcp-renewal-time", "L",			&dhcp_universe, 58 },
	{ "dhcp-rebinding-time", "L",			&dhcp_universe, 59 },
	{ "vendor-class-identifier", "X",		&dhcp_universe, 60 },
	{ "dhcp-client-identifier", "X",		&dhcp_universe, 61 },
	{ "option-62", "X",				&dhcp_universe, 62 },
	{ "option-63", "X",				&dhcp_universe, 63 },
	{ "nisplus-domain", "t",			&dhcp_universe, 64 },
	{ "nisplus-servers", "IA",			&dhcp_universe, 65 },
	{ "tftp-server-name", "t",			&dhcp_universe, 66 },
	{ "bootfile-name", "t",				&dhcp_universe, 67 },
	{ "mobile-ip-home-agent", "IA",			&dhcp_universe, 68 },
	{ "smtp-server", "IA",				&dhcp_universe, 69 },
	{ "pop-server", "IA",				&dhcp_universe, 70 },
	{ "nntp-server", "IA",				&dhcp_universe, 71 },
	{ "www-server", "IA",				&dhcp_universe, 72 },
	{ "finger-server", "IA",			&dhcp_universe, 73 },
	{ "irc-server", "IA",				&dhcp_universe, 74 },
	{ "streettalk-server", "IA",			&dhcp_universe, 75 },
	{ "streettalk-directory-assistance-server", "IA", &dhcp_universe, 76 },
	{ "user-class", "t",				&dhcp_universe, 77 },
	{ "option-78", "X",				&dhcp_universe, 78 },
	{ "option-79", "X",				&dhcp_universe, 79 },
	{ "option-80", "X",				&dhcp_universe, 80 },
	{ "option-81", "X",				&dhcp_universe, 81 },
	{ "option-82", "X",				&dhcp_universe, 82 },
	{ "option-83", "X",				&dhcp_universe, 83 },
	{ "option-84", "X",				&dhcp_universe, 84 },
	{ "nds-servers", "IA",				&dhcp_universe, 85 },
	{ "nds-tree-name", "X",				&dhcp_universe, 86 },
	{ "nds-context", "X",				&dhcp_universe, 87 },
	{ "option-88", "X",				&dhcp_universe, 88 },
	{ "option-89", "X",				&dhcp_universe, 89 },
	{ "option-90", "X",				&dhcp_universe, 90 },
	{ "option-91", "X",				&dhcp_universe, 91 },
	{ "option-92", "X",				&dhcp_universe, 92 },
	{ "option-93", "X",				&dhcp_universe, 93 },
	{ "option-94", "X",				&dhcp_universe, 94 },
	{ "option-95", "X",				&dhcp_universe, 95 },
	{ "option-96", "X",				&dhcp_universe, 96 },
	{ "option-97", "X",				&dhcp_universe, 97 },
	{ "option-98", "X",				&dhcp_universe, 98 },
	{ "option-99", "X",				&dhcp_universe, 99 },
	{ "option-100", "X",				&dhcp_universe, 100 },
	{ "option-101", "X",				&dhcp_universe, 101 },
	{ "option-102", "X",				&dhcp_universe, 102 },
	{ "option-103", "X",				&dhcp_universe, 103 },
	{ "option-104", "X",				&dhcp_universe, 104 },
	{ "option-105", "X",				&dhcp_universe, 105 },
	{ "option-106", "X",				&dhcp_universe, 106 },
	{ "option-107", "X",				&dhcp_universe, 107 },
	{ "option-108", "X",				&dhcp_universe, 108 },
	{ "option-109", "X",				&dhcp_universe, 109 },
	{ "option-110", "X",				&dhcp_universe, 110 },
	{ "option-111", "X",				&dhcp_universe, 111 },
	{ "option-112", "X",				&dhcp_universe, 112 },
	{ "option-113", "X",				&dhcp_universe, 113 },
	{ "option-114", "X",				&dhcp_universe, 114 },
	{ "option-115", "X",				&dhcp_universe, 115 },
	{ "option-116", "X",				&dhcp_universe, 116 },
	{ "option-117", "X",				&dhcp_universe, 117 },
	{ "option-118", "X",				&dhcp_universe, 118 },
	{ "option-119", "X",				&dhcp_universe, 119 },
	{ "option-120", "X",				&dhcp_universe, 120 },
	{ "option-121", "X",				&dhcp_universe, 121 },
	{ "option-122", "X",				&dhcp_universe, 122 },
	{ "option-123", "X",				&dhcp_universe, 123 },
	{ "option-124", "X",				&dhcp_universe, 124 },
	{ "option-125", "X",				&dhcp_universe, 125 },
	{ "option-126", "X",				&dhcp_universe, 126 },
	{ "option-127", "X",				&dhcp_universe, 127 },
	{ "option-128", "X",				&dhcp_universe, 128 },
	{ "option-129", "X",				&dhcp_universe, 129 },
	{ "option-130", "X",				&dhcp_universe, 130 },
	{ "option-131", "X",				&dhcp_universe, 131 },
	{ "option-132", "X",				&dhcp_universe, 132 },
	{ "option-133", "X",				&dhcp_universe, 133 },
	{ "option-134", "X",				&dhcp_universe, 134 },
	{ "option-135", "X",				&dhcp_universe, 135 },
	{ "option-136", "X",				&dhcp_universe, 136 },
	{ "option-137", "X",				&dhcp_universe, 137 },
	{ "option-138", "X",				&dhcp_universe, 138 },
	{ "option-139", "X",				&dhcp_universe, 139 },
	{ "option-140", "X",				&dhcp_universe, 140 },
	{ "option-141", "X",				&dhcp_universe, 141 },
	{ "option-142", "X",				&dhcp_universe, 142 },
	{ "option-143", "X",				&dhcp_universe, 143 },
	{ "option-144", "X",				&dhcp_universe, 144 },
	{ "option-145", "X",				&dhcp_universe, 145 },
	{ "option-146", "X",				&dhcp_universe, 146 },
	{ "option-147", "X",				&dhcp_universe, 147 },
	{ "option-148", "X",				&dhcp_universe, 148 },
	{ "option-149", "X",				&dhcp_universe, 149 },
	{ "option-150", "X",				&dhcp_universe, 150 },
	{ "option-151", "X",				&dhcp_universe, 151 },
	{ "option-152", "X",				&dhcp_universe, 152 },
	{ "option-153", "X",				&dhcp_universe, 153 },
	{ "option-154", "X",				&dhcp_universe, 154 },
	{ "option-155", "X",				&dhcp_universe, 155 },
	{ "option-156", "X",				&dhcp_universe, 156 },
	{ "option-157", "X",				&dhcp_universe, 157 },
	{ "option-158", "X",				&dhcp_universe, 158 },
	{ "option-159", "X",				&dhcp_universe, 159 },
	{ "option-160", "X",				&dhcp_universe, 160 },
	{ "option-161", "X",				&dhcp_universe, 161 },
	{ "option-162", "X",				&dhcp_universe, 162 },
	{ "option-163", "X",				&dhcp_universe, 163 },
	{ "option-164", "X",				&dhcp_universe, 164 },
	{ "option-165", "X",				&dhcp_universe, 165 },
	{ "option-166", "X",				&dhcp_universe, 166 },
	{ "option-167", "X",				&dhcp_universe, 167 },
	{ "option-168", "X",				&dhcp_universe, 168 },
	{ "option-169", "X",				&dhcp_universe, 169 },
	{ "option-170", "X",				&dhcp_universe, 170 },
	{ "option-171", "X",				&dhcp_universe, 171 },
	{ "option-172", "X",				&dhcp_universe, 172 },
	{ "option-173", "X",				&dhcp_universe, 173 },
	{ "option-174", "X",				&dhcp_universe, 174 },
	{ "option-175", "X",				&dhcp_universe, 175 },
	{ "option-176", "X",				&dhcp_universe, 176 },
	{ "option-177", "X",				&dhcp_universe, 177 },
	{ "option-178", "X",				&dhcp_universe, 178 },
	{ "option-179", "X",				&dhcp_universe, 179 },
	{ "option-180", "X",				&dhcp_universe, 180 },
	{ "option-181", "X",				&dhcp_universe, 181 },
	{ "option-182", "X",				&dhcp_universe, 182 },
	{ "option-183", "X",				&dhcp_universe, 183 },
	{ "option-184", "X",				&dhcp_universe, 184 },
	{ "option-185", "X",				&dhcp_universe, 185 },
	{ "option-186", "X",				&dhcp_universe, 186 },
	{ "option-187", "X",				&dhcp_universe, 187 },
	{ "option-188", "X",				&dhcp_universe, 188 },
	{ "option-189", "X",				&dhcp_universe, 189 },
	{ "option-190", "X",				&dhcp_universe, 190 },
	{ "option-191", "X",				&dhcp_universe, 191 },
	{ "option-192", "X",				&dhcp_universe, 192 },
	{ "option-193", "X",				&dhcp_universe, 193 },
	{ "option-194", "X",				&dhcp_universe, 194 },
	{ "option-195", "X",				&dhcp_universe, 195 },
	{ "option-196", "X",				&dhcp_universe, 196 },
	{ "option-197", "X",				&dhcp_universe, 197 },
	{ "option-198", "X",				&dhcp_universe, 198 },
	{ "option-199", "X",				&dhcp_universe, 199 },
	{ "option-200", "X",				&dhcp_universe, 200 },
	{ "option-201", "X",				&dhcp_universe, 201 },
	{ "option-202", "X",				&dhcp_universe, 202 },
	{ "option-203", "X",				&dhcp_universe, 203 },
	{ "option-204", "X",				&dhcp_universe, 204 },
	{ "option-205", "X",				&dhcp_universe, 205 },
	{ "option-206", "X",				&dhcp_universe, 206 },
	{ "option-207", "X",				&dhcp_universe, 207 },
	{ "option-208", "X",				&dhcp_universe, 208 },
	{ "option-209", "X",				&dhcp_universe, 209 },
	{ "authenticate", "X",				&dhcp_universe, 210 },
	{ "option-211", "X",				&dhcp_universe, 211 },
	{ "option-212", "X",				&dhcp_universe, 212 },
	{ "option-213", "X",				&dhcp_universe, 213 },
	{ "option-214", "X",				&dhcp_universe, 214 },
	{ "option-215", "X",				&dhcp_universe, 215 },
	{ "option-216", "X",				&dhcp_universe, 216 },
	{ "option-217", "X",				&dhcp_universe, 217 },
	{ "option-218", "X",				&dhcp_universe, 218 },
	{ "option-219", "X",				&dhcp_universe, 219 },
	{ "option-220", "X",				&dhcp_universe, 220 },
	{ "option-221", "X",				&dhcp_universe, 221 },
	{ "option-222", "X",				&dhcp_universe, 222 },
	{ "option-223", "X",				&dhcp_universe, 223 },
	{ "option-224", "X",				&dhcp_universe, 224 },
	{ "option-225", "X",				&dhcp_universe, 225 },
	{ "option-226", "X",				&dhcp_universe, 226 },
	{ "option-227", "X",				&dhcp_universe, 227 },
	{ "option-228", "X",				&dhcp_universe, 228 },
	{ "option-229", "X",				&dhcp_universe, 229 },
	{ "option-230", "X",				&dhcp_universe, 230 },
	{ "option-231", "X",				&dhcp_universe, 231 },
	{ "option-232", "X",				&dhcp_universe, 232 },
	{ "option-233", "X",				&dhcp_universe, 233 },
	{ "option-234", "X",				&dhcp_universe, 234 },
	{ "option-235", "X",				&dhcp_universe, 235 },
	{ "option-236", "X",				&dhcp_universe, 236 },
	{ "option-237", "X",				&dhcp_universe, 237 },
	{ "option-238", "X",				&dhcp_universe, 238 },
	{ "option-239", "X",				&dhcp_universe, 239 },
	{ "option-240", "X",				&dhcp_universe, 240 },
	{ "option-241", "X",				&dhcp_universe, 241 },
	{ "option-242", "X",				&dhcp_universe, 242 },
	{ "option-243", "X",				&dhcp_universe, 243 },
	{ "option-244", "X",				&dhcp_universe, 244 },
	{ "option-245", "X",				&dhcp_universe, 245 },
	{ "option-246", "X",				&dhcp_universe, 246 },
	{ "option-247", "X",				&dhcp_universe, 247 },
	{ "option-248", "X",				&dhcp_universe, 248 },
	{ "option-249", "X",				&dhcp_universe, 249 },
	{ "option-250", "X",				&dhcp_universe, 250 },
	{ "option-251", "X",				&dhcp_universe, 251 },
	{ "option-252", "X",				&dhcp_universe, 252 },
	{ "option-253", "X",				&dhcp_universe, 253 },
	{ "option-254", "X",				&dhcp_universe, 254 },
	{ "option-end", "e",				&dhcp_universe, 255 },
};

char *hardware_types [] = {
	"unknown-0",
	"ethernet",
	"unknown-2",
	"unknown-3",
	"unknown-4",
	"unknown-5",
	"token-ring",
	"unknown-7",
	"fddi",
	"unknown-9",
	"unknown-10",
	"unknown-11",
	"unknown-12",
	"unknown-13",
	"unknown-14",
	"unknown-15",
	"unknown-16",
	"unknown-17",
	"unknown-18",
	"unknown-19",
	"unknown-20",
	"unknown-21",
	"unknown-22",
	"unknown-23",
	"unknown-24",
	"unknown-25",
	"unknown-26",
	"unknown-27",
	"unknown-28",
	"unknown-29",
	"unknown-30",
	"unknown-31",
	"unknown-32",
	"unknown-33",
	"unknown-34",
	"unknown-35",
	"unknown-36",
	"unknown-37",
	"unknown-38",
	"unknown-39",
	"unknown-40",
	"unknown-41",
	"unknown-42",
	"unknown-43",
	"unknown-44",
	"unknown-45",
	"unknown-46",
	"unknown-47",
	"unknown-48",
	"unknown-49",
	"unknown-50",
	"unknown-51",
	"unknown-52",
	"unknown-53",
	"unknown-54",
	"unknown-55",
	"unknown-56",
	"unknown-57",
	"unknown-58",
	"unknown-59",
	"unknown-60",
	"unknown-61",
	"unknown-62",
	"unknown-63",
	"unknown-64",
	"unknown-65",
	"unknown-66",
	"unknown-67",
	"unknown-68",
	"unknown-69",
	"unknown-70",
	"unknown-71",
	"unknown-72",
	"unknown-73",
	"unknown-74",
	"unknown-75",
	"unknown-76",
	"unknown-77",
	"unknown-78",
	"unknown-79",
	"unknown-80",
	"unknown-81",
	"unknown-82",
	"unknown-83",
	"unknown-84",
	"unknown-85",
	"unknown-86",
	"unknown-87",
	"unknown-88",
	"unknown-89",
	"unknown-90",
	"unknown-91",
	"unknown-92",
	"unknown-93",
	"unknown-94",
	"unknown-95",
	"unknown-96",
	"unknown-97",
	"unknown-98",
	"unknown-99",
	"unknown-100",
	"unknown-101",
	"unknown-102",
	"unknown-103",
	"unknown-104",
	"unknown-105",
	"unknown-106",
	"unknown-107",
	"unknown-108",
	"unknown-109",
	"unknown-110",
	"unknown-111",
	"unknown-112",
	"unknown-113",
	"unknown-114",
	"unknown-115",
	"unknown-116",
	"unknown-117",
	"unknown-118",
	"unknown-119",
	"unknown-120",
	"unknown-121",
	"unknown-122",
	"unknown-123",
	"unknown-124",
	"unknown-125",
	"unknown-126",
	"unknown-127",
	"unknown-128",
	"unknown-129",
	"unknown-130",
	"unknown-131",
	"unknown-132",
	"unknown-133",
	"unknown-134",
	"unknown-135",
	"unknown-136",
	"unknown-137",
	"unknown-138",
	"unknown-139",
	"unknown-140",
	"unknown-141",
	"unknown-142",
	"unknown-143",
	"unknown-144",
	"unknown-145",
	"unknown-146",
	"unknown-147",
	"unknown-148",
	"unknown-149",
	"unknown-150",
	"unknown-151",
	"unknown-152",
	"unknown-153",
	"unknown-154",
	"unknown-155",
	"unknown-156",
	"unknown-157",
	"unknown-158",
	"unknown-159",
	"unknown-160",
	"unknown-161",
	"unknown-162",
	"unknown-163",
	"unknown-164",
	"unknown-165",
	"unknown-166",
	"unknown-167",
	"unknown-168",
	"unknown-169",
	"unknown-170",
	"unknown-171",
	"unknown-172",
	"unknown-173",
	"unknown-174",
	"unknown-175",
	"unknown-176",
	"unknown-177",
	"unknown-178",
	"unknown-179",
	"unknown-180",
	"unknown-181",
	"unknown-182",
	"unknown-183",
	"unknown-184",
	"unknown-185",
	"unknown-186",
	"unknown-187",
	"unknown-188",
	"unknown-189",
	"unknown-190",
	"unknown-191",
	"unknown-192",
	"unknown-193",
	"unknown-194",
	"unknown-195",
	"unknown-196",
	"unknown-197",
	"unknown-198",
	"unknown-199",
	"unknown-200",
	"unknown-201",
	"unknown-202",
	"unknown-203",
	"unknown-204",
	"unknown-205",
	"unknown-206",
	"unknown-207",
	"unknown-208",
	"unknown-209",
	"unknown-210",
	"unknown-211",
	"unknown-212",
	"unknown-213",
	"unknown-214",
	"unknown-215",
	"unknown-216",
	"unknown-217",
	"unknown-218",
	"unknown-219",
	"unknown-220",
	"unknown-221",
	"unknown-222",
	"unknown-223",
	"unknown-224",
	"unknown-225",
	"unknown-226",
	"unknown-227",
	"unknown-228",
	"unknown-229",
	"unknown-230",
	"unknown-231",
	"unknown-232",
	"unknown-233",
	"unknown-234",
	"unknown-235",
	"unknown-236",
	"unknown-237",
	"unknown-238",
	"unknown-239",
	"unknown-240",
	"unknown-241",
	"unknown-242",
	"unknown-243",
	"unknown-244",
	"unknown-245",
	"unknown-246",
	"unknown-247",
	"unknown-248",
	"unknown-249",
	"unknown-250",
	"unknown-251",
	"unknown-252",
	"unknown-253",
	"unknown-254",
	"unknown-255" };

struct universe agent_universe;
struct option agent_options [256] = {
	{ "pad", "",					&agent_universe, 0 },
	{ "circuit-id", "X",				&agent_universe, 1 },
	{ "remote-id", "X",				&agent_universe, 2 },
	{ "agent-id", "I",				&agent_universe, 3 },
	{ "option-4", "X",				&agent_universe, 4 },
	{ "option-5", "X",				&agent_universe, 5 },
	{ "option-6", "X",				&agent_universe, 6 },
	{ "option-7", "X",				&agent_universe, 7 },
	{ "option-8", "X",				&agent_universe, 8 },
	{ "option-9", "X",				&agent_universe, 9 },
	{ "option-10", "X",				&agent_universe, 10 },
	{ "option-11", "X",				&agent_universe, 11 },
	{ "option-12", "X",				&agent_universe, 12 },
	{ "option-13", "X",				&agent_universe, 13 },
	{ "option-14", "X",				&agent_universe, 14 },
	{ "option-15", "X",				&agent_universe, 15 },
	{ "option-16", "X",				&agent_universe, 16 },
	{ "option-17", "X",				&agent_universe, 17 },
	{ "option-18", "X",				&agent_universe, 18 },
	{ "option-19", "X",				&agent_universe, 19 },
	{ "option-20", "X",				&agent_universe, 20 },
	{ "option-21", "X",				&agent_universe, 21 },
	{ "option-22", "X",				&agent_universe, 22 },
	{ "option-23", "X",				&agent_universe, 23 },
	{ "option-24", "X",				&agent_universe, 24 },
	{ "option-25", "X",				&agent_universe, 25 },
	{ "option-26", "X",				&agent_universe, 26 },
	{ "option-27", "X",				&agent_universe, 27 },
	{ "option-28", "X",				&agent_universe, 28 },
	{ "option-29", "X",				&agent_universe, 29 },
	{ "option-30", "X",				&agent_universe, 30 },
	{ "option-31", "X",				&agent_universe, 31 },
	{ "option-32", "X",				&agent_universe, 32 },
	{ "option-33", "X",				&agent_universe, 33 },
	{ "option-34", "X",				&agent_universe, 34 },
	{ "option-35", "X",				&agent_universe, 35 },
	{ "option-36", "X",				&agent_universe, 36 },
	{ "option-37", "X",				&agent_universe, 37 },
	{ "option-38", "X",				&agent_universe, 38 },
	{ "option-39", "X",				&agent_universe, 39 },
	{ "option-40", "X",				&agent_universe, 40 },
	{ "option-41", "X",				&agent_universe, 41 },
	{ "option-42", "X",				&agent_universe, 42 },
	{ "option-43", "X",				&agent_universe, 43 },
	{ "option-44", "X",				&agent_universe, 44 },
	{ "option-45", "X",				&agent_universe, 45 },
	{ "option-46", "X",				&agent_universe, 46 },
	{ "option-47", "X",				&agent_universe, 47 },
	{ "option-48", "X",				&agent_universe, 48 },
	{ "option-49", "X",				&agent_universe, 49 },
	{ "option-50", "X",				&agent_universe, 50 },
	{ "option-51", "X",				&agent_universe, 51 },
	{ "option-52", "X",				&agent_universe, 52 },
	{ "option-53", "X",				&agent_universe, 53 },
	{ "option-54", "X",				&agent_universe, 54 },
	{ "option-55", "X",				&agent_universe, 55 },
	{ "option-56", "X",				&agent_universe, 56 },
	{ "option-57", "X",				&agent_universe, 57 },
	{ "option-58", "X",				&agent_universe, 58 },
	{ "option-59", "X",				&agent_universe, 59 },
	{ "option-60", "X",				&agent_universe, 60 },
	{ "option-61", "X",				&agent_universe, 61 },
	{ "option-62", "X",				&agent_universe, 62 },
	{ "option-63", "X",				&agent_universe, 63 },
	{ "option-64", "X",				&agent_universe, 64 },
	{ "option-65", "X",				&agent_universe, 65 },
	{ "option-66", "X",				&agent_universe, 66 },
	{ "option-67", "X",				&agent_universe, 67 },
	{ "option-68", "X",				&agent_universe, 68 },
	{ "option-69", "X",				&agent_universe, 69 },
	{ "option-70", "X",				&agent_universe, 70 },
	{ "option-71", "X",				&agent_universe, 71 },
	{ "option-72", "X",				&agent_universe, 72 },
	{ "option-73", "X",				&agent_universe, 73 },
	{ "option-74", "X",				&agent_universe, 74 },
	{ "option-75", "X",				&agent_universe, 75 },
	{ "option-76", "X",				&agent_universe, 76 },
	{ "option-77", "X",				&agent_universe, 77 },
	{ "option-78", "X",				&agent_universe, 78 },
	{ "option-79", "X",				&agent_universe, 79 },
	{ "option-80", "X",				&agent_universe, 80 },
	{ "option-81", "X",				&agent_universe, 81 },
	{ "option-82", "X",				&agent_universe, 82 },
	{ "option-83", "X",				&agent_universe, 83 },
	{ "option-84", "X",				&agent_universe, 84 },
	{ "option-85", "X",				&agent_universe, 85 },
	{ "option-86", "X",				&agent_universe, 86 },
	{ "option-87", "X",				&agent_universe, 87 },
	{ "option-88", "X",				&agent_universe, 88 },
	{ "option-89", "X",				&agent_universe, 89 },
	{ "option-90", "X",				&agent_universe, 90 },
	{ "option-91", "X",				&agent_universe, 91 },
	{ "option-92", "X",				&agent_universe, 92 },
	{ "option-93", "X",				&agent_universe, 93 },
	{ "option-94", "X",				&agent_universe, 94 },
	{ "option-95", "X",				&agent_universe, 95 },
	{ "option-96", "X",				&agent_universe, 96 },
	{ "option-97", "X",				&agent_universe, 97 },
	{ "option-98", "X",				&agent_universe, 98 },
	{ "option-99", "X",				&agent_universe, 99 },
	{ "option-100", "X",				&agent_universe, 100 },
	{ "option-101", "X",				&agent_universe, 101 },
	{ "option-102", "X",				&agent_universe, 102 },
	{ "option-103", "X",				&agent_universe, 103 },
	{ "option-104", "X",				&agent_universe, 104 },
	{ "option-105", "X",				&agent_universe, 105 },
	{ "option-106", "X",				&agent_universe, 106 },
	{ "option-107", "X",				&agent_universe, 107 },
	{ "option-108", "X",				&agent_universe, 108 },
	{ "option-109", "X",				&agent_universe, 109 },
	{ "option-110", "X",				&agent_universe, 110 },
	{ "option-111", "X",				&agent_universe, 111 },
	{ "option-112", "X",				&agent_universe, 112 },
	{ "option-113", "X",				&agent_universe, 113 },
	{ "option-114", "X",				&agent_universe, 114 },
	{ "option-115", "X",				&agent_universe, 115 },
	{ "option-116", "X",				&agent_universe, 116 },
	{ "option-117", "X",				&agent_universe, 117 },
	{ "option-118", "X",				&agent_universe, 118 },
	{ "option-119", "X",				&agent_universe, 119 },
	{ "option-120", "X",				&agent_universe, 120 },
	{ "option-121", "X",				&agent_universe, 121 },
	{ "option-122", "X",				&agent_universe, 122 },
	{ "option-123", "X",				&agent_universe, 123 },
	{ "option-124", "X",				&agent_universe, 124 },
	{ "option-125", "X",				&agent_universe, 125 },
	{ "option-126", "X",				&agent_universe, 126 },
	{ "option-127", "X",				&agent_universe, 127 },
	{ "option-128", "X",				&agent_universe, 128 },
	{ "option-129", "X",				&agent_universe, 129 },
	{ "option-130", "X",				&agent_universe, 130 },
	{ "option-131", "X",				&agent_universe, 131 },
	{ "option-132", "X",				&agent_universe, 132 },
	{ "option-133", "X",				&agent_universe, 133 },
	{ "option-134", "X",				&agent_universe, 134 },
	{ "option-135", "X",				&agent_universe, 135 },
	{ "option-136", "X",				&agent_universe, 136 },
	{ "option-137", "X",				&agent_universe, 137 },
	{ "option-138", "X",				&agent_universe, 138 },
	{ "option-139", "X",				&agent_universe, 139 },
	{ "option-140", "X",				&agent_universe, 140 },
	{ "option-141", "X",				&agent_universe, 141 },
	{ "option-142", "X",				&agent_universe, 142 },
	{ "option-143", "X",				&agent_universe, 143 },
	{ "option-144", "X",				&agent_universe, 144 },
	{ "option-145", "X",				&agent_universe, 145 },
	{ "option-146", "X",				&agent_universe, 146 },
	{ "option-147", "X",				&agent_universe, 147 },
	{ "option-148", "X",				&agent_universe, 148 },
	{ "option-149", "X",				&agent_universe, 149 },
	{ "option-150", "X",				&agent_universe, 150 },
	{ "option-151", "X",				&agent_universe, 151 },
	{ "option-152", "X",				&agent_universe, 152 },
	{ "option-153", "X",				&agent_universe, 153 },
	{ "option-154", "X",				&agent_universe, 154 },
	{ "option-155", "X",				&agent_universe, 155 },
	{ "option-156", "X",				&agent_universe, 156 },
	{ "option-157", "X",				&agent_universe, 157 },
	{ "option-158", "X",				&agent_universe, 158 },
	{ "option-159", "X",				&agent_universe, 159 },
	{ "option-160", "X",				&agent_universe, 160 },
	{ "option-161", "X",				&agent_universe, 161 },
	{ "option-162", "X",				&agent_universe, 162 },
	{ "option-163", "X",				&agent_universe, 163 },
	{ "option-164", "X",				&agent_universe, 164 },
	{ "option-165", "X",				&agent_universe, 165 },
	{ "option-166", "X",				&agent_universe, 166 },
	{ "option-167", "X",				&agent_universe, 167 },
	{ "option-168", "X",				&agent_universe, 168 },
	{ "option-169", "X",				&agent_universe, 169 },
	{ "option-170", "X",				&agent_universe, 170 },
	{ "option-171", "X",				&agent_universe, 171 },
	{ "option-172", "X",				&agent_universe, 172 },
	{ "option-173", "X",				&agent_universe, 173 },
	{ "option-174", "X",				&agent_universe, 174 },
	{ "option-175", "X",				&agent_universe, 175 },
	{ "option-176", "X",				&agent_universe, 176 },
	{ "option-177", "X",				&agent_universe, 177 },
	{ "option-178", "X",				&agent_universe, 178 },
	{ "option-179", "X",				&agent_universe, 179 },
	{ "option-180", "X",				&agent_universe, 180 },
	{ "option-181", "X",				&agent_universe, 181 },
	{ "option-182", "X",				&agent_universe, 182 },
	{ "option-183", "X",				&agent_universe, 183 },
	{ "option-184", "X",				&agent_universe, 184 },
	{ "option-185", "X",				&agent_universe, 185 },
	{ "option-186", "X",				&agent_universe, 186 },
	{ "option-187", "X",				&agent_universe, 187 },
	{ "option-188", "X",				&agent_universe, 188 },
	{ "option-189", "X",				&agent_universe, 189 },
	{ "option-190", "X",				&agent_universe, 190 },
	{ "option-191", "X",				&agent_universe, 191 },
	{ "option-192", "X",				&agent_universe, 192 },
	{ "option-193", "X",				&agent_universe, 193 },
	{ "option-194", "X",				&agent_universe, 194 },
	{ "option-195", "X",				&agent_universe, 195 },
	{ "option-196", "X",				&agent_universe, 196 },
	{ "option-197", "X",				&agent_universe, 197 },
	{ "option-198", "X",				&agent_universe, 198 },
	{ "option-199", "X",				&agent_universe, 199 },
	{ "option-200", "X",				&agent_universe, 200 },
	{ "option-201", "X",				&agent_universe, 201 },
	{ "option-202", "X",				&agent_universe, 202 },
	{ "option-203", "X",				&agent_universe, 203 },
	{ "option-204", "X",				&agent_universe, 204 },
	{ "option-205", "X",				&agent_universe, 205 },
	{ "option-206", "X",				&agent_universe, 206 },
	{ "option-207", "X",				&agent_universe, 207 },
	{ "option-208", "X",				&agent_universe, 208 },
	{ "option-209", "X",				&agent_universe, 209 },
	{ "option-210", "X",				&agent_universe, 210 },
	{ "option-211", "X",				&agent_universe, 211 },
	{ "option-212", "X",				&agent_universe, 212 },
	{ "option-213", "X",				&agent_universe, 213 },
	{ "option-214", "X",				&agent_universe, 214 },
	{ "option-215", "X",				&agent_universe, 215 },
	{ "option-216", "X",				&agent_universe, 216 },
	{ "option-217", "X",				&agent_universe, 217 },
	{ "option-218", "X",				&agent_universe, 218 },
	{ "option-219", "X",				&agent_universe, 219 },
	{ "option-220", "X",				&agent_universe, 220 },
	{ "option-221", "X",				&agent_universe, 221 },
	{ "option-222", "X",				&agent_universe, 222 },
	{ "option-223", "X",				&agent_universe, 223 },
	{ "option-224", "X",				&agent_universe, 224 },
	{ "option-225", "X",				&agent_universe, 225 },
	{ "option-226", "X",				&agent_universe, 226 },
	{ "option-227", "X",				&agent_universe, 227 },
	{ "option-228", "X",				&agent_universe, 228 },
	{ "option-229", "X",				&agent_universe, 229 },
	{ "option-230", "X",				&agent_universe, 230 },
	{ "option-231", "X",				&agent_universe, 231 },
	{ "option-232", "X",				&agent_universe, 232 },
	{ "option-233", "X",				&agent_universe, 233 },
	{ "option-234", "X",				&agent_universe, 234 },
	{ "option-235", "X",				&agent_universe, 235 },
	{ "option-236", "X",				&agent_universe, 236 },
	{ "option-237", "X",				&agent_universe, 237 },
	{ "option-238", "X",				&agent_universe, 238 },
	{ "option-239", "X",				&agent_universe, 239 },
	{ "option-240", "X",				&agent_universe, 240 },
	{ "option-241", "X",				&agent_universe, 241 },
	{ "option-242", "X",				&agent_universe, 242 },
	{ "option-243", "X",				&agent_universe, 243 },
	{ "option-244", "X",				&agent_universe, 244 },
	{ "option-245", "X",				&agent_universe, 245 },
	{ "option-246", "X",				&agent_universe, 246 },
	{ "option-247", "X",				&agent_universe, 247 },
	{ "option-248", "X",				&agent_universe, 248 },
	{ "option-249", "X",				&agent_universe, 249 },
	{ "option-250", "X",				&agent_universe, 250 },
	{ "option-251", "X",				&agent_universe, 251 },
	{ "option-252", "X",				&agent_universe, 252 },
	{ "option-253", "X",				&agent_universe, 253 },
	{ "option-254", "X",				&agent_universe, 254 },
	{ "option-end", "e",				&agent_universe, 255 },
};

struct universe server_universe;
struct option server_options [256] = {
	{ "pad", "",				&server_universe, 0 },
	{ "default-lease-time", "L",		&server_universe, 1 },
	{ "max-lease-time", "L",		&server_universe, 2 },
	{ "min-lease-time", "L",		&server_universe, 3 },
	{ "dynamic-bootp-lease-cutoff", "L",	&server_universe, 4 },
	{ "dynamic-bootp-lease-length", "L",	&server_universe, 5 },
	{ "boot-unknown-clients", "f",		&server_universe, 6 },
	{ "dynamic-bootp", "f",			&server_universe, 7 },
	{ "allow-bootp", "f",			&server_universe, 8 },
	{ "allow-booting", "f",			&server_universe, 9 },
	{ "one-lease-per-client", "f",		&server_universe, 10 },
	{ "get-lease-hostnames", "f",		&server_universe, 11 },
	{ "use-host-decl-names", "f",		&server_universe, 12 },
	{ "use-lease-addr-for-default-route", "f", &server_universe, 13 },
	{ "min-secs", "B",			&server_universe, 14 },
	{ "filename", "t",			&server_universe, 15 },
	{ "server-name", "t",			&server_universe, 16 },
	{ "next-server", "I",			&server_universe, 17 },
	{ "authoritative", "f",			&server_universe, 18 },
	{ "vendor-option-space", "U",		&server_universe, 19 },
	{ "always-reply-rfc1048", "f",		&server_universe, 20 },
	{ "site-option-space", "X",		&server_universe, 21 },
	{ "always-broadcast", "f",		&server_universe, 22 },
	{ "ddns-domainname", "t",		&server_universe, 23 },
	{ "ddns-hostname", "t",			&server_universe, 24 },
	{ "ddns-rev-domainname", "t",		&server_universe, 25 },
	{ "option-26", "X",			&server_universe, 26 },
	{ "option-27", "X",			&server_universe, 27 },
	{ "option-28", "X",			&server_universe, 28 },
	{ "option-29", "X",			&server_universe, 29 },
	{ "option-30", "X",			&server_universe, 30 },
	{ "option-31", "X",			&server_universe, 31 },
	{ "option-32", "X",			&server_universe, 32 },
	{ "option-33", "X",			&server_universe, 33 },
	{ "option-34", "X",			&server_universe, 34 },
	{ "option-35", "X",			&server_universe, 35 },
	{ "option-36", "X",			&server_universe, 36 },
	{ "option-37", "X",			&server_universe, 37 },
	{ "option-38", "X",			&server_universe, 38 },
	{ "option-39", "X",			&server_universe, 39 },
	{ "option-40", "X",			&server_universe, 40 },
	{ "option-41", "X",			&server_universe, 41 },
	{ "option-42", "X",			&server_universe, 42 },
	{ "option-43", "X",			&server_universe, 43 },
	{ "option-44", "X",			&server_universe, 44 },
	{ "option-45", "X",			&server_universe, 45 },
	{ "option-46", "X",			&server_universe, 46 },
	{ "option-47", "X",			&server_universe, 47 },
	{ "option-48", "X",			&server_universe, 48 },
	{ "option-49", "X",			&server_universe, 49 },
	{ "option-50", "X",			&server_universe, 50 },
	{ "option-51", "X",			&server_universe, 51 },
	{ "option-52", "X",			&server_universe, 52 },
	{ "option-53", "X",			&server_universe, 53 },
	{ "option-54", "X",			&server_universe, 54 },
	{ "option-55", "X",			&server_universe, 55 },
	{ "option-56", "X",			&server_universe, 56 },
	{ "option-57", "X",			&server_universe, 57 },
	{ "option-58", "X",			&server_universe, 58 },
	{ "option-59", "X",			&server_universe, 59 },
	{ "option-60", "X",			&server_universe, 60 },
	{ "option-61", "X",			&server_universe, 61 },
	{ "option-62", "X",			&server_universe, 62 },
	{ "option-63", "X",			&server_universe, 63 },
	{ "option-64", "X",			&server_universe, 64 },
	{ "option-65", "X",			&server_universe, 65 },
	{ "option-66", "X",			&server_universe, 66 },
	{ "option-67", "X",			&server_universe, 67 },
	{ "option-68", "X",			&server_universe, 68 },
	{ "option-69", "X",			&server_universe, 69 },
	{ "option-70", "X",			&server_universe, 70 },
	{ "option-71", "X",			&server_universe, 71 },
	{ "option-72", "X",			&server_universe, 72 },
	{ "option-73", "X",			&server_universe, 73 },
	{ "option-74", "X",			&server_universe, 74 },
	{ "option-75", "X",			&server_universe, 75 },
	{ "option-76", "X",			&server_universe, 76 },
	{ "option-77", "X",			&server_universe, 77 },
	{ "option-78", "X",			&server_universe, 78 },
	{ "option-79", "X",			&server_universe, 79 },
	{ "option-80", "X",			&server_universe, 80 },
	{ "option-81", "X",			&server_universe, 81 },
	{ "option-82", "X",			&server_universe, 82 },
	{ "option-83", "X",			&server_universe, 83 },
	{ "option-84", "X",			&server_universe, 84 },
	{ "option-85", "X",			&server_universe, 85 },
	{ "option-86", "X",			&server_universe, 86 },
	{ "option-87", "X",			&server_universe, 87 },
	{ "option-88", "X",			&server_universe, 88 },
	{ "option-89", "X",			&server_universe, 89 },
	{ "option-90", "X",			&server_universe, 90 },
	{ "option-91", "X",			&server_universe, 91 },
	{ "option-92", "X",			&server_universe, 92 },
	{ "option-93", "X",			&server_universe, 93 },
	{ "option-94", "X",			&server_universe, 94 },
	{ "option-95", "X",			&server_universe, 95 },
	{ "option-96", "X",			&server_universe, 96 },
	{ "option-97", "X",			&server_universe, 97 },
	{ "option-98", "X",			&server_universe, 98 },
	{ "option-99", "X",			&server_universe, 99 },
	{ "option-100", "X",			&server_universe, 100 },
	{ "option-101", "X",			&server_universe, 101 },
	{ "option-102", "X",			&server_universe, 102 },
	{ "option-103", "X",			&server_universe, 103 },
	{ "option-104", "X",			&server_universe, 104 },
	{ "option-105", "X",			&server_universe, 105 },
	{ "option-106", "X",			&server_universe, 106 },
	{ "option-107", "X",			&server_universe, 107 },
	{ "option-108", "X",			&server_universe, 108 },
	{ "option-109", "X",			&server_universe, 109 },
	{ "option-110", "X",			&server_universe, 110 },
	{ "option-111", "X",			&server_universe, 111 },
	{ "option-112", "X",			&server_universe, 112 },
	{ "option-113", "X",			&server_universe, 113 },
	{ "option-114", "X",			&server_universe, 114 },
	{ "option-115", "X",			&server_universe, 115 },
	{ "option-116", "X",			&server_universe, 116 },
	{ "option-117", "X",			&server_universe, 117 },
	{ "option-118", "X",			&server_universe, 118 },
	{ "option-119", "X",			&server_universe, 119 },
	{ "option-120", "X",			&server_universe, 120 },
	{ "option-121", "X",			&server_universe, 121 },
	{ "option-122", "X",			&server_universe, 122 },
	{ "option-123", "X",			&server_universe, 123 },
	{ "option-124", "X",			&server_universe, 124 },
	{ "option-125", "X",			&server_universe, 125 },
	{ "option-126", "X",			&server_universe, 126 },
	{ "option-127", "X",			&server_universe, 127 },
	{ "option-128", "X",			&server_universe, 128 },
	{ "option-129", "X",			&server_universe, 129 },
	{ "option-130", "X",			&server_universe, 130 },
	{ "option-131", "X",			&server_universe, 131 },
	{ "option-132", "X",			&server_universe, 132 },
	{ "option-133", "X",			&server_universe, 133 },
	{ "option-134", "X",			&server_universe, 134 },
	{ "option-135", "X",			&server_universe, 135 },
	{ "option-136", "X",			&server_universe, 136 },
	{ "option-137", "X",			&server_universe, 137 },
	{ "option-138", "X",			&server_universe, 138 },
	{ "option-139", "X",			&server_universe, 139 },
	{ "option-140", "X",			&server_universe, 140 },
	{ "option-141", "X",			&server_universe, 141 },
	{ "option-142", "X",			&server_universe, 142 },
	{ "option-143", "X",			&server_universe, 143 },
	{ "option-144", "X",			&server_universe, 144 },
	{ "option-145", "X",			&server_universe, 145 },
	{ "option-146", "X",			&server_universe, 146 },
	{ "option-147", "X",			&server_universe, 147 },
	{ "option-148", "X",			&server_universe, 148 },
	{ "option-149", "X",			&server_universe, 149 },
	{ "option-150", "X",			&server_universe, 150 },
	{ "option-151", "X",			&server_universe, 151 },
	{ "option-152", "X",			&server_universe, 152 },
	{ "option-153", "X",			&server_universe, 153 },
	{ "option-154", "X",			&server_universe, 154 },
	{ "option-155", "X",			&server_universe, 155 },
	{ "option-156", "X",			&server_universe, 156 },
	{ "option-157", "X",			&server_universe, 157 },
	{ "option-158", "X",			&server_universe, 158 },
	{ "option-159", "X",			&server_universe, 159 },
	{ "option-160", "X",			&server_universe, 160 },
	{ "option-161", "X",			&server_universe, 161 },
	{ "option-162", "X",			&server_universe, 162 },
	{ "option-163", "X",			&server_universe, 163 },
	{ "option-164", "X",			&server_universe, 164 },
	{ "option-165", "X",			&server_universe, 165 },
	{ "option-166", "X",			&server_universe, 166 },
	{ "option-167", "X",			&server_universe, 167 },
	{ "option-168", "X",			&server_universe, 168 },
	{ "option-169", "X",			&server_universe, 169 },
	{ "option-170", "X",			&server_universe, 170 },
	{ "option-171", "X",			&server_universe, 171 },
	{ "option-172", "X",			&server_universe, 172 },
	{ "option-173", "X",			&server_universe, 173 },
	{ "option-174", "X",			&server_universe, 174 },
	{ "option-175", "X",			&server_universe, 175 },
	{ "option-176", "X",			&server_universe, 176 },
	{ "option-177", "X",			&server_universe, 177 },
	{ "option-178", "X",			&server_universe, 178 },
	{ "option-179", "X",			&server_universe, 179 },
	{ "option-180", "X",			&server_universe, 180 },
	{ "option-181", "X",			&server_universe, 181 },
	{ "option-182", "X",			&server_universe, 182 },
	{ "option-183", "X",			&server_universe, 183 },
	{ "option-184", "X",			&server_universe, 184 },
	{ "option-185", "X",			&server_universe, 185 },
	{ "option-186", "X",			&server_universe, 186 },
	{ "option-187", "X",			&server_universe, 187 },
	{ "option-188", "X",			&server_universe, 188 },
	{ "option-189", "X",			&server_universe, 189 },
	{ "option-190", "X",			&server_universe, 190 },
	{ "option-191", "X",			&server_universe, 191 },
	{ "option-192", "X",			&server_universe, 192 },
	{ "option-193", "X",			&server_universe, 193 },
	{ "option-194", "X",			&server_universe, 194 },
	{ "option-195", "X",			&server_universe, 195 },
	{ "option-196", "X",			&server_universe, 196 },
	{ "option-197", "X",			&server_universe, 197 },
	{ "option-198", "X",			&server_universe, 198 },
	{ "option-199", "X",			&server_universe, 199 },
	{ "option-200", "X",			&server_universe, 200 },
	{ "option-201", "X",			&server_universe, 201 },
	{ "option-202", "X",			&server_universe, 202 },
	{ "option-203", "X",			&server_universe, 203 },
	{ "option-204", "X",			&server_universe, 204 },
	{ "option-205", "X",			&server_universe, 205 },
	{ "option-206", "X",			&server_universe, 206 },
	{ "option-207", "X",			&server_universe, 207 },
	{ "option-208", "X",			&server_universe, 208 },
	{ "option-209", "X",			&server_universe, 209 },
	{ "option-210", "X",			&server_universe, 210 },
	{ "option-211", "X",			&server_universe, 211 },
	{ "option-212", "X",			&server_universe, 212 },
	{ "option-213", "X",			&server_universe, 213 },
	{ "option-214", "X",			&server_universe, 214 },
	{ "option-215", "X",			&server_universe, 215 },
	{ "option-216", "X",			&server_universe, 216 },
	{ "option-217", "X",			&server_universe, 217 },
	{ "option-218", "X",			&server_universe, 218 },
	{ "option-219", "X",			&server_universe, 219 },
	{ "option-220", "X",			&server_universe, 220 },
	{ "option-221", "X",			&server_universe, 221 },
	{ "option-222", "X",			&server_universe, 222 },
	{ "option-223", "X",			&server_universe, 223 },
	{ "option-224", "X",			&server_universe, 224 },
	{ "option-225", "X",			&server_universe, 225 },
	{ "option-226", "X",			&server_universe, 226 },
	{ "option-227", "X",			&server_universe, 227 },
	{ "option-228", "X",			&server_universe, 228 },
	{ "option-229", "X",			&server_universe, 229 },
	{ "option-230", "X",			&server_universe, 230 },
	{ "option-231", "X",			&server_universe, 231 },
	{ "option-232", "X",			&server_universe, 232 },
	{ "option-233", "X",			&server_universe, 233 },
	{ "option-234", "X",			&server_universe, 234 },
	{ "option-235", "X",			&server_universe, 235 },
	{ "option-236", "X",			&server_universe, 236 },
	{ "option-237", "X",			&server_universe, 237 },
	{ "option-238", "X",			&server_universe, 238 },
	{ "option-239", "X",			&server_universe, 239 },
	{ "option-240", "X",			&server_universe, 240 },
	{ "option-241", "X",			&server_universe, 241 },
	{ "option-242", "X",			&server_universe, 242 },
	{ "option-243", "X",			&server_universe, 243 },
	{ "option-244", "X",			&server_universe, 244 },
	{ "option-245", "X",			&server_universe, 245 },
	{ "option-246", "X",			&server_universe, 246 },
	{ "option-247", "X",			&server_universe, 247 },
	{ "option-248", "X",			&server_universe, 248 },
	{ "option-249", "X",			&server_universe, 249 },
	{ "option-250", "X",			&server_universe, 250 },
	{ "option-251", "X",			&server_universe, 251 },
	{ "option-252", "X",			&server_universe, 252 },
	{ "option-253", "X",			&server_universe, 253 },
	{ "option-254", "X",			&server_universe, 254 },
	{ "option-end", "e",			&server_universe, 255 },
};

struct hash_table universe_hash;
struct universe **universes;
int universe_count, universe_max;

void initialize_universes()
{
	int i;

	universe_max = 10;
	universes = ((struct universe **)
		     dmalloc (universe_max * sizeof (struct universe *),
			      "initialize_universes"));
	if (!universes)
		log_fatal ("Can't allocate option space table.");
	memset (universes, 0, universe_max * sizeof (struct universe *));

	/* Set up the DHCP option universe... */
	dhcp_universe.name = "dhcp";
	dhcp_universe.lookup_func = lookup_hashed_option;
	dhcp_universe.option_state_dereference =
		hashed_option_state_dereference;
	dhcp_universe.get_func = hashed_option_get;
	dhcp_universe.set_func = hashed_option_set;
	dhcp_universe.save_func = save_hashed_option;
	dhcp_universe.delete_func = delete_hashed_option;
	dhcp_universe.encapsulate = hashed_option_space_encapsulate;
	dhcp_universe.length_size = 1;
	dhcp_universe.tag_size = 1;
	dhcp_universe.store_tag = putUChar;
	dhcp_universe.store_length = putUChar;
	dhcp_universe.index = universe_count++;
	universes [dhcp_universe.index] = &dhcp_universe;
	dhcp_universe.hash = new_hash ();
	if (!dhcp_universe.hash)
		log_fatal ("Can't allocate dhcp option hash table.");
	for (i = 0; i < 256; i++) {
		dhcp_universe.options [i] = &dhcp_options [i];
		add_hash (dhcp_universe.hash,
			  (unsigned char *)dhcp_options [i].name, 0,
			  (unsigned char *)&dhcp_options [i]);
	}

	/* Set up the Relay Agent Information Option suboption universe... */
	agent_universe.name = "agent";
	agent_universe.option_state_dereference =
		agent_option_state_dereference;
	agent_universe.get_func = agent_option_get;
	agent_universe.index = universe_count++;
	agent_universe.length_size = 1;
	agent_universe.tag_size = 1;
	agent_universe.store_tag = putUChar;
	agent_universe.store_length = putUChar;
	universes [agent_universe.index] = &agent_universe;
	agent_universe.hash = new_hash ();
	if (!agent_universe.hash)
		log_fatal ("Can't allocate agent option hash table.");
	for (i = 0; i < 256; i++) {
		agent_universe.options [i] = &agent_options [i];
		add_hash (agent_universe.hash,
			  (unsigned char *)agent_options [i].name, 0,
			  (unsigned char *)&agent_options [i]);
	}

	/* Set up the server option universe... */
	server_universe.name = "server";
	server_universe.lookup_func = lookup_hashed_option;
	server_universe.option_state_dereference =
		hashed_option_state_dereference;
	server_universe.get_func = hashed_option_get;
	server_universe.set_func = hashed_option_set;
	server_universe.save_func = save_hashed_option;
	server_universe.delete_func = delete_hashed_option;
	server_universe.encapsulate = hashed_option_space_encapsulate;
	server_universe.length_size = 1;
	server_universe.tag_size = 1;
	server_universe.store_tag = putUChar;
	server_universe.store_length = putUChar;
	server_universe.index = universe_count++;
	universes [server_universe.index] = &server_universe;
	server_universe.hash = new_hash ();
	if (!server_universe.hash)
		log_fatal ("Can't allocate server option hash table.");
	for (i = 0; i < 256; i++) {
		server_universe.options [i] = &server_options [i];
		add_hash (server_universe.hash,
			  (unsigned char *)server_options [i].name, 0,
			  (unsigned char *)&server_options [i]);
	}

	/* Set up the hash of universes. */
	universe_hash.hash_count = DEFAULT_HASH_SIZE;	
	add_hash (&universe_hash, (unsigned char *)dhcp_universe.name, 0,
		  (unsigned char *)&dhcp_universe);
	add_hash (&universe_hash, (unsigned char *)agent_universe.name, 0,
		  (unsigned char *)&agent_universe);
	add_hash (&universe_hash, (unsigned char *)server_universe.name, 0,
		  (unsigned char *)&server_universe);
}
