/*
 * Decompiled with CFR 0.152.
 */
package test.mac;

import gnu.crypto.mac.IMac;
import gnu.crypto.mac.TMMH16;
import gnu.crypto.prng.BasePRNG;
import gnu.crypto.prng.IRandom;
import gnu.crypto.prng.LimitReachedException;
import gnu.crypto.util.Util;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOfTMMH16
extends TestCase {
    private IRandom keystream;
    private byte[] output;
    private byte[] message;
    private byte[] result;
    private IMac mac;
    private HashMap attributes;
    static /* synthetic */ Class class$test$mac$TestOfTMMH16;

    public TestOfTMMH16(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestOfTMMH16.suite());
    }

    public static Test suite() {
        return new TestSuite(class$test$mac$TestOfTMMH16 == null ? (class$test$mac$TestOfTMMH16 = TestOfTMMH16.class$("test.mac.TestOfTMMH16")) : class$test$mac$TestOfTMMH16);
    }

    public void testVector1() throws InvalidKeyException {
        this.output = new byte[]{-99, 106};
        this.mac = new TMMH16();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("gnu.crypto.mac.tmmh.keystream", this.keystream);
        attributes.put("gnu.crypto.mac.tmmh.tag.length", new Integer(2));
        this.mac.init(attributes);
        this.message = new byte[]{-54, -2, -70, -66, -70, -34};
        int i = 0;
        while (i < this.message.length) {
            this.mac.update(this.message[i]);
            ++i;
        }
        this.result = this.mac.digest();
        Assert.assertTrue((String)"testVector1()", (boolean)Util.areEqual((byte[])this.result, (byte[])this.output));
    }

    public void testVector2() throws InvalidKeyException {
        this.output = new byte[]{-56, -114};
        this.mac = new TMMH16();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("gnu.crypto.mac.tmmh.keystream", this.keystream);
        attributes.put("gnu.crypto.mac.tmmh.tag.length", new Integer(2));
        this.mac.init(attributes);
        this.message = new byte[]{-54, -2, -70};
        int i = 0;
        while (i < this.message.length) {
            this.mac.update(this.message[i]);
            ++i;
        }
        this.result = this.mac.digest();
        Assert.assertTrue((String)"testVector2()", (boolean)Util.areEqual((byte[])this.result, (byte[])this.output));
    }

    public void testVector3() throws InvalidKeyException {
        this.output = new byte[]{-99, 106, -64, -45};
        this.mac = new TMMH16();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("gnu.crypto.mac.tmmh.keystream", this.keystream);
        attributes.put("gnu.crypto.mac.tmmh.tag.length", new Integer(4));
        this.mac.init(attributes);
        this.message = new byte[]{-54, -2, -70, -66, -70, -34};
        int i = 0;
        while (i < this.message.length) {
            this.mac.update(this.message[i]);
            ++i;
        }
        this.result = this.mac.digest();
        Assert.assertTrue((String)"testVector3()", (boolean)Util.areEqual((byte[])this.result, (byte[])this.output));
    }

    protected void setUp() throws Exception {
        this.attributes = new HashMap();
        this.keystream = new DummyKeystream();
        this.keystream.init(null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DummyKeystream
    extends BasePRNG {
        DummyKeystream() {
            super("???");
        }

        public Object clone() {
            return null;
        }

        public void setup(Map attributes) {
        }

        public void fillBlock() throws LimitReachedException {
            this.buffer = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, -2, -36};
        }
    }
}

