/*
 * Copyright (C) 1997, 1998
 *	Sony Computer Science Laboratories Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY SONY CSL AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL SONY CSL OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: if_altq.h,v 1.1.6.2 1999/01/20 17:53:30 itojun Exp $
 */
#ifndef _NET_IF_ALTQ_H_
#define _NET_IF_ALTQ_H_

/*
 * common network flow info structure
 */
struct flowinfo {
	u_char		fi_len;		/* total length */
	u_char		fi_family;	/* address family */
	u_int8_t	fi_data[46];	/* actually longer; address family
					   specific flow info. */
};

/* protocol header info is passed to an enqueue routine */
struct pr_hdr {
	u_int8_t	ph_family;	/* protocol family (e,g, PF_INET) */
	caddr_t		ph_hdr;		/* pointer to a protocol header */
};


#if defined(KERNEL) || defined(_KERNEL)

/* if_altqflags */
#define ALTQF_READY	 0x01	/* driver supports alternate queueing */
#define ALTQF_ENABLE	 0x02	/* altq is in use */
#define ALTQF_ACCOUNTING 0x04	/* altq accounting is enabled */
#define ALTQF_DRIVER1	 0x40	/* driver specific */

/* if_altqtype */
#define ALTQT_NONE	0	/* reserved */
#define ALTQT_CBQ	1	/* cbq */
#define ALTQT_WFQ	2	/* wfq */
#define ALTQT_AFMAP	3	/* afmap */
#define ALTQT_FIFOQ	4	/* fifoq */
#define ALTQT_RED	5	/* red */
#define ALTQT_RIO	6	/* rio */
#define ALTQT_LOCALQ	7	/* local use */
#define ALTQT_MAX	8

/* if_altqflags set internally only: */
#define	ALTQF_CANTCHANGE 	(ALTQF_READY)

#define ALTQ_IS_READY(ifp)	((ifp)->if_altqflags & ALTQF_READY)
#define ALTQ_IS_ON(ifp)		((ifp)->if_altqflags & ALTQF_ENABLE)

#define SET_ACCOUNTING(ifp)	((ifp)->if_altqflags |= ALTQF_ACCOUNTING)
#define CLEAR_ACCOUNTING(ifp)	((ifp)->if_altqflags &= ~ALTQF_ACCOUNTING)


/* if_altqenqueue 4th arg */
#define ALTEQ_NORMAL	0	/* normal queueing */
#define ALTEQ_ACCOK	1	/* accounting successful queueing */
#define ALTEQ_ACCDROP	2	/* accounting packet drop */

/* if_altqdequeue 2nd arg */	
#define ALTDQ_DEQUEUE	0	/* dequeue mbuf from the queue */
#define ALTDQ_PEEK	1	/* don't dequeue mbuf from the queue */
#define ALTDQ_FLUSH	2	/* discard all the queued packets */

#define ALTQ_ACCOUNTING(ifp, m, h, mode) \
		if ((ifp)->if_altqflags & ALTQF_ACCOUNTING) \
			(ifp)->if_altqenqueue((ifp), (m), (h), (mode));


struct ifnet; struct mbuf;	/* forward declarations for Standard C */

void *altq_lookup __P((char *, int));
int if_altqattach __P((struct ifnet *, void *,
		       int (*)(struct ifnet *, struct mbuf *, struct pr_hdr *, int),
		       struct mbuf *(*)(struct ifnet *, int), int));
int if_altqdetach __P((struct ifnet *));
int if_altqenable __P((struct ifnet *));
int if_altqdisable __P((struct ifnet *));
int altq_extractflow __P((struct mbuf *, struct pr_hdr *,
			  struct flowinfo *, u_int32_t));
int altq_mkctlhdr __P((struct pr_hdr *));

/* ioctl cmd type */
#if (__FreeBSD__ < 3)
typedef int ioctlcmd_t;
#else
typedef u_long ioctlcmd_t;
#endif

/* macro for timeout/untimeout */
#if (__FreeBSD__ < 3)
/* dummy callout_handle structure */
struct callout_handle {
	void *callout;
};
#define CALLOUT_HANDLE_INIT(h)	{ (h)->callout = NULL; }
#define TIMEOUT(f,a,t,h)	timeout((f),(a),(t))
#define UNTIMEOUT(f,a,h)	untimeout((f),(a))
#else
#define CALLOUT_HANDLE_INIT(h)	callout_handle_init((h))
#define TIMEOUT(f,a,t,h)	{ (h) = timeout((f),(a),(t)); }
#define UNTIMEOUT(f,a,h)	untimeout((f),(a),(h))
#endif

#if defined(ALTQ_DEBUG) && (ALTQ_DEBUG != 0)
#ifdef __STDC__
#define	ASSERT(e)	((e) ? (void)0 : altq_assert(__FILE__, __LINE__, #e))
#else	/* PCC */
#define	ASSERT(e)	((e) ? (void)0 : altq_assert(__FILE__, __LINE__, "e"))
#endif
#else
#undef ALTQ_DEBUG
#define	ASSERT(e)	((void)0)
#endif

void altq_assert __P((const char *, int, const char *));

#endif /* KERNEL */

#endif /* _NET_IF_ALTQ_H_ */

