/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * IPsec controller part.
 */

#ifndef _NETINET6_IPSEC_H_
#define _NETINET6_IPSEC_H_

#include <netkey/keydb.h>
#include <netkey/keyv2.h>

/*
 * AH/ESP level values.
 */
#define	IPSEC_LEVEL_BYPASS	0
#define	IPSEC_LEVEL_NONE	1
#define	IPSEC_LEVEL_DEFAULT	2
#define	IPSEC_LEVEL_AVAIL	3
#define	IPSEC_LEVEL_USE		4
#define	IPSEC_LEVEL_REQUIRE	5
#define	IPSEC_LEVEL_UNIQUE	6

/* ipsec policy level */
struct ipsecpolicy {
	u_int level0[SADB_PROTO_MAX];	/* level defined by user */
	u_int level[SADB_PROTO_MAX];	/* level per protocol as to be use. */
	struct secasb *sab;		/* cache for SAD tuple. */
	struct secpc *sp;		/* cache for SPD tuple, */
					/* only use in in{,6}pcb. */
};

#define IPSEC_REPLAYWSIZE  32

/* statistics for ipsec processing */
struct ipsecstat {
	u_long in_success;  /* succeeded inbound process */
	u_long in_polvio;   /* security policy violation for inbound process */
	u_long in_nosa;     /* inbound SA is unavailable */
	u_long in_inval;    /* inbound processing failed due to EINVAL */
	u_long in_badspi;   /* failed getting a SPI */
	u_long in_ahreplay; /* AH replay check failed */
	u_long in_espreplay; /* ESP replay check failed */
	u_long in_ahauthsucc; /* AH authentication success */
	u_long in_ahauthfail; /* AH authentication failure */
	u_long in_espauthsucc; /* ESP authentication success */
	u_long in_espauthfail; /* ESP authentication failure */
	u_long in_esphist[SADB_EALG_MAX];
	u_long in_ahhist[SADB_AALG_MAX];
	u_long out_success; /* succeeded outbound process */
	u_long out_polvio;  /* security policy violation for outbound process */
	u_long out_nosa;    /* outbound SA is unavailable */
	u_long out_inval;   /* outbound process failed due to EINVAL */
	u_long out_noroute; /* there is no route */
	u_long out_esphist[SADB_EALG_MAX];
	u_long out_ahhist[SADB_AALG_MAX];
};

/*
 * Definitions for IPsec & Key sysctl operations.
 */
/*
 * Names for IPsec & Key sysctl objects
 */
#define IPSECCTL_STATS			1	/* stats */
#define IPSECCTL_DEF_POLICY		2
#define IPSECCTL_DEF_ESP_TRANSLEV	3	/* int; ESP tunnel mode */
#define IPSECCTL_DEF_ESP_NETLEV		4	/* int; ESP transport mode */
#define IPSECCTL_DEF_AH_TRANSLEV	5	/* int; AH transport mode */
#define IPSECCTL_DEF_AH_NETLEV		6	/* int; AH tunnel mode */
#define IPSECCTL_INBOUND_CALL_IKE	7
#define	IPSECCTL_AH_CLEARTOS		8
#define	IPSECCTL_AH_OFFSETMASK		9
#define	IPSECCTL_DFBIT			10
#define IPSECCTL_MAXID			11

#define IPSECCTL_NAMES { \
	{ 0, 0 }, \
	{ "stats", CTLTYPE_STRUCT }, \
	{ "def_policy", CTLTYPE_INT }, \
	{ "esp_trans_deflev", CTLTYPE_INT }, \
	{ "esp_net_deflev", CTLTYPE_INT }, \
	{ "ah_trans_deflev", CTLTYPE_INT }, \
	{ "ah_net_deflev", CTLTYPE_INT }, \
	{ "inbound_call_ike", CTLTYPE_INT }, \
	{ "ah_cleartos", CTLTYPE_INT }, \
	{ "ah_offsetmask", CTLTYPE_INT }, \
	{ "dfbit", CTLTYPE_INT }, \
}

#define IPSEC6CTL_NAMES { \
	{ 0, 0 }, \
	{ "stats", CTLTYPE_STRUCT }, \
	{ "def_policy", CTLTYPE_INT }, \
	{ "esp_trans_deflev", CTLTYPE_INT }, \
	{ "esp_net_deflev", CTLTYPE_INT }, \
	{ "ah_trans_deflev", CTLTYPE_INT }, \
	{ "ah_net_deflev", CTLTYPE_INT }, \
	{ "inbound_call_ike", CTLTYPE_INT }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
	{ 0, 0 }, \
}

#define IPSECCTL_VARS { \
	0, \
	&ipsecstat, \
	&ip4_def_policy, \
	&ip4_def_level.level[SADB_X_ESP_TRANS], \
	&ip4_def_level.level[SADB_X_ESP_NETWORK], \
	&ip4_def_level.level[SADB_X_AH_TRANS], \
	&ip4_def_level.level[SADB_X_AH_NETWORK], \
	&ip4_inbound_call_ike, \
	&ip4_ah_cleartos, \
	&ip4_ah_offsetmask, \
	&ip4_ipsec_dfbit, \
}

#define IPSEC6CTL_VARS { \
	0, \
	&ipsec6stat, \
	&ip6_def_policy, \
	&ip6_def_level.level[SADB_X_ESP_TRANS], \
	&ip6_def_level.level[SADB_X_ESP_NETWORK], \
	&ip6_def_level.level[SADB_X_AH_TRANS], \
	&ip6_def_level.level[SADB_X_AH_NETWORK], \
	&ip6_inbound_call_ike, \
	0, \
	0, \
	0, \
}

#ifdef KERNEL

extern struct ipsecstat ipsecstat;
extern int ip4_def_policy;
extern struct ipsecpolicy ip4_def_level;
extern int ip4_inbound_call_ike;
extern int ip4_ah_cleartos;
extern int ip4_ah_offsetmask;
extern int ip4_ipsec_dfbit;

#ifdef INET6
extern struct ipsecstat ipsec6stat;
extern int ip6_def_policy;
extern struct ipsecpolicy ip6_def_level;
extern int ip6_inbound_call_ike;
#endif

extern struct secasb *ipsec4_policybysock __P((struct mbuf *, struct socket *,
					struct ipsecpolicy *, int *));
extern struct secasb *ipsec4_policybyaddr __P((struct mbuf *,
					struct ipsecpolicy *, int *));
struct inpcb;
extern struct ipsecpolicy *ipsec4_getpolicy __P((struct inpcb *,
					struct secindex *, int *));
#ifdef INET6
extern struct secasb *ipsec6_policybysock __P((struct mbuf *, struct socket *,
					struct ipsecpolicy *, int *));
extern struct secasb *ipsec6_policybyaddr __P((struct mbuf *,
					struct ipsecpolicy *, int *));
struct in6pcb;
extern struct ipsecpolicy *ipsec6_getpolicy __P((struct in6pcb *,
					struct secindex *, int *));
#endif /*INET6*/

struct inpcb;
extern int ipsec4_init_level __P((struct inpcb *));
extern int ipsec4_set_level __P((struct inpcb *, int, int));
extern int ipsec4_in_reject __P((struct inpcb *, struct mbuf *));

#ifdef INET6
struct in6pcb;
extern int ipsec6_init_level __P((struct in6pcb *));
extern int ipsec6_set_level __P((struct in6pcb *, int, int));
extern int ipsec6_in_reject __P((struct in6pcb *, struct mbuf *));
#endif /*INET6*/

struct secas;
struct tcpcb;
struct tcp6cb;
struct mbuf *ipsec4_encapsulate __P((struct mbuf *, struct secas *));
#ifdef INET6
struct mbuf *ipsec6_encapsulate __P((struct mbuf *, struct secas *));
#endif
extern int ipsec_chkreplay __P((u_int32_t, struct secas *));
extern size_t ipsec4_hdrsiz __P((struct mbuf *, struct inpcb *));
extern size_t ipsec4_hdrsiz_tcp __P((struct tcpcb *));
#ifdef INET6
extern size_t ipsec6_hdrsiz __P((struct mbuf *, struct in6pcb *));
extern size_t ipsec6_hdrsiz_tcp __P((struct tcp6cb *));
#endif

struct ip;
extern void ipsec4_logpacket __P((struct ip *, u_int32_t));
extern void ipsec4_logsa __P((struct secas *));

#ifdef INET6
struct ip6_hdr;
extern void ipsec6_logpacket __P((struct ip6_hdr *, u_int32_t));
extern void ipsec6_logsa __P((struct secas *));
#endif /*INET6*/

extern void ipsec_dumpmbuf __P((struct mbuf *));

#if defined(__bsdi__) || defined(__NetBSD__)
int ipsec_sysctl __P((int *, u_int, void *, size_t *, void *, size_t));
int ipsec6_sysctl __P((int *, u_int, void *, size_t *, void *, size_t));
#endif /* __bsdi__ || __NetBSD__ */

#endif /*KERNEL*/

#endif /*_NETINET6_IPSEC_H_*/
