/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "NPL"); you may not use this file except in
 * compliance with the NPL.  You may obtain a copy of the NPL at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the NPL is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the NPL
 * for the specific language governing rights and limitations under the
 * NPL.
 *
 * The Initial Developer of this code under the NPL is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation.  All Rights
 * Reserved.
 */
/*-----------------------------------------*/
/*																		*/
/* Name:		<Xfe/StringDefs.h>										*/
/* Description:	Xfe widgets string definitions.							*/
/* Author:		Ramiro Estrugo <ramiro@netscape.com>					*/
/*																		*/
/*----------------------------------------------------------------------*/


#ifndef _XfeStringDefs_h_						/* start StringDefs.h	*/
#define _XfeStringDefs_h_

/*----------------------------------------------------------------------*/
/*																		*/
/* Callback Names														*/
/*																		*/
/*----------------------------------------------------------------------*/
#define XmNactionCallback					"actionCallback"
#define XmNanimationCallback				"animationCallback"
#define XmNbeforeRealizeCallback			"beforeRealizeCallback"
#define XmNbeforeResizeCallback				"beforeResizeCallback"
#define XmNbutton3DownCallback				"button3DownCallback"
#define XmNbutton3UpCallback				"button3UpCallback"
#define XmNchangeManagedCallback			"changeManagedCallback"
#define XmNcloseCallback					"closeCallback"
#define XmNcloseCallback					"closeCallback"
#define XmNdeleteWindowCallback				"deleteWindowCallback"
#define XmNdockCallback						"dockCallback"
#define XmNdragAllowCallback				"dragAllowCallback"
#define XmNdragEndCallback					"dragEndCallback"
#define XmNenterCallback					"enterCallback"
#define XmNfirstMapCallback					"firstMapCallback"
#define XmNfloatingMapCallback				"floatingMapCallback"
#define XmNfloatingUnmapCallback			"floatingUnmapCallback"
#define XmNfocusInCallback					"focusInCallback"
#define XmNfocusOutCallback					"focusOutCallback"
#define XmNgrabCallback						"grabCallback"
#define XmNlayoutCallback					"layoutCallback"
#define XmNleaveCallback					"leaveCallback"
#define XmNmoveCallback						"moveCallback"
#define XmNnewItemCallback					"newItemCallback"
#define XmNopenCallback						"openCallback"
#define XmNpositionChangeCallback			"positionChangeCallback"
#define XmNsaveYourselfCallback				"saveYourselfCallback"
#define XmNselectionChangedCallback			"selectionChangedCallback"
#define XmNsizeChangeCallback				"sizeChangeCallback"
#define XmNsnapCallback						"snapCallback"
#define XmNsubmenuTearCallback				"submenuTearCallback"
#define XmNswapCallback						"swapCallback"
#define XmNtaskBarCallback					"taskBarCallback"
#define XmNtitleChangedCallback				"titleChangedCallback"
#define XmNtoggleBoxCallback				"toggleBoxCallback"
#define XmNtoggleSelectionCallback			"toggleSelectionCallback"
#define XmNundockCallback					"undockCallback"
#define XmNungrabCallback					"ungrabCallback"
#define XmNvisibilityCallback				"visibilityCallback"
								   
/*----------------------------------------------------------------------*/
/*																		*/
/* Resource Names														*/
/*																		*/
/*----------------------------------------------------------------------*/
#define XmNactionButton					"actionButton"
#define XmNactionCursor					"actionCursor"
#define XmNactionPixmap					"actionPixmap"
#define XmNactive						"active"
#define XmNactiveButton					"activeButton"
#define XmNallowDrag					"allowDrag"
#define XmNallowExpand					"allowExpand"
#define XmNallowTearOff					"allowTearOff"
#define XmNallowWrap					"allowWrap"
#define XmNalwaysVisible				"alwaysVisible"
#define XmNanimationInterval			"animationInterval"
#define XmNanimationPixmaps				"animationPixmaps"
#define XmNanimationRunning				"animationRunning"
#define XmNarmBackground				"armBackground"
#define XmNarmOffset					"armOffset"
#define XmNarmed						"armed"
#define XmNarmedPixmap					"armedPixmap"
#define XmNarmedPixmapMask				"armedPixmapMask"
#define XmNarrow						"arrow"
#define XmNarrowDisplayPolicy			"arrowDisplayPolicy"
#define XmNarrowHeight					"arrowHeight"
#define XmNarrowPlacement				"arrowPlacement"
#define XmNarrowType					"arrowType"
#define XmNarrowWidth					"arrowWidth"
#define XmNarticleLabel					"articleLabel"
#define XmNarticleWidth					"articleWidth"
#define XmNattachmentOneBottom			"attachmentOneBottom"
#define XmNattachmentOneLeft			"attachmentOneLeft"
#define XmNattachmentOneRight			"attachmentOneRight"
#define XmNattachmentOneTop				"attachmentOneTop"
#define XmNattachmentTwoBottom			"attachmentTwoBottom"
#define XmNattachmentTwoLeft			"attachmentTwoLeft"
#define XmNattachmentTwoRight			"attachmentTwoRight"
#define XmNattachmentTwoTop				"attachmentTwoTop"
#define XmNattributeOptionMenu			"attributeOptionMenu"
#define XmNbackwardArrow				"backwardArrow"
#define XmNbarColor						"barColor"
#define XmNbottomPixmap					"bottomPixmap"
#define XmNbottomRaisedPixmap			"bottomRaisedPixmap"
#define XmNbottomView					"bottomView"
#define XmNboxHeight					"boxHeight"
#define XmNboxState						"boxState"
#define XmNboxThickness					"boxThickness"
#define XmNboxType						"boxType"
#define XmNboxWidth						"boxWidth"
#define XmNbufferType					"bufferType"
#define XmNbusy							"busy"
#define XmNbusyCursor					"busyCursor"
#define XmNbusyCursorOn					"busyCursorOn"
#define XmNbuttonLayout					"buttonLayout"
#define XmNbuttonTrigger				"buttonTrigger"
#define XmNbypassShell					"bypassShell"
#define XmNcascadeArrowDirection		"cascadeArrowDirection"
#define XmNcascadeArrowHeight			"cascadeArrowHeight"
#define XmNcascadeArrowLocation			"cascadeArrowLocation"
#define XmNcascadeArrowWidth			"cascadeArrowWidth"
#define XmNcenterView					"centerView"
#define XmNchildForceHeight				"childForceHeight"
#define XmNchildForceWidth				"childForceWidth"
#define XmNchildOne						"childOne"
#define XmNchildTwo						"childTwo"
#define XmNchildUsePreferredHeight		"childUsePreferredHeight"
#define XmNchildUsePreferredWidth		"childUsePreferredWidth"
#define XmNchromeChildType				"chromeChildType"
#define XmNclipArea						"clipArea"
#define XmNclipShadowThickness			"clipShadowThickness"
#define XmNclipShadowType				"clipShadowType"
#define XmNclosedTabs					"closedTabs"
#define XmNcurrentPixmapIndex			"currentPixmapIndex"
#define XmNcursor						"cursor"
#define XmNcursorOn						"cursorOn"
#define XmNcylonInterval				"cylonInterval"
#define XmNcylonOffset					"cylonOffset"
#define XmNcylonRunning					"cylonRunning"
#define XmNcylonWidth					"cylonWidth"
#define XmNdashBoard					"dashBoard"
#define XmNdefaultPixmap				"defaultPixmap"
#define XmNdeterminate                  "determinate"
#define XmNdocked						"docked"
#define XmNdockedTaskBar				"dockedTaskBar"
#define XmNdragButton					"dragButton"
#define XmNdragCursor					"dragCursor"
#define XmNdragInProgress				"dragInProgress"
#define XmNdragThreshold				"dragThreshold"
#define XmNdrawCascadeArrow				"drawCascadeArrow"
#define XmNdynamicIndicator				"dynamicIndicator"
#define XmNeditModifiers				"editModifiers"
#define XmNemulateMotif					"emulateMotif"
#define XmNendPercent					"endPercent"
#define XmNfillOnEnter					"fillOnEnter"
#define XmNfloatingShell				"floatingShell"
#define XmNfloatingTarget				"floatingTarget"
#define XmNfloatingTaskBar				"floatingTaskBar"
#define XmNfontItemFonts				"fontItemFonts"
#define XmNfontItemLabels				"fontItemLabels"
#define XmNforwardArrow					"forwardArrow"
#define XmNhasBeenMapped				"hasBeenMapped"
#define XmNhorizontalCursor				"horizontalCursor"
#define XmNhorizontalPixmap				"horizontalPixmap"
#define XmNhorizontalRaisedPixmap		"horizontalRaisedPixmap"
#define XmNicon							"icon"
#define XmNignoreConfigure				"ignoreConfigure"
#define XmNignoreExposures				"ignoreExposures"
#define XmNindicatorLocation			"indicatorLocation"
#define XmNindicatorPosition			"indicatorPosition"
#define XmNindicatorThreshold			"indicatorThreshold"
#define XmNinputDateLabel				"inputDateLabel"
#define XmNinputOptionMenu				"inputOptionMenu"
#define XmNinputTextField				"inputTextField"
#define XmNinsensitivePixmap			"insensitivePixmap"
#define XmNinsensitivePixmapMask		"insensitivePixmapMask"
#define XmNinstancePointer				"instancePointer"
#define XmNitem							"item"
#define XmNitemBackground				"itemBackground"
#define XmNitemFontList					"itemFontList"
#define XmNitemForeground				"itemForeground"
#define XmNitemList						"itemList"
#define XmNlabelAlignment				"labelAlignment"
#define XmNlabelDirection				"labelDirection"
#define XmNlayableChildren				"layableChildren"
#define XmNleftPixmap					"leftPixmap"
#define XmNleftRaisedPixmap				"leftRaisedPixmap"
#define XmNleftView						"leftView"
#define XmNlinkNode						"linkNode"
#define XmNlistFontList					"listFontList"
#define XmNlogo							"logo"
#define XmNmanagedItemCount				"managedItemCount"
#define XmNmatchSubMenuWidth			"matchSubMenuWidth"
#define XmNmaxChildHeight				"maxChildHeight"
#define XmNmaxChildWidth				"maxChildWidth"
#define XmNmaxNumColumns				"maxNumColumns"
#define XmNmaxNumRows					"maxNumRows"
#define XmNnumAnimationPixmaps			"numAnimationPixmaps"
#define XmNnumFontItems					"numFontItems"
#define XmNnumLayableChildren			"numLayableChildren"
#define XmNnumPopupChildren				"numPopupChildren"
#define XmNnumPrivateComponents			"numPrivateComponents"
#define XmNnumRows						"numRows"
#define XmNopen							"open"
#define XmNopenedTabs					"openedTabs"
#define XmNoperatorOptionMenu			"operatorOptionMenu"
#define XmNpaneChildAttachment			"paneChildAttachment"
#define XmNpaneChildType				"paneChildType"
#define XmNpaneDragMode					"paneDragMode"
#define XmNpaneSashType					"paneSashType"
#define XmNpixmapMask					"pixmapMask"
#define XmNpointerInside				"pointerInside"
#define XmNpoppedUp						"poppedUp"
#define XmNpopupChildren				"popupChildren"
#define XmNpopupCursor					"popupCursor"
#define XmNpopupDelay					"popupDelay"
#define XmNpreferredHeight				"preferredHeight"
#define XmNpreferredWidth				"preferredWidth"
#define XmNpretendSensitive				"pretendSensitive"
#define XmNprivateComponent				"privateComponent"
#define XmNprogressBar					"progressBar"
#define XmNraiseBackground				"raiseBackground"
#define XmNraiseBorderThickness			"raiseBorderThickness"
#define XmNraiseForeground				"raiseForeground"
#define XmNraiseOffset					"raiseOffset"
#define XmNraiseOnEnter					"raiseOnEnter"
#define XmNraised						"raised"
#define XmNraisedPixmap					"raisedPixmap"
#define XmNraisedPixmapMask				"raisedPixmapMask"
#define XmNresetWhenIdle				"resetWhenIdle"
#define XmNrightPixmap					"rightPixmap"
#define XmNrightRaisedPixmap			"rightRaisedPixmap"
#define XmNrightView					"rightView"
#define XmNrulesType					"rulesType"
#define XmNsashAlwaysVisible			"sashAlwaysVisible"
#define XmNsashColor					"sashColor"
#define XmNsashOffset					"sashOffset"
#define XmNsashPosition					"sashPosition"
#define XmNsashShadowType				"sashShadowType"
#define XmNsashSpacing					"sashSpacing"
#define XmNsashThickness				"sashThickness"
#define XmNselectOnHighlight			"selectOnHighlight"
#define XmNselected						"selected"
#define XmNselectedButton				"selectedButton"
#define XmNselectionColor				"selectionColor"
#define XmNselectionModifiers			"selectionModifiers"
#define XmNseparatorThickness			"separatorThickness"
#define XmNshareShell					"shareShell"
#define XmNshell						"shell"
#define XmNshowActionButton				"showActionButton"
#define XmNshowDockedTaskBar			"showDockedTaskBar"
#define XmNshowLogo						"showLogo"
#define XmNstartIconic					"startIconic"
#define XmNstartPercent					"startPercent"
#define XmNstatusBar					"statusBar"
#define XmNsubMenuAlignment				"subMenuAlignment"
#define XmNsubMenuLocation				"subMenuLocation"
#define XmNswapThreshold				"swapThreshold"
#define XmNtabButtons					"tabButtons"
#define XmNtabOffset					"TabOffset"
#define XmNtaskBar						"taskBar"
#define XmNtaskBarDocked				"taskBarDocked"
#define XmNtitleFontList				"titleFontList"
#define XmNtitleShadowThickness			"titleShadowThickness"
#define XmNtitleShadowType				"titleShadowType"
#define XmNtoggleBehavior				"toggleBehavior"
#define XmNtoolBar						"toolBar"
#define XmNtoolBarPosition				"toolBarPosition"
#define XmNtoolBarSelectionPolicy		"toolBarSelectionPolicy"
#define XmNtoolBox						"toolBox"
#define XmNtopPixmap					"topPixmap"
#define XmNtopRaisedPixmap				"topRaisedPixmap"
#define XmNtopView						"topView"
#define XmNtorn							"torn"
#define XmNtornShellTitle				"tornShellTitle"
#define XmNtrackDeleteWindow			"trackDeleteWindow"
#define XmNtrackEditres					"trackEditres"
#define XmNtrackMapping					"trackMapping"
#define XmNtrackPosition				"trackPosition"
#define XmNtrackSaveYourself			"trackSaveYourself"
#define XmNtrackSize					"trackSize"
#define XmNtransparentCursor			"transparentCursor"
#define XmNtruncateLabel				"truncateLabel"
#define XmNtruncateProc					"truncateProc"
#define XmNundockPixmap					"undockPixmap"
#define XmNusePreferredHeight			"usePreferredHeight"
#define XmNusePreferredWidth			"usePreferredWidth"
#define XmNverticalCursor				"verticalCursor"
#define XmNverticalPixmap				"verticalPixmap"
#define XmNverticalRaisedPixmap			"verticalRaisedPixmap"

/*----------------------------------------------------------------------*/
/*																		*/
/* Class Names															*/
/*																		*/
/*----------------------------------------------------------------------*/
#define XmCActionPixmap					"ActionPixmap"
#define XmCActive						"Active"
#define XmCActiveButton					"ActiveButton"
#define XmCAlwaysVisible				"AlwaysVisible"
#define XmCAnimationInterval			"AnimationInterval"
#define XmCAnimationPixmaps				"AnimationPixmaps"
#define XmCArmBackground				"ArmBackground"
#define XmCArmOffset					"ArmOffset"
#define XmCArmed						"Armed"
#define XmCArmedPixmap					"ArmedPixmap"
#define XmCArmedPixmapMask				"ArmedPixmapMask"
#define XmCArrowDisplayPolicy			"ArrowDisplayPolicy"
#define XmCArrowHeight					"ArrowHeight"
#define XmCArrowPlacement				"ArrowPlacement"
#define XmCArrowType					"ArrowType"
#define XmCArrowWidth					"ArrowWidth"
#define XmCArticleWidth					"ArticleWidth"
#define XmCAttachmentOneBottom			"AttachmentOneBottom"
#define XmCAttachmentOneLeft			"AttachmentOneLeft"
#define XmCAttachmentOneRight			"AttachmentOneRight"
#define XmCAttachmentOneTop				"AttachmentOneTop"
#define XmCAttachmentTwoBottom			"AttachmentTwoBottom"
#define XmCAttachmentTwoLeft			"AttachmentTwoLeft"
#define XmCAttachmentTwoRight			"AttachmentTwoRight"
#define XmCAttachmentTwoTop				"AttachmentTwoTop"
#define XmCBackwardArrow				"BackwardArrow"
#define XmCBarColor						"BarColor"
#define XmCBottomPixmap					"BottomPixmap"
#define XmCBottomRaisedPixmap			"BottomRaisedPixmap"
#define XmCBoxHeight					"BoxHeight"
#define XmCBoxState						"BoxState"
#define XmCBoxThickness					"BoxThickness"
#define XmCBoxType						"BoxType"
#define XmCBoxWidth						"BoxWidth"
#define XmCBufferType					"BufferType"
#define XmCBusy							"Busy"
#define XmCBusyCursor					"BusyCursor"
#define XmCBusyCursorOn					"BusyCursorOn"
#define XmCButtonLayout					"ButtonLayout"
#define XmCButtonTrigger				"ButtonTrigger"
#define XmCBypassShell					"BypassShell"
#define XmCCascadeArrowDirection		"CascadeArrowDirection"
#define XmCCascadeArrowHeight			"CascadeArrowHeight"
#define XmCCascadeArrowLocation			"CascadeArrowLocation"
#define XmCCascadeArrowWidth			"CascadeArrowWidth"
#define XmCChildForceHeight				"ChildForceHeight"
#define XmCChildForceWidth				"ChildForceWidth"
#define XmCChildOne						"ChildOne"
#define XmCChildTwo						"ChildTwo"
#define XmCChildUsePreferredHeight		"ChildUsePreferredHeight"
#define XmCChildUsePreferredWidth		"ChildUsePreferredWidth"
#define XmCChromeChildType				"ChromeChildType"
#define XmCClipArea						"ClipArea"
#define XmCCurrentPixmapIndex			"CurrentPixmapIndex"
#define XmCCursorOn						"CursorOn"
#define XmCCylonInterval				"CylonInterval"
#define XmCCylonOffset					"CylonOffset"
#define XmCCylonWidth					"CylonWidth"
#define XmCDefaultPixmap				"DefaultPixmap"
#define XmCDeterminate                  "Determinate"
#define XmCDocked						"Docked"
#define XmCDragButton					"DragButton"
#define XmCDragCursor					"DragCursor"
#define XmCDragInProgress				"DragInProgress"
#define XmCDragThreshold				"DragThreshold"
#define XmCDrawCascadeArrow				"DrawCascadeArrow"
#define XmCDropping						"Dropping"
#define XmCDynamicIndicator				"DynamicIndicator"
#define XmCEditModifiers				"EditModifiers"
#define XmCEmulateMotif					"EmulateMotif"
#define XmCEndPercent					"EndPercent"
#define XmCFillOnEnter					"FillOnEnter"
#define XmCFontItemFonts				"FontItemFonts"
#define XmCFontItemLabels				"FontItemLabels"
#define XmCForwardArrow					"ForwardArrow"
#define XmCHighlightOnRaise				"HighlightOnRaise"
#define XmCHorizontalCursor				"HorizontalCursor"
#define XmCHorizontalPixmap				"HorizontalPixmap"
#define XmCHorizontalRaisedPixmap		"HorizontalRaisedPixmap"
#define XmCIgnoreConfigure				"IgnoreConfigure"
#define XmCIgnoreExposures				"IgnoreExposures"
#define XmCIndicatorLocation			"IndicatorLocation"
#define XmCIndicatorPosition			"IndicatorPosition"
#define XmCIndicatorThreshold			"IndicatorThreshold"
#define XmCInsensitivePixmap			"InsensitivePixmap"
#define XmCInsensitivePixmapMask		"InsensitivePixmapMask"
#define XmCInstancePointer				"InstancePointer"
#define XmCItemBackground				"ItemBackground"
#define XmCItemFontList					"ItemFontList"
#define XmCItemForeground				"ItemForeground"
#define XmCLabelAlignment				"LabelAlignment"
#define XmCLabelDirection				"LabelDirection"
#define XmCLayableChildren				"LayableChildren"
#define XmCLeftPixmap					"LeftPixmap"
#define XmCLeftRaisedPixmap				"LeftRaisedPixmap"
#define XmCLinkNode						"LinkNode"
#define XmCListFontList					"ListFontList"
#define XmCMatchSubMenuWidth			"MatchSubMenuWidth"
#define XmCMaxNumColumns				"MaxNumColumns"
#define XmCMaxNumRows					"MaxNumRows"
#define XmCNumAnimationPixmaps			"NumAnimationPixmaps"
#define XmCNumFontItems					"NumFontItems"
#define XmCNumLayableChildren			"NumLayableChildren"
#define XmCNumLogoPixmaps				"NumLogoPixmaps"
#define XmCNumRows						"NumRows"
#define XmCOpen							"Open"
#define XmCPaneChildAttachment			"PaneChildAttachment"
#define XmCPaneChildType				"PaneChildType"
#define XmCPaneDragMode					"PaneDragMode"
#define XmCPaneSashType					"PaneSashType"
#define XmCPixmapMask					"PixmapMask"
#define XmCPopupCursor					"PopupCursor"
#define XmCPopupDelay					"PopupDelay"
#define XmCPretendSensitive				"PretendSensitive"
#define XmCPrivateComponent				"PrivateComponent"
#define XmCRaiseBackground				"RaiseBackground"
#define XmCRaiseBorderThickness			"RaiseBorderThickness"
#define XmCRaiseForeground				"RaiseForeground"
#define XmCRaiseOffset					"RaiseOffset"
#define XmCRaiseOnEnter					"RaiseOnEnter"
#define XmCRaised						"Raised"
#define XmCRaisedPixmap					"RaisedPixmap"
#define XmCRaisedPixmapMask				"RaisedPixmapMask"
#define XmCResetWhenIdle				"ResetWhenIdle"
#define XmCResizeCursor					"ResizeCursor"
#define XmCRightPixmap					"RightPixmap"
#define XmCRightRaisedPixmap			"RightRaisedPixmap"
#define XmCRulesType					"RulesType"
#define XmCSashAlwaysVisible			"SashAlwaysVisible"
#define XmCSashColor					"SashColor"
#define XmCSashSpacing					"SashSpacing"
#define XmCSashThickness				"SashThickness"
#define XmCSelectOnHighlight			"SelectOnHighlight"
#define XmCSelected						"Selected"
#define XmCSelectedButton				"SelectedButton"
#define XmCSelectionColor				"SelectionColor"
#define XmCSelectionModifiers			"SelectionModifiers"
#define XmCSeparatorThickness			"SeparatorThickness"
#define XmCShareShell					"ShareShell"
#define XmCShowActionButton				"ShowActionButton"
#define XmCShowDockedTaskBar			"ShowDockedTaskBar"
#define XmCShowLogo						"ShowLogo"
#define XmCStartIconic					"StartIconic"
#define XmCStartPercent					"StartPercent"
#define XmCSubMenuAlignment				"SubMenuAlignment"
#define XmCSubMenuLocation				"SubMenuLocation"
#define XmCSwapThreshold				"SwapThreshold"
#define XmCTaskBarDocked				"TaskBarDocked"
#define XmCTitleFontList				"TitleFontList"
#define XmCToggleBehavior				"ToggleBehavior"
#define XmCToolBarPosition				"ToolBarPosition"
#define XmCToolBarSelectionPolicy		"ToolBarSelectionPolicy"
#define XmCTopPixmap					"TopPixmap"
#define XmCTopRaisedPixmap				"TopRaisedPixmap"
#define XmCTornShellTitle				"TornShellTitle"
#define XmCTrackDeleteWindow			"TrackDeleteWindow"
#define XmCTrackEditres					"TrackEditres"
#define XmCTrackMapping					"TrackMapping"
#define XmCTrackPosition				"TrackPosition"
#define XmCTrackSaveYourself			"TrackSaveYourself"
#define XmCTrackSize					"TrackSize"
#define XmCTruncateLabel				"TruncateLabel"
#define XmCTruncateProc					"TruncateProc"
#define XmCUndockPixmap					"UndockPixmap"
#define XmCUsePreferredHeight			"UsePreferredHeight"
#define XmCUsePreferredWidth			"UsePreferredWidth"
#define XmCVerticalCursor				"VerticalCursor"
#define XmCVerticalPixmap				"VerticalPixmap"
#define XmCVerticalRaisedPixmap			"VerticalRaisedPixmap"

/*----------------------------------------------------------------------*/
/*																		*/
/* Representation Types													*/
/*																		*/
/*----------------------------------------------------------------------*/
#define XmRArrowDisplayPolicy			XmRScrollBarDisplayPolicy
#define XmRBoxType						"BoxType"
#define XmRBufferType					"BufferType"
#define XmRButtonLayout					"ButtonLayout"
#define XmRButtonTrigger				"ButtonTrigger"
#define XmRChromeChildType				"ChromeChildType"
#define XmRLinkedChildren				"LinkedChildren"
#define XmRLocationType					"LocationType"
#define XmRModifiers					"Modifiers"
#define XmRPaneChildAttachment			"PaneChildAttachment"
#define XmRPaneChildType				"PaneChildType"
#define XmRPaneDragMode					"PaneDragMode"
#define XmRPaneSashType					"PaneSashType"
#define XmRPixmapTable					"PixmapTable"
#define XmRProgressBarMode				"ProgressBarMode"
#define XmRRulesType					"RulesType"
#define XmRToolBarIndicatorLocation		"ToolBarIndicatorLocation"
#define XmRToolBarSelectionPolicy		"ToolBarSelectionPolicy"
#define XmRToolBarToggleBehavior		"ToolBarToggleBehavior"
#define XmRToolScrollArrowPlacement		"ToolScrollArrowPlacement"
#define XmRTruncateProc					"TruncateProc"
#define XmRXfeArrowType					"XfeArrowType"

/*----------------------------------------------------------------------*/
/*																		*/
/* Things that conflict with Motif 2.x									*/
/*																		*/
/*----------------------------------------------------------------------*/
#if XmVersion < 2000
#define XmNdragStartCallback			"dragStartCallback"
#define XmNcomboBoxType					"comboBoxType"
#define XmCComboBoxType					"ComboBoxType"
#define XmRComboBoxType					"ComboBoxType"
#endif

/*----------------------------------------------------------------------*/
/*																		*/
/* Things that conflict elsewhere										*/
/*																		*/
/*----------------------------------------------------------------------*/
#ifndef XmNlist
#define XmNlist							"list"
#endif

#endif											/* end StringDefs.h		*/
