#include <sys/types.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char *progname;
int errors = 0;			/* number of errors */
int reverse = 0;		/* do reverse mapping */
int canon = 0;			/* look for canonical name */
char *input = NULL;		/* file to take input from */
int af = AF_UNSPEC;
int shortoutput = 0;

extern int errno;

int
lookup(host)
	char *host;
{
	struct addrinfo hints;
	struct addrinfo *res, *res0;
	struct sockaddr_in *sin;
	struct sockaddr_in6 *sin6;
	char buf[NI_MAXHOST];
	int error;

	memset(&hints, 0, sizeof(hints));
	hints.ai_flags = AI_CANONNAME;
	hints.ai_family = af;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_protocol = 0;
	error = getaddrinfo(host, NULL, &hints, &res0);
	if (error) {
		printf("%s\n", gai_strerror(error));
		return(1);
	}

	for (res = res0; res; res=res->ai_next) {
		if (canon && res->ai_canonname) {
			printf("Canonical name: %s\n", res->ai_canonname);
		}
		if (canon)
			printf("\t");
		if (res->ai_family == AF_INET) {
			sin = (struct sockaddr_in *)res->ai_addr;
			printf("%s\n", inet_ntop(res->ai_family,
						 &sin->sin_addr,
						 buf, sizeof(buf)));
		} else {
			sin6 = (struct sockaddr_in6 *)res->ai_addr;
			printf("%s\n", inet_ntop(res->ai_family,
						 &sin6->sin6_addr,
						 buf, sizeof(buf)));
		}
		if (reverse) {
			if (canon)
				printf("\t");
			printf("Reverse map:   ");
			getnameinfo(res->ai_addr, res->ai_addr->sa_len,
				    buf, sizeof(buf), NULL, 0, 0);
			printf("%s\n", buf);
		}
		if (shortoutput)
			break;
	}
	freeaddrinfo(res0);
	return(0);
}

void
usage()
{
	fprintf(stderr, "\
Usage: %s [-crs46] hostname ... / address ...\n\
       %s [-crs46] -f file\n",
		progname, progname);
}

int
main(argc, argv)
	int argc;
	char **argv;
{
	extern int optind;	/* from getopt */
	extern char *optarg;	/* argument to option, set by getopt(3) */
	int opt;		/* option character */
	char *cp, *strrchr();
	FILE *in;
	char buffer[2048];	/* hope this won't break */

	progname = argv[0];
	if ((cp = strrchr(progname, '/')))
		progname = cp + 1;
	while ((opt = getopt(argc, argv, "cf:rs46?")) != -1) {
		switch (opt) {
		case 's':	/* short */
			shortoutput = 1;
			break;
		case 'f':	/* read arguments from file or stdin */
			input = optarg;
			break;
		case 'r':	/* normal and reverse mapping */
			reverse = 1;
			break;
		case 'c':	/* canonical name */
			canon = 1;
			break;
		case '6':
			af = AF_INET6;
			break;
		case '4':
			af = AF_INET;
			break;
		case '?':	/* give usage message */
			errors++;
		}
	}
	if (errors ||
	    optind > argc ||
	    (input == NULL && optind >= argc)) {
		usage();
		exit(-1);
	}
	if (input) {
		if (strcmp(input, "-")) {
			if ((in = fopen(input, "r")) == NULL) {
				perror(input);
				exit(errno);
			}
		} else
			in = stdin;
		while (fscanf(in, "%s", buffer) != EOF)
			lookup(buffer);
	} else {
		while (optind < argc)
			errors += lookup(argv[optind++]);
	}
	return(errors);
}
