%{
#include <sys/types.h>
#include <sys/socket.h>

#include <net/route.h>

#include <netinet/in.h>
#include <netinet6/in6.h>

#include <netkey/keydb.h>

#include <errno.h>

#include "var.h"
#include "vmbuf.h"
#include "isakmp.h"
#include "isakmp_var.h"
#include "ipsec_doi.h"
#include "oakley.h"
#include "pluto.h"
#include "cfparse.h"
#include "admin.h"
#include "handler.h"
#include "misc.h"
#include "debug.h"

int default_life_type;
u_int32 default_life_duration;
int reparse = 0;

char *racoon_conf = YIPSD_CONF_FILE;
struct isakmp_conf cftab;
struct sockaddr anonremote;
static struct isakmp_conf *cfp = 0;
static int cf_ph;
static struct isakmp_cf_sa *cur_sap;
static struct isakmp_cf_p  *cur_pp;
static struct isakmp_cf_t  *cur_tp;

/* temporary buffer */
static struct sockaddr *pp_addr;
static u_int pp_prefix;
static u_int pp_port;

static int cf_setdata_v __P((int, caddr_t, int));
static int cf_setdata_l __P((int, u_int32_t));
void cf_post_config(void);

%}

%union {
	unsigned long num;
	vchar_t val;
}

%token EOS BOC EOC

%token LOGGING LOGLEV
%token PADDING MAX_LENGTH RANDOM_LENGTH CHECK_LENGTH EXCL_LASTONE
%token LISTEN X_ISAKMP X_ADMIN

	/* remote */
%token REMOTE ANONYMOUS IPV4_ADDRESS IPV6_ADDRESS PREFIX
%token TRY_TO_SEND SEND_TIMER
%token NEED PFS
%token PHASE EXCHANGE_MODE MAIN AGGRESSIVE QUICK
%token DOI X_IPSEC_DOI
%token SITUATION IDENTITY_ONLY
%token ID_TYPE ID_IPV4_ADDR ID_IPV6_ADDR PORT FQDN
%token PROPOSAL PROTOCOL ISAKMP ESP AH SPI
%token TRANSFORM OAKLEY DES_IV64 DES DES3 DES_IV32 MD5 SHA1
%token ENCRYPTION_ALGORITHM /* DES DES3 */
%token HASH_ALGORITHM /* MD5 SHA1 */
%token AUTHENTICATION_METHOD PRE_SHARED_KEY RSA DSS
%token DH_GROUP MODP768 MODP1024
%token NONCE_SIZE
%token LIFETIME SECOND KB
%token ENCRYPTION_MODE TUNNEL TRANSPORT
%token AUTHENTICATION_ALGORITHM NONE HMAC_MD5 HMAC_SHA1

	/* filter */
%token FILTER DEFAULT /* PREFIX */
%token ALLOW DENY

%token SWITCH DECSTRING HEXSTRING QUOTEDSTRING HOSTNAME

%%

statements:
		/* empty */
	|	statements statement
	;

statement:
		logging_statement
	|	padding_statement
	|	listen_statement
	|	remote_statement
	|	filter_statement
	;

	/* logging */
logging_statement:
		LOGGING log_specs EOS
	;

log_specs:
		/* empty */
	|	log_specs HEXSTRING
		{
			if (!f_debug)
				debug |= yylval.num;
		}
	|	log_specs LOGLEV
		{
			if (!f_debug)
				debug |= yylval.num;
		}
	;

	/* padding */
padding_statement:
	 	PADDING BOC padding_stmts EOC
	|	PADDING padding_stmt
	;

padding_stmts:
		/* empty */
	|	padding_stmts padding_stmt
	;

padding_stmt:
		MAX_LENGTH DECSTRING EOS
		{
			isakmp_pad_lword = yylval.num;
		}
	|	RANDOM_LENGTH SWITCH EOS
		{
			isakmp_randpad = yylval.num;
		}
	|	CHECK_LENGTH SWITCH EOS
		{
			isakmp_pad_check = yylval.num;
		}
	|	EXCL_LASTONE SWITCH EOS
		{
			isakmp_pad_exclone = yylval.num;
		}
	;

	/* listen */
listen_statement:
		LISTEN BOC listen_stmts EOC
	;

listen_stmts:
		/* empty */
	|	listen_stmts listen_stmt
	;

listen_stmt:
		X_ISAKMP ip_address
		{
			if (n_soI >= 10) {
				errno = ENOBUFS;
				perror("over number of listen port");
				return(-1);
			}

			myaddr[n_soI] = pp_addr;
		}
		listen_port EOS
	|	X_ADMIN DECSTRING EOS
		{
			portA = yylval.num;
		}
	;

listen_port:
		/* nothing */
		{
			_INPORTBYAF(myaddr[n_soI]) = htons(PORT_ISAKMP);
			n_soI++;
		}
	|	PORT DECSTRING
		{
			_INPORTBYAF(myaddr[n_soI]) = htons(yylval.num);
			n_soI++;
		}
	;

	/* remote */
remote_statement:
		REMOTE remote_spec BOC remote_stmts EOC
	;

remote_spec:
		ANONYMOUS
		{
			YIPSDP(PLOG("*** remote anonymous ***\n"));
			cfp = &cftab;
			cfp->remote = &anonremote;
			memset((caddr_t)&anonremote, 0, sizeof(struct sockaddr));
			cfp->remote->sa_len = sizeof(struct sockaddr_in);
			cfp->remote->sa_family = PF_INET;
			_INPORTBYAF(cfp->remote)= htons(PORT_ISAKMP);
		}
		remote_port_spec
	|	ip_address
		{
			struct isakmp_conf *new;

			YIPSDP(PLOG("*** remote %s ***\n", yylval.val.v));
			if ((new = CALLOC(sizeof(struct isakmp_conf),
			                  struct isakmp_conf *)) == 0) {
				perror("calloc");
				return(-1);
			}

			new->remote = pp_addr;

			if (cfp == 0)
				cftab.next = new;
			else
				cfp->next = new;

			cfp = new;
		}
		remote_port_spec
	;

ip_address:
		IPV4_ADDRESS
		{
			struct sockaddr_in *in;
			u_int sa_len = yylval.val.l;

			if ((in = (struct sockaddr_in *)malloc(sa_len)) == 0)
				return(-1);
			memset((caddr_t)in, 0, sa_len);

			in->sin_family = PF_INET;
			in->sin_len = sa_len;
			(void)inet_pton(PF_INET, yylval.val.v, &in->sin_addr);

			pp_addr = (struct sockaddr *)in;
		}
	|	IPV6_ADDRESS
		{
			struct sockaddr_in6 *in6;
			u_int sa_len = yylval.val.l;

			if ((in6 = (struct sockaddr_in6 *)malloc(sa_len)) == 0)
				return(-1);
			memset((caddr_t)in6, 0, sa_len);

			in6->sin6_family = PF_INET6;
			in6->sin6_len = sa_len;
			(void)inet_pton(PF_INET6, yylval.val.v,
					&in6->sin6_addr);

			pp_addr = (struct sockaddr *)in6;
		}
	;
		
remote_port_spec:
		/* nothing */
		{
			((struct sockaddr_in *)cfp->remote)->sin_port = htons(PORT_ISAKMP);
		}
	|
		PORT DECSTRING
		{
			((struct sockaddr_in *)cfp->remote)->sin_port = htons(yylval.num);
		}
	;

remote_stmts:
		/* empty */
	|	remote_stmts remote_stmt
	;

remote_stmt:
		PHASE DECSTRING
		{
			switch (yylval.num) {
			case 1:
				cf_ph = 0;
				break;
			case 2:
				cf_ph = 1;
				break;
			default:
				perror("invalid phase number");
				return(-1);
			}

			if ((cfp->ph[cf_ph] = CALLOC(sizeof(struct isakmp_cf_phase),
			                 struct isakmp_cf_phase *)) == 0) {
				perror("calloc");
				return(-1);
			}

			cur_sap = &cfp->ph[cf_ph]->sa;
			cur_pp = cur_sap->p;

			YIPSDP(PLOG("*** phase %d allocated ***\n", yylval.num));
		}
		BOC phase_stmts EOC
	|	TRY_TO_SEND DECSTRING EOS
		{
			isakmp_try = yylval.num;
		}
	|	SEND_TIMER DECSTRING EOS
		{
			isakmp_timer = yylval.num;
		}
	|	NEED PFS EOS
		{
			cfp->pfs = PFS_NEED;
		}
	;

phase_stmts:
		/* empty */
	|	phase_stmts phase_stmt
	;

phase_stmt:
		EXCHANGE_MODE exchange_t EOS
	|	DOI doi_t EOS
	|	SITUATION situation_t EOS
	|	id_statement EOS
	|	PROPOSAL DECSTRING
		{
			struct isakmp_cf_p **p;

			if (cur_sap->p == 0)
				p = &cur_sap->p;
			else
				p = &cur_pp->next;

			if ((*p = CALLOC(sizeof(struct isakmp_cf_p),
			                 struct isakmp_cf_p *)) == 0) {
				perror("calloc");
				return(-1);
			}

			(*p)->p_no = yylval.num;
			cur_pp = (*p);

			YIPSDP(PLOG("*** proposal %d allocated ***\n", yylval.num));
		}
		protocol_t BOC transform_stmts EOC
	;

exchange_t:
		MAIN
		{
			cfp->ph[cf_ph]->etype = ISAKMP_ETYPE_IDENT;
		}
	|	AGGRESSIVE
		{
			cfp->ph[cf_ph]->etype = ISAKMP_ETYPE_AGG;
		}
	|	QUICK
		{
			cfp->ph[cf_ph]->etype = ISAKMP_ETYPE_QUICK;
		}
	;

doi_t:
		X_IPSEC_DOI
		{
			cur_sap->doi = htonl(IPSEC_DOI);
		}
	;

situation_t:
		IDENTITY_ONLY
		{
			cur_sap->sit = htonl(IPSECDOI_SIT_IDENTITY_ONLY);
		}
	;

id_statement:
		ID_TYPE ID_IPV4_ADDR IPV4_ADDRESS PORT DECSTRING
		{
			int tlen = sizeof(struct ipsecdoi_id);
			int idlen = 4;
			caddr_t bp;
			struct in_addr in;

			if ((cfp->ph[cf_ph]->idb = vmalloc(tlen)) == 0) {
				perror("vmalloc");
				return(-1);
			}
			bp = cfp->ph[cf_ph]->idb->v;

			bp[0] = IPSECDOI_ID_IPV4_ADDR;
			if (yylval.num == 0) {
				bp[1] = 0;
				*(u_int16 *)&bp[2] = 0;
			} else {
				bp[1] = htons(17); /* udp */
				*(u_int16 *)&bp[2] = yylval.num;
			}

			inet_aton(yylval.val.v, &in);
			memcpy(bp + idlen, (caddr_t)&in.s_addr, idlen);
		}
	|	ID_TYPE FQDN HOSTNAME
		{
			int tlen = sizeof(struct ipsecdoi_id);
			int idlen = yylval.val.l;
			caddr_t bp;

			if ((cfp->ph[cf_ph]->idb = vmalloc(tlen)) == 0) {
				perror("vmalloc");
				return(-1);
			}
			bp = cfp->ph[cf_ph]->idb->v;

			bp[0] = IPSECDOI_ID_FQDN;
			bp[1] = 0; /* XXX */
			*(u_int16 *)&bp[2] = 0; /* XXX */
		}
	;

protocol_t:
		ISAKMP
		{
			cur_pp->prot_id = IPSECDOI_PROTO_ISAKMP;
		}
	|	ESP
		{
			cur_pp->prot_id = IPSECDOI_PROTO_IPSEC_ESP;
		}
	|	AH
		{
			cur_pp->prot_id = IPSECDOI_PROTO_IPSEC_AH;
		}
	;

transform_stmts:
		/* empty */
	|	transform_stmts transform_stmt
	;

transform_stmt:
		TRANSFORM DECSTRING
		{
			struct isakmp_cf_t **t;

			if (cur_pp->t == 0)
				t = &cur_pp->t;
			else
				t = &cur_tp->next;

			if ((*t = CALLOC(sizeof(struct isakmp_cf_t),
			                 struct isakmp_cf_t *)) == 0) {
				perror("calloc");
				return(-1);
			}

			(*t)->t_no = yylval.num;
			cur_tp = (*t);
			cur_pp->num_t++;

			YIPSDP(PLOG("*** transform %d allocated ***\n", yylval.num));
		}
		transform_t BOC transform_attributes EOC
	;

transform_t:
		OAKLEY
		{
			cur_tp->t_id = IPSECDOI_KEY_IKE;
		}
	|	DES_IV64
		{
			cur_tp->t_id = IPSECDOI_ESP_DES_IV64;
		}
	|	DES
		{
			cur_tp->t_id = IPSECDOI_ESP_DES;
		}
	|	DES3
		{
			cur_tp->t_id = IPSECDOI_ESP_3DES;
		}
	|	DES_IV32
		{
			cur_tp->t_id = IPSECDOI_ESP_DES_IV32;
		}
	|	MD5
		{
			cur_tp->t_id = IPSECDOI_AH_MD5;
		}
	|	SHA1
		{
			cur_tp->t_id = IPSECDOI_AH_SHA;
		}
	;

transform_attributes:
		/* empty */
	|	transform_attributes transform_attribute
	;

transform_attribute:
		LIFETIME HEXSTRING life_t EOS
		{
			caddr_t value = hexstr2val(yylval.val.v, yylval.val.l);

			cf_setdata_v((cf_ph == 1 ? IPSECDOI_ATTR_SA_LDUR
						 : OAKLEY_ATTR_SA_LDUR),
					value, yylval.val.l);
		}
	|	LIFETIME DECSTRING life_t EOS
		{
			cf_setdata_v((cf_ph == 1 ? IPSECDOI_ATTR_SA_LDUR
						 : OAKLEY_ATTR_SA_LDUR),
					(caddr_t)&yylval.num, sizeof(u_int32_t));
		}
	|	ENCRYPTION_ALGORITHM cipher_t EOS
	|	HASH_ALGORITHM hash_t EOS
	|	AUTHENTICATION_METHOD auth_method EOS
	|	DH_GROUP dh_group_t EOS
	|	NONCE_SIZE DECSTRING EOS
	|	ENCRYPTION_MODE enc_mode_t EOS
	|	AUTHENTICATION_ALGORITHM auth_t EOS
	;

life_t:
		SECOND
		{
			cf_setdata_l((cf_ph == 1 ? IPSECDOI_ATTR_SA_LTYPE
						 : OAKLEY_ATTR_SA_LTYPE),
					cf_ph == 1 ? IPSECDOI_ATTR_SA_LTYPE_SEC
						   : OAKLEY_ATTR_SA_LTYPE_SEC);
		}
	|	KB
		{
			PLOG("KB isn't supported.\n");
			return(-1);
		}
	;

cipher_t:
		DES
		{
			if (cf_ph == 1) {
				PLOG("DES isn't supported.\n");
				return(-1);
			}
			cf_setdata_l(OAKLEY_ATTR_ENC_ALG,
			              OAKLEY_ATTR_ENC_ALG_DES);
		}
	|	DES3
		{
			if (cf_ph == 1) {
				PLOG("3DES isn't supported.\n");
				return(-1);
			}
			cf_setdata_l(OAKLEY_ATTR_ENC_ALG,
			              OAKLEY_ATTR_ENC_ALG_3DES);
		}
	;

hash_t:
		MD5
		{
			if (cf_ph == 1) {
				PLOG("MD5 isn't supported.\n");
				return(-1);
			}
			cf_setdata_l(OAKLEY_ATTR_HASH_ALG,
			              OAKLEY_ATTR_HASH_ALG_MD5);
		}
	|	SHA1
		{
			if (cf_ph == 1) {
				PLOG("SHA1 isn't supported.\n");
				return(-1);
			}
			cf_setdata_l(OAKLEY_ATTR_HASH_ALG,
			              OAKLEY_ATTR_HASH_ALG_SHA);
		}
	;

auth_method:
		PRE_SHARED_KEY QUOTEDSTRING
		{
			if (cf_ph == 1) {
				PLOG("PRE_SHARED_KEY isn't supported.\n");
				return(-1);
			}
			cf_setdata_l(OAKLEY_ATTR_AUTH_METHOD,
			              OAKLEY_ATTR_AUTH_METHOD_PSKEY);

			if ((cfp->ph[cf_ph]->pskey
			    = vmalloc(yylval.val.l)) == 0) {
				perror("vmalloc");
				return(-1);
			}
			memcpy(cfp->ph[cf_ph]->pskey->v, yylval.val.v, yylval.val.l);
		}
	|	RSA
		{
			PLOG("RSA isn't supported.\n");
			return(-1);
		}
	|	DSS
		{
			PLOG("DSS isn't supported.\n");
			return(-1);
		}
	;

dh_group_t:
		MODP768
		{
			if (cf_ph == 1) {
				PLOG("MODP768 isn't supported.\n");
				return(-1);
			}
			cf_setdata_l(OAKLEY_ATTR_GRP_DESC,
			              OAKLEY_ATTR_GRP_DESC_MODP768);
		}
	|	MODP1024
		{
			if (cf_ph == 1) {
				PLOG("MODP1024 isn't supported.\n");
				return(-1);
			}
			cf_setdata_l(OAKLEY_ATTR_GRP_DESC,
			              OAKLEY_ATTR_GRP_DESC_MODP1024);
		}
	;

enc_mode_t:
		TUNNEL
		{
			if (cf_ph == 0) {
				PLOG("TUNNEL isn't supported.\n");
				return(-1);
			}
			cf_setdata_l(IPSECDOI_ATTR_ENC_MODE,
					IPSECDOI_ATTR_ENC_MODE_TUNNEL);
		}
	|	TRANSPORT
		{
			if (cf_ph == 0) {
				PLOG("TRANSPORT isn't supported.\n");
				return(-1);
			}
			cf_setdata_l(IPSECDOI_ATTR_ENC_MODE,
					IPSECDOI_ATTR_ENC_MODE_TRNS);
		}
	;

auth_t:
		NONE
		{
			if (cf_ph == 0) {
				PLOG("NONE isn't supported.\n");
				return(-1);
			}
		}
	|	HMAC_MD5
		{
			if (cf_ph == 0) {
				PLOG("HMAC_MD5 isn't supported.\n");
				return(-1);
			}
			cf_setdata_l(IPSECDOI_ATTR_AUTH,
			              IPSECDOI_ATTR_AUTH_HMAC_MD5);
		}
	|	HMAC_SHA1
		{
			if (cf_ph == 0) {
				PLOG("HMAC_SHA1 isn't supported.\n");
				return(-1);
			}
			cf_setdata_l(IPSECDOI_ATTR_AUTH,
			              IPSECDOI_ATTR_AUTH_HMAC_SHA1);
		}
	;

	/* filter */
filter_statement:
		FILTER BOC filter_stmts EOC
	;

filter_stmts:
		/* empty */
	|	filter_stmts filter_stmt
	;

filter_stmt:
		DEFAULT filter_rule EOS
	|	filter_rule BOC address_patterns EOC
	;

filter_rule:
		ALLOW
	|	DENY
	;

address_patterns:
		/* empty */
	|	address_patterns address_pattern
	;

address_pattern:
		IPV4_ADDRESS EOS
	|	IPV4_ADDRESS DECSTRING EOS
	|	IPV4_ADDRESS PREFIX DECSTRING EOS
	|	IPV4_ADDRESS PREFIX EOS
	;

%%

static int
cf_setdata_v(type, value, len)
	int type, len;
	caddr_t value;
{
	struct isakmp_data *data;
	int oldlen, tlen;

	if (cur_tp->data == 0)
		oldlen = 0;
	else
		oldlen = cur_tp->data->l;

	tlen = oldlen + sizeof(struct isakmp_data) + len;

	if (VREALLOC(cur_tp->data, tlen) == 0) {
		perror("vrealloc");
		return(-1);
	}

	data = (struct isakmp_data *)(cur_tp->data->v + oldlen);
	data->type = htons((u_int16)type | ISAKMP_GEN_TLV);
	data->lorv = htons((u_int16)len);
	memcpy((caddr_t)data + sizeof(struct isakmp_data), value, len);

	return(0);
}

static int
cf_setdata_l(type, lorv)
	int type;
	u_int32_t lorv;
{
	struct isakmp_data *data;
	int oldlen;

	if (cur_tp->data == 0)
		oldlen = 0;
	else
		oldlen = cur_tp->data->l;

	if (VREALLOC(cur_tp->data, oldlen + sizeof(struct isakmp_data)) == 0) {
		perror("vrealloc");
		return(-1);
	}

	data = (struct isakmp_data *)(cur_tp->data->v + oldlen);
	data->type = htons((u_int16)type | ISAKMP_GEN_TV);
	data->lorv = htons((u_int16)lorv);

	return(0);
}

void
cf_post_config()
{
	struct isakmp_conf *p;
	struct isakmp_cf_sa *cf_sa;
	struct isakmp_cf_p *cf_p;
	struct isakmp_cf_t *cf_t;
	u_int32 cf_sa_len, cf_p_len, cf_t_len;
	int i;

	for (p = &cftab; p; p = p->next) {
		for (i = 0; i < 2; i++) {
			cf_sa = &p->ph[i]->sa;
			cf_sa_len = 0;

			/* modifing proposal payload */
			for (cf_p = cf_sa->p; cf_p; cf_p = cf_p->next) {
				cf_p_len = 0;

				/* modifing transform payload */
				for (cf_t = cf_p->t; cf_t; cf_t = cf_t->next) {
					cf_t->len = sizeof(struct isakmp_pl_t)
					    + (cf_t->data ? cf_t->data->l : 0);
					cf_p_len += cf_t->len;
				}
				cf_p->len = sizeof(struct isakmp_pl_p)
					+ ((cf_p->prot_id == IPSECDOI_PROTO_ISAKMP) ? 0 : 4)
					+ cf_p_len;
				cf_sa_len += cf_p->len;
			}
			cf_sa->len = sizeof(struct isakmp_pl_sa) + cf_sa_len;
		}

	}

	return;
}

void
cf_init()
{
	memset((caddr_t)&cftab, 0, sizeof(cftab));
	return;
}

int
re_cfparse()
{
	reparse = 1;
	return(cfparse());
}

