/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    its contributors.
 * 4. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/* YIPS @(#)$Id: misc.c,v 1.1.1.1.2.5.2.3 1998/09/14 05:11:38 sakane Exp $ */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/socket.h>

#include <net/route.h>

#include <netinet/in.h>
#include <netinet6/in6.h>

#include <netkey/keydb.h>

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <time.h>

#include "var.h"
#include "misc.h"
#include "debug.h"

char _addr1_[BUFADDRSIZE], _addr2_[BUFADDRSIZE]; /* for message */

int plog0(const char *, ...);
int plog(const char *, const char *, ...);
int plog2(struct sockaddr *, const char *, const char *, ...);
char *timetostr(time_t);
int pdump(void *, int, int);
u_char *mem2str(u_char *, int);
char *strtob(char *, int, int *);
int saddrcmp __P((struct sockaddr *, struct sockaddr *));

int
plog0(const char *fmt, ...)
{
	va_list ap;

	YIPSDEBUG(DEBUG_DATE, printf("%s: ", timetostr(time(0))));

	va_start(ap, fmt);
	(void)vprintf(fmt, ap);
	va_end(ap);

	return(0);
}

int
plog(const char *func, const char *fmt, ...)
{
	va_list ap;

	YIPSDEBUG(DEBUG_DATE, printf("%s: ", timetostr(time(0))));
	YIPSDEBUG(DEBUG_DEBUG, printf("%s: ", func));

	va_start(ap, fmt);
	(void)vprintf(fmt, ap);
	va_end(ap);

	return(0);
}

int
plog2(struct sockaddr *addr, const char *func, const char *fmt, ...)
{
	va_list ap;

	YIPSDEBUG(DEBUG_DATE, printf("%s: ", timetostr(time(0))));
	YIPSDEBUG(DEBUG_DEBUG, printf("%s: ", func));
	YIPSDEBUG(DEBUG_ADDR,
		if (addr != 0) {
			INET_NTOP(addr, _addr1_);
		        printf("[%s] ", _addr1_);
		});

	va_start(ap, fmt);
	(void)vprintf(fmt, ap);
	va_end(ap);

	return(0);
}

char *
timetostr(t)
	time_t t;
{
	static char buf[20];
	struct tm *tm;

	tm = localtime(&t);
	sprintf(buf, "%02d-%02d-%02d %02d:%02d:%02d",
	    tm->tm_year, tm->tm_mon+1, tm->tm_mday,
	    tm->tm_hour, tm->tm_min, tm->tm_sec);

	return(buf);
}

int
pdump(buf0, len, mode)
	void *buf0;
	int len;
	int mode;
{
	caddr_t buf = (caddr_t)buf0;
	int i;

	for (i = 0; i < len; i++) {
		if (mode == YDUMP_BIN) {
			printf("%c", (unsigned char)buf[i]);
		} else { /* HEX */
			if (i != 0 && i % 32 == 0) printf("\n");
			if (i % 4 == 0) printf(" ");
			printf("%02x", (unsigned char)buf[i]);
		}
	}

	printf("\n");
}

/*
 * must free buffer allocated later.
 */
u_char *
mem2str(buf, mlen)
	u_char *buf;
	int mlen;
{
	u_char *new;
	u_int len = (mlen * 2) + mlen / 8 + 1;
	u_int i, j;

	if ((new = malloc(len)) == 0) return(0);

	for (i = 0, j = 0; i < mlen; i++) {
		sprintf(&new[j], "%02x", buf[i]);
		j += 2;
		if (i % 8 == 7)
			new[j++] = ' ';
	}
	buf[j] = '\0';

	return(new);
}

char *
strtob(str, base, len)
	char *str;
	int base, *len;
{
	int f, i;
	char *dst;
	u_char *rp;
	char *p, b[3], *bp;

	for (i = 0, p = str; *p != '\0'; p++) {
		if ( (*p >= '0' && *p <= '9')
		  || (*p >= 'a' && *p <= 'f')
		  || (*p >= 'A' && *p <= 'F')) {
			i++;
		} 
	}
	i = i/2;
	if (i == 0) return(0);

	if ((dst = malloc(i)) == 0) {
		return(0);
	}

	i = 0;
	f = 0;
	for (rp = dst, p = str; *p != '\0'; p++) {
		if ( (*p >= '0' && *p <= '9')
		  || (*p >= 'a' && *p <= 'f')
		  || (*p >= 'A' && *p <= 'F')) {
			if (!f) {
				b[0] = *p;
				f = 1;
			} else {
				b[1] = *p;
				b[2] = '\0';
				*rp++ = (char)strtol(b, &bp, base);
				i++;
				f = 0;
			}
		} 
	}

	*len = i;

	return(dst);
}

/*
 * compare tow buffer of sockaddr 
 * XXX: don't compare ports.
 * OUT:	0: equal.
 *	1: not equal.
 */
int
saddrcmp(addr1, addr2)
	struct sockaddr *addr1, *addr2;
{
	int sa_len;

	if (addr1 == 0 && addr2 == 0)
		return(0);

	if (addr1 == 0 || addr2 == 0)
		return(1);

	if (addr1->sa_len != addr2->sa_len
	 || addr1->sa_family != addr2->sa_family
	 /* || _INPORTBYAF(addr1) != _INPORTBYAF(addr2)*/ )
		return(1);

	if (memcmp(_SADDRBYAF(addr1), _SADDRBYAF(addr2),
		_ALENBYAF(addr2->sa_family) != 0))
		return(1);

	return(0);
}

/*
 * exchange hex string to value.
 */
caddr_t
hexstr2val(buf, len)
	caddr_t buf;
	u_int len;
{
	caddr_t res, bp;
	caddr_t p = buf;

	if ((res = malloc(len)) == 0)
		return(0);
	memset(res, 0, len);

	bp = res;
	while (*p) {
		*bp = (ATOX(p[0]) << 4) | ATOX(p[1]);
		p += 2, bp++;
	}

	return(res);
}

