/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/* YIPS @(#)$Id: admin.c,v 1.1.1.1.2.2.4.4 1998/10/05 08:34:40 itojun Exp $ */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>

#include <netinet/in.h>

#include <string.h>
#include <errno.h>

#include "var.h"
#include "vmbuf.h"
#include "misc.h"
#include "schedule.h"
#include "admin.h"
#include "debug.h"

int sockA;
u_int portA = PORT_ADMIN;

vchar_t *isakmp_dump_sa();

int
admin_handler()
{
	struct sockaddr from;
	struct admin_com com;
	int len, fromlen = sizeof(from);
	vchar_t *buf;

	while ((len = recvfrom(sockA, (char *)&com, sizeof(com),
	                    0, &from, &fromlen)) < 0) {
		if (errno == EINTR) continue;
		plog("admin_handler", "recvfrom (%s)\n", strerror(errno));
		return(-1);
	}

	if (len < sizeof(com)) {
		plog("admin_handler", "Invalid header length.\n");
		return(-1);
	}

	switch (com.cmd) {
	case ADMIN_SHOW_SCHED:
		if ((buf = sched_dump()) < 0) {
			return(-1);
		}
		break;

	case ADMIN_SHOW_SA:
		if ((buf = isakmp_dump_sa()) < 0) {
			return(-1);
		}
		break;

	default:
		plog("admin_handler", "illegal command\n");
		return(-1);
	}

	if ((len = sendto(sockA, buf->v, buf->l,
	                  0, &from, sizeof(from))) < 0) {
		plog("admin_handler", "sendto (%s)\n", strerror(errno));
		return(-1);
	}

	(void)free(buf);

	return(0);
}

int
admin_init()
{
	struct sockaddr_in name;

	if ((sockA = socket(PF_INET, SOCK_DGRAM, 0)) < 0) {
		plog("admin_init", "socket (%s)\n", strerror(errno));
		return(-1);
	}

	memset((char *)&name, 0, sizeof(name));
	name.sin_family = AF_INET;
	name.sin_port = htons((u_short)portA);
	name.sin_addr.s_addr = htonl(0x7f000001);
	name.sin_len = sizeof(name);

	if (bind(sockA, (struct sockaddr *)&name, sizeof(name)) < 0) {
		plog("admin_init", "bind (%s) port=%u\n",
			strerror(errno), portA);
		(void)close(sockA);
		return(-1);
	}

	YIPSDEBUG(DEBUG_INFO, plog("admin_init",
	    "using port of %d as to manage daemon.\n", portA));

	return(sockA);
}

int
admin_close()
{
	return(close(sockA));
}
