/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/* YIPS @(#)$Id: queue.h,v 1.1.1.1.2.1.4.1 1998/10/05 08:35:13 itojun Exp $ */

#if !defined(_QUEUE_H_)
#define _QUEUE_H_

struct pst_queue {
	struct pfkey_st *head;
	struct pfkey_st *tail;
	int len;
};

/* derived from netinet/if.h */
#define REQ_ENQUEUE(stq, pst) { \
	(pst)->next = 0; \
	if ((stq)->tail == 0) \
		(stq)->head = (pst); \
	else \
		(stq)->tail->next = (pst); \
	(stq)->tail = (pst); \
	(stq)->len++; \
}

#define REQ_PREPEND(stq, pst) { \
	(pst)->next = (stq)->head; \
	if ((stq)->tail == 0) \
		(stq)->tail = (pst); \
	(stq)->head = (pst); \
	(stq)->len++; \
}

#define REQ_DEQUEUE(stq, pst) { \
	(pst) = (stq)->head; \
	if (pst) { \
		if (((stq)->head = (pst)->next) == 0) \
			(stq)->tail = 0; \
		(pst)->next = 0; \
		(stq)->len--; \
	}\
}

#endif /* !defined(_QUEUE_H_) */
