/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/* YIPS @(#)$Id: crypto.h,v 1.1.1.1.2.2.4.3 1998/11/10 03:30:54 itojun Exp $ */

/* DES */
extern vchar_t *eay_des_encrypt(vchar_t *, caddr_t, caddr_t);
extern vchar_t *eay_des_decrypt(vchar_t *, caddr_t, caddr_t);
extern vchar_t *eay_3des_encrypt(vchar_t *, caddr_t, caddr_t, caddr_t, caddr_t);
extern vchar_t *eay_3des_decrypt(vchar_t *, caddr_t, caddr_t, caddr_t, caddr_t);
extern caddr_t eay_crypto_des_set_key(char *);

/* HMAC SHA1 */
extern vchar_t *eay_hmacsha1_one(vchar_t *, vchar_t *);
/* HMAC MD5 */
extern vchar_t *eay_hmacmd5_one(vchar_t *, vchar_t *);

/* SHA functions */
extern caddr_t eay_sha1_init(void);
extern void eay_sha1_update(caddr_t, vchar_t *);
extern vchar_t *eay_sha1_final(caddr_t);
extern vchar_t *eay_sha1_one(vchar_t *);

/* MD5 functions */
extern caddr_t eay_md5_init(void);
extern void eay_md5_update(caddr_t, vchar_t *);
extern vchar_t *eay_md5_final(caddr_t);
extern vchar_t *eay_md5_one(vchar_t *);

/* eay_set_random */
extern vchar_t *eay_set_random(u_int32_t);

/* DH */
extern int eay_dh_generate(vchar_t *, u_int32_t, u_int, vchar_t **, vchar_t **);
extern int eay_dh_compute(vchar_t *, u_int32_t, vchar_t *, vchar_t *, vchar_t *, vchar_t **);

/* misc */
extern int eay_revbnl(vchar_t *);
#include <bn.h>
extern int eay_v2bn(BIGNUM **, vchar_t *);
extern int eay_bn2v(vchar_t **, BIGNUM *);

#define DESBLOCKLEN 8
#define IPSEC_ENCRYPTKEYLEN 8
