/***************************************
  $Header: /home/amb/wwwoffle/RCS/misc.h 2.20 1999/09/11 14:00:03 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.5.
  Miscellaneous HTTP / HTML functions.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997,98,99 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/


#ifndef MISC_H
#define MISC_H    /*+ To stop multiple inclusions. +*/

#include <stdio.h>

/*+ A forward definition of the protocol type. +*/
typedef struct _Protocol *ProtocolP;

/*+ A URL data type. +*/
typedef struct _URL
{
 char *name;                    /*+ The canonical URL for the object. +*/

 char *link;                    /*+ A URL that will work for browsers (may point to name). +*/

 char *file;                    /*+ The URL that is used for generating the filename (may point to name). +*/

 char *hostp;                   /*+ A pointer to the host in the url. +*/
 char *pathp;                   /*+ A pointer to the path in the url. +*/

 char *proto;                   /*+ The protocol. +*/
 char *host;                    /*+ The host. +*/
 char *path;                    /*+ The path. +*/
 char *args;                    /*+ The arguments. +*/

 ProtocolP Protocol;            /*+ The protocol. +*/

 char *user;                    /*+ The username if supplied. +*/
 char *pass;                    /*+ The password if supplied. +*/

 char *dir;                     /*+ The directory name for the host to avoid using ':' on Win32 (may point to host). +*/

 char local;                    /*+ Set to true if the host is the localhost. +*/
}
URL;

/*+ A request or reply header type. +*/
typedef struct _Header
{
 int type;                      /*+ The type of header, request=1 or reply=0. +*/

 char *method;                  /*+ The request method used. +*/
 char *url;                     /*+ The requested URL. +*/
 int status;                    /*+ The reply status. +*/
 char *note;                    /*+ The reply string. +*/
 char *version;                 /*+ The HTTP version. +*/

 int n;                         /*+ The number of header entries. +*/
 char **key;                    /*+ The name of the header line. +*/
 char **val;                    /*+ The value of the header line. +*/

 int size;                      /*+ The size of the header as read from the file/socket. +*/
}
Header;

/*+ A request or reply body type. +*/
typedef struct _Body
{
 int length;                    /*+ The length of the content. +*/

 char *content;                 /*+ The content itself. +*/
}
Body;


/* in misc.c */

URL *SplitURL(char *url);
void AddURLPassword(URL *Url,char *user,char *pass);
void FreeURL(URL *Url);

char *LinkURL(URL *Url,char *link);

char *CanonicaliseName(char *name);

char *MakeHash(const char *args);

char *RFC822Date(long t,int utc);
long DateToTimeT(const char *date);

char *URLDecode(const char *str, int isform);
char *URLEncode(const char *str);
char *URLEncodePassword(const char *str);

char *Base64Decode(const char *str,int *l);
char *Base64Encode(const char *str,int l);

char* HTMLString(const char* c);

/* In io.c */

char *fgets_realloc(char *buffer,FILE *file);

void init_buffer(int fd);
int empty_buffer(int fd);

int read_data(int fd,char *buffer,int n);
int read_data_or_timeout(int fd,char *buffer,int n,int timeout);

char *read_line(int fd,char *line);
char *read_line_or_timeout(int fd,char *line,int timeout);

int write_data(int fd,const char *data,int n);

int write_string(int fd,const char *str);

#ifdef __GNUC__
int write_formatted(int fd,const char *fmt,...) __attribute__ ((format (printf,2,3)));
#else
int write_formatted(int fd,const char *fmt,...);
#endif

#endif /* MISC_H */
