/*
 * Copyright (C) 1998 Specialix International.
 *
 * Download code for SI/XIO/SX host cards.
 *
 * Redistribution and use in binary forms (this file is a binary form),
 * with or without modification, are permitted provided that the following
 * conditions are met:
 * 1. Redistributions in binary form must reproduce the above copyright
 *    notices, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 2. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Specialix International.
 * 3. The name of Specialix International may not be used to endorse or
 *    promote products derived from this software without specific prior
 *    written permission.
 * 4. No attempt is made to decompile, reverse engineer or otherwise
 *    discover the source code of the contents of this file. The source
 *    code is regarded as an unpublished trade secret held by Specialix
 *    International.
 *
 * THIS SOFTWARE IS PROVIDED BY ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHORS BE LIABLE.
 *
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: src/sys/dev/si/si3_t225.c,v 1.7 2003/08/24 18:03:43 obrien Exp $");

#include <sys/param.h>
#include <sys/bus.h>
#include <dev/si/sivar.h>

/* SI3_T225.C Version, Bootstrap and Download Code Arrays... */

/* SI3_T225 embedded version... 

	Copyright (c) Specialix International Ltd 1996-1999.
	JET.BIN Version 3.0.6 Beta I Created Jul 12 1999 @ 14:56:59

*/

unsigned char si3_t225_bootstrap[] =
{
	0x28,0x20,0x21,0x02,0x60,0x0a
};
int si3_t225_bsize = sizeof(si3_t225_bootstrap);

unsigned short si3_t225_bootloadaddr = 0x8000 - sizeof(si3_t225_bootstrap);

unsigned char si3_t225_download[] =
{
	0x00,0x00,0xBC,0x4B,0x00,0x00,0x00,0x00,	/* 0000: ..K.... */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 0008: ........ */
	0x24,0xF2,0x21,0xF8,0x24,0xF2,0x21,0xFC,	/* 0010: $!$! */
	0x22,0xF9,0x25,0xF7,0x46,0x23,0xFC,0xD4,	/* 0018: "%F# */
	0x40,0x31,0xD1,0x21,0x20,0x20,0x20,0x40,	/* 0020: @1!   @ */
	0x71,0xF4,0xD2,0x23,0x4B,0xD3,0x73,0x72,	/* 0028: q#Ksr */
	0x71,0x24,0xFA,0x74,0x23,0xFC,0x2F,0x2F,	/* 0030: q$t#.. */
	0x2F,0x4E,0xF6,0x20,0x20,0x22,0x04,0x4D,	/* 0038: .N  ".M */
	0x6F,0x6E,0x20,0x4A,0x75,0x6C,0x20,0x31,	/* 0040: on Jul 1 */
	0x32,0x20,0x31,0x34,0x3A,0x35,0x37,0x3A,	/* 0048: 2 14:57: */
	0x30,0x34,0x20,0x31,0x39,0x39,0x39,0x0A,	/* 0050: 04 1999. */
	0x00,0x6A,0x65,0x74,0x2E,0x65,0x70,0x72,	/* 0058: .jet.epr */
	0x00,0x20,0x20,0x22,0xB0,0x21,0x12,0xDD,	/* 0060: .  "!. */
	0x24,0xF2,0x21,0xF8,0x24,0xF2,0x21,0xFC,	/* 0068: $!$! */
	0x22,0xF9,0x25,0xF8,0x40,0xDE,0x4B,0xDF,	/* 0070: "%@K */
	0x24,0xF2,0x7E,0x24,0xF2,0xFA,0xE0,0x1E,	/* 0078: $~$. */
	0x4B,0x22,0xF1,0x40,0x25,0xF4,0x22,0x46,	/* 0080: K"@%"F */
	0x21,0xFB,0xD0,0x24,0xF2,0xD1,0x24,0x4B,	/* 0088: !$$K */
	0x21,0xFB,0xD2,0x72,0x84,0x21,0xD0,0x72,	/* 0090: !r!r */
	0x30,0x21,0x70,0xF2,0x21,0xD1,0x21,0x71,	/* 0098: 0!p!!q */
	0xD2,0x1B,0xD3,0x7D,0xD4,0x40,0xD5,0x1C,	/* 00A0: .}@. */
	0xD6,0x19,0xD7,0x1A,0xD8,0x21,0x70,0xF6,	/* 00A8: ..!p */
	0x60,0xBC,0x7D,0x27,0x88,0xDD,0x22,0x40,	/* 00B0: `}'"@ */
	0x21,0xFB,0xD0,0x44,0x24,0xF2,0xFA,0xD1,	/* 00B8: !D$ */
	0x24,0xF2,0xD2,0x7B,0x83,0x60,0x4C,0x24,	/* 00C0: ${`L$ */
	0xF6,0x21,0x71,0xF2,0xD3,0x7D,0xD4,0x24,	/* 00C8: !q}$ */
	0xF2,0xD5,0x7A,0x7D,0xF2,0xD6,0x79,0x73,	/* 00D0: z}ys */
	0xF2,0xF6,0x21,0xF5,0x20,0x6E,0x03,0x00,	/* 00D8: ! n.. */
	0x00,0x20,0x61,0xBF,0x40,0xD1,0x40,0xDF,	/* 00E0: . a@@ */
	0x21,0x76,0x67,0x88,0xDE,0x40,0x21,0x74,	/* 00E8: !vg@!t */
	0xE0,0x10,0x23,0x24,0x94,0x28,0x45,0x71,	/* 00F0: .#$(Eq */
	0xF4,0x22,0x2B,0xAD,0x71,0x46,0x24,0xF0,	/* 00F8: "+qF$ */
	0x21,0xD0,0x71,0x23,0x4F,0x24,0xF6,0xD5,	/* 0100: !q#O$ */
	0x21,0x70,0xC0,0x23,0xAF,0x7F,0xA7,0x7D,	/* 0108: !p#} */
	0xD6,0x76,0x75,0xF2,0xDD,0x02,0x7E,0xD6,	/* 0110: vu.~ */
	0x75,0xA6,0x75,0x76,0x10,0x22,0x2F,0x94,	/* 0118: uuv.". */
	0x40,0xD2,0x44,0xD3,0x41,0x72,0x24,0xF1,	/* 0120: @DAr$ */
	0x74,0x24,0xF6,0x21,0xA7,0x11,0x72,0x21,	/* 0128: t$!.r! */
	0x72,0xFA,0x41,0xFB,0x75,0xAE,0x76,0x27,	/* 0130: rAuv' */
	0x88,0xD0,0x70,0x21,0x75,0xF2,0x72,0x21,	/* 0138: p!ur! */
	0x72,0xFA,0x75,0xFB,0x12,0x22,0x45,0x22,	/* 0140: ru."E" */
	0xF1,0x22,0x26,0x07,0x21,0x70,0xC2,0x22,	/* 0148: "&.!p" */
	0x25,0xA7,0x75,0xC0,0xA7,0x41,0xDF,0x40,	/* 0150: %uA@ */
	0xD4,0x22,0x24,0x0C,0x75,0xC9,0xA7,0x41,	/* 0158: "$.uɧA */
	0xDF,0x40,0xD4,0x22,0x24,0x02,0x75,0xC7,	/* 0160: @"$.u */
	0xA7,0x41,0xDF,0x40,0xD4,0x22,0x23,0x08,	/* 0168: A@"#. */
	0x75,0xC1,0xA7,0x40,0xDF,0x40,0xD4,0x22,	/* 0170: u@@" */
	0x22,0x0E,0x75,0xC2,0x22,0xA7,0x41,0xD0,	/* 0178: ".u"A */
	0x70,0x21,0xAF,0x10,0x22,0x2B,0x92,0x71,	/* 0180: p!."+q */
	0x28,0xC2,0xA4,0x70,0x81,0xD0,0x08,0x71,	/* 0188: (¤p.q */
	0x28,0xC3,0xA4,0x70,0x60,0x8F,0xD0,0x70,	/* 0190: (äp`p */
	0xA7,0x11,0x7C,0x21,0x72,0xFA,0x41,0xFB,	/* 0198: .|!rA */
	0x62,0x0E,0x22,0x20,0x03,0x75,0xC4,0xAC,	/* 01A0: b." .uĬ */
	0x1D,0x10,0x22,0x23,0x9D,0x7D,0x21,0x77,	/* 01A8: .."#}!w */
	0xE0,0x21,0x2F,0x04,0x75,0xC6,0xA9,0x21,	/* 01B0: !..uƩ! */
	0x79,0x10,0x22,0x22,0x9D,0x21,0x2E,0x08,	/* 01B8: y.""!.. */
	0x75,0xCB,0xA9,0x21,0x78,0x10,0x22,0x22,	/* 01C0: u˩!x."" */
	0x91,0x21,0x2D,0x0C,0x75,0xC8,0xAC,0x1D,	/* 01C8: !-.uȬ. */
	0x10,0x22,0x21,0x96,0x7D,0x21,0x78,0xE0,	/* 01D0: ."!}!x */
	0x21,0x2C,0x0D,0x75,0xCA,0xAC,0x1D,0x10,	/* 01D8: !,.uʬ.. */
	0x22,0x20,0x97,0x7D,0x21,0x79,0xE0,0x21,	/* 01E0: " }!y! */
	0x2B,0x0E,0x75,0xCC,0x2C,0xAB,0x40,0xD6,	/* 01E8: +.u,@ */
	0x40,0xDA,0x40,0xD8,0x7E,0xD7,0x41,0xD6,	/* 01F0: @@~A */
	0x10,0x22,0x23,0x9D,0x23,0x4F,0x71,0xF9,	/* 01F8: ."##Oq */
	0xC0,0xD6,0x76,0x22,0xA8,0x41,0x7A,0xF2,	/* 0200: v"Az */
	0xDA,0x40,0xD2,0x44,0xD3,0x41,0x72,0x24,	/* 0208: @DAr$ */
	0xF1,0x74,0x24,0xF6,0xA7,0x11,0x72,0x21,	/* 0210: t$.r! */
	0x72,0xFA,0x41,0xFB,0x12,0x21,0x44,0x22,	/* 0218: rA.!D" */
	0xF1,0x10,0x22,0x21,0x94,0x23,0x4F,0x71,	/* 0220: ."!#Oq */
	0xF9,0xC0,0xD6,0x62,0x05,0x71,0x23,0x4F,	/* 0228: b.q#O */
	0x24,0xF6,0xD5,0x7A,0x40,0xF9,0x23,0xA3,	/* 0230: $z@# */
	0x75,0xA6,0x75,0x77,0x10,0x21,0x2D,0x94,	/* 0238: uuw.!- */
	0x40,0xD2,0x44,0xD3,0x41,0x72,0x24,0xF1,	/* 0240: @DAr$ */
	0x74,0x24,0xF6,0x21,0xA7,0x11,0x72,0x21,	/* 0248: t$!.r! */
	0x72,0xFA,0x41,0xFB,0x75,0xAE,0x77,0x27,	/* 0250: rAuw' */
	0x88,0xD0,0x70,0x21,0x75,0xF2,0x72,0x21,	/* 0258: p!ur! */
	0x72,0xFA,0x75,0xFB,0x12,0x22,0x45,0x22,	/* 0260: ru."E" */
	0xF1,0x24,0x0C,0x41,0xD6,0x76,0x21,0xAF,	/* 0268: $.Av! */
	0x75,0x77,0x10,0x21,0x29,0x9E,0x77,0x75,	/* 0270: uw.!)wu */
	0xF2,0xD7,0x78,0x75,0xF2,0xD8,0x10,0x21,	/* 0278: xu.! */
	0x2B,0x97,0x23,0x4F,0x71,0xF9,0xD6,0x71,	/* 0280: +#Oqq */
	0x23,0x4F,0x24,0xF6,0xD5,0x62,0x0E,0x40,	/* 0288: #O$b.@ */
	0xD2,0x44,0xD3,0x41,0x72,0x24,0xF1,0x74,	/* 0290: DAr$t */
	0x24,0xF6,0x21,0xA6,0x72,0x21,0x72,0xFA,	/* 0298: $!r!r */
	0x78,0xFE,0x78,0xAE,0x7E,0x27,0x88,0xD0,	/* 02A0: xx~' */
	0x70,0x21,0x75,0xF2,0x72,0x21,0x72,0xFA,	/* 02A8: p!ur!r */
	0x78,0xFB,0x12,0x22,0x44,0x22,0xF1,0x2E,	/* 02B0: x."D". */
	0x0F,0x75,0xCD,0x22,0xAC,0x40,0xD6,0x7A,	/* 02B8: .u"@z */
	0xD7,0x77,0x22,0xA1,0x10,0x21,0x27,0x91,	/* 02C0: w".!' */
	0x40,0xD2,0x44,0xD3,0x41,0x72,0x24,0xF1,	/* 02C8: @DAr$ */
	0x74,0x24,0xF6,0xA7,0x11,0x72,0x21,0x72,	/* 02D0: t$.r!r */
	0xFA,0x41,0xFB,0x12,0x21,0x44,0x22,0xF1,	/* 02D8: A.!D" */
	0x16,0x22,0x41,0x22,0xF1,0x40,0xDA,0x2B,	/* 02E0: ."A"@+ */
	0x0F,0x75,0xCE,0x2B,0xAB,0x40,0xD0,0x40,	/* 02E8: .u+@@ */
	0xD2,0x40,0xD3,0x41,0xD0,0x70,0x22,0xA7,	/* 02F0: @Ap" */
	0x73,0x72,0x46,0x23,0xF6,0xD2,0xD3,0x10,	/* 02F8: srF#. */
	0x21,0x23,0x96,0x71,0x23,0x4F,0x24,0xF6,	/* 0300: !#q#O$ */
	0x21,0xFD,0xD8,0xD9,0x40,0x72,0x78,0x23,	/* 0308: !@rx# */
	0xF7,0xD2,0x73,0x79,0x23,0xF7,0xD3,0x2C,	/* 0310: sy#, */
	0x40,0x71,0xF9,0xC0,0xD0,0x62,0x06,0x28,	/* 0318: @qb.( */
	0x20,0x40,0xD6,0x40,0xD7,0x73,0x77,0xF9,	/* 0320:  @@sw */
	0xC0,0xAB,0x73,0x77,0xF4,0xC0,0xA7,0x41,	/* 0328: swA */
	0x72,0x76,0x24,0xFF,0xF0,0xC0,0x27,0xA0,	/* 0330: rv$' */
	0x73,0x77,0xF9,0xC0,0xAB,0x73,0x77,0xF4,	/* 0338: swsw */
	0xC0,0xA7,0x41,0x72,0x76,0x24,0xFF,0xF0,	/* 0340: Arv$ */
	0xC0,0x25,0xAD,0x40,0x72,0x76,0x24,0xFF,	/* 0348: %@rv$ */
	0xD8,0x73,0x77,0x24,0xFF,0xD9,0x79,0x40,	/* 0350: sw$y@ */
	0xF9,0xC0,0xAC,0x79,0xC0,0xAA,0x41,0x78,	/* 0358: yAx */
	0x27,0x2F,0x2F,0x4F,0x24,0xFF,0xF0,0xC0,	/* 0360: '..O$ */
	0x21,0xAF,0x76,0xD0,0x2F,0x4F,0x70,0x24,	/* 0368: !v.Op$ */
	0xF2,0xF2,0x27,0x2F,0x2F,0x4F,0xF0,0x24,	/* 0370: '..O$ */
	0x94,0x40,0x76,0x27,0x2F,0x2F,0x4F,0x23,	/* 0378: @v'..O# */
	0xF7,0xD6,0x77,0x40,0x23,0xF7,0xD7,0x21,	/* 0380: w@#! */
	0x0D,0x76,0xDB,0x40,0x72,0x76,0x24,0xFF,	/* 0388: .v@rv$ */
	0xD8,0x73,0x77,0x24,0xFF,0xD9,0x78,0xD0,	/* 0390: sw$x */
	0x2F,0x4F,0x7B,0x24,0xF2,0xF2,0x70,0xF0,	/* 0398: .O{$p */
	0x21,0x9B,0x72,0xD6,0x73,0xD7,0x66,0x00,	/* 03A0: !rsf. */
	0x0A,0x75,0xDC,0x41,0x7C,0x24,0xF1,0x74,	/* 03A8: .uA|$t */
	0x24,0xFB,0xD4,0x10,0x28,0x93,0x62,0x23,	/* 03B0: $.(b# */
	0x0C,0x21,0xB1,0x22,0xF0,0x60,0xBE,0x41,	/* 03B8: .!"`A */
	0xD0,0x70,0xD1,0x75,0x73,0x23,0xFB,0x74,	/* 03C0: pus#t */
	0x71,0xF9,0x21,0xAB,0x70,0x74,0x71,0xF4,	/* 03C8: q!ptq */
	0xF9,0xA4,0x74,0x71,0xF4,0xD0,0x73,0x71,	/* 03D0: tqsq */
	0x73,0xF2,0x70,0x24,0xFA,0x71,0x70,0xF2,	/* 03D8: sp$qp */
	0xD1,0x70,0x70,0xF2,0xD0,0x61,0x00,0xB2,	/* 03E0: ppa. */
	0x22,0xF0,0x40,0xD3,0x40,0x72,0xE0,0x41,	/* 03E8: "@@rA */
	0xD3,0x73,0x21,0xAE,0x72,0x30,0x46,0x24,	/* 03F0: s!r0F$ */
	0xF1,0x72,0xE0,0x71,0x23,0x9B,0x71,0x31,	/* 03F8: rq#q1 */
	0x23,0x4F,0x24,0xF6,0x72,0x30,0xF2,0x72,	/* 0400: #O$r0r */
	0xE0,0x2C,0x40,0x71,0x31,0xF9,0xC0,0xD3,	/* 0408: ,@q1 */
	0x62,0x0F,0x22,0xF0,0x60,0xBE,0x74,0x27,	/* 0410: b."`t' */
	0x88,0xD0,0x73,0x21,0x34,0x30,0xD1,0x71,	/* 0418: s!40q */
	0x73,0x21,0x33,0xF2,0x70,0x73,0x21,0x35,	/* 0420: s!3ps!5 */
	0xF2,0x75,0x24,0xFA,0x73,0x21,0x34,0x30,	/* 0428: u$s!40 */
	0x75,0xF5,0x73,0x21,0x34,0xE0,0xB2,0x22,	/* 0430: us!4" */
	0xF0,0x71,0x21,0x34,0x30,0x71,0x21,0x33,	/* 0438: q!40q!3 */
	0xF2,0xF1,0x71,0xE1,0x71,0x21,0x34,0x30,	/* 0440: qq!40 */
	0x81,0x71,0x21,0x34,0xE0,0x22,0xF0,0x8A,	/* 0448: q!4" */
	0xF0,0x0C,0x89,0x3C,0x00,0x00,0x07,0x00,	/* 0450: .<.... */
	0x00,0x08,0x00,0x00,0x00,0x81,0x00,0x80,	/* 0458: ...... */
	0xFF,0x7F,0xFF,0x7F,0xA4,0x8D,0x60,0x8D,	/* 0460: ` */
	0x26,0x8D,0xFF,0x80,0x00,0x00,0x02,0x00,	/* 0468: &.... */
	0x01,0x00,0x6E,0x00,0x74,0x46,0x75,0x46,	/* 0470: ..n.tFuF */
	0x10,0x00,0x06,0x00,0x34,0x81,0x00,0x00,	/* 0478: ....4.. */
	0xFF,0x80,0x00,0x00,0xFF,0x80,0x00,0x00,	/* 0480: .... */
	0xFF,0x80,0xFF,0x80,0x0C,0x8D,0x03,0x00,	/* 0488: ... */
	0x3C,0x02,0x00,0x02,0x00,0x11,0x00,0x5C,	/* 0490: <......\ */
	0x8D,0x02,0x00,0x12,0x00,0x26,0x8D,0x02,	/* 0498: ....&. */
	0x00,0x13,0x00,0xFF,0x80,0x60,0xBC,0x21,	/* 04A0: ...`! */
	0xF5,0x00,0x00,0x00,0x00,0xCA,0x45,0x00,	/* 04A8: ....E. */
	0x00,0x14,0x39,0xC6,0x02,0x06,0x00,0xC6,	/* 04B0: ..9... */
	0x83,0x00,0x00,0xFF,0x80,0x3C,0x01,0xD0,	/* 04B8: ..<. */
	0x83,0x00,0x08,0x0C,0x85,0xFF,0x80,0x0C,	/* 04C0: .... */
	0x8D,0x04,0x00,0x04,0x00,0x20,0x02,0x00,	/* 04C8: .... .. */
	0x11,0x00,0xA0,0x8D,0x02,0x00,0x12,0x00,	/* 04D0: ...... */
	0x60,0x8D,0x02,0x00,0x13,0x00,0xFF,0x80,	/* 04D8: `.... */
	0x02,0x00,0x04,0x00,0x9C,0x8D,0x00,0x00,	/* 04E0: ...... */
	0x00,0x00,0x60,0xBC,0x21,0xF5,0x8A,0x34,	/* 04E8: ..`!4 */
	0x89,0x06,0x5C,0x8D,0x26,0x8D,0xFF,0x80,	/* 04F0: .\& */
	0x8A,0xCB,0x06,0x89,0x06,0xA0,0x8D,0x60,	/* 04F8: ..` */
	0x8D,0xFF,0x80,0x86,0xF0,0x0C,0x8B,0xC4,	/* 0500: . */
	0xD7,0x0A,0x85,0x60,0xBC,0x75,0xD3,0x73,	/* 0508: .`us */
	0x27,0x3B,0x2C,0x48,0xF4,0x75,0x2D,0x96,	/* 0510: ';,Hu- */
	0xA5,0x28,0x4E,0x75,0x2F,0x99,0x26,0x44,	/* 0518: (Nu.&D */
	0xD0,0x73,0x51,0x73,0x75,0x29,0x91,0xA5,	/* 0520: sQsu) */
	0x28,0x41,0x75,0x2E,0x9A,0x73,0x31,0xD0,	/* 0528: (Au.s1 */
	0x26,0x44,0xD1,0x40,0xD2,0x25,0x25,0x41,	/* 0530: &D@%%A */
	0x21,0xFB,0x73,0x30,0x75,0x23,0x29,0x2E,	/* 0538: !s0u#). */
	0x9E,0xA5,0x29,0x44,0x75,0x2D,0x90,0x2C,	/* 0540: )Du-, */
	0x48,0xD0,0x73,0x53,0x73,0x52,0x75,0x26,	/* 0548: HsSsRu& */
	0x97,0xA5,0x28,0x45,0x75,0x2C,0x90,0x73,	/* 0550: (Eu,s */
	0x33,0xD0,0x2C,0x48,0xD1,0x40,0xD2,0x25,	/* 0558: 3,H@% */
	0x2D,0x43,0x21,0xFB,0x73,0x32,0x75,0x23,	/* 0560: -C!s2u# */
	0x29,0x2C,0x94,0xA5,0x28,0x45,0x75,0x2A,	/* 0568: ),(Eu* */
	0x96,0x75,0x24,0x26,0x92,0x40,0xB4,0x22,	/* 0570: u$&@" */
	0xF0,0x03,0x00,0x02,0x00,0x01,0x00,0x00,	/* 0578: ....... */
	0x00,0xA4,0x00,0x71,0xD2,0x72,0x61,0x4F,	/* 0580: ..qraO */
	0x21,0xFB,0x44,0x23,0x2F,0x2A,0x92,0x22,	/* 0588: !D#.*" */
	0xF0,0x60,0xBE,0x73,0x58,0xD0,0x41,0x74,	/* 0590: `sXAt */
	0x70,0x60,0x3E,0x24,0xFF,0xF0,0x21,0xA3,	/* 0598: p`>$! */
	0x70,0x30,0x74,0x70,0x30,0xF2,0x70,0xE0,	/* 05A0: p0tp0p */
	0x70,0x60,0x3E,0x74,0xF4,0x70,0x60,0xEE,	/* 05A8: p`>tp` */
	0xB2,0x22,0xF0,0x24,0xF2,0xB2,0x22,0xF0,	/* 05B0: "$" */
	0x60,0xBF,0x75,0xC0,0xA4,0x24,0x20,0x40,	/* 05B8: `u$ @ */
	0xD5,0x21,0x40,0x72,0x63,0x9B,0x73,0xE0,	/* 05C0: !@rcs */
	0x75,0x72,0x63,0x95,0x74,0xE0,0x73,0x30,	/* 05C8: urcts0 */
	0x24,0xF2,0xF4,0x21,0xA5,0x74,0x30,0x24,	/* 05D0: $!t0$ */
	0xF2,0xF4,0xAF,0x75,0xD0,0x2A,0x45,0x74,	/* 05D8: u*Et */
	0x30,0x72,0x24,0x23,0x29,0x91,0x40,0xB1,	/* 05E0: 0r$#)@ */
	0x22,0xF0,0x41,0xB1,0x22,0xF0,0x60,0xBE,	/* 05E8: "A"` */
	0x73,0x58,0xD0,0x74,0x73,0x24,0x21,0x25,	/* 05F0: sXts$!% */
	0x90,0x25,0xFA,0x70,0xE0,0x24,0xF2,0xF4,	/* 05F8: %p$ */
	0x21,0xA0,0x74,0x70,0xE1,0x74,0x70,0x60,	/* 0600: !tptp` */
	0xEE,0x70,0x31,0x70,0x60,0xEF,0x40,0xB2,	/* 0608: p1p`@ */
	0x22,0xF0,0x28,0x4E,0xB2,0x22,0xF0,0x72,	/* 0610: "(N"r */
	0x21,0x20,0x40,0xE0,0x71,0x23,0x2A,0x27,	/* 0618: ! @q#*' */
	0x91,0x22,0xF0,0x00,0x00,0x86,0x00,0x71,	/* 0620: "...q */
	0x58,0xD2,0x72,0x60,0x44,0x21,0xFB,0x41,	/* 0628: Xr`D!A */
	0x23,0x2E,0x2F,0x9D,0x22,0xF0,0x20,0x43,	/* 0630: #.." C */
	0x6F,0x70,0x79,0x72,0x69,0x67,0x68,0x74,	/* 0638: opyright */
	0x20,0x28,0x63,0x29,0x20,0x53,0x70,0x65,	/* 0640:  (c) Spe */
	0x63,0x69,0x61,0x6C,0x69,0x78,0x20,0x49,	/* 0648: cialix I */
	0x6E,0x74,0x65,0x72,0x6E,0x61,0x74,0x69,	/* 0650: nternati */
	0x6F,0x6E,0x61,0x6C,0x20,0x4C,0x74,0x64,	/* 0658: onal Ltd */
	0x20,0x31,0x39,0x39,0x36,0x2D,0x31,0x39,	/* 0660:  1996-19 */
	0x39,0x39,0x2E,0x0D,0x0A,0x4A,0x45,0x54,	/* 0668: 99...JET */
	0x2E,0x42,0x49,0x4E,0x20,0x56,0x65,0x72,	/* 0670: .BIN Ver */
	0x73,0x69,0x6F,0x6E,0x20,0x33,0x2E,0x30,	/* 0678: sion 3.0 */
	0x2E,0x36,0x20,0x42,0x65,0x74,0x61,0x20,	/* 0680: .6 Beta  */
	0x49,0x20,0x43,0x72,0x65,0x61,0x74,0x65,	/* 0688: I Create */
	0x64,0x20,0x4A,0x75,0x6C,0x20,0x31,0x32,	/* 0690: d Jul 12 */
	0x20,0x31,0x39,0x39,0x39,0x20,0x40,0x20,	/* 0698:  1999 @  */
	0x31,0x34,0x3A,0x35,0x36,0x3A,0x35,0x39,	/* 06A0: 14:56:59 */
	0x00,0x06,0x03,0xCE,0x03,0x71,0x5A,0xD2,	/* 06A8: ....qZ */
	0x60,0x45,0x21,0xFB,0x72,0x42,0x24,0xFA,	/* 06B0: `E!rB$ */
	0x68,0x4B,0x21,0xFB,0x72,0xE1,0x22,0xF0,	/* 06B8: hK!r" */
	0x20,0x61,0xBD,0x21,0x74,0x5C,0xD9,0x40,	/* 06C0:  a!t\@ */
	0xDA,0x40,0xD8,0x28,0x40,0xD7,0x28,0x40,	/* 06C8: @(@(@ */
	0xD2,0x40,0xD6,0x76,0x47,0x24,0xF1,0x27,	/* 06D0: @vG$' */
	0x20,0x20,0x40,0xFA,0xD4,0x40,0xD3,0x40,	/* 06D8:   @@@ */
	0xD1,0x71,0x44,0x24,0xF1,0x76,0x47,0x24,	/* 06E0: qD$vG$ */
	0xF1,0x27,0x20,0x20,0x40,0xFA,0xFA,0x3D,	/* 06E8: '  @= */
	0x2A,0x40,0x24,0xF6,0x2A,0x40,0xF4,0xC0,	/* 06F0: *@$*@ */
	0xAE,0x71,0x41,0xF2,0xD1,0x41,0x44,0x71,	/* 06F8: qAADq */
	0x24,0xFF,0xF0,0xC0,0xAB,0x62,0x0A,0x41,	/* 0700: $b.A */
	0xD8,0x41,0xD3,0x7A,0x41,0xF4,0x27,0xAC,	/* 0708: AzA' */
	0x73,0xC0,0x21,0xA2,0x74,0x31,0x2F,0x4F,	/* 0710: s!t1.O */
	0x24,0xF6,0x2F,0x4F,0xF4,0x27,0xA9,0x41,	/* 0718: $.O'A */
	0xDA,0x78,0x41,0xF4,0x26,0xAC,0x76,0x21,	/* 0720: xA&v! */
	0xA8,0x72,0x51,0xF1,0x21,0x28,0x40,0xF8,	/* 0728: rQ!(@ */
	0x77,0x28,0x50,0xFA,0x25,0xFA,0xD7,0x67,	/* 0730: w(P%g */
	0x20,0x20,0x40,0x24,0xFB,0x72,0xE0,0x77,	/* 0738:   @$rw */
	0xD2,0x76,0x47,0x24,0xF1,0x27,0x20,0x20,	/* 0740: vG$'   */
	0x40,0xFA,0xD4,0x40,0x72,0xE0,0x76,0x72,	/* 0748: @@rvr */
	0x83,0x23,0xFB,0x74,0x72,0xE3,0x78,0x2B,	/* 0750: #trx+ */
	0xA6,0x48,0x72,0x51,0x23,0xFB,0x40,0x74,	/* 0758: HrQ#@t */
	0x27,0xEF,0x40,0x74,0x26,0xE8,0x40,0x74,	/* 0760: '@t&@t */
	0x21,0xE8,0x44,0x74,0x27,0xEF,0x40,0x74,	/* 0768: !Dt'@t */
	0x26,0xE8,0x25,0x45,0x74,0x21,0xE8,0x40,	/* 0770: &%Et!@ */
	0x74,0x27,0xEF,0x74,0x21,0x38,0x2F,0x4F,	/* 0778: t't!8.O */
	0x24,0xF6,0x25,0x45,0xF4,0x22,0xAF,0x22,	/* 0780: $%E"" */
	0x48,0xD1,0x22,0x0D,0x2F,0x4F,0x21,0xB3,	/* 0788: H"..O! */
	0x22,0xF0,0x2F,0x4F,0x21,0xB3,0x22,0xF0,	/* 0790: ".O!" */
	0x78,0xC0,0xA4,0x20,0x7A,0x21,0xA1,0x67,	/* 0798: x z!g */
	0x21,0x2E,0x40,0x70,0xE0,0x21,0x28,0x40,	/* 07A0: !.@p!(@ */
	0x70,0x21,0xE7,0x41,0x21,0xB3,0x22,0xF0,	/* 07A8: p!A!" */
	0x2F,0x4F,0x21,0xB3,0x22,0xF0,0x24,0x48,	/* 07B0: .O!"$H */
	0xD1,0x71,0x72,0x54,0x23,0xFB,0x74,0x27,	/* 07B8: qrT#t' */
	0x3F,0x2F,0x4F,0x24,0xF6,0x72,0x5F,0x23,	/* 07C0: ?.O$r_# */
	0xFB,0x74,0x24,0x30,0x2F,0x4F,0x24,0xF6,	/* 07C8: t$0.O$ */
	0x72,0x21,0x8F,0x23,0xFB,0x44,0x74,0x27,	/* 07D0: r!#Dt' */
	0xEF,0x74,0x24,0x30,0x2F,0x4F,0x24,0xF6,	/* 07D8: t$0.O$ */
	0x72,0x21,0x50,0x23,0xFB,0x72,0x54,0xF1,	/* 07E0: r!P#rT */
	0x24,0x48,0xF4,0xA8,0x79,0x32,0x41,0xF2,	/* 07E8: $Hy2A */
	0x79,0xE2,0x21,0x02,0x74,0x23,0x39,0x43,	/* 07F0: y!.t#9C */
	0x24,0xF6,0x81,0x72,0x22,0x81,0x23,0xFB,	/* 07F8: $r"# */
	0x79,0x33,0x41,0xF2,0x79,0xE3,0x74,0x21,	/* 0800: y3Ayt! */
	0x74,0x21,0x20,0x2B,0x9D,0x24,0x0E,0x74,	/* 0808: t! +$.t */
	0x24,0x30,0x2F,0x4F,0x24,0xF6,0xD1,0x79,	/* 0810: $0.O$y */
	0x31,0x41,0xF2,0x79,0xE1,0x71,0x41,0x24,	/* 0818: 1AyqA$ */
	0xF6,0x21,0xA8,0x71,0x2A,0x4B,0xF4,0xA5,	/* 0820: !q*K */
	0x20,0x44,0xD1,0x03,0x20,0x4A,0xD1,0x71,	/* 0828:  D. Jq */
	0x72,0x54,0x23,0xFB,0x44,0x72,0x51,0x23,	/* 0830: rT#DrQ# */
	0xFB,0x21,0x06,0x71,0x2A,0x4A,0xF4,0xA5,	/* 0838: !.q*J */
	0x20,0x48,0xD1,0x03,0x20,0x4B,0xD1,0x71,	/* 0840:  H. Kq */
	0x72,0x54,0x23,0xFB,0x48,0x72,0x51,0x23,	/* 0848: rT#HrQ# */
	0xFB,0x2F,0x4F,0x74,0x6F,0x40,0x24,0xF6,	/* 0850: .Oto@$ */
	0x28,0x40,0x24,0xFB,0xE0,0x77,0x28,0x50,	/* 0858: (@$w(P */
	0xD3,0x76,0xAF,0x73,0x23,0x50,0x67,0x20,	/* 0860: vs#Pg  */
	0x20,0x40,0x24,0xFB,0x70,0xE0,0x73,0x70,	/* 0868:  @$psp */
	0x21,0xE7,0x40,0xD1,0x41,0x72,0x51,0xF1,	/* 0870: !@ArQ */
	0x40,0x24,0xFF,0xF0,0xC0,0x21,0x23,0xA7,	/* 0878: @$!# */
	0x73,0x25,0xFA,0xD0,0x71,0x72,0x55,0xFA,	/* 0880: s%qrU */
	0xE0,0x72,0x54,0xF1,0x70,0x53,0x23,0xFB,	/* 0888: rTpS# */
	0x21,0x40,0x70,0x57,0x23,0xFB,0x41,0x70,	/* 0890: !@pW#Ap */
	0x21,0x8F,0x23,0xFB,0x71,0x70,0x87,0x23,	/* 0898: !#qp# */
	0xFB,0x2F,0x4F,0x70,0x21,0x51,0x23,0xFB,	/* 08A0: .Op!Q# */
	0x78,0x26,0xA0,0x21,0x2A,0x4F,0x21,0xFB,	/* 08A8: x&!*O! */
	0x1B,0x21,0x40,0x24,0xFA,0x74,0x70,0xE1,	/* 08B0: .!@$tp */
	0x41,0x71,0x43,0x24,0xFF,0xF0,0xA8,0x74,	/* 08B8: AqC$t */
	0x27,0x3F,0x4F,0x24,0xF6,0xD5,0x0B,0x74,	/* 08C0: '?O$.t */
	0x27,0x3F,0x2F,0x4F,0x24,0xF6,0x44,0x24,	/* 08C8: '?.O$D$ */
	0xF0,0xD5,0x75,0x2F,0x4F,0x24,0xF6,0x25,	/* 08D0: u.O$% */
	0xFA,0xD5,0x70,0x21,0x52,0x23,0xFB,0x75,	/* 08D8: p!R#u */
	0x1B,0xF2,0xF1,0x70,0x21,0x53,0x23,0xFB,	/* 08E0: .p!S# */
	0x75,0x47,0x24,0xF6,0x45,0xF4,0xC0,0xAD,	/* 08E8: uG$E */
	0x71,0xA5,0x71,0x44,0xF4,0xC0,0xA6,0x41,	/* 08F0: qqDA */
	0x70,0x22,0x87,0x23,0xFB,0x4B,0x70,0x21,	/* 08F8: p"#Kp! */
	0x5B,0x23,0xFB,0x4B,0x70,0x23,0x87,0x23,	/* 0900: [#Kp## */
	0xFB,0x27,0x0D,0x21,0x25,0x4F,0x21,0xFB,	/* 0908: '.!%O! */
	0x1B,0x48,0x24,0xFA,0x72,0x54,0xF1,0x48,	/* 0910: .H$rTH */
	0xF4,0x21,0xAD,0x72,0x54,0xF1,0x4B,0xF4,	/* 0918: !rTK */
	0x21,0xA6,0x71,0x1B,0xFA,0x30,0x48,0xF8,	/* 0920: !q.0H */
	0x74,0xFA,0x70,0xE1,0x41,0x71,0x1B,0xFA,	/* 0928: tpAq. */
	0x30,0x24,0xF1,0x70,0x8F,0x23,0xFB,0x0F,	/* 0930: 0$p#. */
	0x71,0x48,0xF8,0x74,0xFA,0x70,0xE1,0x41,	/* 0938: qHtpA */
	0x71,0x24,0xF1,0x70,0x8F,0x23,0xFB,0x71,	/* 0940: q$p#q */
	0x41,0x24,0xF6,0xC0,0xAE,0x72,0x54,0xF1,	/* 0948: A$rT */
	0x44,0xF4,0xA8,0x72,0x54,0xF1,0x4A,0xF4,	/* 0950: DrTJ */
	0xC0,0x22,0xAD,0x70,0x31,0xD5,0x2E,0x40,	/* 0958: "p1.@ */
	0x75,0x61,0x4F,0x24,0xF6,0xE4,0x40,0x75,	/* 0960: uaO$@u */
	0x61,0x4F,0x24,0xF6,0xE5,0x40,0x75,0x61,	/* 0968: aO$@ua */
	0x4F,0x24,0xF6,0xE6,0x42,0x75,0x61,0x4F,	/* 0970: O$BuaO */
	0x24,0xF6,0xE7,0x75,0x61,0x4F,0x24,0xF6,	/* 0978: $uaO$ */
	0x3E,0x40,0x75,0x61,0x4F,0x24,0xF6,0xED,	/* 0980: >@uaO$ */
	0x77,0x67,0x20,0x20,0x40,0x24,0xFB,0x70,	/* 0988: wg  @$p */
	0xE2,0x73,0x21,0x28,0x50,0x25,0xFA,0xD3,	/* 0990: s!(P% */
	0x23,0x50,0x67,0x20,0x20,0x40,0x24,0xFB,	/* 0998: #Pg  @$ */
	0x70,0xE0,0x73,0x70,0x21,0xE7,0x71,0x41,	/* 09A0: psp!qA */
	0xF2,0xD1,0x41,0x72,0x51,0xF1,0x71,0x24,	/* 09A8: ArQq$ */
	0xFF,0xF0,0xC0,0xA3,0x61,0x2C,0x09,0x76,	/* 09B0: a,.v */
	0x41,0xF2,0xD6,0x41,0x44,0x76,0x24,0xFF,	/* 09B8: AADv$ */
	0xF0,0xC0,0xA3,0x62,0x20,0x0D,0x67,0x21,	/* 09C0: b .g! */
	0x2E,0x40,0x70,0xE0,0x21,0x28,0x40,0x70,	/* 09C8: .@p!(@p */
	0x21,0xE7,0x41,0x21,0xB3,0x22,0xF0,0x60,	/* 09D0: !A!"` */
	0xBE,0x73,0x5C,0xD1,0x40,0x71,0xE0,0x27,	/* 09D8: s\@q' */
	0x20,0x20,0x40,0xD0,0x40,0x40,0x73,0x23,	/* 09E0:   @@@s# */
	0x2F,0x28,0x9C,0x21,0x20,0x40,0xD0,0x40,	/* 09E8: .(! @@ */
	0x27,0x2E,0x20,0x40,0x73,0x23,0x2F,0x27,	/* 09F0: '. @s#.' */
	0x9E,0x24,0x40,0x71,0x30,0x81,0x23,0xFB,	/* 09F8: $@q0# */
	0x71,0x60,0x3E,0x71,0x30,0xE2,0x26,0x44,	/* 0A00: q`>q0&D */
	0x71,0x30,0xE1,0x73,0x63,0x2B,0x92,0x71,	/* 0A08: q0sc+q */
	0x30,0x23,0xFB,0x71,0x30,0xF1,0x41,0xF4,	/* 0A10: 0#q0A */
	0xC0,0x23,0xA7,0x71,0x60,0x34,0x73,0x24,	/* 0A18: #q`4s$ */
	0x20,0x23,0x9E,0x28,0x40,0x54,0xF1,0x2F,	/* 0A20:  #(@T. */
	0x40,0x24,0xF6,0x21,0xAA,0x41,0x71,0x33,	/* 0A28: @$!Aq3 */
	0x40,0x24,0xFF,0xF0,0xC0,0xA4,0x71,0x32,	/* 0A30: @$q2 */
	0x21,0xA3,0x71,0x60,0x36,0x73,0x24,0x20,	/* 0A38: !q`6s$  */
	0x20,0x91,0x73,0x2F,0x21,0x9E,0x0B,0x73,	/* 0A40:  s.!.s */
	0x22,0x2D,0x2B,0x93,0x05,0x73,0x22,0x20,	/* 0A48: "-+.s"  */
	0x28,0x99,0x21,0x20,0x40,0x30,0x41,0xF2,	/* 0A50: (! @0A */
	0x21,0x20,0x40,0xE0,0x60,0x04,0x20,0xF0,	/* 0A58: ! @`.  */
	0xD0,0x00,0xF0,0x00,0xC0,0x00,0x00,0xF0,	/* 0A60: .... */
	0xD0,0xF0,0xF0,0x00,0xC0,0x00,0x00,0x00,	/* 0A68: .... */
	0x00,0x03,0x00,0x04,0x00,0x07,0x00,0x00,	/* 0A70: ........ */
	0x00,0xBE,0x1F,0x71,0x5C,0xD2,0x72,0x60,	/* 0A78: ..q\r` */
	0x44,0x21,0xFB,0x41,0x23,0x2A,0x2A,0x99,	/* 0A80: D!A#** */
	0x22,0xF0,0x20,0x60,0xBC,0x75,0x21,0x50,	/* 0A88: " `u!P */
	0xD1,0x71,0x60,0x3C,0x35,0x41,0xF2,0x71,	/* 0A90: q`<5Aq */
	0x60,0x3C,0xE5,0x71,0x60,0x3C,0x31,0x21,	/* 0A98: `<q`<1! */
	0xA1,0x40,0x23,0x2D,0x20,0x49,0x71,0x60,	/* 0AA0: @#- Iq` */
	0x3C,0x31,0x21,0xFA,0x75,0x23,0x25,0x2D,	/* 0AA8: <1!u#%- */
	0x97,0x07,0x29,0x4C,0x75,0x23,0x25,0x2C,	/* 0AB0: .)Lu#%, */
	0x9F,0x21,0x28,0x40,0x25,0xFA,0xD0,0x53,	/* 0AB8: !(@%S */
	0xF1,0x2F,0x40,0x24,0xF6,0xC0,0x24,0xA6,	/* 0AC0: .@$$ */
	0x70,0x57,0xF1,0xC0,0x23,0xA3,0x70,0x34,	/* 0AC8: pW#p4 */
	0x22,0x20,0x20,0x40,0x24,0xF6,0x22,0xA9,	/* 0AD0: "  @$" */
	0x70,0x5C,0xF1,0xD3,0x70,0x75,0x22,0x2A,	/* 0AD8: p\pu"* */
	0x27,0x93,0x2F,0x4F,0x24,0xF6,0x25,0xFA,	/* 0AE0: '.O$% */
	0xD2,0x73,0xF4,0x21,0xA4,0x72,0x70,0x5C,	/* 0AE8: s!rp\ */
	0x23,0xFB,0x70,0x21,0x89,0xF1,0x42,0x24,	/* 0AF0: #p!B$ */
	0xFB,0x70,0x21,0x89,0x23,0xFB,0x41,0x71,	/* 0AF8: p!#Aq */
	0xE1,0x70,0x21,0x37,0x25,0xFA,0xD0,0x21,	/* 0B00: p!7%! */
	0x28,0x40,0xF4,0xA2,0x64,0x0A,0x71,0x31,	/* 0B08: (@d.q1 */
	0x71,0x32,0x24,0xFB,0x68,0xAB,0x41,0x71,	/* 0B10: q2$hAq */
	0x60,0x3C,0xE4,0x71,0x31,0x27,0x2C,0x28,	/* 0B18: `<q1',( */
	0x40,0xE0,0x71,0x60,0x3C,0x56,0xF1,0x81,	/* 0B20: @q`<V */
	0x71,0x60,0x3C,0x56,0x23,0xFB,0x40,0x71,	/* 0B28: q`<V#@q */
	0xE1,0x40,0x71,0xE2,0x6A,0x0B,0x20,0x61,	/* 0B30: @qj. a */
	0xBF,0x21,0x72,0x21,0x53,0xD9,0x28,0x40,	/* 0B38: !r!S(@ */
	0xD3,0x40,0xD2,0x24,0xF2,0x58,0x21,0x72,	/* 0B40: @$X!r */
	0x23,0x23,0x26,0x9B,0x79,0x60,0x39,0x53,	/* 0B48: ##&y`9S */
	0xF1,0x81,0x79,0x60,0x39,0x53,0x23,0xFB,	/* 0B50: y`9S# */
	0x73,0xDA,0x72,0xDF,0x73,0x33,0xD1,0x72,	/* 0B58: srs3r */
	0x44,0xF8,0x71,0x27,0xEF,0x71,0x26,0x37,	/* 0B60: Dq'q&7 */
	0x2F,0x4F,0x24,0xF6,0x25,0xFA,0xD5,0x41,	/* 0B68: .O$%A */
	0x24,0xF6,0x25,0x2E,0xA2,0x71,0x26,0x3B,	/* 0B70: $%.q&; */
	0x2F,0x4F,0x24,0xF6,0xD4,0x71,0x26,0x38,	/* 0B78: .O$q&8 */
	0x2F,0x4F,0x24,0xF6,0xD7,0x74,0x43,0x24,	/* 0B80: .O$tC$ */
	0xF6,0x71,0x26,0xE8,0x71,0x24,0x33,0x47,	/* 0B88: q&q$3G */
	0x24,0xF6,0x25,0xFA,0xD6,0x43,0xF4,0x21,	/* 0B90: $%C! */
	0x24,0xA4,0x76,0x47,0xF4,0xC0,0x25,0x2B,	/* 0B98: $vG%+ */
	0xA6,0x40,0xDB,0x72,0x74,0x43,0x24,0xF6,	/* 0BA0: @rtC$ */
	0x28,0xF1,0x73,0x55,0xFA,0x30,0xD6,0x71,	/* 0BA8: (sU0q */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0xD8,0x71,	/* 0BB0: &2.O$q */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x21,0xD0,	/* 0BB8: &2.O$! */
	0x78,0x48,0x24,0xF6,0x21,0xA0,0x76,0x21,	/* 0BC0: xH$!v! */
	0x89,0xF1,0x41,0x24,0xFB,0x76,0x21,0x89,	/* 0BC8: A$v! */
	0x23,0xFB,0x41,0x79,0x60,0xEE,0x78,0x47,	/* 0BD0: #Ay`xG */
	0x24,0xF6,0xAD,0x76,0x21,0x50,0xF1,0x28,	/* 0BD8: $v!P( */
	0x40,0x24,0xF6,0xA4,0x41,0x79,0x60,0xEE,	/* 0BE0: @$Ay` */
	0x78,0x41,0x24,0xF6,0xA8,0x76,0x21,0x3E,	/* 0BE8: xA$v!> */
	0x41,0xF2,0x76,0x21,0xEE,0x78,0x42,0x24,	/* 0BF0: Av!xB$ */
	0xF6,0xAA,0x76,0x21,0x3C,0x41,0xF2,0x76,	/* 0BF8: v!<Av */
	0x21,0xEC,0x41,0xDB,0x78,0x44,0x24,0xF6,	/* 0C00: !AxD$ */
	0xAA,0x76,0x21,0x3D,0x41,0xF2,0x76,0x21,	/* 0C08: v!=Av! */
	0xED,0x41,0xDB,0x7B,0x25,0x23,0xA4,0x76,	/* 0C10: A{%#v */
	0x21,0x50,0xF1,0x24,0x40,0x24,0xF6,0xA6,	/* 0C18: !P$@$ */
	0x76,0x22,0x8B,0xF1,0x21,0xD0,0x76,0x55,	/* 0C20: v"!vU */
	0xF1,0xDB,0x76,0x8B,0xF1,0xDD,0x76,0x34,	/* 0C28: vv4 */
	0xDE,0x7D,0x7B,0x41,0xF2,0xF4,0x2F,0x4F,	/* 0C30: }{A.O */
	0x24,0xF6,0x25,0xFA,0xDC,0x25,0x20,0xA3,	/* 0C38: $%%  */
	0x21,0x70,0x7B,0x2F,0x4F,0x24,0xF6,0x76,	/* 0C40: !p{.O$v */
	0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,	/* 0C48: +P#{A */
	0x76,0x55,0x23,0xFB,0x7D,0x7B,0x41,0xF2,	/* 0C50: vU#}{A */
	0x41,0xF2,0xF4,0x2F,0x4F,0x24,0xF6,0xD0,	/* 0C58: A.O$ */
	0x7E,0x48,0x24,0xF6,0x24,0x2E,0xA4,0x41,	/* 0C60: ~H$$.A */
	0x7C,0x23,0x4F,0x24,0xFF,0xF0,0xC0,0x24,	/* 0C68: |#O$$ */
	0x2D,0xA9,0x41,0x24,0x40,0x70,0x24,0xFF,	/* 0C70: -A$@p$ */
	0xF0,0xC0,0x24,0x2C,0xAE,0x7E,0x21,0x40,	/* 0C78: $,~!@ */
	0x24,0xFB,0xDE,0x76,0x21,0x58,0xF1,0x48,	/* 0C80: $v!XH */
	0x24,0xF6,0x22,0xA1,0x7E,0x22,0x40,0x24,	/* 0C88: $"~"@$ */
	0xF6,0xC0,0x21,0xA9,0x71,0x35,0x2F,0x4F,	/* 0C90: !q5.O */
	0x24,0xF6,0xC0,0x21,0xA0,0x40,0xD0,0x21,	/* 0C98: $!@! */
	0x20,0x40,0x76,0x21,0x72,0x21,0x29,0x2B,	/* 0CA0:  @v!r!)+ */
	0x9A,0x22,0x42,0x71,0xE5,0x76,0x23,0x81,	/* 0CA8: "Bqv# */
	0xF1,0x28,0x40,0x24,0xF6,0xAD,0x40,0xD0,	/* 0CB0: (@$@ */
	0x21,0x20,0x20,0x40,0x76,0x21,0x72,0x21,	/* 0CB8: !  @v!r! */
	0x29,0x2A,0x90,0x76,0x21,0x58,0xF1,0x24,	/* 0CC0: )*v!X$ */
	0x40,0x24,0xF6,0x24,0x27,0xAD,0x40,0xD0,	/* 0CC8: @$$'@ */
	0x22,0x20,0x20,0x40,0x76,0x21,0x72,0x21,	/* 0CD0: "  @v!r! */
	0x29,0x28,0x98,0x24,0x26,0x0D,0x72,0x74,	/* 0CD8: )($&.rt */
	0x43,0x24,0xF6,0x28,0xF1,0x73,0x55,0xFA,	/* 0CE0: C$(sU */
	0x30,0x25,0xFA,0xD6,0x22,0x87,0xF1,0xC0,	/* 0CE8: 0%" */
	0xAC,0x76,0x21,0x54,0xF1,0x41,0x24,0xFB,	/* 0CF0: v!TA$ */
	0x76,0x21,0x54,0x23,0xFB,0x76,0x55,0xF1,	/* 0CF8: v!T#vU */
	0xDB,0x76,0x8B,0xF1,0xDD,0x76,0x34,0xDE,	/* 0D00: vv4 */
	0x7D,0x7B,0x41,0xF2,0xF4,0x2F,0x4F,0x24,	/* 0D08: }{A.O$ */
	0xF6,0xDC,0x41,0x79,0x60,0xEF,0x71,0x3E,	/* 0D10: Ay`q> */
	0x2F,0x4F,0x24,0xF6,0xD0,0x41,0x7C,0x70,	/* 0D18: .O$A|p */
	0x24,0xFF,0xF0,0xA3,0x7C,0xD8,0x02,0x70,	/* 0D20: $|.p */
	0xD8,0x78,0x23,0x25,0xAB,0x70,0x78,0xF4,	/* 0D28: x#%px */
	0xD0,0x78,0x41,0xF4,0xD8,0x41,0x22,0x40,	/* 0D30: xAA"@ */
	0x78,0x24,0xFF,0xF0,0xC0,0x23,0x24,0xA3,	/* 0D38: x$#$ */
	0x78,0x42,0x21,0xFB,0x28,0xF1,0xF6,0x23,	/* 0D40: xB!(# */
	0x22,0x03,0x20,0x23,0x20,0x09,0x20,0x22,	/* 0D48: ". # . " */
	0x2E,0x0F,0x20,0x22,0x2D,0x05,0x20,0x22,	/* 0D50: .. "-. " */
	0x2B,0x0B,0x20,0x22,0x2A,0x01,0x20,0x22,	/* 0D58: +. "*. " */
	0x28,0x07,0x20,0x22,0x26,0x0D,0x20,0x22,	/* 0D60: (. "&. " */
	0x25,0x03,0x20,0x22,0x23,0x09,0x20,0x22,	/* 0D68: %. "#. " */
	0x21,0x0F,0x20,0x22,0x20,0x05,0x20,0x21,	/* 0D70: !. " . ! */
	0x2E,0x0B,0x20,0x21,0x2D,0x01,0x20,0x21,	/* 0D78: .. !-. ! */
	0x2B,0x07,0x20,0x21,0x29,0x0D,0x20,0x21,	/* 0D80: +. !). ! */
	0x28,0x03,0x20,0x21,0x26,0x09,0x20,0x21,	/* 0D88: (. !&. ! */
	0x24,0x0F,0x20,0x21,0x23,0x05,0x20,0x21,	/* 0D90: $. !#. ! */
	0x21,0x0B,0x20,0x21,0x20,0x01,0x20,0x2E,	/* 0D98: !. ! . . */
	0x08,0x20,0x20,0x2C,0x0E,0x20,0x20,0x2B,	/* 0DA0: .  ,.  + */
	0x04,0x20,0x20,0x29,0x0A,0x20,0x20,0x28,	/* 0DA8: .  ).  ( */
	0x00,0x20,0x20,0x26,0x06,0x20,0x20,0x24,	/* 0DB0: .  &.  $ */
	0x0C,0x20,0x20,0x23,0x02,0x20,0x20,0x21,	/* 0DB8: .  #.  ! */
	0x08,0x20,0x20,0x71,0x26,0x32,0x2F,0x4F,	/* 0DC0: .  q&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,	/* 0DC8: ${.O$v */
	0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,	/* 0DD0: +P#{A */
	0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 0DD8: q&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,	/* 0DE0: {.O$v+P */
	0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,	/* 0DE8: #{Aq */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 0DF0: &2.O${. */
	0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,	/* 0DF8: O$v+P# */
	0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,	/* 0E00: {Aq&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 0E08: .O${.O$ */
	0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,	/* 0E10: v+P#{ */
	0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,	/* 0E18: Aq&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,	/* 0E20: ${.O$v */
	0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,	/* 0E28: +P#{A */
	0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 0E30: q&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,	/* 0E38: {.O$v+P */
	0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,	/* 0E40: #{Aq */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 0E48: &2.O${. */
	0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,	/* 0E50: O$v+P# */
	0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,	/* 0E58: {Aq&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 0E60: .O${.O$ */
	0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,	/* 0E68: v+P#{ */
	0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,	/* 0E70: Aq&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,	/* 0E78: ${.O$v */
	0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,	/* 0E80: +P#{A */
	0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 0E88: q&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,	/* 0E90: {.O$v+P */
	0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,	/* 0E98: #{Aq */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 0EA0: &2.O${. */
	0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,	/* 0EA8: O$v+P# */
	0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,	/* 0EB0: {Aq&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 0EB8: .O${.O$ */
	0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,	/* 0EC0: v+P#{ */
	0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,	/* 0EC8: Aq&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,	/* 0ED0: ${.O$v */
	0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,	/* 0ED8: +P#{A */
	0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 0EE0: q&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,	/* 0EE8: {.O$v+P */
	0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,	/* 0EF0: #{Aq */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 0EF8: &2.O${. */
	0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,	/* 0F00: O$v+P# */
	0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,	/* 0F08: {Aq&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 0F10: .O${.O$ */
	0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,	/* 0F18: v+P#{ */
	0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,	/* 0F20: Aq&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,	/* 0F28: ${.O$v */
	0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,	/* 0F30: +P#{A */
	0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 0F38: q&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,	/* 0F40: {.O$v+P */
	0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,	/* 0F48: #{Aq */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 0F50: &2.O${. */
	0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,	/* 0F58: O$v+P# */
	0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,	/* 0F60: {Aq&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 0F68: .O${.O$ */
	0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,	/* 0F70: v+P#{ */
	0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,	/* 0F78: Aq&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,	/* 0F80: ${.O$v */
	0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,	/* 0F88: +P#{A */
	0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 0F90: q&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,	/* 0F98: {.O$v+P */
	0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,	/* 0FA0: #{Aq */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 0FA8: &2.O${. */
	0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,	/* 0FB0: O$v+P# */
	0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,	/* 0FB8: {Aq&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 0FC0: .O${.O$ */
	0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,	/* 0FC8: v+P#{ */
	0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,	/* 0FD0: Aq&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,	/* 0FD8: ${.O$v */
	0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,	/* 0FE0: +P#{A */
	0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 0FE8: q&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,	/* 0FF0: {.O$v+P */
	0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,	/* 0FF8: #{Aq */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 1000: &2.O${. */
	0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,	/* 1008: O$v+P# */
	0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,	/* 1010: {Aq&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 1018: .O${.O$ */
	0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,	/* 1020: v+P#{ */
	0x41,0xF2,0xDB,0x71,0x26,0x32,0x2F,0x4F,	/* 1028: Aq&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x76,	/* 1030: ${.O$v */
	0x2B,0x50,0xF2,0x23,0xFB,0x7B,0x41,0xF2,	/* 1038: +P#{A */
	0xDB,0x71,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 1040: q&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x76,0x2B,0x50,	/* 1048: {.O$v+P */
	0xF2,0x23,0xFB,0x7B,0x41,0xF2,0xDB,0x71,	/* 1050: #{Aq */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 1058: &2.O${. */
	0x4F,0x24,0xF6,0x76,0x2B,0x50,0xF2,0x23,	/* 1060: O$v+P# */
	0xFB,0x7B,0x41,0xF2,0xDB,0x71,0x26,0x32,	/* 1068: {Aq&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 1070: .O${.O$ */
	0xF6,0x76,0x2B,0x50,0xF2,0x23,0xFB,0x7B,	/* 1078: v+P#{ */
	0x41,0xF2,0xDB,0x7B,0x76,0x55,0x23,0xFB,	/* 1080: A{vU# */
	0x70,0x76,0x21,0x3F,0xF2,0x76,0x21,0xEF,	/* 1088: pv!?v! */
	0x70,0x25,0xFA,0x60,0x4F,0xF2,0xD0,0xAE,	/* 1090: p%`OЮ */
	0x71,0x26,0x32,0x70,0x25,0xFA,0x60,0x4F,	/* 1098: q&2p%`O */
	0xF2,0xD0,0xA3,0x20,0x60,0x02,0x7D,0x7B,	/* 10A0: У `.}{ */
	0x41,0xF2,0xF4,0x2F,0x4F,0x24,0xF6,0xD0,	/* 10A8: A.O$ */
	0x7E,0x48,0x24,0xF6,0x27,0xAC,0x41,0x7C,	/* 10B0: ~H$'A| */
	0x23,0x4F,0x24,0xFF,0xF0,0xC0,0x27,0xA2,	/* 10B8: #O$' */
	0x41,0x24,0x40,0x70,0x24,0xFF,0xF0,0xC0,	/* 10C0: A$@p$ */
	0x26,0xA8,0x7E,0x21,0x40,0x24,0xFB,0xDE,	/* 10C8: &~!@$ */
	0x76,0x21,0x58,0xF1,0x48,0x24,0xF6,0x22,	/* 10D0: v!XH$" */
	0xAD,0x7E,0x22,0x40,0x24,0xF6,0xC0,0x22,	/* 10D8: ~"@$" */
	0xA5,0x71,0x35,0x2F,0x4F,0x24,0xF6,0xA8,	/* 10E0: q5.O$ */
	0x7E,0x2C,0x40,0x24,0xFB,0xDE,0x21,0x06,	/* 10E8: ~,@$!. */
	0x40,0xD0,0x21,0x20,0x40,0x76,0x21,0x72,	/* 10F0: @! @v!r */
	0x21,0x25,0x26,0x97,0x22,0x42,0x71,0xE5,	/* 10F8: !%&"Bq */
	0x7E,0x22,0x40,0x24,0xFB,0xDE,0x76,0x23,	/* 1100: ~"@$v# */
	0x81,0xF1,0x28,0x40,0x24,0xF6,0xAD,0x40,	/* 1108: (@$@ */
	0xD0,0x21,0x20,0x20,0x40,0x76,0x21,0x72,	/* 1110: !  @v!r */
	0x21,0x25,0x24,0x97,0x76,0x21,0x58,0xF1,	/* 1118: !%$v!X */
	0x24,0x40,0x24,0xF6,0xAD,0x40,0xD0,0x22,	/* 1120: $@$@" */
	0x20,0x20,0x40,0x76,0x21,0x72,0x21,0x25,	/* 1128:   @v!r!% */
	0x23,0x91,0x74,0x23,0x4F,0x24,0xF6,0x71,	/* 1130: #t#O$q */
	0x26,0xEB,0x77,0x71,0x26,0xE8,0x7E,0x76,	/* 1138: &wq&~v */
	0xE4,0x21,0x04,0x70,0x76,0x21,0x3F,0xF2,	/* 1140: !.pv!? */
	0x76,0x21,0xEF,0x74,0x23,0x4F,0x24,0xF6,	/* 1148: v!t#O$ */
	0x71,0x26,0xEB,0x77,0x71,0x26,0xE8,0x75,	/* 1150: q&wq&u */
	0x42,0x24,0xF6,0x24,0x21,0xAD,0x71,0x26,	/* 1158: B$$!q& */
	0x3A,0x2F,0x4F,0x24,0xF6,0xD4,0x71,0x26,	/* 1160: :.O$q& */
	0x38,0x2F,0x4F,0x24,0xF6,0xD7,0x74,0x43,	/* 1168: 8.O$tC */
	0x24,0xF6,0x71,0x26,0xE8,0x72,0x74,0x43,	/* 1170: $q&rtC */
	0x24,0xF6,0x28,0xF1,0x73,0x55,0xFA,0x30,	/* 1178: $(sU0 */
	0x25,0xFA,0xD0,0x22,0x87,0xF1,0xC0,0xAC,	/* 1180: %" */
	0x70,0x21,0x54,0xF1,0x42,0x24,0xFB,0x70,	/* 1188: p!TB$p */
	0x21,0x54,0x23,0xFB,0x70,0x23,0x85,0xF1,	/* 1190: !T#p# */
	0xAC,0x70,0x21,0x72,0x24,0x27,0x9F,0x70,	/* 1198: p!r$'p */
	0x34,0xD6,0x23,0x2C,0x07,0x70,0x8D,0xF1,	/* 11A0: 4#,.p */
	0xDE,0x70,0x56,0xF1,0xD8,0x70,0x34,0x25,	/* 11A8: pVp4% */
	0xFA,0xD6,0x21,0x20,0x40,0x24,0xF6,0x21,	/* 11B0: ! @$! */
	0xA8,0x76,0x61,0x2F,0x4F,0x24,0xF6,0x22,	/* 11B8: va.O$" */
	0x20,0x40,0x24,0xFB,0x60,0x4E,0x24,0xF6,	/* 11C0:  @$`N$ */
	0xD6,0x71,0x36,0x2F,0x49,0x24,0xF6,0x71,	/* 11C8: q6.I$q */
	0xE6,0x7E,0x78,0xF4,0x2F,0x4F,0x24,0xF6,	/* 11D0: ~x.O$ */
	0x25,0xFA,0xDC,0x23,0x28,0xA0,0x70,0x53,	/* 11D8: %#(pS */
	0xF1,0x24,0x48,0xF4,0xA3,0x4C,0xDB,0x03,	/* 11E0: $HL. */
	0x22,0x40,0xDB,0x7B,0xDD,0x41,0x7C,0x7D,	/* 11E8: "@{A|} */
	0x24,0xFF,0xF0,0xA3,0x7C,0xDB,0x02,0x7D,	/* 11F0: $|.} */
	0xDB,0x76,0x24,0x20,0x40,0x24,0xF6,0x25,	/* 11F8: v$ @$% */
	0xA3,0x7B,0x23,0x20,0xA1,0x70,0x23,0x50,	/* 1200: {# p#P */
	0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x4A,	/* 1208: x.O$J */
	0xF4,0x21,0xAD,0x70,0x23,0x50,0x78,0x2F,	/* 1210: !p#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,	/* 1218: O$q& */
	0x78,0x41,0xF2,0xD8,0x7B,0x60,0x4F,0xF2,	/* 1220: xA{`O */
	0xDB,0x7D,0x60,0x4F,0xF2,0xDD,0x21,0x0E,	/* 1228: }`O!. */
	0x41,0x42,0x7D,0x24,0xFF,0xF0,0x22,0x2C,	/* 1230: AB}$", */
	0xAD,0x4D,0x71,0x26,0xE3,0x4A,0x71,0x26,	/* 1238: Mq&Jq& */
	0xE3,0x78,0x41,0xF2,0xD8,0x7B,0x60,0x4F,	/* 1240: xA{`O */
	0xF2,0xDB,0x7D,0x42,0xF4,0xDD,0x7B,0x22,	/* 1248: }B{" */
	0x2B,0xA4,0x64,0x01,0x7B,0x41,0xF4,0xDB,	/* 1250: +d.{A */
	0x41,0x22,0x40,0x7B,0x24,0xFF,0xF0,0xC0,	/* 1258: A"@{$ */
	0x22,0x2A,0xA3,0x7B,0x42,0x21,0xFB,0x28,	/* 1260: "*{B!( */
	0xF1,0xF6,0x22,0x28,0x08,0x20,0x22,0x27,	/* 1268: "(. "' */
	0x03,0x20,0x22,0x25,0x0E,0x20,0x22,0x24,	/* 1270: . "%. "$ */
	0x09,0x20,0x22,0x23,0x04,0x20,0x22,0x21,	/* 1278: . "#. "! */
	0x0F,0x20,0x22,0x20,0x0A,0x20,0x21,0x2F,	/* 1280: . " . !. */
	0x05,0x20,0x21,0x2E,0x00,0x20,0x21,0x2C,	/* 1288: . !.. !, */
	0x0B,0x20,0x21,0x2B,0x06,0x20,0x21,0x2A,	/* 1290: . !+. !* */
	0x01,0x20,0x21,0x28,0x0C,0x20,0x21,0x27,	/* 1298: . !(. !' */
	0x07,0x20,0x21,0x26,0x02,0x20,0x21,0x24,	/* 12A0: . !&. !$ */
	0x0D,0x20,0x21,0x23,0x08,0x20,0x21,0x22,	/* 12A8: . !#. !" */
	0x03,0x20,0x21,0x20,0x0E,0x20,0x2F,0x0A,	/* 12B0: . ! . .. */
	0x20,0x20,0x2E,0x05,0x20,0x20,0x2D,0x00,	/* 12B8:   ..  -. */
	0x20,0x20,0x2B,0x0B,0x20,0x20,0x2A,0x06,	/* 12C0:   +.  *. */
	0x20,0x20,0x29,0x01,0x20,0x20,0x27,0x0C,	/* 12C8:   ).  '. */
	0x20,0x20,0x26,0x07,0x20,0x20,0x25,0x02,	/* 12D0:   &.  %. */
	0x20,0x20,0x23,0x0D,0x20,0x20,0x22,0x08,	/* 12D8:   #.  ". */
	0x20,0x20,0x21,0x03,0x20,0x20,0x70,0x23,	/* 12E0:   !.  p# */
	0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,	/* 12E8: Px.O$ */
	0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,	/* 12F0: q&xAp */
	0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,	/* 12F8: #Px.O$ */
	0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,	/* 1300: q&xA */
	0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,	/* 1308: p#Px.O$ */
	0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,	/* 1310: q&xA */
	0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,	/* 1318: p#Px.O$ */
	0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,	/* 1320: q&xA */
	0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,	/* 1328: p#Px.O */
	0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,	/* 1330: $q&x */
	0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,	/* 1338: Ap#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,	/* 1340: O$q& */
	0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,	/* 1348: xAp#Px */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,	/* 1350: .O$q& */
	0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,	/* 1358: xAp#P */
	0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,	/* 1360: x.O$q */
	0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,	/* 1368: &xAp# */
	0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,	/* 1370: Px.O$ */
	0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,	/* 1378: q&xAp */
	0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,	/* 1380: #Px.O$ */
	0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,	/* 1388: q&xA */
	0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,	/* 1390: p#Px.O$ */
	0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,	/* 1398: q&xA */
	0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,	/* 13A0: p#Px.O$ */
	0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,	/* 13A8: q&xA */
	0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,	/* 13B0: p#Px.O */
	0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,	/* 13B8: $q&x */
	0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,	/* 13C0: Ap#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,	/* 13C8: O$q& */
	0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,	/* 13D0: xAp#Px */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,	/* 13D8: .O$q& */
	0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,	/* 13E0: xAp#P */
	0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,	/* 13E8: x.O$q */
	0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,	/* 13F0: &xAp# */
	0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,	/* 13F8: Px.O$ */
	0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,	/* 1400: q&xAp */
	0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,	/* 1408: #Px.O$ */
	0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,	/* 1410: q&xA */
	0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,	/* 1418: p#Px.O$ */
	0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,	/* 1420: q&xA */
	0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,	/* 1428: p#Px.O$ */
	0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,	/* 1430: q&xA */
	0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,	/* 1438: p#Px.O */
	0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,	/* 1440: $q&x */
	0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,	/* 1448: Ap#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,	/* 1450: O$q& */
	0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,	/* 1458: xAp#Px */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,	/* 1460: .O$q& */
	0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,	/* 1468: xAp#P */
	0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,	/* 1470: x.O$q */
	0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,	/* 1478: &xAp# */
	0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,	/* 1480: Px.O$ */
	0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,0x70,	/* 1488: q&xAp */
	0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,0xF2,	/* 1490: #Px.O$ */
	0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,0xD8,	/* 1498: q&xA */
	0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,0xF6,	/* 14A0: p#Px.O$ */
	0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,0xF2,	/* 14A8: q&xA */
	0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,0x24,	/* 14B0: p#Px.O$ */
	0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,0x41,	/* 14B8: q&xA */
	0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,0x4F,	/* 14C0: p#Px.O */
	0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,0x78,	/* 14C8: $q&x */
	0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,0x2F,	/* 14D0: Ap#Px. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,0xE3,	/* 14D8: O$q& */
	0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,0x78,	/* 14E0: xAp#Px */
	0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,0x26,	/* 14E8: .O$q& */
	0xE3,0x78,0x41,0xF2,0xD8,0x70,0x23,0x50,	/* 14F0: xAp#P */
	0x78,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x71,	/* 14F8: x.O$q */
	0x26,0xE3,0x78,0x41,0xF2,0xD8,0x7E,0x78,	/* 1500: &xA~x */
	0x2F,0x4F,0x24,0xF6,0xF4,0x2F,0x4F,0x24,	/* 1508: .O$.O$ */
	0xF6,0xDB,0x78,0x2F,0x4F,0x24,0xF6,0x70,	/* 1510: x.O$p */
	0x56,0x23,0xFB,0x41,0x7C,0x2C,0x40,0x24,	/* 1518: V#A|,@$ */
	0xFF,0xF0,0xC0,0xA9,0x41,0x2C,0x41,0x7B,	/* 1520: A,A{ */
	0x24,0xFF,0xF0,0x22,0xA9,0x41,0x7C,0x24,	/* 1528: $"A|$ */
	0x40,0x24,0xFF,0xF0,0xC0,0x23,0xA5,0x41,	/* 1530: @$#A */
	0x24,0x41,0x7B,0x24,0xFF,0xF0,0xC0,0x22,	/* 1538: $A{$" */
	0xAB,0x76,0x28,0x20,0x40,0x24,0xF6,0x22,	/* 1540: v( @$" */
	0xA3,0x76,0x68,0x2F,0x4F,0x24,0xF6,0xD6,	/* 1548: vh.O$ */
	0x41,0x79,0x60,0xEE,0x21,0x06,0x76,0x28,	/* 1550: Ay`!.v( */
	0x20,0x40,0x24,0xFB,0xD6,0x0E,0x76,0x60,	/* 1558:  @$.v` */
	0x4E,0x24,0xF6,0xD6,0x71,0x36,0x2F,0x49,	/* 1560: N$q6.I */
	0x24,0xF6,0x71,0xE6,0x74,0x23,0x4F,0x24,	/* 1568: $qt#O$ */
	0xF6,0x71,0x26,0xEA,0x77,0x71,0x26,0xE8,	/* 1570: q&wq& */
	0x76,0x70,0xE4,0x75,0x44,0x24,0xF6,0x25,	/* 1578: vpuD$% */
	0xAE,0x71,0x26,0x39,0x2F,0x4F,0x24,0xF6,	/* 1580: q&9.O$ */
	0xD4,0x71,0x26,0x38,0x2F,0x4F,0x24,0xF6,	/* 1588: q&8.O$ */
	0xD7,0x74,0x43,0x24,0xF6,0x71,0x26,0xE8,	/* 1590: tC$q& */
	0x72,0x74,0x43,0x24,0xF6,0x28,0xF1,0x73,	/* 1598: rtC$(s */
	0x55,0xFA,0x30,0x25,0xFA,0xD0,0x21,0x72,	/* 15A0: U0%!r */
	0x21,0x24,0x9C,0x70,0x21,0x72,0x22,0x2B,	/* 15A8: !$p!r"+ */
	0x90,0x70,0x22,0x87,0xF1,0xC0,0xAC,0x70,	/* 15B0: p"p */
	0x21,0x54,0xF1,0x44,0x24,0xFB,0x70,0x21,	/* 15B8: !TD$p! */
	0x54,0x23,0xFB,0x41,0x79,0x60,0xEE,0x70,	/* 15C0: T#Ay`p */
	0x21,0x89,0xF1,0x42,0x24,0xFB,0x70,0x21,	/* 15C8: !B$p! */
	0x89,0x23,0xFB,0x74,0x23,0x4F,0x24,0xF6,	/* 15D0: #t#O$ */
	0x71,0x26,0xE9,0x77,0x71,0x26,0xE8,0x73,	/* 15D8: q&wq&s */
	0x89,0xF1,0x71,0x27,0xEF,0x72,0x41,0xF2,	/* 15E0: q'rA */
	0xD2,0x41,0x72,0x41,0x24,0xFF,0xF0,0xC0,	/* 15E8: ArA$ */
	0x21,0xA2,0x40,0xD2,0x73,0x30,0xAA,0x73,	/* 15F0: !@s0s */
	0x30,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0xD3,	/* 15F8: 0'..O$ */
	0x03,0x28,0x40,0xD3,0x75,0xC0,0xAE,0x73,	/* 1600: .(@us */
	0x7A,0xF4,0xC0,0x6A,0x24,0xAE,0x72,0x7F,	/* 1608: zj$r */
	0xF4,0xA3,0x6A,0x24,0x07,0x40,0x27,0x28,	/* 1610: j$.@'( */
	0x20,0x40,0xE0,0x6A,0x22,0x05,0x60,0xBE,	/* 1618:  @j".` */
	0x74,0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,	/* 1620: t2'..O$ */
	0x33,0xD1,0x74,0x23,0x85,0xF1,0xD0,0x43,	/* 1628: 3t#C */
	0x70,0xF9,0x21,0xA0,0x70,0x2B,0xAD,0x70,	/* 1630: p!p+p */
	0x41,0xF4,0x21,0xAA,0x70,0x42,0xF4,0xC0,	/* 1638: A!pB */
	0x2B,0xA2,0x23,0x0A,0x70,0x43,0xF4,0x2A,	/* 1640: +#.pC* */
	0xAB,0x70,0x44,0xF4,0x25,0xAA,0x70,0x45,	/* 1648: pD%pE */
	0xF4,0xC0,0x2A,0xA0,0x27,0x0A,0x71,0x35,	/* 1650: *'.q5 */
	0x2F,0x4F,0x24,0xF6,0xC0,0x29,0xA5,0x71,	/* 1658: .O$)q */
	0x39,0x22,0x40,0x24,0xF6,0xC0,0x21,0xA0,	/* 1660: 9"@$! */
	0x71,0x39,0x2F,0x4F,0x24,0xF6,0x22,0x40,	/* 1668: q9.O$"@ */
	0x24,0xFB,0x71,0xE9,0x24,0x4E,0x71,0xE5,	/* 1670: $q$Nq */
	0x42,0x74,0x23,0x85,0x23,0xFB,0x71,0x35,	/* 1678: Bt##q5 */
	0x2F,0x4F,0x24,0xF6,0xC0,0x26,0xAD,0x40,	/* 1680: .O$&@ */
	0x71,0x26,0xE3,0x28,0x41,0x71,0x26,0xE3,	/* 1688: q&(Aq& */
	0x74,0x34,0x60,0x4E,0x24,0xF6,0x74,0xE4,	/* 1690: t4`N$t */
	0x71,0x36,0x2F,0x49,0x24,0xF6,0x71,0xE6,	/* 1698: q6.I$q */
	0x43,0x74,0x23,0x85,0x23,0xFB,0x24,0x0C,	/* 16A0: Ct##$. */
	0x71,0x35,0x2F,0x4F,0x24,0xF6,0xC0,0x24,	/* 16A8: q5.O$$ */
	0xA3,0x71,0x39,0x22,0x40,0x24,0xF6,0xC0,	/* 16B0: q9"@$ */
	0x21,0xA0,0x71,0x39,0x2F,0x4F,0x24,0xF6,	/* 16B8: !q9.O$ */
	0x22,0x40,0x24,0xFB,0x71,0xE9,0x24,0x4E,	/* 16C0: "@$q$N */
	0x71,0xE5,0x45,0x74,0x23,0x85,0x23,0xFB,	/* 16C8: qEt## */
	0x71,0x35,0x2F,0x4F,0x24,0xF6,0xC0,0x21,	/* 16D0: q5.O$! */
	0xAB,0x40,0x71,0x26,0xE3,0x28,0x43,0x71,	/* 16D8: @q&(Cq */
	0x26,0xE3,0x71,0x39,0x2D,0x4F,0x24,0xF6,	/* 16E0: &q9-O$ */
	0x71,0xE9,0x24,0x4E,0x71,0xE5,0x40,0x74,	/* 16E8: q$Nq@t */
	0x23,0x85,0x23,0xFB,0xB2,0x22,0xF0,0x60,	/* 16F0: ##"` */
	0xBF,0x73,0x31,0x25,0xFA,0xD0,0x35,0x2F,	/* 16F8: s1%5. */
	0x4F,0x24,0xF6,0x21,0xA0,0x73,0x22,0x50,	/* 1700: O$!s"P */
	0xF1,0x21,0x40,0x24,0xFB,0x73,0x22,0x50,	/* 1708: !@$s"P */
	0x23,0xFB,0xB1,0x22,0xF0,0x73,0x22,0x50,	/* 1710: #"s"P */
	0xF1,0x61,0x4F,0x24,0xF6,0x73,0x22,0x50,	/* 1718: aO$s"P */
	0x23,0xFB,0x73,0x21,0x58,0xF1,0x21,0x40,	/* 1720: #s!X!@ */
	0x24,0xF6,0x24,0xA4,0x70,0x26,0x3C,0x21,	/* 1728: $$p&<! */
	0x40,0x24,0xF6,0x21,0xAD,0x73,0x22,0x50,	/* 1730: @$!s"P */
	0xF1,0x41,0x24,0xF6,0x24,0xAC,0x21,0x48,	/* 1738: A$$!H */
	0x70,0xE5,0x73,0x22,0x50,0xF1,0x60,0x4E,	/* 1740: ps"P`N */
	0x24,0xF6,0x73,0x22,0x50,0x23,0xFB,0xB1,	/* 1748: $s"P# */
	0x22,0xF0,0x73,0x22,0x50,0xF1,0x41,0x24,	/* 1750: "s"PA$ */
	0xF6,0x23,0xF2,0x22,0xAD,0x21,0x44,0x70,	/* 1758: #"!Dp */
	0xE5,0x73,0x22,0x50,0xF1,0x41,0x24,0xFB,	/* 1760: s"PA$ */
	0x73,0x22,0x50,0x23,0xFB,0xB1,0x22,0xF0,	/* 1768: s"P#" */
	0x73,0x22,0x50,0xF1,0x41,0x24,0xF6,0x21,	/* 1770: s"PA$! */
	0xA1,0x21,0x48,0x70,0xE5,0x73,0x22,0x50,	/* 1778: !Hps"P */
	0xF1,0x60,0x4E,0x24,0xF6,0x73,0x22,0x50,	/* 1780: `N$s"P */
	0x23,0xFB,0xB1,0x22,0xF0,0x60,0xBF,0x41,	/* 1788: #"`A */
	0x73,0x26,0xE6,0x43,0x73,0x26,0xE8,0x40,	/* 1790: s&Cs&@ */
	0x73,0x27,0xE4,0x42,0x73,0x26,0xE8,0x40,	/* 1798: s'Bs&@ */
	0x73,0x27,0xE4,0x41,0x73,0x26,0xE8,0x40,	/* 17A0: s'As&@ */
	0x73,0x27,0xE4,0x40,0x73,0x26,0xE8,0x40,	/* 17A8: s'@s&@ */
	0x73,0x27,0xE4,0x43,0x73,0x26,0xE8,0x40,	/* 17B0: s'Cs&@ */
	0x73,0x27,0xEA,0x42,0x73,0x26,0xE8,0x40,	/* 17B8: s'Bs&@ */
	0x73,0x27,0xEA,0x41,0x73,0x26,0xE8,0x40,	/* 17C0: s'As&@ */
	0x73,0x27,0xEA,0x40,0x73,0x26,0xE8,0x40,	/* 17C8: s'@s&@ */
	0x73,0x27,0xEA,0x44,0x73,0x26,0xE8,0x2A,	/* 17D0: s'Ds&* */
	0x48,0x73,0x26,0xED,0x40,0x73,0x26,0xEE,	/* 17D8: Hs&@s& */
	0x40,0x73,0x26,0xEF,0x41,0x73,0x26,0xEC,	/* 17E0: @s&As& */
	0x43,0x73,0x26,0xE6,0x43,0x73,0x26,0xE6,	/* 17E8: Cs&Cs& */
	0x43,0x73,0x26,0xE6,0x44,0x73,0x26,0xE8,	/* 17F0: Cs&Ds& */
	0x2A,0x48,0x73,0x26,0xED,0x22,0x40,0x73,	/* 17F8: *Hs&"@s */
	0x26,0xEE,0x40,0x73,0x26,0xEF,0x43,0x73,	/* 1800: &@s&Cs */
	0x26,0xE6,0x43,0x73,0x26,0xE6,0x43,0x73,	/* 1808: &Cs&Cs */
	0x26,0xE6,0x40,0x73,0x26,0xEC,0x40,0xD0,	/* 1810: &@s&@ */
	0x43,0x73,0x26,0xE6,0x70,0x81,0xD0,0x21,	/* 1818: Cs&p! */
	0x40,0x70,0xF9,0xA2,0x60,0x02,0x44,0x73,	/* 1820: @p`.Ds */
	0x26,0xE8,0x40,0x73,0x26,0xED,0x22,0x40,	/* 1828: &@s&"@ */
	0x73,0x26,0xEE,0x43,0x73,0x26,0xEF,0x41,	/* 1830: s&Cs&A */
	0x73,0x26,0xEC,0x43,0x73,0x26,0xE6,0x43,	/* 1838: s&Cs&C */
	0x73,0x26,0xE6,0x43,0x73,0x26,0xE6,0x43,	/* 1840: s&Cs&C */
	0x73,0x26,0xE6,0x40,0x73,0x26,0xEC,0x40,	/* 1848: s&@s&@ */
	0x73,0x26,0xE6,0x40,0x73,0x26,0xE8,0x26,	/* 1850: s&@s&& */
	0x44,0x72,0x22,0x28,0x22,0x9A,0xB1,0x22,	/* 1858: Dr"("" */
	0xF0,0x60,0xBE,0x40,0xD0,0x74,0x31,0xD1,	/* 1860: `@t1 */
	0x74,0x87,0xF1,0x74,0x32,0x27,0x2F,0x2F,	/* 1868: tt2'.. */
	0x4F,0x24,0xF6,0x89,0x23,0xFB,0x74,0x87,	/* 1870: O$#t */
	0xF1,0x71,0x27,0xEF,0x74,0x87,0xF1,0x43,	/* 1878: q'tC */
	0x24,0xF6,0x71,0x26,0xE8,0x71,0x26,0x3C,	/* 1880: $q&q&< */
	0x2F,0x4F,0x24,0xF6,0x74,0x21,0x53,0xF1,	/* 1888: .O$t!S */
	0x24,0xF6,0x25,0xFA,0xD1,0x28,0x40,0x24,	/* 1890: $%(@$ */
	0xF6,0xA5,0x70,0x44,0x24,0xFB,0xD0,0x71,	/* 1898: pD$q */
	0x22,0x40,0x24,0xF6,0xA6,0x70,0x24,0x40,	/* 18A0: "@$p$@ */
	0x24,0xFB,0xD0,0x71,0x21,0x40,0x24,0xF6,	/* 18A8: $q!@$ */
	0xA6,0x70,0x22,0x40,0x24,0xFB,0xD0,0x71,	/* 18B0: p"@$q */
	0x24,0x40,0x24,0xF6,0xA5,0x70,0x42,0x24,	/* 18B8: $@$pB$ */
	0xFB,0xD0,0x70,0x74,0x5C,0x23,0xFB,0xB2,	/* 18C0: pt\# */
	0x22,0xF0,0x60,0xBD,0x40,0xD1,0x71,0x44,	/* 18C8: "`@qD */
	0xF8,0x75,0x27,0xEF,0x71,0x74,0x61,0x2B,	/* 18D0: u'qta+ */
	0x94,0x71,0xAF,0x75,0x27,0x3F,0x2F,0x4F,	/* 18D8: qu'?.O */
	0x24,0xF6,0x44,0x24,0xF0,0xD2,0x75,0x27,	/* 18E0: $D$u' */
	0x3F,0x0A,0x75,0x27,0x3F,0x47,0x24,0xF6,	/* 18E8: ?.u'?G$ */
	0xD2,0x75,0x27,0x3F,0x72,0x45,0xF4,0xA5,	/* 18F0: u'?rE */
	0x40,0x75,0x24,0xEB,0x05,0x28,0x40,0x75,	/* 18F8: @u$.(@u */
	0x24,0xEB,0x2C,0x43,0x75,0x27,0xEE,0x40,	/* 1900: $,Cu'@ */
	0xD0,0x70,0x75,0x26,0xE8,0x70,0xC0,0x22,	/* 1908: pu&p" */
	0xA0,0x72,0x45,0xF4,0xC0,0x21,0xAA,0x40,	/* 1910: rE!@ */
	0x75,0x27,0xE6,0x24,0x44,0x75,0x24,0x30,	/* 1918: u'$Du$0 */
	0x2F,0x4F,0x24,0xF6,0xF9,0xA6,0x24,0x42,	/* 1920: .O$$B */
	0x75,0x27,0xE2,0x05,0x21,0x4F,0x75,0x27,	/* 1928: u'.!Ou' */
	0xE2,0x70,0x81,0xD0,0x44,0x70,0xF9,0xA3,	/* 1930: pDp */
	0x20,0x63,0x0E,0x40,0x75,0x21,0xE8,0x40,	/* 1938:  c.@u!@ */
	0x75,0x26,0xEC,0x40,0x75,0x26,0xED,0x75,	/* 1940: u&@u&u */
	0x35,0x2F,0x4F,0x24,0xF6,0xAA,0x75,0x35,	/* 1948: 5.O$u5 */
	0x2F,0x4F,0x24,0xF6,0xA3,0x20,0x60,0x06,	/* 1950: .O$ `. */
	0x71,0x81,0xD1,0x42,0x71,0xF9,0xA2,0x69,	/* 1958: qBqi */
	0x0D,0xB3,0x22,0xF0,0x60,0xBB,0x76,0x21,	/* 1960: ."`v! */
	0x53,0xD4,0x21,0x28,0x40,0xD1,0x41,0x27,	/* 1968: S!(@A' */
	0x28,0x28,0x40,0xE0,0x74,0x60,0x39,0x87,	/* 1970: ((@t`9 */
	0xF1,0x81,0x74,0x60,0x39,0x87,0x23,0xFB,	/* 1978: t`9# */
	0x41,0x27,0x28,0x28,0x40,0xE0,0x71,0x21,	/* 1980: A'((@q! */
	0x37,0xD1,0x40,0x27,0x28,0x28,0x40,0xE0,	/* 1988: 7@'((@ */
	0x71,0x57,0xF1,0x25,0xFA,0xD0,0xAC,0x70,	/* 1990: qW%Ьp */
	0x74,0xFA,0x30,0xD2,0x71,0x76,0x2F,0x2B,	/* 1998: t0qv.+ */
	0x9B,0x62,0xA1,0x71,0x31,0xD3,0x71,0x34,	/* 19A0: bq1q4 */
	0xD2,0x70,0xC0,0x24,0xA7,0x72,0x41,0x24,	/* 19A8: p$rA$ */
	0xF6,0xC0,0x24,0xA0,0x71,0x8D,0xF1,0x71,	/* 19B0: $qq */
	0x56,0xF1,0xF4,0x23,0xA7,0x72,0x41,0x24,	/* 19B8: V#rA$ */
	0xFB,0x25,0xFA,0xD2,0x71,0xE4,0x71,0x87,	/* 19C0: %qq */
	0xF1,0x71,0x32,0x27,0x2F,0x2F,0x4F,0x24,	/* 19C8: q2'..O$ */
	0xF6,0x89,0x23,0xFB,0x71,0x87,0xF1,0x73,	/* 19D0: #qs */
	0x27,0xEF,0x71,0x87,0xF1,0x43,0x24,0xF6,	/* 19D8: 'qC$ */
	0x73,0x26,0xE8,0x73,0x36,0x2F,0x4F,0x24,	/* 19E0: s&s6.O$ */
	0xF6,0x44,0x24,0xFB,0x73,0xE6,0x41,0x71,	/* 19E8: D$sAq */
	0x22,0x89,0x23,0xFB,0x72,0x21,0x40,0x24,	/* 19F0: "#r!@$ */
	0xF6,0x2D,0xA8,0x72,0x28,0x40,0x24,0xF6,	/* 19F8: -r(@$ */
	0x24,0xA0,0x71,0x87,0xF1,0x71,0x32,0x27,	/* 1A00: $qq2' */
	0x2F,0x2F,0x4F,0x24,0xF6,0x89,0x23,0xFB,	/* 1A08: ..O$# */
	0x71,0x87,0xF1,0x73,0x27,0xEF,0x71,0x87,	/* 1A10: qs'q */
	0xF1,0x43,0x24,0xF6,0x73,0x26,0xE8,0x73,	/* 1A18: C$s&s */
	0x35,0x2F,0x4F,0x24,0xF6,0xC0,0x2A,0xA8,	/* 1A20: 5.O$* */
	0x40,0xD0,0x21,0x20,0x40,0x71,0x76,0x2C,	/* 1A28: @! @qv, */
	0x23,0x91,0x22,0x42,0x73,0xE5,0x72,0x22,	/* 1A30: #"Bsr" */
	0x40,0x24,0xFB,0x6C,0x4F,0x24,0xF6,0xD2,	/* 1A38: @$lO$ */
	0x28,0x0E,0x41,0x71,0x55,0xF1,0x71,0x8B,	/* 1A40: (.AqUq */
	0xF1,0xFC,0x2F,0x4F,0x24,0xF6,0x24,0x40,	/* 1A48: .O$$@ */
	0xF0,0x24,0xFF,0xF0,0xC0,0x27,0xA9,0x71,	/* 1A50: $'q */
	0x87,0xF1,0x71,0x32,0x27,0x2F,0x2F,0x4F,	/* 1A58: q2'..O */
	0x24,0xF6,0x89,0x23,0xFB,0x71,0x87,0xF1,	/* 1A60: $#q */
	0x73,0x27,0xEF,0x71,0x87,0xF1,0x43,0x24,	/* 1A68: s'qC$ */
	0xF6,0x73,0x26,0xE8,0x73,0x35,0x2F,0x4F,	/* 1A70: s&s5.O */
	0x24,0xF6,0xC0,0x25,0xA3,0x71,0x21,0x58,	/* 1A78: $%q!X */
	0xF1,0x48,0x24,0xF6,0x21,0xA6,0x21,0x20,	/* 1A80: H$!!  */
	0x40,0xD0,0x21,0x20,0x40,0x71,0x76,0x2B,	/* 1A88: @! @qv+ */
	0x2D,0x91,0x22,0x41,0x73,0xE5,0x72,0x66,	/* 1A90: -"Asrf */
	0x4F,0x24,0xF6,0xD2,0x71,0x23,0x81,0xF1,	/* 1A98: O$q# */
	0x28,0x40,0x24,0xF6,0xAE,0x21,0x20,0x20,	/* 1AA0: (@$!   */
	0x40,0xD0,0x21,0x20,0x20,0x40,0x71,0x76,	/* 1AA8: @!  @qv */
	0x2B,0x2B,0x90,0x71,0x21,0x58,0xF1,0x24,	/* 1AB0: ++q!X$ */
	0x40,0x24,0xF6,0xAE,0x22,0x20,0x20,0x40,	/* 1AB8: @$"  @ */
	0xD0,0x22,0x20,0x20,0x40,0x71,0x76,0x2B,	/* 1AC0: "  @qv+ */
	0x29,0x99,0x72,0x61,0x4F,0x24,0xF6,0xD2,	/* 1AC8: )raO$ */
	0x72,0x71,0xE4,0x71,0x22,0x50,0xF1,0x21,	/* 1AD0: rqq"P! */
	0x40,0x24,0xF6,0x22,0xA2,0x71,0x87,0xF1,	/* 1AD8: @$"q */
	0x71,0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,	/* 1AE0: q2'..O$ */
	0x89,0x23,0xFB,0x71,0x87,0xF1,0x73,0x27,	/* 1AE8: #qs' */
	0xEF,0x71,0x87,0xF1,0x43,0x24,0xF6,0x73,	/* 1AF0: qC$s */
	0x26,0xE8,0x71,0x76,0x64,0x2F,0x98,0x61,	/* 1AF8: &qvd.a */
	0x27,0x02,0x60,0xBB,0x77,0x31,0xD1,0x77,	/* 1B00: '.`w1w */
	0x34,0xD2,0x77,0x87,0xF1,0x77,0x32,0x27,	/* 1B08: 4ww2' */
	0x2F,0x2F,0x4F,0x24,0xF6,0x89,0x23,0xFB,	/* 1B10: ..O$# */
	0x77,0x87,0xF1,0x71,0x27,0xEF,0x77,0x87,	/* 1B18: wq'w */
	0xF1,0x43,0x24,0xF6,0x71,0x26,0xE8,0x77,	/* 1B20: C$q&w */
	0x21,0x8F,0xF1,0x23,0xA4,0x77,0x32,0x27,	/* 1B28: !#w2' */
	0x2F,0x2F,0x4F,0x24,0xF6,0xD0,0x77,0x87,	/* 1B30: ..O$w */
	0xF1,0x43,0xF9,0x21,0xA0,0x70,0x21,0x8D,	/* 1B38: C!p! */
	0xF1,0x81,0x70,0x21,0x8D,0x23,0xFB,0x22,	/* 1B40: p!#" */
	0x44,0x71,0x27,0xEF,0x0C,0x70,0x5E,0xF1,	/* 1B48: Dq'.p^ */
	0x81,0x70,0x5E,0x23,0xFB,0x48,0x71,0x27,	/* 1B50: p^#Hq' */
	0xEF,0x40,0x77,0x21,0x8F,0x23,0xFB,0x24,	/* 1B58: @w!#$ */
	0x09,0x77,0x21,0x58,0xF1,0x42,0x24,0xF6,	/* 1B60: .w!XB$ */
	0xA8,0x71,0x3B,0x44,0x24,0xF6,0xC0,0x23,	/* 1B68: q;D$# */
	0xA2,0x77,0x21,0x59,0xF1,0x21,0x40,0x24,	/* 1B70: w!Y!@$ */
	0xF6,0xA9,0x71,0x26,0x3C,0x24,0x40,0x24,	/* 1B78: q&<$@$ */
	0xF6,0x22,0xA0,0x77,0x21,0x58,0xF1,0x21,	/* 1B80: "w!X! */
	0x40,0x24,0xF6,0xA8,0x71,0x26,0x3C,0x21,	/* 1B88: @$q&<! */
	0x40,0x24,0xF6,0xAF,0x72,0x22,0x20,0x40,	/* 1B90: @$r" @ */
	0x24,0xF6,0xC0,0xA7,0x20,0x77,0x22,0x85,	/* 1B98: $ w" */
	0xF1,0x21,0xA3,0x72,0x62,0x2F,0x4F,0x24,	/* 1BA0: !rb.O$ */
	0xF6,0xD2,0x71,0x35,0x2F,0x4F,0x24,0xF6,	/* 1BA8: q5.O$ */
	0x22,0xA3,0x40,0xB5,0x22,0xF0,0x72,0x21,	/* 1BB0: "@"r! */
	0x20,0x40,0x24,0xFB,0x41,0x24,0xFB,0x77,	/* 1BB8:  @$A$w */
	0xE4,0x77,0x22,0x87,0xF1,0xA7,0x20,0x28,	/* 1BC0: w" ( */
	0x44,0x71,0xE6,0x05,0x20,0x29,0x42,0x71,	/* 1BC8: Dq. )Bq */
	0xE6,0x41,0xB5,0x22,0xF0,0x77,0x22,0x85,	/* 1BD0: A"w" */
	0xF1,0x21,0xA6,0x77,0x22,0x87,0xF1,0x24,	/* 1BD8: !w"$ */
	0x27,0xA8,0x40,0x71,0x21,0xE5,0x40,0x71,	/* 1BE0: '@q!@q */
	0x21,0xE6,0x21,0x48,0x71,0xE5,0x24,0x26,	/* 1BE8: !!Hq$& */
	0x0D,0x41,0x77,0x22,0x85,0x23,0xFB,0x77,	/* 1BF0: .Aw"#w */
	0x22,0x87,0xF1,0x22,0xA4,0x71,0x24,0x30,	/* 1BF8: ""q$0 */
	0x2F,0x4F,0x24,0xF6,0x24,0x42,0xF4,0xA6,	/* 1C00: .O$$B */
	0x21,0x4F,0x71,0x27,0xE2,0x09,0x40,0x71,	/* 1C08: !Oq'.@q */
	0x27,0xE6,0x24,0x42,0x71,0x27,0xE2,0x22,	/* 1C10: '$Bq'" */
	0x40,0x77,0x21,0x55,0x23,0xFB,0x22,0x24,	/* 1C18: @w!U#"$ */
	0x02,0x71,0x24,0x30,0x2F,0x4F,0x24,0xF6,	/* 1C20: .q$0.O$ */
	0x24,0x42,0xF4,0xA7,0x2D,0x26,0x46,0x21,	/* 1C28: $B-&F! */
	0xFB,0xD3,0x06,0x2D,0x22,0x47,0x21,0xFB,	/* 1C30: .-"G! */
	0xD3,0x77,0x5B,0xF1,0x4F,0x24,0xF6,0xD0,	/* 1C38: w[O$ */
	0x77,0x53,0xF1,0x24,0x48,0xF4,0xC0,0xAA,	/* 1C40: wS$H */
	0x70,0x4F,0xF4,0xC0,0xA5,0x77,0x23,0x83,	/* 1C48: pOw# */
	0xF1,0xD0,0x77,0x53,0xF1,0x24,0x48,0xF4,	/* 1C50: wS$H */
	0xC0,0xA9,0x41,0x21,0x4E,0x70,0x24,0xFF,	/* 1C58: A!Np$ */
	0xF0,0xC0,0xAF,0x77,0x53,0xF1,0x24,0x48,	/* 1C60: wS$H */
	0xF4,0xAD,0x41,0x70,0x4D,0x24,0xFF,0xF0,	/* 1C68: ApM$ */
	0xC0,0xA5,0x77,0x21,0x5B,0xF1,0xD0,0x21,	/* 1C70: w![! */
	0x41,0x70,0xF9,0x21,0xA0,0x70,0x22,0xAB,	/* 1C78: Ap!p" */
	0x70,0x43,0xF4,0x22,0xA6,0x70,0x44,0xF4,	/* 1C80: pC"pD */
	0xC0,0x22,0xA7,0x21,0x0E,0x21,0x43,0x70,	/* 1C88: "!.!Cp */
	0xF9,0xAE,0x70,0x21,0x41,0xF4,0x21,0xA3,	/* 1C90: p!A! */
	0x70,0x21,0x42,0xF4,0xC0,0x21,0xA3,0x0B,	/* 1C98: p!B!. */
	0x70,0x21,0x43,0xF4,0xA6,0x70,0x21,0x44,	/* 1CA0: p!Cp!D */
	0xF4,0xC0,0xA7,0x4C,0x77,0x21,0x55,0x23,	/* 1CA8: Lw!U# */
	0xFB,0x07,0x22,0x40,0x77,0x21,0x55,0x23,	/* 1CB0: ."@w!U# */
	0xFB,0x70,0x73,0x28,0xF1,0x30,0x71,0x27,	/* 1CB8: ps(0q' */
	0xE2,0x70,0x73,0x28,0xF1,0x31,0x71,0x27,	/* 1CC0: ps(1q' */
	0xE6,0x77,0x22,0x8D,0xF1,0x2F,0x40,0x24,	/* 1CC8: w".@$ */
	0xF6,0x77,0x5B,0xF1,0x4F,0x24,0xF6,0x24,	/* 1CD0: w[O$$ */
	0xFB,0x77,0x22,0x8D,0x23,0xFB,0x77,0x23,	/* 1CD8: w"#w# */
	0x83,0xF1,0x77,0x21,0x5B,0x23,0xFB,0x77,	/* 1CE0: w![#w */
	0x5B,0xF1,0x44,0x24,0xF0,0xD0,0x77,0x53,	/* 1CE8: [D$wS */
	0xF1,0x24,0x48,0xF4,0xC0,0xAB,0x70,0x4F,	/* 1CF0: $HpO */
	0xF4,0xC0,0xA6,0x20,0x77,0x21,0x5A,0xF1,	/* 1CF8:  w!Z */
	0xD0,0x77,0x53,0xF1,0x24,0x48,0xF4,0xC0,	/* 1D00: wS$H */
	0xAA,0x41,0x21,0x4E,0x70,0x24,0xFF,0xF0,	/* 1D08: A!Np$ */
	0xC0,0x21,0xA0,0x77,0x53,0xF1,0x24,0x48,	/* 1D10: !wS$H */
	0xF4,0xAE,0x41,0x70,0x4D,0x24,0xFF,0xF0,	/* 1D18: ApM$ */
	0xC0,0xA6,0x20,0x77,0x23,0x87,0xF1,0xD0,	/* 1D20:  w# */
	0x70,0x73,0x28,0xF1,0x30,0x71,0x27,0xE8,	/* 1D28: ps(0q' */
	0x70,0x73,0x28,0xF1,0x31,0x71,0x27,0xEC,	/* 1D30: ps(1q' */
	0x77,0x22,0x8D,0xF1,0x4F,0x24,0xF6,0x77,	/* 1D38: w"O$w */
	0x5B,0xF1,0x2F,0x40,0x24,0xF6,0x24,0xFB,	/* 1D40: [.@$$ */
	0x77,0x22,0x8D,0x23,0xFB,0x77,0x21,0x5A,	/* 1D48: w"#w!Z */
	0xF1,0x77,0x23,0x87,0x23,0xFB,0x40,0x77,	/* 1D50: w##@w */
	0x21,0xEC,0x40,0x77,0x21,0xED,0x40,0x77,	/* 1D58: !@w!@w */
	0x21,0xEE,0x40,0x77,0x21,0xEF,0x77,0x21,	/* 1D60: !@w!w! */
	0x8D,0xF1,0x71,0x21,0xEA,0x77,0x5F,0xF1,	/* 1D68: q!w_ */
	0x71,0x21,0xEB,0x77,0x21,0x8B,0xF1,0x71,	/* 1D70: q!w!q */
	0x21,0xEC,0x77,0x5E,0xF1,0x71,0x21,0xED,	/* 1D78: !w^q! */
	0x40,0x77,0x21,0x89,0x23,0xFB,0x77,0x5A,	/* 1D80: @w!#wZ */
	0xF1,0x25,0xFA,0xD0,0x77,0x23,0x81,0x23,	/* 1D88: %w## */
	0xFB,0x70,0x43,0x24,0xF6,0xD3,0x70,0x21,	/* 1D90: pC$p! */
	0x40,0x24,0xF6,0xC0,0x22,0xA0,0x70,0x48,	/* 1D98: @$"pH */
	0x24,0xF6,0xA9,0x20,0x73,0x22,0x40,0x24,	/* 1DA0: $ s"@$ */
	0xFB,0xD3,0x07,0x20,0x73,0x24,0x40,0x24,	/* 1DA8: . s$@$ */
	0xFB,0xD3,0x70,0x44,0x24,0xF6,0xA7,0x20,	/* 1DB0: pD$  */
	0x73,0x28,0x40,0x24,0xFB,0xD3,0x77,0x5D,	/* 1DB8: s(@$w] */
	0xF1,0x28,0x40,0x24,0xF6,0xA3,0x20,0x07,	/* 1DC0: (@$ . */
	0x20,0x73,0x21,0x40,0x24,0xFB,0xD3,0x77,	/* 1DC8:  s!@$w */
	0x21,0x85,0xF1,0x25,0xFA,0xD0,0x77,0x21,	/* 1DD0: !%w! */
	0x59,0x23,0xFB,0x70,0x4F,0x24,0xF6,0x4F,	/* 1DD8: Y#pO$O */
	0xF4,0xA3,0x20,0x06,0x20,0x73,0x48,0x24,	/* 1DE0:  . sH$ */
	0xFB,0xD3,0x73,0x71,0xE8,0x40,0xD3,0x70,	/* 1DE8: sq@p */
	0x28,0x40,0x24,0xF6,0xA7,0x20,0x73,0x21,	/* 1DF0: (@$ s! */
	0x40,0x24,0xFB,0xD3,0x73,0x71,0xE9,0x77,	/* 1DF8: @$sqw */
	0x53,0xF1,0x24,0x48,0xF4,0xA6,0x20,0x48,	/* 1E00: S$H H */
	0x71,0xEA,0x05,0x20,0x28,0x44,0x71,0xEA,	/* 1E08: q. (Dq */
	0x77,0x21,0x50,0xF1,0x25,0xFA,0xD0,0x77,	/* 1E10: w!P%w */
	0x22,0x81,0x23,0xFB,0x77,0x5D,0xF1,0x77,	/* 1E18: "#w]w */
	0x21,0x58,0x23,0xFB,0x70,0x28,0x40,0x24,	/* 1E20: !X#p(@$ */
	0xF6,0xA5,0x20,0x40,0xD3,0x21,0x06,0x70,	/* 1E28:  @!.p */
	0x48,0x24,0xF6,0xA5,0x20,0x42,0xD3,0x0D,	/* 1E30: H$ B. */
	0x20,0x70,0x44,0x24,0xF6,0xA5,0x20,0x44,	/* 1E38:  pD$ D */
	0xD3,0x03,0x20,0x43,0xD3,0x70,0x41,0x24,	/* 1E40: . CpA$ */
	0xF6,0xA9,0x20,0x73,0x21,0x48,0x24,0xFB,	/* 1E48:  s!H$ */
	0xD3,0x0D,0x20,0x70,0x42,0x24,0xF6,0xC0,	/* 1E50: . pB$ */
	0xA6,0x20,0x73,0x48,0x24,0xFB,0xD3,0x73,	/* 1E58:  sH$s */
	0x71,0x21,0xEE,0x40,0xD3,0x77,0x5D,0xF1,	/* 1E60: q!@w] */
	0x44,0x24,0xF6,0x22,0xA9,0x77,0x22,0x87,	/* 1E68: D$"w" */
	0xF1,0xAD,0x20,0x71,0x24,0x30,0x2F,0x4F,	/* 1E70:  q$0.O */
	0x24,0xF6,0x24,0x42,0xF4,0xAF,0x20,0x72,	/* 1E78: $$B r */
	0x64,0x2F,0x4F,0x24,0xF6,0xD2,0x73,0x42,	/* 1E80: d.O$sB */
	0x24,0xFB,0xD3,0x21,0x00,0x72,0x24,0x20,	/* 1E88: $!.r$  */
	0x40,0x24,0xFB,0xD2,0x08,0x20,0x72,0x64,	/* 1E90: @$. rd */
	0x2F,0x4F,0x24,0xF6,0xD2,0x77,0x21,0x51,	/* 1E98: .O$w!Q */
	0xF1,0x2F,0x4F,0xF4,0xAE,0x20,0x77,0x22,	/* 1EA0: .O w" */
	0x87,0xF1,0xC0,0xA7,0x20,0x73,0x28,0x40,	/* 1EA8:  s(@ */
	0x24,0xFB,0xD3,0x73,0x71,0x21,0xEF,0x77,	/* 1EB0: $sq!w */
	0x22,0x87,0xF1,0x22,0xA7,0x77,0x22,0x87,	/* 1EB8: ""w" */
	0xF1,0x21,0x28,0xA7,0x71,0x24,0x30,0x2F,	/* 1EC0: !(q$0. */
	0x4F,0x24,0xF6,0x24,0x42,0xF4,0x21,0x27,	/* 1EC8: O$$B!' */
	0xAA,0x77,0x5D,0xF1,0x44,0x24,0xF6,0x21,	/* 1ED0: w]D$! */
	0x27,0xA1,0x72,0x24,0x20,0x40,0x24,0xFB,	/* 1ED8: 'r$ @$ */
	0xD2,0x21,0x26,0x07,0x40,0xD4,0x40,0xD3,	/* 1EE0: !&.@@ */
	0x40,0xD0,0x77,0x5D,0xF1,0x48,0x24,0xF6,	/* 1EE8: @w]H$ */
	0xA7,0x70,0x21,0x20,0x40,0x24,0xFB,0xD0,	/* 1EF0: p! @$ */
	0x77,0x5A,0xF1,0x28,0x40,0x24,0xF6,0xAA,	/* 1EF8: wZ(@$ */
	0x70,0x21,0x20,0x20,0x40,0x24,0xFB,0xD0,	/* 1F00: p!  @$ */
	0x21,0x08,0x73,0x21,0x20,0x20,0x40,0x24,	/* 1F08: !.s!  @$ */
	0xFB,0xD3,0x77,0x21,0x87,0xF1,0x41,0x24,	/* 1F10: w!A$ */
	0xF6,0xA8,0x74,0x21,0x20,0x20,0x40,0x24,	/* 1F18: t!  @$ */
	0xFB,0xD4,0x77,0x5D,0xF1,0x24,0x40,0x24,	/* 1F20: w]$@$ */
	0xF6,0xAA,0x70,0x22,0x20,0x20,0x40,0x24,	/* 1F28: p"  @$ */
	0xFB,0xD0,0x21,0x08,0x73,0x22,0x20,0x20,	/* 1F30: !.s"   */
	0x40,0x24,0xFB,0xD3,0x77,0x21,0x87,0xF1,	/* 1F38: @$w! */
	0x42,0x24,0xF6,0xA8,0x74,0x22,0x20,0x20,	/* 1F40: B$t"   */
	0x40,0x24,0xFB,0xD4,0x77,0x5D,0xF1,0x42,	/* 1F48: @$w]B */
	0x24,0xF6,0x21,0xA2,0x77,0x5D,0xF1,0x41,	/* 1F50: $!w]A */
	0x24,0xF6,0xA6,0x70,0x42,0x24,0xFB,0xD0,	/* 1F58: $pB$ */
	0x05,0x70,0x41,0x24,0xFB,0xD0,0x77,0x21,	/* 1F60: .pA$w! */
	0x85,0xF1,0x21,0x40,0x24,0xF6,0xA6,0x70,	/* 1F68: !@$p */
	0x21,0x40,0x24,0xFB,0xD0,0x77,0x5D,0xF1,	/* 1F70: !@$w] */
	0x21,0x40,0x24,0xF6,0xA6,0x70,0x22,0x40,	/* 1F78: !@$p"@ */
	0x24,0xFB,0xD0,0x23,0x21,0x23,0x43,0x77,	/* 1F80: $#!#Cw */
	0x76,0x26,0x2D,0x97,0x74,0xD0,0x73,0x77,	/* 1F88: v&-tsw */
	0x76,0x29,0x22,0x9C,0x77,0x5D,0xF1,0x22,	/* 1F90: v)"w]" */
	0x40,0x24,0xF6,0x23,0xA4,0x77,0x76,0x67,	/* 1F98: @$#wvg */
	0x2B,0x9F,0x77,0x21,0x85,0xF1,0x21,0x40,	/* 1FA0: +w!!@ */
	0x24,0xF6,0xA4,0x2B,0x40,0xD0,0x03,0x2F,	/* 1FA8: $+@.. */
	0x40,0xD0,0x77,0x21,0x53,0xF1,0x70,0x24,	/* 1FB0: @w!Sp$ */
	0xF6,0x25,0xFA,0xD0,0x71,0x21,0xE6,0x71,	/* 1FB8: %q!q */
	0x21,0x35,0x4F,0x24,0xF6,0x70,0x60,0x40,	/* 1FC0: !5O$p`@ */
	0x24,0xF6,0x24,0xFB,0x71,0x21,0xE5,0x21,	/* 1FC8: $$q!! */
	0x03,0x22,0x44,0x77,0x5C,0x23,0xFB,0x40,	/* 1FD0: ."Dw\#@ */
	0x71,0x21,0xE6,0x71,0x21,0x35,0x4F,0x24,	/* 1FD8: q!q!5O$ */
	0xF6,0x71,0x21,0xE5,0x72,0x60,0x44,0x24,	/* 1FE0: q!r`D$ */
	0xF6,0xD2,0x77,0x5D,0xF1,0x42,0x24,0xF6,	/* 1FE8: w]B$ */
	0xA5,0x72,0x42,0x24,0xFB,0xD2,0x77,0x5D,	/* 1FF0: rB$w] */
	0xF1,0x48,0x24,0xF6,0xA5,0x72,0x48,0x24,	/* 1FF8: H$rH$ */
	0xFB,0xD2,0x77,0x5D,0xF1,0x41,0x24,0xF6,	/* 2000: w]A$ */
	0xA5,0x72,0x41,0x24,0xFB,0xD2,0x72,0x62,	/* 2008: rA$rb */
	0x2F,0x2F,0x4F,0x24,0xF6,0xD2,0x77,0x5D,	/* 2010: ..O$w] */
	0xF1,0x22,0x40,0x24,0xF6,0xA8,0x72,0x22,	/* 2018: "@$r" */
	0x20,0x20,0x40,0x24,0xFB,0xD2,0x77,0x5A,	/* 2020:   @$wZ */
	0xF1,0x28,0x40,0x24,0xF6,0xA5,0x72,0x48,	/* 2028: (@$rH */
	0x24,0xFB,0xD2,0x77,0x5D,0xF1,0x24,0x40,	/* 2030: $w]$@ */
	0x24,0xF6,0xA5,0x72,0x48,0x24,0xFB,0xD2,	/* 2038: $rH$ */
	0x72,0x48,0x24,0xF6,0xA6,0x72,0x6F,0x4F,	/* 2040: rH$roO */
	0x24,0xF6,0xD2,0x42,0x71,0x22,0xE1,0x24,	/* 2048: $Bq"$ */
	0x4E,0x71,0xE5,0x72,0x77,0xE4,0x40,0xB5,	/* 2050: Nqrw@ */
	0x22,0xF0,0x21,0x4A,0x71,0xE5,0x72,0x60,	/* 2058: "!Jqr` */
	0x4E,0x24,0xF6,0x77,0xE4,0x29,0x40,0x71,	/* 2060: N$w)@q */
	0xE6,0x40,0x77,0x22,0x85,0x23,0xFB,0x77,	/* 2068: @w"#w */
	0x57,0xF1,0x44,0xF4,0xA6,0x40,0x77,0x57,	/* 2070: WD@wW */
	0x23,0xFB,0x03,0x77,0x76,0x98,0x41,0x76,	/* 2078: #.wvAv */
	0x21,0xE1,0x40,0xB5,0x22,0xF0,0x60,0xBF,	/* 2080: !@"` */
	0x73,0x31,0xD0,0x73,0x87,0xF1,0x73,0x32,	/* 2088: s1ss2 */
	0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,0x23,	/* 2090: '..O$# */
	0xFB,0x73,0x87,0xF1,0x70,0x27,0xEF,0x73,	/* 2098: sp's */
	0x87,0xF1,0x43,0x24,0xF6,0x70,0x26,0xE8,	/* 20A0: C$p& */
	0x70,0x26,0x3C,0x28,0x40,0x24,0xF6,0xA9,	/* 20A8: p&<(@$ */
	0x40,0x73,0x57,0x23,0xFB,0x41,0x72,0x21,	/* 20B0: @sW#Ar! */
	0xE1,0x40,0xB1,0x22,0xF0,0x60,0xBF,0x73,	/* 20B8: @"`s */
	0x31,0xD0,0x73,0x87,0xF1,0x73,0x32,0x27,	/* 20C0: 1ss2' */
	0x2F,0x2F,0x4F,0x24,0xF6,0x89,0x23,0xFB,	/* 20C8: ..O$# */
	0x73,0x87,0xF1,0x70,0x27,0xEF,0x73,0x87,	/* 20D0: sp's */
	0xF1,0x43,0x24,0xF6,0x70,0x26,0xE8,0x73,	/* 20D8: C$p&s */
	0x72,0x22,0x25,0x95,0xA4,0x40,0xB1,0x22,	/* 20E0: r"%@" */
	0xF0,0x73,0x8D,0xF1,0x73,0x56,0xF1,0xF4,	/* 20E8: ssV */
	0xA4,0x41,0xB1,0x22,0xF0,0x73,0x21,0x8F,	/* 20F0: A"s! */
	0xF1,0xA8,0x73,0x72,0x2C,0x9C,0x40,0xB1,	/* 20F8: sr,@ */
	0x22,0xF0,0x73,0x22,0x89,0xF1,0xC0,0xA9,	/* 2100: "s" */
	0x73,0x34,0x22,0x20,0x40,0x24,0xFB,0x73,	/* 2108: s4" @$s */
	0xE4,0x73,0x34,0x22,0x20,0x40,0x24,0xF6,	/* 2110: s4" @$ */
	0xA8,0x73,0x72,0x2A,0x9D,0x40,0xB1,0x22,	/* 2118: sr*@" */
	0xF0,0x73,0x34,0x21,0x20,0x40,0x24,0xFB,	/* 2120: s4! @$ */
	0x73,0xE4,0x73,0x22,0x87,0xF1,0xAC,0x73,	/* 2128: ss"s */
	0x34,0x41,0x24,0xFB,0x73,0xE4,0x28,0x44,	/* 2130: 4A$s(D */
	0x70,0xE6,0x0B,0x73,0x34,0x41,0x24,0xFB,	/* 2138: p.s4A$ */
	0x73,0xE4,0x29,0x42,0x70,0xE6,0x40,0xB1,	/* 2140: s)Bp@ */
	0x22,0xF0,0x60,0xBE,0x74,0x31,0xD0,0x74,	/* 2148: "`t1t */
	0x87,0xF1,0x74,0x32,0x27,0x2F,0x2F,0x4F,	/* 2150: t2'..O */
	0x24,0xF6,0x89,0x23,0xFB,0x74,0x87,0xF1,	/* 2158: $#t */
	0x70,0x27,0xEF,0x74,0x87,0xF1,0x43,0x24,	/* 2160: p'tC$ */
	0xF6,0x70,0x26,0xE8,0x74,0x23,0x85,0xF1,	/* 2168: p&t# */
	0xD1,0x43,0x71,0xF9,0xAD,0x71,0x21,0xA0,	/* 2170: Cqq! */
	0x71,0x41,0xF4,0x21,0xA1,0x71,0x42,0xF4,	/* 2178: qA!qB */
	0xAD,0x06,0x71,0x43,0xF4,0x21,0xAD,0x71,	/* 2180: .qC!q */
	0x41,0x74,0x23,0x85,0x23,0xFB,0x74,0x34,	/* 2188: At##t4 */
	0x41,0x24,0xFB,0x74,0xE4,0x70,0x36,0x2F,	/* 2190: A$tp6. */
	0x4F,0x24,0xF6,0x42,0x24,0xFB,0x70,0xE6,	/* 2198: O$B$p */
	0x40,0xB2,0x22,0xF0,0x74,0x57,0xF1,0x4C,	/* 21A0: @"tWL */
	0xF4,0xC0,0xA6,0x21,0x42,0x74,0x57,0x23,	/* 21A8: !BtW# */
	0xFB,0x40,0xB2,0x22,0xF0,0x72,0x71,0x21,	/* 21B0: @"rq! */
	0x27,0x9F,0xC0,0xA5,0x40,0x72,0x57,0x23,	/* 21B8: '@rW# */
	0xFB,0x40,0x22,0xF0,0x40,0x22,0xF0,0x41,	/* 21C0: @"@"A */
	0x22,0xF0,0x60,0xBD,0x75,0x31,0xD1,0x75,	/* 21C8: "`u1u */
	0x87,0xF1,0x75,0x32,0x27,0x2F,0x2F,0x4F,	/* 21D0: u2'..O */
	0x24,0xF6,0x89,0x23,0xFB,0x75,0x87,0xF1,	/* 21D8: $#u */
	0x71,0x27,0xEF,0x75,0x87,0xF1,0x43,0x24,	/* 21E0: q'uC$ */
	0xF6,0x71,0x26,0xE8,0x75,0x74,0x21,0x24,	/* 21E8: q&ut!$ */
	0x98,0xA4,0x40,0xB3,0x22,0xF0,0x71,0x35,	/* 21F0: @"q5 */
	0x2F,0x4F,0x24,0xF6,0xA4,0x40,0xB3,0x22,	/* 21F8: .O$@" */
	0xF0,0x75,0x21,0x8F,0xF1,0xC0,0x24,0xAA,	/* 2200: u!$ */
	0x75,0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,	/* 2208: u2'..O$ */
	0xD0,0x75,0x34,0x22,0x20,0x40,0x24,0xF6,	/* 2210: u4" @$ */
	0x26,0xA7,0x75,0x87,0xF1,0x43,0xF9,0x21,	/* 2218: &uC! */
	0xAB,0x70,0x21,0x8D,0xF1,0x60,0x8F,0x25,	/* 2220: p!`% */
	0xFA,0x70,0x21,0x8D,0x23,0xFB,0x2F,0x4F,	/* 2228: p!#.O */
	0x24,0xF6,0xC0,0x21,0xAD,0x24,0x44,0x71,	/* 2230: $!$Dq */
	0x27,0xEF,0x21,0x06,0x70,0x5E,0xF1,0x60,	/* 2238: '!.p^` */
	0x8F,0x25,0xFA,0x70,0x5E,0x23,0xFB,0x2F,	/* 2240: %p^#. */
	0x4F,0x24,0xF6,0xC0,0xA5,0x21,0x40,0x71,	/* 2248: O$!@q */
	0x27,0xEF,0x40,0x75,0x8D,0x23,0xFB,0x40,	/* 2250: '@u#@ */
	0x75,0x55,0x23,0xFB,0x40,0x75,0x56,0x23,	/* 2258: uU#@uV# */
	0xFB,0x40,0x75,0x8B,0x23,0xFB,0x40,0x75,	/* 2260: @u#@u */
	0x22,0x89,0x23,0xFB,0x75,0x34,0x62,0x2F,	/* 2268: "#u4b. */
	0x4F,0x24,0xF6,0x75,0xE4,0x75,0x22,0x87,	/* 2270: O$uu" */
	0xF1,0x27,0xA3,0x21,0x44,0x71,0xE5,0x29,	/* 2278: '!Dq) */
	0x09,0x75,0x22,0x89,0xF1,0x22,0xA5,0x75,	/* 2280: .u""u */
	0x34,0x21,0x20,0x40,0x24,0xF6,0x22,0xA7,	/* 2288: 4! @$" */
	0x75,0x22,0x50,0xF1,0x41,0x24,0xF6,0x25,	/* 2290: u"PA$% */
	0xA1,0x21,0x48,0x71,0xE5,0x75,0x22,0x50,	/* 2298: !Hqu"P */
	0xF1,0x60,0x4E,0x24,0xF6,0x75,0x22,0x50,	/* 22A0: `N$u"P */
	0x23,0xFB,0x23,0x0E,0x75,0x34,0x22,0x20,	/* 22A8: ##.u4"  */
	0x40,0x24,0xFB,0x75,0xE4,0x23,0x03,0x75,	/* 22B0: @$u#.u */
	0x34,0x21,0x20,0x40,0x24,0xFB,0x75,0xE4,	/* 22B8: 4! @$u */
	0x40,0x75,0x8D,0x23,0xFB,0x40,0x75,0x56,	/* 22C0: @u#@uV */
	0x23,0xFB,0x75,0x22,0x87,0xF1,0xAC,0x75,	/* 22C8: #u"u */
	0x34,0x41,0x24,0xFB,0x75,0xE4,0x28,0x44,	/* 22D0: 4A$u(D */
	0x71,0xE6,0x0B,0x75,0x34,0x41,0x24,0xFB,	/* 22D8: q.u4A$ */
	0x75,0xE4,0x29,0x42,0x71,0xE6,0x28,0x42,	/* 22E0: u)Bq(B */
	0x71,0xE5,0x40,0xB3,0x22,0xF0,0x75,0x21,	/* 22E8: q@"u! */
	0x87,0xF1,0x41,0x24,0xF6,0xC0,0xAB,0x40,	/* 22F0: A$@ */
	0xD0,0x21,0x20,0x20,0x40,0x75,0x74,0x25,	/* 22F8: !  @ut% */
	0x2B,0x9E,0x75,0x21,0x87,0xF1,0x42,0x24,	/* 2300: +u!B$ */
	0xF6,0xC0,0xAB,0x40,0xD0,0x22,0x20,0x20,	/* 2308: @"   */
	0x40,0x75,0x74,0x25,0x2A,0x9A,0x28,0x40,	/* 2310: @ut%*(@ */
	0x71,0xE5,0x75,0x34,0x60,0x4E,0x24,0xF6,	/* 2318: qu4`N$ */
	0x75,0xE4,0x40,0x71,0xE6,0x41,0x75,0x21,	/* 2320: u@qAu! */
	0x8F,0x23,0xFB,0x21,0x40,0x75,0x57,0x23,	/* 2328: #!@uW# */
	0xFB,0x41,0x74,0x21,0xE1,0x40,0xB3,0x22,	/* 2330: At!@" */
	0xF0,0x60,0xBE,0x74,0x31,0xD0,0x74,0x87,	/* 2338: `t1t */
	0xF1,0x74,0x32,0x27,0x2F,0x2F,0x4F,0x24,	/* 2340: t2'..O$ */
	0xF6,0x89,0x23,0xFB,0x74,0x87,0xF1,0x70,	/* 2348: #tp */
	0x27,0xEF,0x74,0x87,0xF1,0x43,0x24,0xF6,	/* 2350: 'tC$ */
	0x70,0x26,0xE8,0x74,0x23,0x85,0xF1,0xD1,	/* 2358: p&t# */
	0x43,0x71,0xF9,0xA5,0x71,0x24,0xA0,0x71,	/* 2360: Cqq$q */
	0x0E,0x71,0x43,0xF4,0xAA,0x71,0x44,0xF4,	/* 2368: .qCqD */
	0x21,0xAF,0x71,0x45,0xF4,0x21,0xAA,0x74,	/* 2370: !qE!t */
	0x53,0xF1,0x24,0x48,0xF4,0xC0,0xAC,0x70,	/* 2378: S$Hp */
	0x35,0x2F,0x4F,0x24,0xF6,0xC0,0xAA,0x28,	/* 2380: 5.O$( */
	0x42,0x70,0xE5,0x44,0x74,0x23,0x85,0x23,	/* 2388: BpDt## */
	0xFB,0x74,0x34,0x41,0x24,0xFB,0x74,0xE4,	/* 2390: t4A$t */
	0x70,0x36,0x2F,0x4F,0x24,0xF6,0x42,0x24,	/* 2398: p6.O$B$ */
	0xFB,0x70,0xE6,0x41,0xB2,0x22,0xF0,0x40,	/* 23A0: pA"@ */
	0xB2,0x22,0xF0,0x60,0xBF,0x73,0x31,0xD0,	/* 23A8: "`s1 */
	0x73,0x87,0xF1,0x73,0x32,0x27,0x2F,0x2F,	/* 23B0: ss2'.. */
	0x4F,0x24,0xF6,0x89,0x23,0xFB,0x73,0x87,	/* 23B8: O$#s */
	0xF1,0x70,0x27,0xEF,0x73,0x87,0xF1,0x43,	/* 23C0: p'sC */
	0x24,0xF6,0x70,0x26,0xE8,0x73,0x22,0x87,	/* 23C8: $p&s" */
	0xF1,0xC0,0xA8,0x70,0x3B,0x2F,0x4B,0x24,	/* 23D0: p;.K$ */
	0xF6,0x70,0xEB,0x40,0x73,0x57,0x23,0xFB,	/* 23D8: p@sW# */
	0x41,0x72,0x21,0xE1,0x40,0xB1,0x22,0xF0,	/* 23E0: Ar!@" */
	0x60,0xBF,0x73,0x31,0xD0,0x73,0x87,0xF1,	/* 23E8: `s1s */
	0x73,0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,	/* 23F0: s2'..O$ */
	0x89,0x23,0xFB,0x73,0x87,0xF1,0x70,0x27,	/* 23F8: #sp' */
	0xEF,0x73,0x87,0xF1,0x43,0x24,0xF6,0x70,	/* 2400: sC$p */
	0x26,0xE8,0x70,0x35,0x2F,0x4F,0x24,0xF6,	/* 2408: &p5.O$ */
	0xA4,0x40,0xB1,0x22,0xF0,0x73,0x8D,0xF1,	/* 2410: @"s */
	0x73,0x56,0x23,0xFB,0x28,0x42,0x70,0xE5,	/* 2418: sV#(Bp */
	0x73,0x72,0x67,0x97,0x40,0xB1,0x22,0xF0,	/* 2420: srg@" */
	0x72,0x8B,0xF1,0x72,0x55,0x23,0xFB,0x41,	/* 2428: rrU#A */
	0x71,0x21,0xE1,0x40,0x72,0x57,0x23,0xFB,	/* 2430: q!@rW# */
	0x40,0x22,0xF0,0x60,0xBF,0x73,0x31,0xD0,	/* 2438: @"`s1 */
	0x73,0x87,0xF1,0x73,0x32,0x27,0x2F,0x2F,	/* 2440: ss2'.. */
	0x4F,0x24,0xF6,0x89,0x23,0xFB,0x73,0x87,	/* 2448: O$#s */
	0xF1,0x70,0x27,0xEF,0x73,0x87,0xF1,0x43,	/* 2450: p'sC */
	0x24,0xF6,0x70,0x26,0xE8,0x73,0x22,0x87,	/* 2458: $p&s" */
	0xF1,0xC0,0xAB,0x70,0x3B,0x2F,0x4F,0x24,	/* 2460: p;.O$ */
	0xF6,0x44,0x24,0xFB,0x70,0xEB,0x41,0x72,	/* 2468: D$pAr */
	0x21,0xE1,0x40,0x73,0x57,0x23,0xFB,0x40,	/* 2470: !@sW#@ */
	0xB1,0x22,0xF0,0x60,0xBF,0x73,0x31,0xD0,	/* 2478: "`s1 */
	0x73,0x87,0xF1,0x73,0x32,0x27,0x2F,0x2F,	/* 2480: ss2'.. */
	0x4F,0x24,0xF6,0x89,0x23,0xFB,0x73,0x87,	/* 2488: O$#s */
	0xF1,0x70,0x27,0xEF,0x73,0x87,0xF1,0x43,	/* 2490: p'sC */
	0x24,0xF6,0x70,0x26,0xE8,0x74,0x70,0x26,	/* 2498: $p&tp& */
	0xEF,0x4F,0x72,0x21,0x2B,0x2E,0x91,0x70,	/* 24A0: Or!+.p */
	0x26,0x3F,0x2F,0x4F,0x24,0xF6,0x75,0x24,	/* 24A8: &?.O$u$ */
	0xF6,0x21,0xAA,0x40,0x70,0x26,0xEF,0x4F,	/* 24B0: !@p&O */
	0x72,0x21,0x2B,0x2C,0x9B,0x70,0x26,0x3F,	/* 24B8: r!+,p&? */
	0x2F,0x4F,0x24,0xF6,0x75,0x24,0xF6,0xA9,	/* 24C0: .O$u$ */
	0x76,0x81,0xB1,0x22,0xF0,0x76,0xB1,0x22,	/* 24C8: v"v" */
	0xF0,0x40,0xB1,0x22,0xF0,0x60,0xBC,0x76,	/* 24D0: @"`v */
	0x31,0xD2,0x40,0xD3,0x76,0x87,0xF1,0x76,	/* 24D8: 1@vv */
	0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,	/* 24E0: 2'..O$ */
	0x23,0xFB,0x76,0x87,0xF1,0x72,0x27,0xEF,	/* 24E8: #vr' */
	0x76,0x87,0xF1,0x43,0x24,0xF6,0x72,0x26,	/* 24F0: vC$r& */
	0xE8,0x76,0x22,0x87,0xF1,0xC0,0xA2,0x4E,	/* 24F8: v"N */
	0xD3,0x73,0xC0,0xAB,0x22,0x40,0xD0,0x49,	/* 2500: s"@I */
	0xD1,0x41,0x76,0x75,0x69,0x9D,0xD3,0x73,	/* 2508: Avuis */
	0xC0,0xAB,0x21,0x40,0xD0,0x4B,0xD1,0x44,	/* 2510: !@KD */
	0x76,0x75,0x6A,0x9F,0xD3,0x72,0x26,0x3F,	/* 2518: vujr&? */
	0x28,0x40,0x24,0xF6,0x25,0xFA,0xD1,0xC0,	/* 2520: (@$% */
	0xA7,0x4E,0xD3,0x71,0x76,0x5C,0x23,0xFB,	/* 2528: Nqv\# */
	0x73,0xC0,0x23,0xA4,0x48,0xD0,0x42,0x72,	/* 2530: s#HBr */
	0x26,0xEF,0x4F,0x75,0x21,0x2B,0x24,0x98,	/* 2538: &Ou!+$ */
	0x40,0x72,0x26,0xEF,0x4F,0x75,0x21,0x2B,	/* 2540: @r&Ou!+ */
	0x23,0x9E,0x72,0x26,0x3F,0x28,0x40,0x24,	/* 2548: #r&?(@$ */
	0xF6,0x25,0xFA,0xD1,0xAA,0x73,0xC0,0xA2,	/* 2550: %Ѫs */
	0x70,0xD3,0x71,0x76,0x5C,0x23,0xFB,0x70,	/* 2558: pqv\#p */
	0x60,0x8F,0x25,0xFA,0xD0,0xA2,0x63,0x0E,	/* 2560: `%Тc. */
	0x73,0xC0,0x23,0xA6,0x42,0x72,0x26,0xEF,	/* 2568: s#Br& */
	0x4F,0x75,0x21,0x2B,0x21,0x92,0x40,0x72,	/* 2570: Ou!+!@r */
	0x26,0xEF,0x22,0x27,0x21,0x40,0xD0,0x72,	/* 2578: &"'!@r */
	0x26,0x3F,0x2F,0x4F,0x24,0xF6,0x25,0xFA,	/* 2580: &?.O$% */
	0xD1,0x24,0x40,0x24,0xF6,0xC0,0xA9,0x70,	/* 2588: $@$p */
	0x60,0x8F,0x25,0xFA,0xD0,0xA2,0x61,0x07,	/* 2590: `%Тa. */
	0x70,0xC0,0xA7,0x71,0x76,0x5C,0x23,0xFB,	/* 2598: pqv\# */
	0x4D,0xD3,0x4F,0x75,0x21,0x2A,0x2E,0x90,	/* 25A0: MOu!*. */
	0x42,0x72,0x26,0xEF,0x4F,0x75,0x21,0x2A,	/* 25A8: Br&Ou!* */
	0x2D,0x96,0x40,0x72,0x26,0xEF,0x28,0x42,	/* 25B0: -@r&(B */
	0x72,0xE5,0x73,0x76,0x21,0x54,0x23,0xFB,	/* 25B8: rsv!T# */
	0x73,0xA4,0x45,0x72,0x26,0xEF,0x40,0x76,	/* 25C0: sEr&@v */
	0x57,0x23,0xFB,0x40,0xB4,0x22,0xF0,0x21,	/* 25C8: W#@"! */
	0x40,0x72,0x71,0x9F,0x22,0xF0,0x42,0x72,	/* 25D0: @rq"Br */
	0x71,0x99,0x22,0xF0,0x28,0x40,0x72,0x71,	/* 25D8: q"(@rq */
	0x92,0x22,0xF0,0x60,0xBF,0x73,0x31,0xD0,	/* 25E0: "`s1 */
	0x73,0x87,0xF1,0x73,0x32,0x27,0x2F,0x2F,	/* 25E8: ss2'.. */
	0x4F,0x24,0xF6,0x89,0x23,0xFB,0x73,0x87,	/* 25F0: O$#s */
	0xF1,0x70,0x27,0xEF,0x73,0x87,0xF1,0x43,	/* 25F8: p'sC */
	0x24,0xF6,0x70,0x26,0xE8,0x74,0x46,0x24,	/* 2600: $p&tF$ */
	0xF6,0xA7,0x73,0x34,0x41,0x24,0xFB,0x73,	/* 2608: s4A$s */
	0xE4,0x70,0x36,0x2F,0x4F,0x24,0xF6,0x74,	/* 2610: p6.O$t */
	0x24,0xFB,0x70,0xE6,0x41,0x72,0x21,0xE1,	/* 2618: $pAr! */
	0x40,0x73,0x57,0x23,0xFB,0x40,0xB1,0x22,	/* 2620: @sW#@" */
	0xF0,0x60,0xBF,0x73,0x31,0xD0,0x73,0x87,	/* 2628: `s1s */
	0xF1,0x73,0x32,0x27,0x2F,0x2F,0x4F,0x24,	/* 2630: s2'..O$ */
	0xF6,0x89,0x23,0xFB,0x73,0x87,0xF1,0x70,	/* 2638: #sp */
	0x27,0xEF,0x73,0x87,0xF1,0x43,0x24,0xF6,	/* 2640: 'sC$ */
	0x70,0x26,0xE8,0x73,0x34,0x60,0x4E,0x24,	/* 2648: p&s4`N$ */
	0xF6,0x73,0xE4,0x40,0x70,0xE6,0x41,0x72,	/* 2650: s@pAr */
	0x21,0xE1,0x40,0x73,0x57,0x23,0xFB,0x40,	/* 2658: !@sW#@ */
	0xB1,0x22,0xF0,0x60,0xBF,0x73,0x31,0xD0,	/* 2660: "`s1 */
	0x73,0x87,0xF1,0x73,0x32,0x27,0x2F,0x2F,	/* 2668: ss2'.. */
	0x4F,0x24,0xF6,0x89,0x23,0xFB,0x73,0x87,	/* 2670: O$#s */
	0xF1,0x70,0x27,0xEF,0x73,0x87,0xF1,0x43,	/* 2678: p'sC */
	0x24,0xF6,0x70,0x26,0xE8,0x74,0x41,0x24,	/* 2680: $p&tA$ */
	0xF6,0x23,0xA0,0x75,0x41,0x24,0xF6,0x21,	/* 2688: #uA$! */
	0xAA,0x70,0x39,0x2F,0x4F,0x24,0xF6,0x24,	/* 2690: p9.O$$ */
	0x40,0x24,0xFB,0x70,0xE9,0x70,0x3A,0x2F,	/* 2698: @$pp:. */
	0x4F,0x24,0xF6,0x23,0x40,0x24,0xFB,0x70,	/* 26A0: O$#@$p */
	0xEA,0x21,0x00,0x70,0x39,0x2B,0x4F,0x24,	/* 26A8: !.p9+O$ */
	0xF6,0x70,0xE9,0x70,0x3A,0x2C,0x4F,0x24,	/* 26B0: pp:,O$ */
	0xF6,0x70,0xEA,0x74,0x42,0x24,0xF6,0x21,	/* 26B8: ptB$! */
	0xAA,0x75,0x42,0x24,0xF6,0xAD,0x70,0x39,	/* 26C0: uB$p9 */
	0x2F,0x4F,0x24,0xF6,0x28,0x40,0x24,0xFB,	/* 26C8: .O$(@$ */
	0x70,0xE9,0x08,0x70,0x39,0x27,0x4F,0x24,	/* 26D0: p.p9'O$ */
	0xF6,0x70,0xE9,0x74,0x21,0x40,0x24,0xF6,	/* 26D8: pt!@$ */
	0x21,0xAA,0x75,0x21,0x40,0x24,0xF6,0xAC,	/* 26E0: !u!@$ */
	0x70,0x39,0x2F,0x4F,0x24,0xF6,0x42,0x24,	/* 26E8: p9.O$B$ */
	0xFB,0x70,0xE9,0x08,0x70,0x39,0x2F,0x4D,	/* 26F0: p.p9.M */
	0x24,0xF6,0x70,0xE9,0x74,0x22,0x40,0x24,	/* 26F8: $pt"@$ */
	0xF6,0xAD,0x73,0x22,0x50,0xF1,0x21,0x40,	/* 2700: s"P!@ */
	0x24,0xFB,0x73,0x22,0x50,0x23,0xFB,0x73,	/* 2708: $s"P#s */
	0x53,0xF1,0x24,0x48,0xF4,0x23,0xA2,0x74,	/* 2710: S$H#t */
	0x21,0x20,0x20,0x40,0x24,0xF6,0x21,0x24,	/* 2718: !  @$!$ */
	0xAB,0x73,0x21,0x52,0xF1,0x48,0x24,0xF6,	/* 2720: s!RH$ */
	0x21,0x22,0xAE,0x75,0x21,0x20,0x20,0x40,	/* 2728: !"u!  @ */
	0x24,0xF6,0x21,0x21,0xA4,0x70,0x21,0x35,	/* 2730: $!!p!5 */
	0x2F,0x40,0x24,0xF6,0x49,0x24,0xFB,0x70,	/* 2738: .@$I$p */
	0x21,0xE5,0x42,0x70,0x26,0xED,0x21,0x22,	/* 2740: !Bp&!" */
	0x03,0x70,0x21,0x35,0x2F,0x40,0x24,0xF6,	/* 2748: .p!5.@$ */
	0x4F,0x24,0xFB,0x70,0x21,0xE5,0x74,0x21,	/* 2750: O$p!t! */
	0x20,0x40,0x24,0xF6,0x22,0xA1,0x75,0x21,	/* 2758:  @$"u! */
	0x20,0x40,0x24,0xF6,0x20,0xAF,0x70,0x21,	/* 2760:  @$ p! */
	0x3F,0x2F,0x4F,0x24,0xF6,0x48,0x24,0xFB,	/* 2768: ?.O$H$ */
	0x70,0x21,0xEF,0x0B,0x20,0x70,0x21,0x3F,	/* 2770: p!. p!? */
	0x2F,0x47,0x24,0xF6,0x70,0x21,0xEF,0x74,	/* 2778: .G$p!t */
	0x21,0x20,0x20,0x40,0x24,0xF6,0x25,0xAB,	/* 2780: !  @$% */
	0x73,0x21,0x52,0xF1,0x48,0x24,0xF6,0x22,	/* 2788: s!RH$" */
	0xAC,0x75,0x21,0x20,0x20,0x40,0x24,0xF6,	/* 2790: u!  @$ */
	0x21,0xA0,0x70,0x21,0x3F,0x2F,0x4B,0x24,	/* 2798: !p!?.K$ */
	0xF6,0x70,0x21,0xEF,0x42,0x70,0x26,0xED,	/* 27A0: p!Bp& */
	0x23,0x09,0x70,0x21,0x3F,0x2F,0x4F,0x24,	/* 27A8: #.p!?.O$ */
	0xF6,0x44,0x24,0xFB,0x70,0x21,0xEF,0x40,	/* 27B0: D$p!@ */
	0x70,0x26,0xED,0x22,0x06,0x75,0x21,0x20,	/* 27B8: p&".u!  */
	0x20,0x40,0x24,0xF6,0x21,0xA1,0x70,0x39,	/* 27C0:  @$!p9 */
	0x2F,0x4F,0x24,0xF6,0x44,0x24,0xFB,0x70,	/* 27C8: .O$D$p */
	0xE9,0x41,0x70,0x26,0xEC,0x0D,0x20,0x70,	/* 27D0: Ap&. p */
	0x39,0x2F,0x4B,0x24,0xF6,0x70,0xE9,0x40,	/* 27D8: 9.K$p@ */
	0x70,0x26,0xEC,0x74,0x22,0x20,0x20,0x40,	/* 27E0: p&t"  @ */
	0x24,0xF6,0x2D,0xA1,0x73,0x21,0x52,0xF1,	/* 27E8: $-s!R */
	0x48,0x24,0xF6,0x22,0xA8,0x75,0x22,0x20,	/* 27F0: H$"u"  */
	0x20,0x40,0x24,0xF6,0x21,0xA1,0x70,0x39,	/* 27F8:  @$!p9 */
	0x2F,0x4F,0x24,0xF6,0x44,0x24,0xFB,0x70,	/* 2800: .O$D$p */
	0xE9,0x41,0x70,0x26,0xEC,0x2A,0x0E,0x70,	/* 2808: Ap&*.p */
	0x39,0x2F,0x4B,0x24,0xF6,0x70,0xE9,0x40,	/* 2810: 9.K$p@ */
	0x70,0x26,0xEC,0x2A,0x00,0x75,0x22,0x20,	/* 2818: p&*.u"  */
	0x20,0x40,0x24,0xF6,0x21,0xA0,0x70,0x21,	/* 2820:  @$!p! */
	0x3F,0x2F,0x4B,0x24,0xF6,0x70,0x21,0xEF,	/* 2828: ?.K$p! */
	0x42,0x70,0x26,0xED,0x28,0x07,0x70,0x21,	/* 2830: Bp&(.p! */
	0x3F,0x2F,0x4F,0x24,0xF6,0x44,0x24,0xFB,	/* 2838: ?.O$D$ */
	0x70,0x21,0xEF,0x40,0x70,0x26,0xED,0x27,	/* 2840: p!@p&' */
	0x04,0x70,0x21,0x35,0x2F,0x40,0x24,0xF6,	/* 2848: .p!5.@$ */
	0x70,0x21,0xE5,0x40,0x70,0x26,0xED,0x21,	/* 2850: p!@p&! */
	0x03,0x75,0x21,0x20,0x20,0x40,0x24,0xF6,	/* 2858: .u!  @$ */
	0xA7,0x20,0x41,0x70,0x26,0xEC,0x05,0x20,	/* 2860:  Ap&.  */
	0x40,0x70,0x26,0xEC,0x74,0x22,0x20,0x20,	/* 2868: @p&t"   */
	0x40,0x24,0xF6,0x24,0xA8,0x73,0x21,0x52,	/* 2870: @$$s!R */
	0xF1,0x48,0x24,0xF6,0x21,0xA5,0x75,0x22,	/* 2878: H$!u" */
	0x20,0x20,0x40,0x24,0xF6,0xA7,0x20,0x41,	/* 2880:   @$ A */
	0x70,0x26,0xEC,0x23,0x00,0x40,0x70,0x26,	/* 2888: p&#.@p& */
	0xEC,0x22,0x0A,0x75,0x22,0x20,0x20,0x40,	/* 2890: ".u"  @ */
	0x24,0xF6,0x21,0xA3,0x70,0x21,0x35,0x2F,	/* 2898: $!p!5. */
	0x40,0x24,0xF6,0x49,0x24,0xFB,0x70,0x21,	/* 28A0: @$I$p! */
	0xE5,0x42,0x70,0x26,0xED,0x0F,0x20,0x70,	/* 28A8: Bp&. p */
	0x21,0x35,0x2F,0x40,0x24,0xF6,0x70,0x21,	/* 28B0: !5.@$p! */
	0xE5,0x40,0x70,0x26,0xED,0xB1,0x22,0xF0,	/* 28B8: @p&" */
	0x60,0xBF,0x73,0x31,0xD0,0x73,0x87,0xF1,	/* 28C0: `s1s */
	0x73,0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,	/* 28C8: s2'..O$ */
	0x89,0x23,0xFB,0x73,0x87,0xF1,0x70,0x27,	/* 28D0: #sp' */
	0xEF,0x73,0x87,0xF1,0x43,0x24,0xF6,0x70,	/* 28D8: sC$p */
	0x26,0xE8,0x74,0x21,0x20,0x20,0x40,0x24,	/* 28E0: &t!  @$ */
	0xF6,0x23,0xA1,0x73,0x21,0x52,0xF1,0x48,	/* 28E8: #s!RH */
	0x24,0xF6,0x21,0xA5,0x75,0x21,0x20,0x20,	/* 28F0: $!u!   */
	0x40,0x24,0xF6,0xA7,0x20,0x42,0x70,0x26,	/* 28F8: @$ Bp& */
	0xED,0x21,0x09,0x40,0x70,0x26,0xED,0x21,	/* 2900: !.@p&! */
	0x03,0x75,0x21,0x20,0x20,0x40,0x24,0xF6,	/* 2908: .u!  @$ */
	0xA7,0x20,0x41,0x70,0x26,0xEC,0x05,0x20,	/* 2910:  Ap&.  */
	0x40,0x70,0x26,0xEC,0x74,0x22,0x20,0x20,	/* 2918: @p&t"   */
	0x40,0x24,0xF6,0x23,0xA4,0x73,0x21,0x52,	/* 2920: @$#s!R */
	0xF1,0x48,0x24,0xF6,0x21,0xA7,0x75,0x22,	/* 2928: H$!u" */
	0x20,0x20,0x40,0x24,0xF6,0xA8,0x20,0x41,	/* 2930:   @$ A */
	0x70,0x26,0xEC,0xB1,0x22,0xF0,0x40,0x70,	/* 2938: p&"@p */
	0x26,0xEC,0xB1,0x22,0xF0,0x75,0x22,0x20,	/* 2940: &"u"  */
	0x20,0x40,0x24,0xF6,0xA8,0x20,0x42,0x70,	/* 2948:  @$ Bp */
	0x26,0xED,0xB1,0x22,0xF0,0x40,0x70,0x26,	/* 2950: &"@p& */
	0xED,0xB1,0x22,0xF0,0x76,0xF6,0x20,0x82,	/* 2958: "v  */
	0x00,0x04,0x00,0x16,0x00,0x00,0x00,0x41,	/* 2960: .......A */
	0x00,0x00,0x00,0x41,0x00,0x04,0x00,0x82,	/* 2968: ...A... */
	0x00,0x03,0x00,0x41,0x00,0x03,0x00,0x82,	/* 2970: ...A... */
	0x00,0x02,0x00,0x4E,0x00,0x02,0x00,0x41,	/* 2978: ...N...A */
	0x00,0x02,0x00,0x82,0x00,0x01,0x00,0x57,	/* 2980: ......W */
	0x00,0x02,0x00,0x41,0x00,0x01,0x00,0x82,	/* 2988: ...A... */
	0x00,0x00,0x00,0x2B,0x00,0x00,0x00,0xA3,	/* 2990: ...+... */
	0x00,0x04,0x00,0x1B,0x00,0x00,0x00,0x51,	/* 2998: .......Q */
	0x00,0x00,0x00,0x51,0x00,0x04,0x00,0xA3,	/* 29A0: ...Q... */
	0x00,0x03,0x00,0x51,0x00,0x03,0x00,0xA3,	/* 29A8: ...Q... */
	0x00,0x02,0x00,0x62,0x00,0x02,0x00,0x51,	/* 29B0: ...b...Q */
	0x00,0x02,0x00,0xA3,0x00,0x01,0x00,0x6D,	/* 29B8: ......m */
	0x00,0x02,0x00,0x51,0x00,0x01,0x00,0xA3,	/* 29C0: ...Q... */
	0x00,0x00,0x00,0x36,0x00,0x00,0x00,0x36,	/* 29C8: ...6...6 */
	0x00,0x05,0x00,0x1B,0x00,0x05,0x00,0x0D,	/* 29D0: ........ */
	0x00,0x05,0x00,0xF4,0x00,0x04,0x00,0x6F,	/* 29D8: ......o */
	0x00,0x04,0x00,0x5B,0x00,0x04,0x00,0xF4,	/* 29E0: ...[... */
	0x00,0x03,0x00,0x6D,0x00,0x01,0x00,0x38,	/* 29E8: ...m...8 */
	0x00,0x00,0x00,0x31,0x00,0x00,0x00,0x29,	/* 29F0: ...1...) */
	0x00,0x00,0x00,0x62,0x00,0x05,0x00,0x53,	/* 29F8: ...b...S */
	0x00,0x05,0x00,0xD9,0x00,0x00,0x00,0x30,	/* 2A00: ......0 */
	0x00,0x05,0x00,0x6D,0x00,0x00,0x00,0x25,	/* 2A08: ...m...% */
	0x00,0x23,0x00,0x21,0x00,0x1F,0x00,0x1D,	/* 2A10: .#.!.... */
	0x00,0x1B,0x00,0x19,0x00,0x17,0x00,0x15,	/* 2A18: ........ */
	0x00,0x13,0x00,0x11,0x00,0x0F,0x00,0x0D,	/* 2A20: ........ */
	0x00,0x0B,0x00,0x09,0x00,0x07,0x00,0x05,	/* 2A28: ........ */
	0x00,0x03,0x00,0x01,0x00,0x00,0x00,0x0E,	/* 2A30: ........ */
	0x0B,0x71,0x21,0x53,0xD2,0x64,0x2E,0x47,	/* 2A38: .q!Sd.G */
	0x21,0xFB,0x72,0x22,0xE6,0x64,0x29,0x42,	/* 2A40: !r"d)B */
	0x21,0xFB,0x72,0x22,0xE4,0x64,0x28,0x44,	/* 2A48: !r"d(D */
	0x21,0xFB,0x72,0x22,0xE2,0x64,0x27,0x45,	/* 2A50: !r"d'E */
	0x21,0xFB,0x72,0x22,0xE0,0x65,0x27,0x43,	/* 2A58: !r"e'C */
	0x21,0xFB,0x72,0x21,0xEE,0x66,0x2D,0x41,	/* 2A60: !r!f-A */
	0x21,0xFB,0x72,0x21,0xEC,0x66,0x2B,0x46,	/* 2A68: !r!f+F */
	0x21,0xFB,0x72,0x21,0xEA,0x66,0x26,0x4E,	/* 2A70: !r!f&N */
	0x21,0xFB,0x72,0x21,0xE8,0x66,0x22,0x49,	/* 2A78: !r!f"I */
	0x21,0xFB,0x72,0x21,0xE6,0x68,0x24,0x40,	/* 2A80: !r!h$@ */
	0x21,0xFB,0x72,0x21,0xE4,0x68,0x23,0x45,	/* 2A88: !r!h#E */
	0x21,0xFB,0x72,0x21,0xE2,0x68,0x22,0x4A,	/* 2A90: !r!h"J */
	0x21,0xFB,0x72,0x21,0xE0,0x68,0x21,0x43,	/* 2A98: !r!h!C */
	0x21,0xFB,0x72,0xEE,0x69,0x2A,0x41,0x21,	/* 2AA0: !ri*A! */
	0xFB,0x72,0xEC,0x69,0x20,0x4D,0x21,0xFB,	/* 2AA8: ri M! */
	0x72,0xEA,0x6F,0x24,0x4B,0x21,0xFB,0x72,	/* 2AB0: ro$K!r */
	0xE8,0x6A,0x2C,0x48,0x21,0xFB,0x72,0xE6,	/* 2AB8: j,H!r */
	0x6F,0x23,0x4D,0x21,0xFB,0x72,0xE4,0x6F,	/* 2AC0: o#M!ro */
	0x23,0x46,0x21,0xFB,0x72,0xE2,0x72,0x6C,	/* 2AC8: #F!rrl */
	0x4C,0x21,0xFB,0x21,0x44,0x21,0x2A,0x25,	/* 2AD0: L!!D!*% */
	0x98,0x22,0xF0,0x60,0xBD,0x74,0x23,0x5A,	/* 2AD8: "`t#Z */
	0xD1,0x21,0x28,0x40,0xD0,0x71,0x62,0x32,	/* 2AE0: !(@qb2 */
	0x87,0xF1,0x81,0x71,0x62,0x32,0x87,0x23,	/* 2AE8: qb2# */
	0xFB,0x74,0x2B,0x95,0x70,0x57,0xF1,0x25,	/* 2AF0: t+pW% */
	0xFA,0xD2,0xAE,0x72,0x71,0x62,0x59,0xFA,	/* 2AF8: ҮrqbY */
	0x30,0xD2,0x70,0x74,0x2A,0x23,0x9A,0x29,	/* 2B00: 0pt*#) */
	0xAA,0x70,0x31,0xD2,0x70,0x34,0x41,0x24,	/* 2B08: p1p4A$ */
	0xF6,0xC0,0x23,0xAE,0x70,0x8D,0xF1,0x70,	/* 2B10: #pp */
	0x56,0xF1,0xF4,0x23,0xA5,0x70,0x34,0x41,	/* 2B18: V#p4A */
	0x24,0xFB,0x70,0xE4,0x70,0x87,0xF1,0x70,	/* 2B20: $ppp */
	0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0x89,	/* 2B28: 2'..O$ */
	0x23,0xFB,0x70,0x87,0xF1,0x72,0x27,0xEF,	/* 2B30: #pr' */
	0x70,0x87,0xF1,0x43,0x24,0xF6,0x72,0x26,	/* 2B38: pC$r& */
	0xE8,0x72,0x36,0x2F,0x4F,0x24,0xF6,0x44,	/* 2B40: r6.O$D */
	0x24,0xFB,0x72,0xE6,0x41,0x70,0x22,0x89,	/* 2B48: $rAp" */
	0x23,0xFB,0x70,0x34,0x21,0x40,0x24,0xF6,	/* 2B50: #p4!@$ */
	0x21,0xAC,0x41,0x70,0x55,0xF1,0x70,0x8B,	/* 2B58: !ApUp */
	0xF1,0xFC,0x2F,0x4F,0x24,0xF6,0x22,0x40,	/* 2B60: .O$"@ */
	0xF0,0x24,0xFF,0xF0,0xC0,0xA8,0x70,0x34,	/* 2B68: $p4 */
	0x61,0x4F,0x24,0xF6,0x70,0xE4,0x70,0x22,	/* 2B70: aO$pp" */
	0x50,0xF1,0x21,0x40,0x24,0xF6,0x22,0xA3,	/* 2B78: P!@$" */
	0x70,0x87,0xF1,0x70,0x32,0x27,0x2F,0x2F,	/* 2B80: pp2'.. */
	0x4F,0x24,0xF6,0x89,0x23,0xFB,0x70,0x87,	/* 2B88: O$#p */
	0xF1,0x72,0x27,0xEF,0x70,0x87,0xF1,0x43,	/* 2B90: r'pC */
	0x24,0xF6,0x72,0x26,0xE8,0x70,0x74,0x61,	/* 2B98: $r&pta */
	0x2B,0x25,0x94,0x70,0x21,0x37,0xD0,0x6C,	/* 2BA0: +%p!7l */
	0x0C,0x60,0xB4,0x7D,0x23,0x5A,0xD6,0x76,	/* 2BA8: .`}#Zv */
	0x30,0xD4,0x76,0x31,0xD1,0x74,0x33,0xD0,	/* 2BB0: 0v1t3 */
	0x71,0x44,0xF8,0x70,0x27,0xEF,0x70,0x26,	/* 2BB8: qDp'p& */
	0x37,0x2F,0x4F,0x24,0xF6,0x25,0xFA,0xD3,	/* 2BC0: 7.O$% */
	0x41,0x24,0xF6,0x25,0x21,0xA9,0x70,0x26,	/* 2BC8: A$%!p& */
	0x3B,0x2F,0x4F,0x24,0xF6,0x25,0xFA,0xD2,	/* 2BD0: ;.O$% */
	0x43,0x24,0xF6,0x70,0x26,0xE8,0x71,0x72,	/* 2BD8: C$p&qr */
	0x43,0x24,0xF6,0x28,0xF1,0x74,0x55,0xFA,	/* 2BE0: C$(tU */
	0x30,0xD5,0x70,0x24,0x33,0x47,0x24,0xF6,	/* 2BE8: 0p$3G$ */
	0x43,0xF4,0x2C,0xAB,0x40,0xD9,0x70,0x26,	/* 2BF0: C,@p& */
	0x32,0x2F,0x4F,0x24,0xF6,0xD8,0x70,0x26,	/* 2BF8: 2.O$p& */
	0x32,0x2F,0x4F,0x24,0xF6,0xDB,0x78,0x48,	/* 2C00: 2.O$xH */
	0x24,0xF6,0x21,0xA0,0x75,0x21,0x89,0xF1,	/* 2C08: $!u! */
	0x41,0x24,0xFB,0x75,0x21,0x89,0x23,0xFB,	/* 2C10: A$u!# */
	0x41,0x76,0x62,0xE7,0x78,0x47,0x24,0xF6,	/* 2C18: AvbxG$ */
	0xAD,0x75,0x21,0x50,0xF1,0x28,0x40,0x24,	/* 2C20: u!P(@$ */
	0xF6,0xA4,0x41,0x76,0x62,0xE7,0x78,0x41,	/* 2C28: AvbxA */
	0x24,0xF6,0xA8,0x75,0x21,0x3E,0x41,0xF2,	/* 2C30: $u!>A */
	0x75,0x21,0xEE,0x78,0x42,0x24,0xF6,0xAA,	/* 2C38: u!xB$ */
	0x75,0x21,0x3C,0x41,0xF2,0x75,0x21,0xEC,	/* 2C40: u!<Au! */
	0x41,0xD9,0x78,0x44,0x24,0xF6,0xAA,0x75,	/* 2C48: AxD$u */
	0x21,0x3D,0x41,0xF2,0x75,0x21,0xED,0x41,	/* 2C50: !=Au!A */
	0xD9,0x79,0x24,0x28,0xA2,0x75,0x21,0x50,	/* 2C58: y$(u!P */
	0xF1,0x24,0x40,0x24,0xF6,0xA5,0x75,0x22,	/* 2C60: $@$u" */
	0x8B,0xF1,0xDB,0x75,0x55,0xF1,0xD8,0x75,	/* 2C68: uUu */
	0x8B,0xF1,0x25,0xFA,0xD9,0x78,0x81,0xFC,	/* 2C70: %x */
	0x2F,0x4F,0x24,0xF6,0x25,0xFA,0xDA,0x24,	/* 2C78: .O$%$ */
	0x25,0xA5,0x7B,0x78,0x2F,0x4F,0x24,0xF6,	/* 2C80: %{x.O$ */
	0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,0x81,	/* 2C88: u+P#x */
	0x75,0x55,0x23,0xFB,0x79,0x78,0x81,0x81,	/* 2C90: uU#yx */
	0xFC,0x2F,0x4F,0x24,0xF6,0xD7,0x75,0x34,	/* 2C98: .O$u4 */
	0x48,0x24,0xF6,0x24,0x23,0xA9,0x7A,0x21,	/* 2CA0: H$$#z! */
	0x4F,0xF9,0x24,0x23,0xA2,0x22,0x40,0x77,	/* 2CA8: O$#"@w */
	0xF9,0x24,0x22,0xAB,0x75,0x34,0x21,0x40,	/* 2CB0: $"u4!@ */
	0x24,0xFB,0x75,0xE4,0x24,0x22,0x00,0x75,	/* 2CB8: $u$".u */
	0x34,0x21,0x40,0x24,0xF6,0xC0,0x24,0x20,	/* 2CC0: 4!@$$  */
	0xA0,0x75,0x22,0x87,0xF1,0xC0,0xAC,0x75,	/* 2CC8: u"u */
	0x21,0x54,0xF1,0x41,0x24,0xFB,0x75,0x21,	/* 2CD0: !TA$u! */
	0x54,0x23,0xFB,0x75,0x55,0xF1,0xD8,0x75,	/* 2CD8: T#uUu */
	0x8B,0xF1,0x25,0xFA,0xD9,0x78,0x81,0xFC,	/* 2CE0: %x */
	0x2F,0x4F,0x24,0xF6,0xDA,0x70,0x3E,0x2F,	/* 2CE8: .O$p>. */
	0x4F,0x24,0xF6,0xD7,0x7A,0x77,0xF9,0xA3,	/* 2CF0: O$zw */
	0x77,0xDB,0x02,0x7A,0xDB,0x77,0x7B,0x2F,	/* 2CF8: w.zw{. */
	0x4F,0x24,0xF6,0xFC,0x2F,0x4F,0x24,0xF6,	/* 2D00: O$.O$ */
	0xD7,0x7B,0x2F,0x4F,0x24,0xF6,0x41,0xF4,	/* 2D08: {.O$A */
	0xDB,0x41,0x22,0x40,0x7B,0x24,0xFF,0xF0,	/* 2D10: A"@{$ */
	0xC0,0x23,0x26,0xA3,0x7B,0x42,0x21,0xFB,	/* 2D18: #&{B! */
	0x28,0xF1,0xF6,0x23,0x24,0x02,0x20,0x23,	/* 2D20: (#$. # */
	0x22,0x07,0x20,0x23,0x20,0x0C,0x20,0x22,	/* 2D28: ". # . " */
	0x2F,0x01,0x20,0x22,0x2D,0x06,0x20,0x22,	/* 2D30: .. "-. " */
	0x2B,0x0B,0x20,0x22,0x2A,0x00,0x20,0x22,	/* 2D38: +. "*. " */
	0x28,0x05,0x20,0x22,0x26,0x0A,0x20,0x22,	/* 2D40: (. "&. " */
	0x24,0x0F,0x20,0x22,0x23,0x04,0x20,0x22,	/* 2D48: $. "#. " */
	0x21,0x09,0x20,0x21,0x2F,0x0E,0x20,0x21,	/* 2D50: !. !.. ! */
	0x2E,0x03,0x20,0x21,0x2C,0x08,0x20,0x21,	/* 2D58: .. !,. ! */
	0x2A,0x0D,0x20,0x21,0x29,0x02,0x20,0x21,	/* 2D60: *. !). ! */
	0x27,0x07,0x20,0x21,0x25,0x0C,0x20,0x21,	/* 2D68: '. !%. ! */
	0x24,0x01,0x20,0x21,0x22,0x06,0x20,0x21,	/* 2D70: $. !". ! */
	0x20,0x0B,0x20,0x2F,0x01,0x20,0x20,0x2D,	/* 2D78:  . ..  - */
	0x06,0x20,0x20,0x2B,0x0B,0x20,0x20,0x2A,	/* 2D80: .  +.  * */
	0x00,0x20,0x20,0x28,0x05,0x20,0x20,0x26,	/* 2D88: .  (.  & */
	0x0A,0x20,0x20,0x24,0x0F,0x20,0x20,0x23,	/* 2D90: .  $.  # */
	0x04,0x20,0x20,0x21,0x09,0x20,0x20,0x78,	/* 2D98: .  !.  x */
	0xDB,0x78,0x81,0xD8,0x70,0x26,0x32,0x2F,	/* 2DA0: xp&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 2DA8: O${.O$ */
	0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,	/* 2DB0: u+P#x */
	0x78,0x81,0xD8,0x70,0x26,0x32,0x2F,0x4F,	/* 2DB8: xp&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,	/* 2DC0: ${.O$u */
	0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,	/* 2DC8: +P#xx */
	0x81,0xD8,0x70,0x26,0x32,0x2F,0x4F,0x24,	/* 2DD0: p&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,	/* 2DD8: {.O$u+ */
	0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,	/* 2DE0: P#xx */
	0xD8,0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 2DE8: p&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,	/* 2DF0: {.O$u+P */
	0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,	/* 2DF8: #xx */
	0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 2E00: p&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,	/* 2E08: .O$u+P */
	0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,	/* 2E10: #xxp */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 2E18: &2.O${. */
	0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,	/* 2E20: O$u+P# */
	0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,0x26,	/* 2E28: xxp& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 2E30: 2.O${.O */
	0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,	/* 2E38: $u+P# */
	0x78,0xDB,0x78,0x81,0xD8,0x70,0x26,0x32,	/* 2E40: xxp&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 2E48: .O${.O$ */
	0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,	/* 2E50: u+P#x */
	0xDB,0x78,0x81,0xD8,0x70,0x26,0x32,0x2F,	/* 2E58: xp&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 2E60: O${.O$ */
	0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,	/* 2E68: u+P#x */
	0x78,0x81,0xD8,0x70,0x26,0x32,0x2F,0x4F,	/* 2E70: xp&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,	/* 2E78: ${.O$u */
	0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,	/* 2E80: +P#xx */
	0x81,0xD8,0x70,0x26,0x32,0x2F,0x4F,0x24,	/* 2E88: p&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,	/* 2E90: {.O$u+ */
	0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,	/* 2E98: P#xx */
	0xD8,0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 2EA0: p&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,	/* 2EA8: {.O$u+P */
	0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,	/* 2EB0: #xx */
	0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 2EB8: p&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,	/* 2EC0: .O$u+P */
	0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,	/* 2EC8: #xxp */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 2ED0: &2.O${. */
	0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,	/* 2ED8: O$u+P# */
	0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,0x26,	/* 2EE0: xxp& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 2EE8: 2.O${.O */
	0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,	/* 2EF0: $u+P# */
	0x78,0xDB,0x78,0x81,0xD8,0x70,0x26,0x32,	/* 2EF8: xxp&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 2F00: .O${.O$ */
	0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,	/* 2F08: u+P#x */
	0xDB,0x78,0x81,0xD8,0x70,0x26,0x32,0x2F,	/* 2F10: xp&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 2F18: O${.O$ */
	0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,	/* 2F20: u+P#x */
	0x78,0x81,0xD8,0x70,0x26,0x32,0x2F,0x4F,	/* 2F28: xp&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,	/* 2F30: ${.O$u */
	0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,	/* 2F38: +P#xx */
	0x81,0xD8,0x70,0x26,0x32,0x2F,0x4F,0x24,	/* 2F40: p&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,	/* 2F48: {.O$u+ */
	0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,	/* 2F50: P#xx */
	0xD8,0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 2F58: p&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,	/* 2F60: {.O$u+P */
	0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,	/* 2F68: #xx */
	0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 2F70: p&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,	/* 2F78: .O$u+P */
	0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,	/* 2F80: #xxp */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 2F88: &2.O${. */
	0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,	/* 2F90: O$u+P# */
	0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,0x26,	/* 2F98: xxp& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 2FA0: 2.O${.O */
	0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,	/* 2FA8: $u+P# */
	0x78,0xDB,0x78,0x81,0xD8,0x70,0x26,0x32,	/* 2FB0: xxp&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 2FB8: .O${.O$ */
	0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,	/* 2FC0: u+P#x */
	0xDB,0x78,0x81,0xD8,0x70,0x26,0x32,0x2F,	/* 2FC8: xp&2. */
	0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,	/* 2FD0: O${.O$ */
	0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,	/* 2FD8: u+P#x */
	0x78,0x81,0xD8,0x70,0x26,0x32,0x2F,0x4F,	/* 2FE0: xp&2.O */
	0x24,0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,	/* 2FE8: ${.O$u */
	0x2B,0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,	/* 2FF0: +P#xx */
	0x81,0xD8,0x70,0x26,0x32,0x2F,0x4F,0x24,	/* 2FF8: p&2.O$ */
	0xF6,0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,	/* 3000: {.O$u+ */
	0x50,0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,	/* 3008: P#xx */
	0xD8,0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,	/* 3010: p&2.O$ */
	0x7B,0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,	/* 3018: {.O$u+P */
	0xF2,0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,	/* 3020: #xx */
	0x70,0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,	/* 3028: p&2.O${ */
	0x2F,0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,	/* 3030: .O$u+P */
	0x23,0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,	/* 3038: #xxp */
	0x26,0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,	/* 3040: &2.O${. */
	0x4F,0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,	/* 3048: O$u+P# */
	0xFB,0x78,0xDB,0x78,0x81,0xD8,0x70,0x26,	/* 3050: xxp& */
	0x32,0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,	/* 3058: 2.O${.O */
	0x24,0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,	/* 3060: $u+P# */
	0x78,0xDB,0x78,0x81,0xD8,0x70,0x26,0x32,	/* 3068: xxp&2 */
	0x2F,0x4F,0x24,0xF6,0x7B,0x2F,0x4F,0x24,	/* 3070: .O${.O$ */
	0xF6,0x75,0x2B,0x50,0xF2,0x23,0xFB,0x78,	/* 3078: u+P#x */
	0x75,0x55,0x23,0xFB,0x77,0x75,0x21,0x3F,	/* 3080: uU#wu!? */
	0xF2,0x75,0x21,0xEF,0x77,0x77,0x60,0x8F,	/* 3088: u!ww` */
	0xD7,0x2F,0x4F,0x24,0xF6,0x21,0xA0,0x70,	/* 3090: .O$!p */
	0x26,0x32,0x77,0x77,0x60,0x8F,0xD7,0x2F,	/* 3098: &2ww`. */
	0x4F,0x24,0xF6,0xA3,0x20,0x60,0x00,0x79,	/* 30A0: O$ `.y */
	0x78,0x81,0xFC,0x2F,0x4F,0x24,0xF6,0xD7,	/* 30A8: x.O$ */
	0x75,0x34,0x48,0x24,0xF6,0x21,0xA2,0x7A,	/* 30B0: u4H$!z */
	0x21,0x4F,0xF9,0xAD,0x22,0x40,0x77,0xF9,	/* 30B8: !O"@w */
	0xA8,0x75,0x34,0x21,0x40,0x24,0xFB,0x75,	/* 30C0: u4!@$u */
	0xE4,0x41,0x76,0x62,0xE8,0x72,0x23,0x4F,	/* 30C8: Avbr#O */
	0x24,0xF6,0x70,0x26,0xEB,0x21,0x00,0x77,	/* 30D0: $p&!.w */
	0x75,0x21,0x3F,0xF2,0x75,0x21,0xEF,0x72,	/* 30D8: u!?u!r */
	0x23,0x4F,0x24,0xF6,0x70,0x26,0xEB,0x73,	/* 30E0: #O$p&s */
	0x42,0x24,0xF6,0x23,0x2B,0xAE,0x70,0x26,	/* 30E8: B$#+p& */
	0x3A,0x2F,0x4F,0x24,0xF6,0x25,0xFA,0xD2,	/* 30F0: :.O$% */
	0x43,0x24,0xF6,0x70,0x26,0xE8,0x71,0x72,	/* 30F8: C$p&qr */
	0x43,0x24,0xF6,0x28,0xF1,0x74,0x55,0xFA,	/* 3100: C$(tU */
	0x30,0x25,0xFA,0xD5,0x22,0x87,0xF1,0xC0,	/* 3108: 0%" */
	0xAC,0x75,0x21,0x54,0xF1,0x42,0x24,0xFB,	/* 3110: u!TB$ */
	0x75,0x21,0x54,0x23,0xFB,0x75,0x23,0x85,	/* 3118: u!T#u# */
	0xF1,0xA9,0x75,0x7D,0x61,0x24,0x2F,0x96,	/* 3120: u}a$. */
	0x23,0x27,0x09,0x75,0x8D,0xF1,0xD9,0x75,	/* 3128: #'.uu */
	0x56,0xF1,0xD8,0x75,0x34,0x21,0x20,0x40,	/* 3130: Vu4! @ */
	0x24,0xF6,0x22,0xA2,0x75,0x34,0x61,0x2F,	/* 3138: $"u4a. */
	0x4F,0x24,0xF6,0x75,0xE4,0x75,0x34,0x22,	/* 3140: O$uu4" */
	0x20,0x40,0x24,0xFB,0x75,0xE4,0x75,0x34,	/* 3148:  @$uu4 */
	0x60,0x4E,0x24,0xF6,0x75,0xE4,0x70,0x36,	/* 3150: `N$up6 */
	0x2F,0x49,0x24,0xF6,0x70,0xE6,0x79,0x78,	/* 3158: .I$pyx */
	0xFC,0x2F,0x4F,0x24,0xF6,0x25,0xFA,0xD7,	/* 3160: .O$% */
	0x75,0x21,0x55,0xF1,0xF9,0xA6,0x75,0x21,	/* 3168: u!Uu! */
	0x55,0xF1,0xDA,0x02,0x77,0xDA,0x7A,0x2F,	/* 3170: U.wz. */
	0x4F,0x24,0xF6,0x41,0xF4,0xDA,0x41,0x22,	/* 3178: O$AA" */
	0x40,0x7A,0x24,0xFF,0xF0,0xC0,0x22,0x2C,	/* 3180: @z$", */
	0xA3,0x7A,0x42,0x21,0xFB,0x28,0xF1,0xF6,	/* 3188: zB!( */
	0x22,0x2A,0x07,0x20,0x22,0x29,0x01,0x20,	/* 3190: "*. ").  */
	0x22,0x27,0x0B,0x20,0x22,0x26,0x05,0x20,	/* 3198: "'. "&.  */
	0x22,0x24,0x0F,0x20,0x22,0x23,0x09,0x20,	/* 31A0: "$. "#.  */
	0x22,0x22,0x03,0x20,0x22,0x20,0x0D,0x20,	/* 31A8: "". " .  */
	0x21,0x2F,0x07,0x20,0x21,0x2E,0x01,0x20,	/* 31B0: !.. !..  */
	0x21,0x2C,0x0B,0x20,0x21,0x2B,0x05,0x20,	/* 31B8: !,. !+.  */
	0x21,0x29,0x0F,0x20,0x21,0x28,0x09,0x20,	/* 31C0: !). !(.  */
	0x21,0x27,0x03,0x20,0x21,0x25,0x0D,0x20,	/* 31C8: !'. !%.  */
	0x21,0x24,0x07,0x20,0x21,0x23,0x01,0x20,	/* 31D0: !$. !#.  */
	0x21,0x21,0x0B,0x20,0x21,0x20,0x05,0x20,	/* 31D8: !!. ! .  */
	0x2F,0x00,0x20,0x20,0x2D,0x0A,0x20,0x20,	/* 31E0: ..  -.   */
	0x2C,0x04,0x20,0x20,0x2A,0x0E,0x20,0x20,	/* 31E8: ,.  *.   */
	0x29,0x08,0x20,0x20,0x28,0x02,0x20,0x20,	/* 31F0: ).  (.   */
	0x26,0x0C,0x20,0x20,0x25,0x06,0x20,0x20,	/* 31F8: &.  %.   */
	0x24,0x00,0x20,0x20,0x22,0x0A,0x20,0x20,	/* 3200: $.  ".   */
	0x21,0x04,0x20,0x20,0x78,0xDA,0x78,0x81,	/* 3208: !.  xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 3210: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 3218: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 3220: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 3228: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 3230: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 3238: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 3240: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 3248: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 3250: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 3258: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 3260: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 3268: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 3270: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 3278: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 3280: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 3288: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 3290: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 3298: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 32A0: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 32A8: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 32B0: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 32B8: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 32C0: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 32C8: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 32D0: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 32D8: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 32E0: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 32E8: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 32F0: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 32F8: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 3300: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 3308: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 3310: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 3318: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 3320: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 3328: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 3330: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 3338: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 3340: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 3348: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 3350: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 3358: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 3360: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 3368: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 3370: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 3378: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 3380: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 3388: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 3390: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 3398: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 33A0: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 33A8: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 33B0: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 33B8: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 33C0: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 33C8: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 33D0: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 33D8: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 33E0: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 33E8: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 33F0: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 33F8: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x78,0xDA,0x78,0x81,	/* 3400: p&xx */
	0xD8,0x75,0x23,0x50,0x7A,0x2F,0x4F,0x24,	/* 3408: u#Pz.O$ */
	0xF6,0xF2,0xF1,0x70,0x26,0xE3,0x78,0xDA,	/* 3410: p&x */
	0x78,0x81,0xD8,0x75,0x23,0x50,0x7A,0x2F,	/* 3418: xu#Pz. */
	0x4F,0x24,0xF6,0xF2,0xF1,0x70,0x26,0xE3,	/* 3420: O$p& */
	0x78,0xDA,0x78,0x81,0xD8,0x75,0x23,0x50,	/* 3428: xxu#P */
	0x7A,0x2F,0x4F,0x24,0xF6,0xF2,0xF1,0x70,	/* 3430: z.O$p */
	0x26,0xE3,0x78,0xDA,0x78,0x81,0xD8,0x75,	/* 3438: &xxu */
	0x23,0x50,0x7A,0x2F,0x4F,0x24,0xF6,0xF2,	/* 3440: #Pz.O$ */
	0xF1,0x70,0x26,0xE3,0x79,0x78,0xFC,0x2F,	/* 3448: p&yx. */
	0x4F,0x24,0xF6,0xD9,0x78,0x75,0x56,0x23,	/* 3450: O$xuV# */
	0xFB,0x77,0x2C,0x40,0xF9,0x21,0xA0,0x2C,	/* 3458: w,@!, */
	0x41,0x79,0xF9,0xAB,0x75,0x34,0x28,0x20,	/* 3460: Ayu4(  */
	0x40,0x24,0xFB,0x75,0xE4,0x22,0x01,0x77,	/* 3468: @$u".w */
	0x24,0x40,0xF9,0x21,0xAB,0x24,0x41,0x79,	/* 3470: $@!$Ay */
	0xF9,0x21,0xA5,0x75,0x34,0x28,0x20,0x40,	/* 3478: !u4( @ */
	0x24,0xF6,0xAD,0x75,0x34,0x68,0x2F,0x4F,	/* 3480: $u4h.O */
	0x24,0xF6,0x75,0xE4,0x41,0x76,0x62,0xE7,	/* 3488: $uAvb */
	0x79,0xC0,0x21,0xA0,0x75,0x34,0x60,0x4E,	/* 3490: y!u4`N */
	0x24,0xF6,0x75,0xE4,0x70,0x36,0x2F,0x49,	/* 3498: $up6.I */
	0x24,0xF6,0x70,0xE6,0x72,0x23,0x4F,0x24,	/* 34A0: $pr#O$ */
	0xF6,0x70,0x26,0xEA,0x73,0x44,0x24,0xF6,	/* 34A8: p&sD$ */
	0x25,0xA3,0x70,0x26,0x39,0x2F,0x4F,0x24,	/* 34B0: %p&9.O$ */
	0xF6,0x25,0xFA,0xD2,0x43,0x24,0xF6,0x70,	/* 34B8: %C$p */
	0x26,0xE8,0x71,0x72,0x43,0x24,0xF6,0x28,	/* 34C0: &qrC$( */
	0xF1,0x74,0x55,0xFA,0x30,0x25,0xFA,0xD5,	/* 34C8: tU0% */
	0x7D,0x61,0x22,0x22,0x92,0x75,0x7D,0x61,	/* 34D0: }a""u}a */
	0x23,0x28,0x96,0x75,0x22,0x87,0xF1,0xC0,	/* 34D8: #(u" */
	0xAC,0x75,0x21,0x54,0xF1,0x44,0x24,0xFB,	/* 34E0: u!TD$ */
	0x75,0x21,0x54,0x23,0xFB,0x41,0x76,0x62,	/* 34E8: u!T#Avb */
	0xE7,0x75,0x21,0x89,0xF1,0x42,0x24,0xFB,	/* 34F0: u!B$ */
	0x75,0x21,0x89,0x23,0xFB,0x72,0x23,0x4F,	/* 34F8: u!#r#O */
	0x24,0xF6,0x70,0x26,0xE9,0x71,0x81,0x2F,	/* 3500: $p&q. */
	0x4F,0x24,0xF6,0x25,0xFA,0xD1,0x41,0xF9,	/* 3508: O$%A */
	0x21,0xA2,0x40,0xD1,0x74,0x30,0xAA,0x74,	/* 3510: !@t0t */
	0x30,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0xD4,	/* 3518: 0'..O$ */
	0x03,0x28,0x40,0xD4,0x73,0xC0,0x21,0xA0,	/* 3520: .(@s! */
	0x74,0x76,0x30,0xF4,0xC0,0x69,0x28,0xA5,	/* 3528: tv0i( */
	0x71,0x76,0x31,0xF4,0xA3,0x69,0x27,0x0D,	/* 3530: qv1i'. */
	0x74,0x76,0xE0,0x71,0x76,0xE1,0xBC,0x22,	/* 3538: tvqv" */
	0xF0,0x76,0xF6,0x80,0x20,0x5C,0x08,0x71,	/* 3540: v \.q */
	0x23,0x5A,0xD2,0x60,0x44,0x21,0xFB,0x72,	/* 3548: #Z`D!r */
	0x41,0x24,0xFA,0x22,0xF0,0x60,0xBF,0x73,	/* 3550: A$"`s */
	0x31,0x21,0x20,0x20,0x40,0x24,0xFB,0x25,	/* 3558: 1!  @$% */
	0xFA,0xD0,0x21,0x40,0x24,0xF6,0x21,0xA2,	/* 3560: !@$! */
	0x70,0x61,0x4F,0x24,0xF6,0x3D,0x2F,0x4F,	/* 3568: paO$=.O */
	0x24,0xF6,0x23,0xF2,0x41,0x24,0xF0,0xB1,	/* 3570: $#A$ */
	0x22,0xF0,0x70,0x61,0x4F,0x24,0xF6,0x3D,	/* 3578: "paO$= */
	0x2F,0x4F,0x24,0xF6,0x23,0xF2,0x41,0x24,	/* 3580: .O$#A$ */
	0xF1,0xB1,0x22,0xF0,0x60,0xBE,0x74,0x31,	/* 3588: "`t1 */
	0x21,0x20,0x20,0x40,0x24,0xFB,0xD1,0x74,	/* 3590: !  @$t */
	0x32,0x27,0x2F,0x2F,0x4F,0x24,0xF6,0xD0,	/* 3598: 2'..O$ */
	0x75,0x41,0xF4,0xAF,0x74,0x8F,0xF1,0x23,	/* 35A0: uAt# */
	0xF2,0x70,0x52,0xF1,0x24,0xF6,0x70,0x52,	/* 35A8: pR$pR */
	0x23,0xFB,0x0C,0x70,0x52,0xF1,0x74,0x8F,	/* 35B0: #.pRt */
	0xF1,0x24,0xFB,0x70,0x52,0x23,0xFB,0x70,	/* 35B8: $pR#p */
	0x52,0xF1,0x23,0xF2,0x71,0x6F,0x40,0x24,	/* 35C0: R#qo@$ */
	0xF6,0x28,0x40,0x24,0xFB,0xE0,0xB2,0x22,	/* 35C8: (@$" */
	0xF0,0x60,0xB8,0x7A,0x31,0x21,0x20,0x20,	/* 35D0: `z1!   */
	0x40,0x24,0xFB,0xD2,0x7A,0x55,0xF1,0xD4,	/* 35D8: @$zU */
	0x7A,0x8B,0xF1,0xD6,0x74,0x76,0xFC,0x2F,	/* 35E0: ztv. */
	0x4F,0x24,0xF6,0xD7,0x7C,0x30,0xD3,0x7A,	/* 35E8: O$|0z */
	0x22,0x81,0xF1,0xD5,0x40,0xD1,0x24,0x40,	/* 35F0: "@$@ */
	0x72,0xE2,0x72,0x33,0x2F,0x4F,0x24,0xF6,	/* 35F8: rr3.O$ */
	0x7A,0x22,0x83,0xF1,0x24,0xF6,0x25,0xFA,	/* 3600: z"$% */
	0xD0,0xC0,0x23,0xAD,0x7B,0x28,0x40,0x24,	/* 3608: #{(@$ */
	0xF6,0x23,0xA6,0x75,0x41,0x24,0xF6,0xA4,	/* 3610: #uA$ */
	0x41,0xD1,0x22,0x0D,0x75,0x42,0x24,0xF6,	/* 3618: A".uB$ */
	0x21,0xA4,0x7A,0x21,0x89,0xF1,0x41,0x24,	/* 3620: !z!A$ */
	0xFB,0x7A,0x21,0x89,0x23,0xFB,0x41,0x79,	/* 3628: z!#Ay */
	0x21,0xE1,0x41,0xD1,0x21,0x03,0x74,0xD1,	/* 3630: !A!.t */
	0x74,0x81,0xD4,0x40,0x71,0x2F,0x4F,0x24,	/* 3638: t@q.O$ */
	0xF6,0x7A,0x2B,0x50,0xF2,0x23,0xFB,0x41,	/* 3640: z+P#A */
	0xD1,0x73,0x42,0x24,0xF6,0x26,0xAF,0x73,	/* 3648: sB$&s */
	0x44,0x24,0xF6,0xAE,0x73,0x41,0x24,0xF6,	/* 3650: D$sA$ */
	0xC0,0x21,0xAB,0x7A,0x58,0xF1,0x70,0xF4,	/* 3658: !zXp */
	0x21,0xA4,0x7A,0x58,0xF1,0x70,0xF4,0xC0,	/* 3660: !zXp */
	0x23,0xA6,0x7A,0x21,0x81,0xF1,0x70,0xF4,	/* 3668: #z!p */
	0x22,0xAE,0x41,0xD1,0x22,0x0A,0x73,0x60,	/* 3670: "A".s` */
	0x4B,0x24,0xF6,0x25,0xFA,0xD3,0x24,0x25,	/* 3678: K$%$% */
	0x40,0x24,0xF6,0xC0,0xAA,0x7A,0x31,0x21,	/* 3680: @$z1! */
	0x20,0x20,0x40,0x24,0xFB,0x7A,0xE1,0x7A,	/* 3688:   @$zz */
	0x58,0xF1,0x70,0xF4,0xA9,0x7A,0x21,0x81,	/* 3690: Xpz! */
	0xF1,0x70,0xF4,0xC0,0xA3,0x20,0x41,0xD1,	/* 3698: p A */
	0x7A,0x21,0x81,0xF1,0x70,0xF4,0xC0,0x21,	/* 36A0: z!p! */
	0xA5,0x71,0xC0,0x21,0xA1,0x73,0x44,0x24,	/* 36A8: q!sD$ */
	0xFB,0xD3,0x7A,0x31,0x61,0x2F,0x2F,0x4F,	/* 36B0: z1a..O */
	0x24,0xF6,0x7A,0xE1,0x41,0xD1,0x7B,0x27,	/* 36B8: $zA{' */
	0x40,0x24,0xF6,0x26,0xA4,0x71,0xC0,0x26,	/* 36C0: @$&q& */
	0xA0,0x73,0x67,0x20,0x20,0x40,0x24,0xF6,	/* 36C8: sg  @$ */
	0x25,0xA7,0x75,0x48,0x24,0xF6,0xA5,0x20,	/* 36D0: %uH$  */
	0x41,0xD1,0x27,0x0D,0x75,0x44,0x24,0xF6,	/* 36D8: A'.uD$ */
	0x23,0xA2,0x2F,0x4F,0x74,0x2F,0x4F,0x24,	/* 36E0: #.Ot.O$ */
	0xF6,0x7A,0x2B,0x50,0xF2,0x23,0xFB,0x40,	/* 36E8: z+P#@ */
	0x74,0x81,0x2F,0x4F,0x24,0xF6,0x7A,0x2B,	/* 36F0: t.O$z+ */
	0x50,0xF2,0x23,0xFB,0x74,0x81,0x81,0x25,	/* 36F8: P#t% */
	0xFA,0xD1,0x81,0xD4,0x70,0x71,0x2F,0x4F,	/* 3700: сpq.O */
	0x24,0xF6,0x7A,0x2B,0x50,0xF2,0x23,0xFB,	/* 3708: $z+P# */
	0x41,0xD1,0x24,0x05,0x74,0xD1,0x74,0x81,	/* 3710: A$.tt */
	0xD4,0x40,0x71,0x2F,0x4F,0x24,0xF6,0x7A,	/* 3718: @q.O$z */
	0x2B,0x50,0xF2,0x23,0xFB,0x41,0xD1,0x23,	/* 3720: +P#A# */
	0x00,0x70,0x2F,0x4F,0xF4,0xC0,0x22,0xA9,	/* 3728: .p.O" */
	0x75,0x44,0x24,0xF6,0x22,0xA3,0x2F,0x4F,	/* 3730: uD$".O */
	0x74,0x2F,0x4F,0x24,0xF6,0x7A,0x2B,0x50,	/* 3738: t.O$z+P */
	0xF2,0x23,0xFB,0x74,0x81,0x25,0xFA,0xD1,	/* 3740: #t% */
	0x81,0xD4,0x2F,0x4F,0x71,0x2F,0x4F,0x24,	/* 3748: .Oq.O$ */
	0xF6,0x7A,0x2B,0x50,0xF2,0x23,0xFB,0x41,	/* 3750: z+P#A */
	0xD1,0x71,0xC0,0x22,0xA6,0x41,0x74,0x76,	/* 3758: q"Atv */
	0xFC,0x2F,0x4F,0x24,0xF6,0x2F,0x4E,0xF0,	/* 3760: .O$.N */
	0x24,0xFF,0xF0,0xC0,0x21,0xA5,0x74,0xD1,	/* 3768: $!t */
	0x74,0x81,0xD4,0x70,0x71,0x2F,0x4F,0x24,	/* 3770: tpq.O$ */
	0xF6,0x7A,0x2B,0x50,0xF2,0x23,0xFB,0x41,	/* 3778: z+P#A */
	0x79,0x21,0xE2,0x72,0x31,0x2F,0x4F,0x24,	/* 3780: y!r1.O$ */
	0xF6,0x25,0xFA,0xDB,0x41,0x24,0xF6,0xA3,	/* 3788: %A$ */
	0x61,0x26,0x01,0x2C,0x40,0x77,0xF9,0x25,	/* 3790: a&.,@w% */
	0xAB,0x41,0x74,0x76,0xFC,0x2F,0x4F,0x24,	/* 3798: Atv.O$ */
	0xF6,0x2B,0x4F,0x24,0xFF,0xF0,0xC0,0x24,	/* 37A0: +O$$ */
	0xAB,0x73,0x48,0x24,0xF6,0x24,0xA5,0x7A,	/* 37A8: sH$$z */
	0x21,0x58,0xF1,0x48,0x24,0xF6,0x21,0xAE,	/* 37B0: !XH$! */
	0x73,0x22,0x40,0x24,0xF6,0xA8,0x73,0x64,	/* 37B8: s"@$sd */
	0x4F,0x24,0xF6,0xD3,0x21,0x00,0x73,0x2D,	/* 37C0: O$!.s- */
	0x40,0x24,0xFB,0xD3,0x7A,0x31,0x61,0x2F,	/* 37C8: @$z1a. */
	0x2F,0x4F,0x24,0xF6,0x7A,0xE1,0x7A,0x23,	/* 37D0: .O$zz# */
	0x81,0xF1,0x28,0x40,0x24,0xF6,0x21,0xA4,	/* 37D8: (@$! */
	0x29,0x40,0x72,0xE2,0x73,0x21,0x40,0x24,	/* 37E0: )@rs!@$ */
	0xFB,0xD3,0x7A,0x31,0x61,0x2F,0x2F,0x4F,	/* 37E8: z1a..O */
	0x24,0xF6,0x7A,0xE1,0x74,0x7A,0x55,0x23,	/* 37F0: $ztzU# */
	0xFB,0x73,0x7C,0xE0,0xB8,0x22,0xF0,0x60,	/* 37F8: s|"` */
	0xB8,0x79,0x23,0x5C,0xD5,0x21,0x28,0x40,	/* 3800: y#\!(@ */
	0xD1,0x71,0x21,0x37,0x25,0xFA,0xD1,0x57,	/* 3808: q!7%W */
	0xF1,0x25,0xFA,0xD0,0xAC,0x70,0x75,0xFA,	/* 3810: %Ьpu */
	0x30,0xD0,0x71,0x79,0x25,0x25,0x9F,0x61,	/* 3818: 0qy%%a */
	0xA8,0x71,0x31,0x25,0xFA,0xD2,0x21,0x20,	/* 3820: q1%!  */
	0x20,0x40,0x24,0xF6,0x27,0xAB,0x72,0x31,	/* 3828:  @$'r1 */
	0x2F,0x4F,0x24,0xF6,0x25,0xFA,0xD3,0x44,	/* 3830: .O$%D */
	0x24,0xF6,0x25,0xAA,0x71,0x56,0xF1,0xD0,	/* 3838: $%qV */
	0x71,0x8D,0xF1,0x70,0xF4,0x25,0xFA,0xD6,	/* 3840: qp% */
	0x24,0xAC,0x70,0x71,0x23,0x50,0xF2,0xF1,	/* 3848: $pq#P */
	0x72,0xE3,0x70,0x41,0xF2,0x71,0x56,0x23,	/* 3850: rpAqV# */
	0xFB,0x76,0x23,0x4F,0x24,0xF6,0xC0,0x23,	/* 3858: v#O$# */
	0xA5,0x76,0x2F,0x4F,0x24,0xF6,0x2C,0x40,	/* 3860: v.O$,@ */
	0xF4,0x22,0xA2,0x76,0x2F,0x4F,0x24,0xF6,	/* 3868: "v.O$ */
	0x24,0x40,0xF4,0xC0,0x22,0xA0,0x71,0x34,	/* 3870: $@"q4 */
	0x28,0x20,0x40,0x24,0xF6,0x21,0xA7,0x71,	/* 3878: ( @$!q */
	0x34,0x68,0x2F,0x4F,0x24,0xF6,0x71,0xE4,	/* 3880: 4h.O$q */
	0x41,0x75,0x62,0xE5,0x09,0x71,0x34,0x28,	/* 3888: Aub.q4( */
	0x20,0x40,0x24,0xFB,0x71,0xE4,0x73,0x41,	/* 3890:  @$qsA */
	0x24,0xF6,0x21,0x25,0xA7,0x71,0x54,0xD0,	/* 3898: $!%qT */
	0x73,0x71,0x79,0x62,0x22,0x9B,0x21,0x24,	/* 38A0: sqyb"!$ */
	0x0B,0x71,0x34,0xD4,0x72,0x21,0x20,0x20,	/* 38A8: .q4r!   */
	0x40,0x24,0xFB,0x25,0xFA,0xD2,0x31,0x2F,	/* 38B0: @$%1. */
	0x4F,0x24,0xF6,0x25,0xFA,0xD3,0x44,0x24,	/* 38B8: O$%D$ */
	0xF6,0x2C,0xA7,0x74,0x24,0x40,0x24,0xF6,	/* 38C0: ,t$@$ */
	0x22,0xA9,0x74,0x28,0x40,0x24,0xF6,0x21,	/* 38C8: "t(@$! */
	0xA5,0x71,0x21,0x83,0xF1,0x72,0xE3,0x74,	/* 38D0: q!rt */
	0x22,0x40,0x24,0xFB,0x25,0xFA,0xD4,0x6C,	/* 38D8: "@$%l */
	0x4F,0x24,0xF6,0xD4,0x2A,0x04,0x71,0x59,	/* 38E0: O$*.qY */
	0xF1,0x72,0xE3,0x74,0x67,0x4F,0x24,0xF6,	/* 38E8: rtgO$ */
	0xD4,0x29,0x07,0x74,0x44,0x24,0xF6,0xC0,	/* 38F0: ).tD$ */
	0x29,0xA0,0x71,0x56,0xF1,0xD0,0x71,0x8D,	/* 38F8: )qVq */
	0xF1,0x70,0xF4,0x25,0xFA,0xD6,0x28,0xA2,	/* 3900: p%( */
	0x70,0x71,0x23,0x50,0xF2,0xF1,0x25,0xFA,	/* 3908: pq#P% */
	0xD7,0x4A,0xF4,0xC0,0x22,0xAB,0x74,0x24,	/* 3910: J"t$ */
	0x20,0x40,0x24,0xF6,0x22,0xA3,0x74,0x21,	/* 3918:  @$"t! */
	0x20,0x40,0x24,0xF6,0x21,0xA0,0x77,0x72,	/* 3920:  @$!wr */
	0xE3,0x74,0x61,0x2F,0x4F,0x24,0xF6,0xD4,	/* 3928: ta.O$ */
	0x70,0x41,0xF2,0xD0,0x21,0x02,0x4D,0x72,	/* 3930: pA!.Mr */
	0xE3,0x74,0x21,0x20,0x40,0x24,0xFB,0xD4,	/* 3938: t! @$ */
	0x07,0x77,0x72,0xE3,0x70,0x41,0xF2,0xD0,	/* 3940: .wrpA */
	0x70,0x71,0x56,0x23,0xFB,0x76,0x23,0x4F,	/* 3948: pqV#v#O */
	0x24,0xF6,0xC0,0x23,0xA5,0x76,0x2F,0x4F,	/* 3950: $#v.O */
	0x24,0xF6,0x2C,0x40,0xF4,0x22,0xA2,0x76,	/* 3958: $,@"v */
	0x2F,0x4F,0x24,0xF6,0x24,0x40,0xF4,0xC0,	/* 3960: .O$$@ */
	0x22,0xA0,0x71,0x34,0x28,0x20,0x40,0x24,	/* 3968: "q4( @$ */
	0xF6,0x21,0xA7,0x71,0x34,0x68,0x2F,0x4F,	/* 3970: !q4h.O */
	0x24,0xF6,0x71,0xE4,0x41,0x75,0x62,0xE5,	/* 3978: $qAub */
	0x09,0x71,0x34,0x28,0x20,0x40,0x24,0xFB,	/* 3980: .q4( @$ */
	0x71,0xE4,0x73,0x41,0x24,0xF6,0xA8,0x14,	/* 3988: qsA$. */
	0xD0,0x73,0x71,0x79,0x63,0x23,0x9A,0x74,	/* 3990: sqyc#t */
	0x21,0x40,0x24,0xF6,0x25,0xA3,0x41,0x71,	/* 3998: !@$%Aq */
	0x55,0xF1,0x71,0x8B,0xF1,0xFC,0x2F,0x4F,	/* 39A0: Uq.O */
	0x24,0xF6,0x24,0x40,0xF0,0x24,0xFF,0xF0,	/* 39A8: $$@$ */
	0xC0,0x23,0xAE,0x74,0x28,0x40,0x24,0xF6,	/* 39B0: #t(@$ */
	0xA6,0x74,0x6C,0x4F,0x24,0xF6,0xD4,0x74,	/* 39B8: tlO$t */
	0x22,0x40,0x24,0xF6,0xA6,0x74,0x24,0x40,	/* 39C0: "@$t$@ */
	0x24,0xFB,0xD4,0x71,0x23,0x81,0xF1,0x28,	/* 39C8: $q#( */
	0x40,0x24,0xF6,0xA4,0x28,0x40,0x72,0xE2,	/* 39D0: @$(@r */
	0x74,0x61,0x4F,0x24,0xF6,0x25,0xFA,0xD4,	/* 39D8: taO$% */
	0x24,0x24,0x44,0x24,0xF6,0xC0,0xAA,0x71,	/* 39E0: $$D$q */
	0x31,0x21,0x20,0x20,0x40,0x24,0xFB,0x71,	/* 39E8: 1!  @$q */
	0xE1,0x74,0x71,0xE4,0x61,0x21,0x02,0x60,	/* 39F0: tqa!.` */
	0xBD,0x75,0x31,0x21,0x20,0x20,0x40,0x24,	/* 39F8: u1!  @$ */
	0xFB,0xD1,0x75,0x34,0x25,0xFA,0xD2,0xD0,	/* 3A00: u4% */
	0x75,0x21,0x8F,0xF1,0xA7,0x40,0x75,0x21,	/* 3A08: u!@u! */
	0x8F,0x23,0xFB,0x07,0x71,0x31,0x48,0x24,	/* 3A10: #.q1H$ */
	0xF6,0x27,0xA4,0x75,0x57,0xF1,0x48,0xF4,	/* 3A18: 'uWH */
	0xC0,0x22,0xA0,0x75,0x5A,0xF1,0x75,0x23,	/* 3A20: "uZu# */
	0x81,0xF1,0xF4,0xC0,0x21,0xA5,0x75,0x21,	/* 3A28: !u! */
	0x85,0xF1,0x75,0x21,0x59,0xF1,0xF4,0xC0,	/* 3A30: u!Y */
	0xAA,0x75,0x5B,0xF1,0x75,0x22,0x8D,0xF1,	/* 3A38: u[u" */
	0xF4,0x23,0xA0,0x21,0x4A,0x71,0xE2,0x75,	/* 3A40: #!Jqu */
	0x5A,0xF1,0x71,0xE0,0x75,0x21,0x85,0xF1,	/* 3A48: Zqu! */
	0x71,0xE0,0x75,0x5B,0xF1,0x71,0xE1,0x75,	/* 3A50: qu[qu */
	0x5A,0xF1,0x75,0x23,0x81,0x23,0xFB,0x75,	/* 3A58: Zu##u */
	0x21,0x85,0xF1,0x75,0x21,0x59,0x23,0xFB,	/* 3A60: !u!Y# */
	0x75,0x5B,0xF1,0x75,0x22,0x8D,0x23,0xFB,	/* 3A68: u[u"# */
	0x45,0x71,0xE2,0x75,0x21,0x87,0xF1,0x41,	/* 3A70: Equ!A */
	0x24,0xF6,0xAF,0x70,0x21,0x40,0x24,0xF6,	/* 3A78: $p!@$ */
	0x21,0xA1,0x75,0x5A,0xF1,0x28,0x40,0x24,	/* 3A80: !uZ(@$ */
	0xF6,0xA9,0x29,0x40,0x71,0xE2,0x08,0x40,	/* 3A88: )@q.@ */
	0xB3,0x22,0xF0,0x28,0x40,0x71,0xE2,0x75,	/* 3A90: "(@qu */
	0x21,0x87,0xF1,0x42,0x24,0xF6,0xA7,0x41,	/* 3A98: !B$A */
	0x75,0x74,0x65,0x2E,0x97,0x06,0x40,0x75,	/* 3AA0: ute..@u */
	0x74,0x65,0x2E,0x90,0x40,0x75,0x21,0x89,	/* 3AA8: te.@u! */
	0x23,0xFB,0x75,0x21,0x8B,0xF1,0x75,0x58,	/* 3AB0: #u!uX */
	0x23,0xFB,0x75,0x21,0x8D,0xF1,0x75,0x59,	/* 3AB8: #u!uY */
	0x23,0xFB,0x75,0x5E,0xF1,0x75,0x21,0x81,	/* 3AC0: #u^u! */
	0x23,0xFB,0x75,0x5F,0xF1,0x75,0x21,0x83,	/* 3AC8: #u_u! */
	0x23,0xFB,0x75,0x21,0x50,0xF1,0x75,0x22,	/* 3AD0: #u!Pu" */
	0x81,0x23,0xFB,0x75,0x21,0x51,0xF1,0x75,	/* 3AD8: #u!Qu */
	0x22,0x83,0x23,0xFB,0x75,0x5D,0xF1,0x75,	/* 3AE0: "#u]u */
	0x21,0x58,0x23,0xFB,0x70,0x60,0x44,0x24,	/* 3AE8: !X#p`D$ */
	0xF6,0xD0,0x75,0x5D,0xF1,0x42,0x24,0xF6,	/* 3AF0: u]B$ */
	0xA5,0x70,0x42,0x24,0xFB,0xD0,0x75,0x5D,	/* 3AF8: pB$u] */
	0xF1,0x48,0x24,0xF6,0xA5,0x70,0x48,0x24,	/* 3B00: H$pH$ */
	0xFB,0xD0,0x75,0x5D,0xF1,0x41,0x24,0xF6,	/* 3B08: u]A$ */
	0xA5,0x70,0x41,0x24,0xFB,0xD0,0x70,0x25,	/* 3B10: pA$p% */
	0x2B,0x2F,0x4F,0x24,0xF6,0xD0,0x75,0x5D,	/* 3B18: +.O$u] */
	0xF1,0x44,0x24,0xF6,0xA7,0x70,0x24,0x20,	/* 3B20: D$p$  */
	0x40,0x24,0xFB,0xD0,0x75,0x5D,0xF1,0x22,	/* 3B28: @$u]" */
	0x40,0x24,0xF6,0xA8,0x70,0x22,0x20,0x20,	/* 3B30: @$p"   */
	0x40,0x24,0xFB,0xD0,0x75,0x5D,0xF1,0x28,	/* 3B38: @$u]( */
	0x40,0x24,0xF6,0xA8,0x70,0x67,0x20,0x20,	/* 3B40: @$pg   */
	0x40,0x24,0xFB,0xD0,0x75,0x5A,0xF1,0x28,	/* 3B48: @$uZ( */
	0x40,0x24,0xF6,0xA5,0x70,0x48,0x24,0xFB,	/* 3B50: @$pH$ */
	0xD0,0x75,0x5D,0xF1,0x24,0x40,0x24,0xF6,	/* 3B58: u]$@$ */
	0xA5,0x70,0x48,0x24,0xFB,0xD0,0x72,0x24,	/* 3B60: pH$r$ */
	0x20,0x40,0x24,0xF6,0xAF,0x70,0x24,0x20,	/* 3B68:  @$p$  */
	0x40,0x24,0xF6,0xC0,0xA7,0x70,0x61,0x2F,	/* 3B70: @$pa. */
	0x4F,0x24,0xF6,0xD0,0x72,0x42,0x24,0xF6,	/* 3B78: O$rB$ */
	0xAC,0x70,0x42,0x24,0xF6,0xC0,0xA6,0x70,	/* 3B80: pB$p */
	0x60,0x4B,0x24,0xF6,0xD0,0x75,0x23,0x81,	/* 3B88: `K$u# */
	0xF1,0x28,0x40,0x24,0xF6,0xA5,0x70,0x48,	/* 3B90: (@$pH */
	0x24,0xFB,0xD0,0x70,0x24,0x25,0x44,0x24,	/* 3B98: $p$%D$ */
	0xF6,0xAB,0x75,0x31,0x61,0x2F,0x2F,0x4F,	/* 3BA0: u1a..O */
	0x24,0xF6,0x75,0xE1,0x0A,0x75,0x31,0x21,	/* 3BA8: $u.u1! */
	0x20,0x20,0x40,0x24,0xFB,0x75,0xE1,0x70,	/* 3BB0:   @$up */
	0x22,0x20,0x20,0x40,0x24,0xF6,0xAA,0x75,	/* 3BB8: "  @$u */
	0x74,0x66,0x29,0x91,0x75,0x5C,0x23,0xFB,	/* 3BC0: tf)u\# */
	0x06,0x22,0x44,0x75,0x5C,0x23,0xFB,0x75,	/* 3BC8: ."Du\#u */
	0x57,0xF1,0x44,0xF4,0xA6,0x40,0x75,0x57,	/* 3BD0: WD@uW */
	0x23,0xFB,0x03,0x75,0x74,0x9B,0x70,0x75,	/* 3BD8: #.utpu */
	0xE4,0x41,0x74,0x21,0xE1,0x40,0xB3,0x22,	/* 3BE0: At!@" */
	0xF0,0x72,0x71,0x66,0x26,0x97,0x44,0x24,	/* 3BE8: rqf&D$ */
	0xF6,0xAA,0x40,0x72,0x57,0x23,0xFB,0x41,	/* 3BF0: @rW#A */
	0x71,0x21,0xE1,0x05,0x46,0x72,0x57,0x23,	/* 3BF8: q!.FrW# */
	0xFB,0x40,0x22,0xF0,0x60,0xBF,0x73,0x31,	/* 3C00: @"`s1 */
	0x21,0x20,0x20,0x40,0x24,0xFB,0xD0,0x73,	/* 3C08: !  @$s */
	0x8D,0xF1,0x73,0x56,0xF1,0xF4,0xC0,0xAF,	/* 3C10: sV */
	0x70,0x30,0x2F,0x4F,0x24,0xF6,0xA8,0x73,	/* 3C18: p0.O$s */
	0x72,0x23,0x95,0x40,0xB1,0x22,0xF0,0x41,	/* 3C20: r#@"A */
	0xB1,0x22,0xF0,0x26,0x40,0x72,0x31,0x21,	/* 3C28: "&@r1! */
	0x20,0x20,0x40,0x24,0xFB,0xE2,0x21,0x42,	/* 3C30:   @$!B */
	0x72,0x57,0x23,0xFB,0x40,0x22,0xF0,0x27,	/* 3C38: rW#@"' */
	0x45,0x72,0x31,0x21,0x20,0x20,0x40,0x24,	/* 3C40: Er1!  @$ */
	0xFB,0xE2,0x40,0x72,0x57,0x23,0xFB,0x40,	/* 3C48: @rW#@ */
	0x22,0xF0,0x40,0x22,0xF0,0x40,0x22,0xF0,	/* 3C50: "@"@" */
	0x60,0xBF,0x73,0x31,0x21,0x20,0x20,0x40,	/* 3C58: `s1!  @ */
	0x24,0xFB,0xD0,0x40,0x73,0x56,0x23,0xFB,	/* 3C60: $@sV# */
	0x40,0x73,0x8D,0x23,0xFB,0x40,0x73,0x8B,	/* 3C68: @s#@s */
	0x23,0xFB,0x40,0x73,0x55,0x23,0xFB,0x73,	/* 3C70: #@sU#s */
	0x21,0x59,0xF1,0x21,0x40,0x24,0xF6,0xAA,	/* 3C78: !Y!@$ */
	0x73,0x21,0x59,0xF1,0x61,0x4F,0x24,0xF6,	/* 3C80: s!YaO$ */
	0x70,0xE0,0x70,0x31,0x48,0x24,0xF6,0x23,	/* 3C88: pp1H$# */
	0xAB,0x73,0x21,0x87,0xF1,0x41,0x24,0xF6,	/* 3C90: s!A$ */
	0xC0,0xA4,0x29,0x40,0x70,0xE2,0x73,0x21,	/* 3C98: )@ps! */
	0x87,0xF1,0x42,0x24,0xF6,0xC0,0xA6,0x40,	/* 3CA0: B$@ */
	0x73,0x72,0x67,0x2D,0x9F,0x40,0x73,0xE4,	/* 3CA8: srg-@s */
	0x23,0x40,0x70,0xE2,0x22,0x40,0x70,0xE2,	/* 3CB0: #@p"@p */
	0x41,0x73,0x21,0x8F,0x23,0xFB,0x21,0x40,	/* 3CB8: As!#!@ */
	0x73,0x57,0x23,0xFB,0x41,0x72,0x21,0xE1,	/* 3CC0: sW#Ar! */
	0x40,0xB1,0x22,0xF0,0x40,0xB1,0x22,0xF0,	/* 3CC8: @"@" */
	0x72,0x34,0x46,0x24,0xF6,0x46,0xF4,0xC0,	/* 3CD0: r4F$F */
	0x21,0xAB,0x72,0x34,0x60,0x4B,0x24,0xF6,	/* 3CD8: !r4`K$ */
	0x72,0xE4,0x72,0x34,0x24,0x25,0x40,0x24,	/* 3CE0: rr4$%@$ */
	0xF6,0xC0,0xAA,0x72,0x31,0x21,0x20,0x20,	/* 3CE8: r1!   */
	0x40,0x24,0xFB,0x72,0xE1,0x40,0x72,0x57,	/* 3CF0: @$r@rW */
	0x23,0xFB,0x41,0x71,0x21,0xE1,0x40,0x22,	/* 3CF8: #Aq!@" */
	0xF0,0x60,0xBF,0x73,0x31,0x21,0x20,0x20,	/* 3D00: `s1!   */
	0x40,0x24,0xFB,0xD0,0x73,0x8D,0xF1,0x73,	/* 3D08: @$ss */
	0x56,0x23,0xFB,0x73,0x34,0x68,0x2F,0x4F,	/* 3D10: V#s4h.O */
	0x24,0xF6,0x73,0xE4,0x73,0x21,0x59,0xF1,	/* 3D18: $ss!Y */
	0x21,0x40,0x24,0xF6,0x21,0xA1,0x73,0x72,	/* 3D20: !@$!sr */
	0x67,0x22,0x9A,0x42,0x24,0xF6,0xC0,0xA7,	/* 3D28: g"B$ */
	0x23,0x40,0x70,0xE2,0x44,0x70,0xE2,0x73,	/* 3D30: #@pDps */
	0x72,0x66,0x95,0x40,0xB1,0x22,0xF0,0x72,	/* 3D38: rf@"r */
	0x8B,0xF1,0x72,0x55,0x23,0xFB,0x40,0x72,	/* 3D40: rU#@r */
	0x57,0x23,0xFB,0x41,0x71,0x21,0xE1,0x40,	/* 3D48: W#Aq!@ */
	0x22,0xF0,0x72,0x34,0x42,0x24,0xF6,0x21,	/* 3D50: "r4B$! */
	0xA1,0x72,0x34,0x44,0x24,0xFB,0x72,0xE4,	/* 3D58: r4D$r */
	0x72,0x31,0x61,0x2F,0x2F,0x4F,0x24,0xF6,	/* 3D60: r1a..O$ */
	0x72,0xE1,0x40,0x72,0x57,0x23,0xFB,0x41,	/* 3D68: r@rW#A */
	0x71,0x21,0xE1,0x40,0x22,0xF0,0x40,0x72,	/* 3D70: q!@"@r */
	0x57,0x23,0xFB,0x40,0x22,0xF0,0x74,0xF6,	/* 3D78: W#@"t */
	0x20,0x1D,0x00,0x1B,0x00,0x19,0x00,0x17,	/* 3D80:  ....... */
	0x00,0x15,0x00,0x13,0x00,0x11,0x00,0x0F,	/* 3D88: ........ */
	0x00,0x0D,0x00,0x0B,0x00,0x09,0x00,0x07,	/* 3D90: ........ */
	0x00,0x05,0x00,0x03,0x00,0x01,0x00,0x00,	/* 3D98: ........ */
	0x00,0xF4,0x00,0x71,0x23,0x5C,0xD2,0x63,	/* 3DA0: ..q#\c */
	0x4B,0x21,0xFB,0x72,0x21,0xEE,0x65,0x40,	/* 3DA8: K!r!e@ */
	0x21,0xFB,0x72,0x21,0xEC,0x67,0x46,0x21,	/* 3DB0: !r!gF! */
	0xFB,0x72,0x21,0xEA,0x6B,0x41,0x21,0xFB,	/* 3DB8: r!kA! */
	0x72,0x21,0xE8,0x6F,0x49,0x21,0xFB,0x72,	/* 3DC0: r!oI!r */
	0x21,0xE6,0x61,0x28,0x49,0x21,0xFB,0x72,	/* 3DC8: !a(I!r */
	0x21,0xE4,0x61,0x27,0x4E,0x21,0xFB,0x72,	/* 3DD0: !a'N!r */
	0x21,0xE2,0x61,0x27,0x43,0x21,0xFB,0x72,	/* 3DD8: !a'C!r */
	0x21,0xE0,0x61,0x25,0x48,0x21,0xFB,0x72,	/* 3DE0: !a%H!r */
	0xEE,0x61,0x23,0x4D,0x21,0xFB,0x72,0xEC,	/* 3DE8: a#M!r */
	0x61,0x20,0x4F,0x21,0xFB,0x72,0xEA,0x64,	/* 3DF0: a O!rd */
	0x2F,0x4B,0x21,0xFB,0x72,0xE8,0x62,0x2E,	/* 3DF8: .K!rb. */
	0x46,0x21,0xFB,0x72,0xE6,0x64,0x2E,0x4D,	/* 3E00: F!rd.M */
	0x21,0xFB,0x72,0xE4,0x64,0x2E,0x46,0x21,	/* 3E08: !rd.F! */
	0xFB,0x72,0xE2,0x72,0x69,0x49,0x21,0xFB,	/* 3E10: rriI! */
	0x21,0x40,0x27,0x21,0x94,0x22,0xF0,0x60,	/* 3E18: !@'!"` */
	0xBF,0x72,0x3A,0xD0,0x72,0x3A,0x72,0x3B,	/* 3E20: r:r:r; */
	0x72,0x3B,0x26,0x2B,0x96,0x72,0x72,0x3B,	/* 3E28: r;&+rr; */
	0xD2,0xD3,0xB1,0x60,0xB8,0x79,0x25,0x5B,	/* 3E30: ӱ`y%[ */
	0xD5,0x7A,0x37,0x7A,0x35,0xF4,0x75,0x21,	/* 3E38: z7z5u! */
	0xEB,0x7A,0x37,0x75,0x21,0xEC,0x7A,0x3D,	/* 3E40: z7u!z= */
	0x75,0x21,0xEF,0x7A,0x3C,0x75,0x22,0xE0,	/* 3E48: u!z<u" */
	0x41,0x75,0x22,0xE3,0x24,0x20,0x40,0x75,	/* 3E50: Au"$ @u */
	0x22,0xE4,0x7A,0x75,0x21,0xEE,0x75,0x21,	/* 3E58: "zu!u! */
	0x55,0x79,0x2B,0x26,0x9E,0xC0,0x22,0xA5,	/* 3E60: Uy+&" */
	0x21,0xFE,0x75,0xEE,0x22,0xF2,0x75,0xED,	/* 3E68: !u"u */
	0x75,0x16,0x44,0x24,0xFA,0x24,0xF2,0xD0,	/* 3E70: u.D$$ */
	0x24,0xF2,0xD1,0x40,0xD2,0x24,0xF2,0xD3,	/* 3E78: $@$ */
	0x40,0xD4,0x16,0x41,0x79,0x63,0x26,0x28,	/* 3E80: @.Ayc&( */
	0x92,0x79,0x2C,0x20,0x98,0xB8,0x22,0xF0,	/* 3E88: y, " */
	0x20,0x00,0x20,0x01,0x00,0xD4,0x01,0x71,	/* 3E90:  . ...q */
	0x25,0x5B,0xD2,0x60,0x42,0x21,0xFB,0x72,	/* 3E98: %[`B!r */
	0xE0,0x72,0x61,0x4D,0x21,0xFB,0x41,0x26,	/* 3EA0: raM!A& */
	0x28,0x97,0x22,0xF0,0x20,0x74,0xD1,0x23,	/* 3EA8: (" t# */
	0x2F,0x05,0x74,0xD1,0x24,0x21,0x0C,0x11,	/* 3EB0: ..t$!.. */
	0x72,0x42,0x23,0x2E,0x9A,0x71,0x22,0xF0,	/* 3EB8: rB#.q" */
	0x40,0xD1,0x11,0x72,0x41,0x23,0x2D,0x9F,	/* 3EC0: @.rA#- */
	0x71,0x2F,0x4F,0x24,0xF6,0x22,0xF0,0x13,	/* 3EC8: q.O$". */
	0x72,0x42,0x23,0x2F,0x9E,0x22,0xF0,0x13,	/* 3ED0: rB#.". */
	0x72,0x41,0x23,0x2F,0x96,0x22,0xF0,0x60,	/* 3ED8: rA#."` */
	0xBE,0x73,0x26,0x3E,0xD0,0x40,0xD1,0x73,	/* 3EE0: s&>@s */
	0x27,0x36,0x24,0xF2,0xF4,0x21,0xA4,0x73,	/* 3EE8: '6$!s */
	0x27,0x36,0x74,0xF9,0xC0,0xAD,0x74,0x73,	/* 3EF0: '6tts */
	0x27,0x37,0xF9,0xC0,0xA6,0x41,0x47,0x73,	/* 3EF8: '7AGs */
	0x2B,0x2B,0x9A,0x70,0x24,0xF2,0xF4,0x21,	/* 3F00: ++p$! */
	0xAB,0x70,0x32,0x74,0xF9,0xC0,0xA9,0x70,	/* 3F08: p2tp */
	0x33,0x70,0x32,0xF2,0x74,0xF9,0xC0,0xAA,	/* 3F10: 3p2t */
	0x70,0x30,0xD0,0x70,0x24,0xF2,0xF4,0xA4,	/* 3F18: p0p$ */
	0x61,0x07,0x41,0xD1,0x71,0xA6,0x41,0x47,	/* 3F20: a.AqAG */
	0x73,0x2B,0x29,0x91,0xB2,0x22,0xF0,0x60,	/* 3F28: s+)"` */
	0xBF,0x11,0xD0,0x72,0x26,0x3E,0x24,0xF2,	/* 3F30: .r&>$ */
	0xF4,0xC0,0x21,0xA0,0x21,0x25,0x46,0x21,	/* 3F38: !!%F! */
	0xFB,0x72,0x28,0xE0,0x22,0x26,0x45,0x21,	/* 3F40: r("&E! */
	0xFB,0x72,0x28,0xE1,0x75,0x72,0x67,0x9F,	/* 3F48: r(urg */
	0x76,0xA8,0x77,0x23,0xF4,0x21,0x50,0x76,	/* 3F50: vw#!Pv */
	0xF9,0xA4,0x41,0xB1,0x22,0xF0,0x77,0x81,	/* 3F58: A"w */
	0xD7,0x73,0x24,0xF2,0xF4,0x26,0xAB,0x75,	/* 3F60: s$&u */
	0x73,0xE2,0x76,0x73,0xE3,0x76,0x73,0x32,	/* 3F68: svsvs2 */
	0xF5,0x60,0x5D,0x77,0x23,0xF4,0xFC,0x73,	/* 3F70: `]w#s */
	0xE4,0x74,0x73,0x34,0x60,0xEF,0x74,0x73,	/* 3F78: ts4`ts */
	0xE6,0x2A,0x27,0x4B,0x21,0xFB,0x73,0x34,	/* 3F80: *'K!s4 */
	0xE0,0x70,0x31,0x73,0x34,0xE1,0x73,0x73,	/* 3F88: p1s4ss */
	0x34,0xE2,0x40,0xD0,0x77,0x60,0x8F,0x40,	/* 3F90: 4@w`@ */
	0xF9,0x21,0xA5,0x70,0x18,0xFA,0x30,0x70,	/* 3F98: !p.0p */
	0x83,0x73,0x34,0xFA,0xE0,0x70,0x81,0xD0,	/* 3FA0: s4p */
	0x77,0x60,0x8F,0x70,0xF9,0xA2,0x61,0x0B,	/* 3FA8: w`pa. */
	0x77,0x73,0xE5,0x24,0xF2,0x81,0x73,0xE7,	/* 3FB0: ws$s */
	0x72,0x25,0x5D,0x72,0x2D,0x99,0x72,0x26,	/* 3FB8: r%]r-r& */
	0x3E,0x73,0xE0,0x73,0x72,0x26,0xEE,0x72,	/* 3FC0: >ssr&r */
	0x25,0x5D,0x72,0x21,0x2E,0x90,0x40,0xB1,	/* 3FC8: %]r!.@ */
	0x22,0xF0,0x41,0xB1,0x22,0xF0,0x60,0xBE,	/* 3FD0: "A"` */
	0x73,0x25,0x5D,0xD1,0x71,0x73,0x2B,0x97,	/* 3FD8: s%]qs+ */
	0x74,0x71,0x21,0x31,0xF4,0xAD,0x71,0x21,	/* 3FE0: tq!1q! */
	0x31,0xD0,0x70,0x30,0x24,0xF2,0xF4,0x22,	/* 3FE8: 1p0$" */
	0xA2,0x21,0x00,0x71,0x21,0x31,0x30,0x71,	/* 3FF0: !.q!10q */
	0x21,0xE1,0x71,0x73,0x21,0x2A,0x9F,0x40,	/* 3FF8: !qs!*@ */
	0xB2,0x22,0xF0,0x70,0x30,0x74,0xF4,0xAB,	/* 4000: "p0t */
	0x70,0x30,0xD0,0x70,0x30,0x24,0xF2,0xF4,	/* 4008: p0p0$ */
	0xA2,0x60,0x00,0x70,0x30,0x24,0xF2,0xF4,	/* 4010: `.p0$ */
	0xAD,0x74,0x30,0x70,0xE0,0x71,0x73,0x21,	/* 4018: t0pqs! */
	0x28,0x9C,0x40,0xB2,0x22,0xF0,0x71,0x73,	/* 4020: (@"qs */
	0x21,0x28,0x93,0x41,0xB2,0x22,0xF0,0x72,	/* 4028: !(A"r */
	0x71,0x65,0x93,0xA6,0x41,0x48,0x71,0x2A,	/* 4030: qeAHq* */
	0x28,0x93,0x22,0xF0,0x72,0x71,0x66,0x96,	/* 4038: ("rqf */
	0xA6,0x41,0x48,0x71,0x2A,0x27,0x96,0x72,	/* 4040: AHq*'r */
	0x71,0x23,0x2F,0x9D,0x22,0xF0,0x01,0x00,	/* 4048: q#.".. */
	0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,	/* 4050: ........ */
	0x00,0x00,0x01,0x0A,0x00,0x08,0x00,0x07,	/* 4058: ........ */
	0x00,0x05,0x00,0x04,0x00,0x02,0x00,0x01,	/* 4060: ........ */
	0x00,0xAE,0x02,0x71,0x25,0x5D,0xD2,0x62,	/* 4068: ..q%]b */
	0x4B,0x21,0xFB,0x72,0x4D,0x24,0xFA,0x72,	/* 4070: K!rM$r */
	0x62,0x4F,0x21,0xFB,0x47,0x24,0x2B,0x91,	/* 4078: bO!G$+ */
	0x22,0xF0,0x20,0x72,0x22,0xFB,0x22,0xF0,	/* 4080: " r"" */
	0x22,0xF2,0x72,0xF2,0xD2,0x72,0x22,0xFB,	/* 4088: "rr" */
	0x22,0xF0,0x21,0xF5,0x22,0xF0,0x20,0x60,	/* 4090: "!" ` */
	0xB8,0x40,0xD3,0x24,0xF2,0xD0,0x24,0xF2,	/* 4098: @$$ */
	0xD1,0x21,0xFE,0x41,0xF4,0xA2,0x28,0x01,	/* 40A0: !A(. */
	0x41,0xD4,0x7A,0x33,0xC1,0xA6,0x40,0x7A,	/* 40A8: Az3@z */
	0xE3,0x40,0x22,0xA0,0x24,0xF2,0x24,0xF2,	/* 40B0: @"$$ */
	0xD6,0xD7,0x7A,0x34,0x24,0xF2,0xF4,0xC0,	/* 40B8: z4$ */
	0xA8,0x16,0x16,0x7A,0xE4,0x7A,0xE5,0x40,	/* 40C0: ..zz@ */
	0xA7,0x16,0x7A,0x35,0xE1,0x16,0x7A,0xE5,	/* 40C8: .z5.z */
	0x15,0x16,0x42,0xF7,0x41,0x7A,0xE9,0x41,	/* 40D0: ..BAzA */
	0x7A,0x30,0x40,0x24,0xFF,0xF0,0x21,0xA1,	/* 40D8: z0@$! */
	0x41,0xD3,0x7A,0x31,0x24,0xF2,0xF4,0x21,	/* 40E0: Az1$! */
	0xA0,0x10,0x7A,0x32,0xE1,0x10,0x7A,0xE2,	/* 40E8: .z2.z */
	0x0E,0x7A,0x30,0x60,0x4F,0xF2,0x7A,0xE0,	/* 40F0: .z0`Oz */
	0x06,0x10,0x7A,0xE1,0x10,0x7A,0xE2,0x40,	/* 40F8: ..z.z@ */
	0x7A,0xE9,0x7A,0x3A,0x24,0xF2,0xF4,0xA5,	/* 4100: zz:$ */
	0x14,0x7A,0x5A,0x42,0xFB,0x41,0xD5,0x7A,	/* 4108: .zZBAz */
	0x34,0x24,0xF2,0xF4,0xC0,0xA5,0x41,0x7A,	/* 4110: 4$Az */
	0xE3,0x40,0xAC,0x7A,0x34,0x31,0x7A,0x34,	/* 4118: @z41z4 */
	0xD6,0x7A,0xE4,0x15,0x76,0x42,0xFB,0x27,	/* 4120: z.vB' */
	0x0B,0x7A,0x36,0xC1,0xA7,0x20,0x40,0x7A,	/* 4128: .z6 @z */
	0xE6,0x40,0x22,0xA2,0x24,0xF2,0x24,0xF2,	/* 4130: @"$$ */
	0xD6,0xD7,0x7A,0x37,0x24,0xF2,0xF4,0xC0,	/* 4138: z7$ */
	0xAA,0x20,0x16,0x16,0x7A,0xE7,0x7A,0xE8,	/* 4140:  ..zz */
	0x40,0xA8,0x20,0x16,0x7A,0x38,0xE1,0x16,	/* 4148: @ .z8. */
	0x7A,0xE8,0x15,0x16,0x42,0xF7,0x7A,0x39,	/* 4150: z..Bz9 */
	0xA6,0x20,0x14,0x7A,0x5A,0x42,0xF7,0x41,	/* 4158:  .zZBA */
	0x7A,0x30,0x40,0x24,0xFF,0xF0,0x21,0xA1,	/* 4160: z0@$! */
	0x41,0xD3,0x7A,0x31,0x24,0xF2,0xF4,0x21,	/* 4168: Az1$! */
	0xA1,0x10,0x7A,0x32,0xE1,0x10,0x7A,0xE2,	/* 4170: .z2.z */
	0x0F,0x7A,0x30,0x60,0x4F,0xF2,0x7A,0xE0,	/* 4178: .z0`Oz */
	0x07,0x20,0x10,0x7A,0xE1,0x10,0x7A,0xE2,	/* 4180: . .z.z */
	0x41,0xD5,0x7A,0x37,0x24,0xF2,0xF4,0xC0,	/* 4188: Az7$ */
	0xA7,0x20,0x41,0x7A,0xE6,0x40,0xAD,0x20,	/* 4190:  Az@  */
	0x7A,0x37,0x31,0x7A,0x37,0xD6,0x7A,0xE7,	/* 4198: z71z7z */
	0x15,0x76,0x42,0xFB,0x73,0xA5,0x20,0x12,	/* 41A0: .vBs . */
	0x10,0x42,0xF7,0xB8,0x22,0xF0,0x60,0xBB,	/* 41A8: .B"` */
	0x41,0xD0,0x21,0xFE,0x41,0xF4,0xA3,0x20,	/* 41B0: A!A  */
	0x27,0x0B,0x77,0x33,0xC1,0xA7,0x20,0x40,	/* 41B8: '.w3 @ */
	0x77,0xE3,0x40,0x22,0xA2,0x24,0xF2,0x24,	/* 41C0: w@"$$ */
	0xF2,0xD2,0xD3,0x77,0x34,0x24,0xF2,0xF4,	/* 41C8: w4$ */
	0xC0,0xAA,0x20,0x12,0x12,0x77,0xE4,0x77,	/* 41D0:  ..ww */
	0xE5,0x40,0xA8,0x20,0x12,0x77,0x35,0xE1,	/* 41D8: @ .w5 */
	0x12,0x77,0xE5,0x11,0x12,0x42,0xF7,0x41,	/* 41E0: .w..BA */
	0x77,0xE9,0x77,0x31,0x24,0xF2,0xF4,0xAB,	/* 41E8: ww1$ */
	0x20,0x77,0x31,0xD1,0x77,0x31,0x31,0x77,	/* 41F0:  w1w11w */
	0xE1,0x09,0x20,0x77,0x30,0x41,0xF2,0x77,	/* 41F8: . w0Aw */
	0xE0,0x05,0x20,0x10,0x71,0x42,0xFB,0x40,	/* 4200: . .qB@ */
	0x77,0xE9,0x77,0x3A,0x24,0xF2,0xF4,0xA6,	/* 4208: ww:$ */
	0x20,0x10,0x77,0x5A,0x42,0xFB,0x41,0xD1,	/* 4210:  .wZBA */
	0x77,0x34,0x24,0xF2,0xF4,0xC0,0xA7,0x20,	/* 4218: w4$  */
	0x41,0x77,0xE3,0x40,0xAD,0x20,0x77,0x34,	/* 4220: Aw@ w4 */
	0x31,0x77,0x34,0xD2,0x77,0xE4,0x11,0x72,	/* 4228: 1w4w.r */
	0x42,0xFB,0xB5,0x22,0xF0,0x77,0x36,0xC1,	/* 4230: B"w6 */
	0xA7,0x20,0x40,0x77,0xE6,0x40,0x22,0xA2,	/* 4238:  @w@" */
	0x24,0xF2,0x24,0xF2,0xD3,0xD4,0x77,0x37,	/* 4240: $$w7 */
	0x24,0xF2,0xF4,0xC0,0xAA,0x20,0x13,0x13,	/* 4248: $ .. */
	0x77,0xE7,0x77,0xE8,0x40,0xA8,0x20,0x13,	/* 4250: ww@ . */
	0x77,0x38,0xE1,0x13,0x77,0xE8,0x12,0x13,	/* 4258: w8.w.. */
	0x42,0xF7,0x77,0x39,0xA6,0x20,0x11,0x77,	/* 4260: Bw9 .w */
	0x5A,0x42,0xF7,0x77,0x31,0x24,0xF2,0xF4,	/* 4268: ZBw1$ */
	0xAB,0x20,0x77,0x31,0xD2,0x77,0x31,0x31,	/* 4270:  w1w11 */
	0x77,0xE1,0x09,0x20,0x77,0x30,0x41,0xF2,	/* 4278: w. w0A */
	0x77,0xE0,0x05,0x20,0x10,0x72,0x42,0xFB,	/* 4280: w. .rB */
	0x41,0xD2,0x77,0x37,0x24,0xF2,0xF4,0xC0,	/* 4288: Aw7$ */
	0xA7,0x20,0x41,0x77,0xE6,0x40,0xAD,0x20,	/* 4290:  Aw@  */
	0x77,0x37,0x31,0x77,0x37,0xD3,0x77,0xE7,	/* 4298: w71w7w */
	0x12,0x73,0x42,0xFB,0xB5,0x22,0xF0,0x60,	/* 42A0: .sB"` */
	0xBF,0x22,0xF9,0x41,0x73,0x24,0xF6,0x21,	/* 42A8: "As$! */
	0xA5,0x72,0xD0,0x74,0x73,0x60,0x8F,0x10,	/* 42B0: rts`. */
	0x25,0xF5,0x21,0x93,0x70,0x72,0xF4,0xC0,	/* 42B8: %!pr */
	0x41,0x24,0xFD,0x25,0xF5,0x04,0x74,0x73,	/* 42C0: A$%.ts */
	0x72,0xF7,0x22,0xF9,0xB1,0x22,0xF0,0x27,	/* 42C8: r""' */
	0x22,0x06,0x20,0x22,0xF9,0x41,0x72,0x24,	/* 42D0: ". "Ar$ */
	0xF6,0xA9,0x73,0x72,0x60,0x8F,0x71,0x25,	/* 42D8: sr`q% */
	0xF5,0x99,0x04,0x73,0x72,0x71,0xFB,0x22,	/* 42E0: .srq" */
	0xF9,0x22,0xF0,0x27,0x20,0x03,0x20,0x01,	/* 42E8: "' . . */
	0x00,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xEF,	/* 42F0: . */
	0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 42F8: ....... */
	0x00,0x0F,0x27,0x02,0x04,0x15,0x00,0x14,	/* 4300: ..'..... */
	0x00,0x12,0x00,0x11,0x00,0x10,0x00,0x0F,	/* 4308: ........ */
	0x00,0x0E,0x00,0x0C,0x00,0x06,0x00,0x66,	/* 4310: .......f */
	0x00,0x71,0x26,0x58,0xD2,0x61,0x43,0x21,	/* 4318: .q&XaC! */
	0xFB,0x72,0x22,0x8F,0x41,0x24,0xFA,0x63,	/* 4320: r"A$c */
	0x44,0x21,0xFB,0x72,0x82,0x21,0x45,0x24,	/* 4328: D!r!E$ */
	0xFA,0x72,0x63,0x4F,0x21,0xFB,0x49,0x21,	/* 4330: rcO!I! */
	0x2F,0x97,0x22,0xF0,0x20,0x73,0x72,0xE0,	/* 4338: ." sr */
	0x24,0xF2,0x72,0xE1,0x41,0x72,0xE3,0x24,	/* 4340: $rAr$ */
	0xF2,0x72,0xE4,0x41,0x72,0xE6,0x24,0xF2,	/* 4348: rAr$ */
	0x72,0xE7,0x40,0x72,0xE9,0x24,0xF2,0x72,	/* 4350: r@r$r */
	0xEA,0x22,0xF0,0x41,0x72,0x30,0x40,0x24,	/* 4358: "Ar0@$ */
	0xFF,0xF0,0xA8,0x40,0x21,0x4B,0xD2,0xD3,	/* 4360: @!K */
	0x27,0x25,0x02,0x72,0x30,0x60,0x4F,0xF2,	/* 4368: '%.r0`O */
	0x72,0xE0,0x22,0xF0,0x72,0x30,0x41,0xF2,	/* 4370: r"r0A */
	0x72,0xE0,0x22,0xF0,0x20,0x46,0x01,0x71,	/* 4378: r" F.q */
	0x28,0x50,0xD2,0x61,0x4D,0x21,0xFB,0x72,	/* 4380: (PaM!r */
	0xE1,0x63,0x4E,0x21,0xFB,0x72,0xE0,0x22,	/* 4388: cN!r" */
	0xF0,0x60,0xBA,0x78,0x24,0xF2,0xF4,0x24,	/* 4390: `x$$ */
	0xA2,0x78,0x60,0x5E,0xD1,0x78,0x41,0x24,	/* 4398: x`^xA$ */
	0xF6,0xC0,0x22,0xA1,0x77,0x27,0x3A,0x71,	/* 43A0: "w':q */
	0xF9,0xC0,0x21,0xA9,0x77,0x27,0x3C,0x71,	/* 43A8: !w'<q */
	0xF9,0x21,0xA2,0x71,0x30,0x24,0xF2,0x81,	/* 43B0: !q0$ */
	0xF4,0xC0,0xAA,0x71,0x31,0x60,0x4C,0x24,	/* 43B8: q1`L$ */
	0xF6,0x71,0x31,0xF4,0xA6,0x41,0x44,0x77,	/* 43C0: q1ADw */
	0x26,0x2F,0x92,0x77,0x28,0x52,0x25,0xFA,	/* 43C8: &.w(R% */
	0xD4,0x30,0x25,0xFA,0xD5,0xD0,0x77,0x28,	/* 43D0: 0%w( */
	0x33,0xD2,0x06,0xB6,0x22,0xF0,0x70,0x30,	/* 43D8: 3."p0 */
	0xD0,0x70,0x72,0xF4,0xA7,0x71,0x70,0x30,	/* 43E0: prqp0 */
	0xF9,0xA2,0x60,0x02,0x70,0x30,0x25,0xFA,	/* 43E8: `.p0% */
	0xD3,0x75,0xF4,0xA7,0x71,0x71,0x31,0xF2,	/* 43F0: uqq1 */
	0x73,0xF4,0xA5,0x73,0x71,0xE0,0x21,0x06,	/* 43F8: ssq!. */
	0x73,0x72,0xF4,0xC0,0xA4,0x20,0x71,0x74,	/* 4400: sr qt */
	0xE1,0x70,0x30,0x31,0x71,0x31,0xF2,0x71,	/* 4408: p01q1q */
	0xE1,0x70,0x30,0x30,0x71,0xE0,0x70,0x70,	/* 4410: p00qpp */
	0x31,0xF2,0x71,0xF4,0x21,0xA0,0x71,0x70,	/* 4418: 1q!qp */
	0xE0,0x71,0x30,0x74,0x30,0xF4,0xC0,0x21,	/* 4420: q0t0! */
	0xA7,0x71,0x74,0xE1,0x21,0x02,0x71,0x31,	/* 4428: qt!.q1 */
	0x70,0x31,0xF2,0x70,0xE1,0x71,0x30,0x70,	/* 4430: p1pq0p */
	0xE0,0x70,0x30,0x74,0x30,0xF4,0xA4,0x20,	/* 4438: p0t0  */
	0xB6,0x22,0xF0,0x70,0x74,0xE1,0xB6,0x22,	/* 4440: "pt" */
	0xF0,0x60,0xBE,0x73,0x28,0x52,0xD0,0x70,	/* 4448: `s(Rp */
	0x32,0x21,0xA8,0x70,0x60,0x3E,0xD1,0x70,	/* 4450: 2!p`>p */
	0x53,0x73,0x21,0x92,0x74,0x73,0x6C,0x91,	/* 4458: Ss!tsl */
	0x70,0x60,0x3F,0xD1,0x70,0x53,0x73,0x96,	/* 4460: p`?pSs */
	0xB2,0x22,0xF0,0xB2,0x22,0xF0,0x75,0xF6,	/* 4468: ""u */
	0x20,0x60,0xBE,0x73,0x28,0x52,0xD0,0x70,	/* 4470:  `s(Rp */
	0x5E,0x25,0xFA,0x25,0xFA,0xD1,0xE0,0x71,	/* 4478: ^%%q */
	0x70,0xE0,0x71,0x70,0xE1,0x40,0x71,0xE1,	/* 4480: pqp@q */
	0x41,0x70,0x53,0x73,0x61,0x2A,0x9E,0x74,	/* 4488: ApSsa*t */
	0x70,0x60,0xEA,0x75,0x74,0xF2,0x70,0x60,	/* 4490: p`utp` */
	0xEB,0x41,0x70,0xE2,0x76,0xA8,0x40,0x70,	/* 4498: Apv@p */
	0x60,0xE3,0x74,0x70,0x60,0xE8,0xB2,0x22,	/* 44A0: `tp`" */
	0xF0,0x40,0x71,0x28,0xE4,0x22,0xF0,0x0E,	/* 44A8: @q(". */
	0x00,0x0D,0x00,0x0B,0x00,0x0A,0x00,0x08,	/* 44B0: ........ */
	0x00,0x07,0x00,0x05,0x00,0x04,0x00,0x01,	/* 44B8: ........ */
	0x00,0x00,0x00,0x6A,0x00,0x71,0x28,0x52,	/* 44C0: ...j.q(R */
	0xD2,0x72,0x61,0x41,0x21,0xFB,0x4A,0x26,	/* 44C8: raA!J& */
	0x90,0x22,0xF0,0x00,0x00,0x00,0x00,0x00,	/* 44D0: "..... */
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	/* 44D8: ........ */
	0x00,0x00,0x00,0x60,0xBE,0x41,0x75,0x76,	/* 44E0: ...`Auv */
	0x24,0xFF,0xF0,0x21,0xA7,0x74,0xD0,0x75,	/* 44E8: $!tu */
	0x74,0xF2,0xD1,0x71,0x70,0xF9,0x21,0xA0,	/* 44F0: tqp! */
	0x40,0x70,0xE0,0x70,0x51,0xD0,0x71,0x70,	/* 44F8: @ppQqp */
	0xF9,0xA6,0x60,0x04,0x41,0xB2,0x22,0xF0,	/* 4500: `.A" */
	0x73,0x21,0x9C,0xD0,0x70,0x30,0xAF,0x70,	/* 4508: s!p0p */
	0x30,0x70,0xF2,0xD0,0x70,0x51,0xD1,0x73,	/* 4510: 0ppQs */
	0x99,0x70,0x30,0xA2,0x60,0x01,0x40,0xB2,	/* 4518: p0`.@ */
	0x22,0xF0,0x75,0xF6,0x20,0x5C,0xC0,0x60,	/* 4520: "u \` */
	0x4A,0x21,0xFB,0x22,0xF0,0x7E,0x02,0x22,	/* 4528: J!"~." */
	0xF0,0x71,0x60,0x8F,0xD1,0x71,0x60,0x4F,	/* 4530: q`q`O */
	0xF9,0x21,0xA4,0x24,0xF2,0x71,0x72,0xFA,	/* 4538: !$qr */
	0x30,0x73,0xFA,0xE0,0x71,0x60,0x8F,0xD1,	/* 4540: 0sq` */
	0x71,0x60,0x4F,0xF9,0xA2,0x61,0x0C,0x22,	/* 4548: q`Oa." */
	0xF0,0x60,0xB4,0x7D,0x29,0x52,0xD0,0x7E,	/* 4550: `})R~ */
	0x7F,0x24,0xFB,0xAE,0x1E,0x2E,0x44,0x21,	/* 4558: $..D! */
	0xFB,0x23,0x2F,0x92,0xAB,0x60,0x4F,0xBC,	/* 4560: #.`O */
	0x22,0xF0,0x70,0x61,0x3A,0xBC,0x22,0xF0,	/* 4568: "pa:" */
	0x40,0x7E,0x41,0x23,0xF7,0xD8,0x7F,0x40,	/* 4570: @~A#@ */
	0x23,0xF7,0xD9,0x78,0x60,0x4E,0x24,0xF6,	/* 4578: #x`N$ */
	0xD6,0x79,0xD7,0x2C,0x42,0x21,0xFB,0x16,	/* 4580: y,B!. */
	0x14,0x22,0x24,0x9B,0x70,0x61,0x3E,0xDA,	/* 4588: ."$pa> */
	0x70,0x7D,0x21,0x2F,0x92,0x10,0xD3,0x70,	/* 4590: p}!..p */
	0x61,0x33,0x21,0xA8,0x70,0x61,0x34,0x73,	/* 4598: a3!pa4s */
	0xF9,0xC0,0xA6,0x73,0x70,0x61,0x35,0xF9,	/* 45A0: spa5 */
	0xA5,0x70,0x61,0x32,0xD1,0x02,0x73,0xD1,	/* 45A8: pa2.s */
	0x71,0x69,0x5A,0xD1,0x70,0x61,0x3A,0xD2,	/* 45B0: qiZpa: */
	0x70,0x61,0x3B,0x21,0xFD,0xDA,0xDB,0x70,	/* 45B8: pa;!p */
	0x61,0x3A,0x21,0xFD,0xD8,0xD9,0x40,0x7A,	/* 45C0: a:!@z */
	0x78,0x24,0xFF,0xD6,0x7B,0x79,0x24,0xFF,	/* 45C8: x${y$ */
	0xD7,0x16,0x1E,0x23,0x28,0x90,0xC0,0x22,	/* 45D0: ..#(" */
	0xAA,0x70,0x61,0x3B,0x24,0xF2,0xF4,0x22,	/* 45D8: pa;$" */
	0xA2,0x70,0x61,0x33,0x22,0xAB,0x71,0x21,	/* 45E0: pa3"q! */
	0xFD,0xD8,0xD9,0x70,0x61,0x3A,0x21,0xFD,	/* 45E8: pa:! */
	0xD6,0xD7,0x40,0x78,0x76,0x24,0xFF,0xDA,	/* 45F0: @xv$ */
	0x79,0x77,0x24,0xFF,0xDB,0x1A,0x1E,0x23,	/* 45F8: yw$..# */
	0x25,0x94,0xAE,0x70,0x61,0x3F,0xD6,0x70,	/* 4600: %pa?p */
	0x7D,0x21,0x27,0x9D,0x60,0x4F,0xBC,0x22,	/* 4608: }!'`O" */
	0xF0,0x75,0x74,0x41,0x23,0xF6,0xDA,0xDB,	/* 4610: utA# */
	0x70,0x61,0x3A,0x21,0xFD,0xD6,0xD7,0x40,	/* 4618: pa:!@ */
	0x7A,0x76,0x23,0xF7,0xD8,0x7B,0x77,0x23,	/* 4620: zv#{w# */
	0xF7,0xD9,0x78,0x70,0x61,0xEA,0x70,0x61,	/* 4628: xpapa */
	0x33,0xA6,0x70,0x61,0x3A,0x70,0x61,0xE4,	/* 4630: 3pa:pa */
	0x70,0x61,0x3F,0xD6,0x70,0x7D,0x21,0x24,	/* 4638: pa?p}!$ */
	0x98,0x72,0xBC,0x22,0xF0,0x00,0x00,0x00,	/* 4640: r"... */
	0x00,0x02,0x00,0x00,0x00,0x60,0xBD,0x75,	/* 4648: .....`u */
	0xD2,0x41,0x74,0x27,0x3F,0x75,0x24,0xFF,	/* 4650: At'?u$ */
	0xF0,0xC0,0xA4,0x74,0x27,0x3F,0xD5,0x75,	/* 4658: t'?u */
	0xD0,0x40,0x25,0xFA,0xD1,0x70,0x74,0x61,	/* 4660: @%pta */
	0x2E,0x97,0x25,0xFA,0xD0,0x60,0x4F,0xF4,	/* 4668: .%`O */
	0xC0,0x22,0xA2,0x41,0x75,0x72,0x24,0xFF,	/* 4670: "Aur$ */
	0xF0,0xA5,0x24,0xF2,0xB3,0x22,0xF0,0x72,	/* 4678: $"r */
	0x25,0xFA,0xD5,0xD0,0x40,0x25,0xFA,0xD1,	/* 4680: %@% */
	0x70,0x74,0x61,0x2C,0x94,0x25,0xFA,0xD0,	/* 4688: pta,% */
	0x60,0x4F,0xF4,0x22,0xA4,0x75,0x70,0xE1,	/* 4690: `O"up */
	0x74,0x28,0x52,0x25,0xFA,0xD2,0x31,0x25,	/* 4698: t(R%1% */
	0xFA,0x25,0xFA,0xD1,0x31,0xF2,0x70,0xF4,	/* 46A0: %1p */
	0x21,0xA4,0x70,0x71,0xE0,0x70,0x72,0xE1,	/* 46A8: !pqpr */
	0x72,0x30,0x72,0x31,0xE0,0x70,0xB3,0x22,	/* 46B0: r0r1p" */
	0xF0,0x24,0xF2,0xB3,0x22,0xF0,0x75,0x71,	/* 46B8: $"uq */
	0x31,0xF2,0x71,0xE1,0x72,0x31,0xB3,0x22,	/* 46C0: 1qr1" */
	0xF0,0x60,0xBB,0x40,0xD1,0x77,0x21,0xAB,	/* 46C8: `@w! */
	0x77,0x52,0x60,0x4D,0xF4,0x60,0x4C,0x24,	/* 46D0: wR`M`L$ */
	0xF6,0xD7,0x76,0x28,0x52,0x25,0xFA,0xD2,	/* 46D8: v(R% */
	0x30,0x25,0xFA,0xD3,0x30,0xD0,0x71,0xC0,	/* 46E0: 0%0q */
	0x25,0xAB,0x05,0x24,0xF2,0xB5,0x22,0xF0,	/* 46E8: %.$" */
	0x70,0x72,0x30,0xF4,0x23,0xAA,0x41,0x77,	/* 46F0: pr0#Aw */
	0x70,0x31,0x24,0xFF,0xF0,0x22,0xAB,0x70,	/* 46F8: p1$"p */
	0x31,0x77,0xF4,0xAF,0x70,0x31,0x77,0xF4,	/* 4700: 1wp1w */
	0x70,0xE1,0x70,0x70,0x31,0xF2,0xD0,0x77,	/* 4708: ppp1w */
	0x70,0xE1,0x04,0x70,0x30,0x73,0xE0,0x24,	/* 4710: p.p0s$ */
	0xF2,0x81,0x70,0xE0,0x70,0x72,0x31,0xF4,	/* 4718: ppr1 */
	0xC0,0xA3,0x73,0x72,0xE1,0x70,0x52,0xD4,	/* 4720: srpR */
	0x41,0xD1,0x70,0xD3,0x70,0x30,0xD0,0x0B,	/* 4728: App0. */
	0x77,0x76,0x6E,0x99,0x25,0xFA,0xD0,0x24,	/* 4730: wvn%$ */
	0xF2,0xF4,0xA5,0x71,0xC0,0xA7,0x64,0x00,	/* 4738: qd. */
	0x24,0xF2,0xB5,0x22,0xF0,0x74,0xB5,0x22,	/* 4740: $"t" */
	0xF0,0x60,0xBD,0x74,0x29,0x52,0xD1,0x71,	/* 4748: `t)Rq */
	0x60,0x32,0xC0,0x21,0xA1,0x71,0x61,0x3C,	/* 4750: `2!qa< */
	0x22,0xA8,0x40,0xD0,0x71,0x61,0x39,0x71,	/* 4758: "@qa9q */
	0x61,0x38,0x74,0x62,0x20,0x9B,0x71,0x61,	/* 4760: a8tb qa */
	0x3E,0xD0,0x71,0x60,0x53,0x74,0x21,0x9B,	/* 4768: >q`St! */
	0x75,0x74,0x6A,0x95,0xD0,0x71,0x61,0x3F,	/* 4770: utjqa? */
	0xD2,0x71,0x60,0x53,0x74,0x9F,0x70,0xB3,	/* 4778: q`Stp */
	0x22,0xF0,0x24,0xF2,0xB3,0x22,0xF0,0x7E,	/* 4780: "$"~ */
	0xF6,0x7A,0xF6,0x74,0xF6,0x76,0xF6,0x01,	/* 4788: ztv. */
	0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,	/* 4790: ........ */
	0x00,0x00,0x00,0x01,0x20,0x0A,0x00,0x08,	/* 4798: .... ... */
	0x00,0x07,0x00,0x05,0x00,0x04,0x00,0x02,	/* 47A0: ........ */
	0x00,0x01,0x00,0xFE,0x02,0x71,0x29,0x52,	/* 47A8: ....q)R */
	0xD2,0x62,0x4A,0x21,0xFB,0x72,0x4D,0x24,	/* 47B0: bJ!rM$ */
	0xFA,0x72,0x62,0x4F,0x21,0xFB,0x47,0x62,	/* 47B8: rbO!Gb */
	0x26,0x9F,0x22,0xF0,0x20,0x20,0x60,0xBB,	/* 47C0: &"  ` */
	0x78,0xD0,0x77,0x11,0x13,0x23,0x94,0x11,	/* 47C8: xw..#. */
	0x76,0x44,0x24,0xFA,0xB5,0x22,0xF0,0x60,	/* 47D0: vD$"` */
	0xBB,0x77,0x30,0x77,0x31,0x24,0xF2,0xF4,	/* 47D8: w0w1$ */
	0x24,0xFB,0xC0,0x21,0xA0,0x78,0x30,0x60,	/* 47E0: $!x0` */
	0x4F,0xF4,0x78,0x31,0x60,0x4F,0xF4,0x24,	/* 47E8: Ox1`O$ */
	0xFB,0xC0,0xA2,0x21,0xF0,0x78,0xD0,0x77,	/* 47F0: !xw */
	0x13,0x11,0x98,0x11,0x76,0x44,0x24,0xFA,	/* 47F8: ...vD$ */
	0xB5,0x22,0xF0,0x60,0xB4,0x40,0xDA,0x40,	/* 4800: "`@@ */
	0xDB,0x24,0xF2,0x7F,0x31,0x24,0xF6,0x21,	/* 4808: $1$! */
	0xA3,0x41,0xDA,0x40,0x40,0x7F,0x30,0x24,	/* 4810: A@@0$ */
	0xFF,0xD8,0xD1,0x71,0x40,0x7F,0x31,0x24,	/* 4818: q@1$ */
	0xFF,0xD9,0xD1,0x08,0x40,0xDA,0x7F,0x30,	/* 4820: .@0 */
	0xD8,0x7F,0x31,0xD9,0x24,0xF2,0x21,0x70,	/* 4828: 1$!p */
	0x31,0x24,0xF6,0x21,0xA6,0x7A,0xC0,0xDB,	/* 4830: 1$!z */
	0x40,0x40,0x21,0x70,0x30,0x24,0xFF,0xD6,	/* 4838: @@!p0$ */
	0xD1,0x71,0x40,0x21,0x70,0x31,0x24,0xFF,	/* 4840: q@!p1$ */
	0xD7,0xD1,0x0A,0x7A,0xDB,0x21,0x70,0x30,	/* 4848: .z!p0 */
	0xD6,0x21,0x70,0x31,0xD7,0x16,0xD0,0x18,	/* 4850: !p1.. */
	0x12,0x14,0x22,0x9D,0x7B,0xAE,0x40,0x40,	/* 4858: .."{@@ */
	0x74,0x24,0xFF,0xD4,0xD1,0x71,0x40,0x75,	/* 4860: t$q@u */
	0x24,0xFF,0xD5,0xD1,0x7A,0xAE,0x40,0x40,	/* 4868: $z@@ */
	0x72,0x24,0xFF,0xD2,0xD1,0x71,0x40,0x73,	/* 4870: r$q@s */
	0x24,0xFF,0xD3,0xD1,0x14,0x7D,0x44,0x24,	/* 4878: $.}D$ */
	0xFA,0x12,0x7E,0x44,0x24,0xFA,0xBC,0x22,	/* 4880: .~D$" */
	0xF0,0x60,0xB6,0x7E,0x30,0xC0,0xA8,0x7E,	/* 4888: `~0~ */
	0x31,0xC0,0xA4,0x21,0xF0,0x2B,0x0B,0x7E,	/* 4890: 1!+.~ */
	0x31,0xC0,0x21,0xAA,0x40,0x7D,0x31,0x7E,	/* 4898: 1!@}1~ */
	0x30,0x21,0xFA,0x7B,0xE1,0xD2,0x72,0x7D,	/* 48A0: 0!{r} */
	0x30,0x7E,0x30,0x21,0xFA,0x7B,0xE0,0x7C,	/* 48A8: 0~0!{| */
	0xE0,0x40,0x7C,0xE1,0x29,0x0C,0x7E,0x31,	/* 48B0: @|).~1 */
	0x7E,0x30,0x21,0xF9,0xD4,0xD5,0xD6,0x76,	/* 48B8: ~0!v */
	0xC0,0xAA,0x40,0xD3,0x7D,0x31,0xD2,0x7D,	/* 48C0: @}1} */
	0x30,0xD1,0x21,0x01,0x40,0x7D,0x31,0x76,	/* 48C8: 0!.@}1v */
	0x23,0xF6,0xD0,0xD3,0x7D,0x31,0x7D,0x30,	/* 48D0: #}1}0 */
	0x76,0x23,0xF6,0xD1,0xD2,0x40,0x7B,0xE1,	/* 48D8: v#@{ */
	0x73,0x75,0xF4,0xC0,0xA5,0x60,0x4F,0x7B,	/* 48E0: su`O{ */
	0xE0,0x08,0x73,0x72,0x75,0x21,0xFA,0x7B,	/* 48E8: .sru!{ */
	0xE0,0xD0,0x7B,0x30,0x24,0xA9,0x40,0x74,	/* 48F0: {0$@t */
	0x7B,0x30,0x23,0xF1,0xD7,0xD8,0x78,0x75,	/* 48F8: {0#xu */
	0x7B,0x30,0x23,0xF1,0xD8,0xD9,0x40,0x71,	/* 4900: {0#@q */
	0x77,0x24,0xFF,0xD1,0xD0,0x70,0x72,0x78,	/* 4908: w$prx */
	0x24,0xFF,0xD2,0xD0,0x70,0x73,0x79,0x24,	/* 4910: $psy$ */
	0xFF,0xD3,0xD0,0x24,0xF2,0x73,0x24,0xF6,	/* 4918: $s$ */
	0x21,0xAD,0x7B,0x30,0x60,0x8F,0x7B,0xE0,	/* 4920: !{0`{ */
	0x40,0x74,0x71,0x23,0xF7,0xD1,0xD0,0x70,	/* 4928: @tq#p */
	0x75,0x72,0x23,0xF7,0xD2,0xD0,0x70,0x40,	/* 4930: ur#p@ */
	0x73,0x23,0xF7,0xD3,0xD0,0x62,0x0C,0x76,	/* 4938: s#b.v */
	0xC0,0xA7,0x71,0x7C,0xE0,0x72,0x7C,0xE1,	/* 4940: q|r| */
	0x09,0x72,0x71,0x76,0x23,0xF5,0x7C,0xE0,	/* 4948: .rqv#| */
	0x7C,0xE1,0xBA,0x22,0xF0,0x20,0x40,0xD3,	/* 4950: |" @ */
	0x71,0x31,0x72,0x31,0xF4,0xC0,0xAF,0x24,	/* 4958: q1r1$ */
	0xF2,0x71,0x30,0x23,0xF3,0x24,0xF2,0x72,	/* 4960: q0#$r */
	0x30,0x23,0xF3,0xF9,0xD3,0x06,0x71,0x31,	/* 4968: 0#.q1 */
	0x72,0x31,0xF9,0xD3,0x73,0x22,0xF0,0x60,	/* 4970: r1s"` */
	0xBE,0x74,0xD1,0x76,0x25,0xA0,0x41,0x21,	/* 4978: tv%A! */
	0x40,0x76,0x24,0xFF,0xF0,0xA4,0x21,0x40,	/* 4980: @v$!@ */
	0xD3,0x02,0x76,0xD3,0x40,0xD0,0x73,0x40,	/* 4988: .v@s@ */
	0xF9,0x21,0xA0,0x75,0x70,0x74,0xF2,0x23,	/* 4990: !upt# */
	0xFB,0x70,0x81,0xD0,0x73,0x70,0xF9,0xA3,	/* 4998: psp */
	0x20,0x60,0x00,0x73,0xD5,0x76,0x73,0xF4,	/* 49A0:  `.svs */
	0xD6,0x76,0x22,0xA2,0x41,0x75,0x76,0x24,	/* 49A8: v"Auv$ */
	0xFF,0xF0,0xA5,0x20,0x75,0xD3,0x03,0x20,	/* 49B0:  u.  */
	0x76,0xD3,0x74,0x75,0x74,0xF2,0x73,0x24,	/* 49B8: vtuts$ */
	0xFA,0x73,0x75,0xF5,0xD5,0x76,0x73,0xF4,	/* 49C0: suvs */
	0xD6,0x76,0xA3,0x20,0x62,0x0E,0x71,0xB2,	/* 49C8: v b.q */
	0x22,0xF0,0x20,0x70,0x72,0xE0,0x10,0x72,	/* 49D0: " pr.r */
	0xE1,0x40,0x22,0xF0,0x72,0x30,0x72,0x31,	/* 49D8: @"r0r1 */
	0xE0,0x73,0xC0,0xA2,0x41,0xD3,0x73,0x72,	/* 49E0: sAsr */
	0x31,0xE1,0x72,0x31,0x23,0xFC,0x71,0x22,	/* 49E8: 1r1#q" */
	0xF0,0x22,0xF9,0x72,0x31,0xF6,0x22,0xF0,	/* 49F0: "r1" */
	0x22,0xF9,0x72,0x31,0xF6,0x22,0xF0,0x40,	/* 49F8: "r1"@ */
	0x40,0x60,0xBB,0x73,0x36,0x73,0x34,0x60,	/* 4A00: @`s6s4` */
	0xEF,0x10,0x73,0x57,0x41,0xFB,0x21,0xF5,	/* 4A08: .sWA! */
	0x20,0x60,0xBF,0x73,0x57,0x21,0xF2,0xD0,	/* 4A10:  `sW! */
	0x70,0x24,0xF2,0xF4,0xA4,0x40,0xB1,0x22,	/* 4A18: p$@" */
	0xF0,0x41,0xB1,0x22,0xF0,0x72,0x71,0x61,	/* 4A20: A"rqa */
	0x98,0xA5,0x41,0x4B,0x71,0x28,0x9E,0x63,	/* 4A28: AKq(c */
	0x4E,0x21,0xFB,0x72,0x34,0xE0,0x70,0x72,	/* 4A30: N!r4pr */
	0xE1,0x72,0x34,0x21,0xFE,0x24,0xFB,0x23,	/* 4A38: r4!$# */
	0xF9,0x22,0xF0,0x72,0x71,0x63,0x9A,0xA5,	/* 4A40: "rqc */
	0x41,0x4B,0x71,0x27,0x90,0x64,0x40,0x21,	/* 4A48: AKq'd@! */
	0xFB,0x72,0x34,0xE0,0x70,0x72,0xE1,0x72,	/* 4A50: r4prr */
	0x34,0x60,0x4E,0x24,0xF6,0x23,0xF9,0x22,	/* 4A58: 4`N$#" */
	0xF0,0x72,0x71,0x65,0x9C,0xA5,0x41,0x4B,	/* 4A60: rqeAK */
	0x71,0x25,0x92,0x66,0x42,0x21,0xFB,0x72,	/* 4A68: q%fB!r */
	0x34,0xE0,0x70,0x72,0xE1,0x72,0x34,0x41,	/* 4A70: 4prr4A */
	0x24,0xFB,0x23,0xF9,0x22,0xF0,0x20,0x72,	/* 4A78: $#" r */
	0xA5,0x72,0x71,0x27,0xE2,0x07,0x22,0x27,	/* 4A80: rq'."' */
	0x20,0x4F,0x71,0x27,0xE2,0x72,0x71,0x27,	/* 4A88:  Oq'rq' */
	0x50,0xD2,0xD3,0x6B,0x07,0x71,0x29,0x3D,	/* 4A90: Pk.q)= */
	0x24,0xF2,0xF4,0xA6,0x71,0x29,0x3D,0xD3,	/* 4A98: $q)= */
	0x71,0x92,0x62,0x0B,0x77,0xF6,0x20,0x00,	/* 4AA0: qb.w . */
	0x00,0x00,0x00,0x71,0x29,0x5D,0xD2,0x72,	/* 4AA8: ...q)]r */
	0x60,0x43,0x21,0xFB,0x41,0x65,0x27,0x99,	/* 4AB0: `C!Ae' */
	0x22,0xF0,0x20,0x21,0x02,0x60,0xBE,0x24,	/* 4AB8: " !.`$ */
	0xF2,0xD0,0x75,0xD1,0x24,0xF2,0x24,0xF2,	/* 4AC0: u$$ */
	0x73,0x60,0x90,0xB2,0x22,0xF0,0x20,0x25,	/* 4AC8: s`" % */
	0xF8,0x21,0xF0,0x22,0xF0,0x60,0xBA,0x40,	/* 4AD0: !"`@ */
	0x21,0xFE,0xF4,0x21,0xAE,0x24,0xF2,0xD4,	/* 4AD8: !!$ */
	0x10,0xD5,0x4B,0x21,0xFB,0xD2,0x40,0x13,	/* 4AE0: .K!@. */
	0x25,0xF2,0x23,0xF9,0x10,0x14,0x41,0xFB,	/* 4AE8: %#..A */
	0x24,0xF3,0x11,0x41,0x24,0xF8,0x24,0xF4,	/* 4AF0: $.A$$ */
	0x72,0x23,0xFC,0x79,0x7C,0x33,0xF2,0x7C,	/* 4AF8: r#y|3| */
	0xE3,0x77,0x7C,0xE6,0x78,0x7C,0xE7,0x40,	/* 4B00: w|x|@ */
	0xD4,0x42,0xD5,0x74,0xC0,0xA4,0x7C,0x39,	/* 4B08: Bt|9 */
	0xD1,0x03,0x7C,0x3A,0xD1,0x71,0x7A,0xF9,	/* 4B10: .|:qz */
	0x25,0xAB,0x24,0xF2,0x71,0x23,0xF3,0xD0,	/* 4B18: %$q# */
	0x70,0x41,0x24,0xF0,0xD2,0x72,0x24,0xF2,	/* 4B20: pA$r$ */
	0xFA,0xD0,0x79,0x70,0x33,0xF2,0x70,0xE3,	/* 4B28: yp3p */
	0x79,0x70,0x34,0xF2,0x70,0xE4,0x74,0x23,	/* 4B30: yp4pt# */
	0xA5,0x22,0x40,0x70,0x31,0x24,0xF6,0xC0,	/* 4B38: "@p1$ */
	0x22,0xAC,0x42,0x70,0x31,0x24,0xF6,0x21,	/* 4B40: "Bp1$! */
	0xA4,0x70,0x37,0x4A,0x21,0xFB,0xF0,0xE0,	/* 4B48: p7J! */
	0x70,0x34,0x70,0x37,0x23,0xFC,0xD4,0xF6,	/* 4B50: p4p7# */
	0x70,0x23,0xFC,0x21,0x01,0x70,0x34,0x70,	/* 4B58: p#!.p4p */
	0x37,0x60,0xEF,0x41,0x70,0x31,0x24,0xF6,	/* 4B60: 7`Ap1$ */
	0xC0,0x70,0x37,0xF2,0x23,0xF9,0x70,0x3E,	/* 4B68: p7#p> */
	0xD3,0x73,0xD1,0x65,0x00,0x14,0x26,0x4F,	/* 4B70: se..&O */
	0x22,0xF1,0x21,0xF5,0xB6,0x22,0xF0,0x20,	/* 4B78: "!"  */
	0x60,0xBA,0x77,0x3F,0xD0,0x24,0xF2,0x70,	/* 4B80: `w?$p */
	0x23,0xF3,0xD1,0x71,0x41,0x24,0xF0,0xD5,	/* 4B88: #qA$ */
	0x75,0x24,0xF2,0xFA,0xD4,0x74,0x39,0xD1,	/* 4B90: u$t9 */
	0x71,0x74,0x34,0xF9,0x24,0xAC,0x24,0xF2,	/* 4B98: qt4$$ */
	0x71,0x23,0xF3,0xD0,0x70,0x41,0x24,0xF0,	/* 4BA0: q#pA$ */
	0xD2,0x72,0x24,0xF2,0xFA,0xD0,0x22,0x40,	/* 4BA8: r$"@ */
	0x70,0x31,0x24,0xF6,0xC0,0x22,0xAC,0x42,	/* 4BB0: p1$"B */
	0x70,0x31,0x24,0xF6,0x21,0xA4,0x70,0x37,	/* 4BB8: p1$!p7 */
	0x4A,0x21,0xFB,0xF0,0xE0,0x70,0x34,0x70,	/* 4BC0: J!p4p */
	0x37,0x23,0xFC,0xD4,0xF6,0x70,0x23,0xFC,	/* 4BC8: 7#p# */
	0x21,0x01,0x70,0x34,0x70,0x37,0x60,0xEF,	/* 4BD0: !.p4p7` */
	0x41,0x70,0x31,0x24,0xF6,0xC0,0x70,0x37,	/* 4BD8: Ap1$p7 */
	0xF2,0x23,0xF9,0x70,0x3E,0xD3,0x73,0xD1,	/* 4BE0: #p>s */
	0x65,0x0E,0xB6,0x22,0xF0,0x20,0x20,0x64,	/* 4BE8: e."  d */
	0x24,0x24,0x08,0x20,0x20,0x60,0x08      	/* 4BF0: $$.  `.  */

};
int si3_t225_dsize = sizeof(si3_t225_download);		/* 0x4BF7 (19447) */

unsigned short si3_t225_downloadaddr = 0x0000;

/* End of SI3_T225.C */
