#!/bin/sh
#	$NetBSD: makemachservices.sh,v 1.5 2003/11/30 00:09:59 manu Exp $
#
# Copyright (c) 2003 The NetBSD Foundation, Inc.
# All rights reserved.
# This code is derived from software contributed to The NetBSD Foundation
# by Emmanuel Dreyfus.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#      This product includes software developed by the NetBSD
#      Foundation, Inc. and its contributors.
# 4. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

master="mach_services.master"
table="mach_services.c"
headers="mach_services.h"
names="mach_services_names.c"

sed -e '
:join
	/\\$/{a\

	N
	s/\\\n//
	b join
	}
' $master | awk '
BEGIN{
	intable = 0;
	table = "'$table'";
	headers = "'$headers'";
	names = "'$names'";

	printf("/* \$NetBSD\$ *\/\n\n") > table;
	printf("/*\n * Mach services table.\n *\n") > table;
	printf(" * DO NOT EDIT -- this file is automatically generated.\n") > \
	    table;

	printf("/* \$NetBSD\$ *\/\n\n") > headers;
	printf("/*\n * Mach services prototypes.\n *\n") > headers;
	printf(" * DO NOT EDIT -- this file is automatically generated.\n") > \
	    headers;

	printf("/* \$NetBSD\$ *\/\n\n") > names;
	printf("/*\n * Mach services names. This file is not built\n") > names;
	printf(" * by the kernel, it is included by kdump sources.\n *\n") > \
	    names;
	printf(" * DO NOT EDIT -- this file is automatically generated.\n") > \
	    names;
}
(NR == 1) {
	gsub(/^[^\$]*\$/, "", $0);
	gsub(/\$.*$/, "", $0);
	printf(" * created from %s\n */\n\n", $0) > table;
	printf("#include \<sys/cdefs.h\>\n__KERNEL_RCSID(0, " \
	    "\"\$NetBSD\$\");\n\n") > table;

	printf(" * created from %s\n */\n\n", $0) > headers;
	printf("#include \<sys/cdefs.h\>\n__KERNEL_RCSID(0, " \
	    "\"\$NetBSD\$\");\n\n") > headers;
	printf("#include <compat/mach/mach_types.h>\n") > headers;
	printf("#include <compat/mach/mach_message.h>\n") > headers;

	printf(" * created from %s\n */\n\n", $0) > names;
	printf("#include \<sys/cdefs.h\>\n__KERNEL_RCSID(0, " \
	    "\"\$NetBSD\$\");\n\n") > names;
	printf("struct mach_service_name {\n") > names;
	printf("	int srv_id;\n") > names;
	printf("	const char *srv_name;\n") > names;
	printf("};\n\n") > names;
	next;
}
(NF == 0 || $1 ~ /^;/) {
	next;
}
($0 ~ /^%%$/) {
	intable = 1;
	printf("\nstruct mach_service mach_services_table[] = {\n") > table;
	printf("\n") > headers;
	printf("struct mach_service_name mach_services_names[] = {\n") > names;
	next;
}
(!intable) {
	printf("%s\n", $0) > table;
	next;
}
(intable && $2 == "STD") {
	printf("	{%d, mach_%s, \"%s\", " \
	    "sizeof(mach_%s_request_t), sizeof(mach_%s_reply_t)},\n", \
	    $1, $3, $3, $3, $3) > table;
	printf("int mach_%s(struct mach_trap_args *);\n", $3) > headers;
	printf("	{%d, \"%s\"},\n", $1, $3) > names;
}
(intable && $2 == "NODEF") {
	printf("	{%d, NULL, \"%s\", 0, 0},\n", \
	    $1, $3, $3, $3, $3) > table;
	printf("	{%d, \"%s\"},\n", $1, $3) > names;
}
(intable && $2 == "UNIMPL") {
	printf("	{%d, NULL, \"unimpl. %s\", 0, 0},\n", \
	    $1, $3, $3, $3, $3) > table;
	printf("	{%d, \"unimpl. %s\"},\n", $1, $3) > names;
}
(intable && $2 == "OBSOL") {
	printf("	{%d, NULL, \"obsolete %s\", 0, 0},\n", \
	    $1, $3, $3, $3, $3) > table;
	printf("	{%d, \"obsolete %s\"},\n", $1, $3) > names;
}
END {
	printf("	{0, NULL, NULL, 0, 0}\n") > table;
	printf("};\n") > table;

	printf("	{0, NULL}\n") > names;
	printf("};\n") > names;
}
'
