/* $NetBSD: netbsd32_syscallargs.h,v 1.31 2003/10/25 16:28:09 chs Exp $ */

/*
 * System call argument lists.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.25 2003/10/25 16:27:25 chs Exp 
 */

#ifndef _netbsd32_SYS__SYSCALLARGS_H_
#define	_netbsd32_SYS__SYSCALLARGS_H_

#ifdef	syscallarg
#undef	syscallarg
#endif

#define	syscallarg(x)							\
	union {								\
		register32_t pad;						\
		struct { x datum; } le;					\
		struct { /* LINTED zero array dimension */		\
			int8_t pad[  /* CONSTCOND */			\
				(sizeof (register32_t) < sizeof (x))	\
				? 0					\
				: sizeof (register32_t) - sizeof (x)];	\
			x datum;					\
		} be;							\
	}

struct netbsd32_exit_args {
	syscallarg(int) rval;
};

struct netbsd32_read_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_voidp) buf;
	syscallarg(netbsd32_size_t) nbyte;
};

struct netbsd32_write_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_voidp) buf;
	syscallarg(netbsd32_size_t) nbyte;
};

struct netbsd32_open_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(int) flags;
	syscallarg(mode_t) mode;
};

struct netbsd32_close_args {
	syscallarg(int) fd;
};

struct netbsd32_wait4_args {
	syscallarg(int) pid;
	syscallarg(netbsd32_intp) status;
	syscallarg(int) options;
	syscallarg(netbsd32_rusagep_t) rusage;
};

struct compat_43_netbsd32_ocreat_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(mode_t) mode;
};

struct netbsd32_link_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(const netbsd32_charp) link;
};

struct netbsd32_unlink_args {
	syscallarg(const netbsd32_charp) path;
};

struct netbsd32_chdir_args {
	syscallarg(const netbsd32_charp) path;
};

struct netbsd32_fchdir_args {
	syscallarg(int) fd;
};

struct netbsd32_mknod_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(mode_t) mode;
	syscallarg(dev_t) dev;
};

struct netbsd32_chmod_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(mode_t) mode;
};

struct netbsd32_chown_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct netbsd32_break_args {
	syscallarg(netbsd32_charp) nsize;
};

struct netbsd32_getfsstat_args {
	syscallarg(netbsd32_statfsp_t) buf;
	syscallarg(netbsd32_long) bufsize;
	syscallarg(int) flags;
};

struct compat_43_netbsd32_olseek_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_long) offset;
	syscallarg(int) whence;
};

struct netbsd32_mount_args {
	syscallarg(const netbsd32_charp) type;
	syscallarg(const netbsd32_charp) path;
	syscallarg(int) flags;
	syscallarg(netbsd32_voidp) data;
};

struct netbsd32_unmount_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(int) flags;
};

struct netbsd32_setuid_args {
	syscallarg(uid_t) uid;
};

struct netbsd32_ptrace_args {
	syscallarg(int) req;
	syscallarg(pid_t) pid;
	syscallarg(netbsd32_caddr_t) addr;
	syscallarg(int) data;
};

struct netbsd32_recvmsg_args {
	syscallarg(int) s;
	syscallarg(netbsd32_msghdrp_t) msg;
	syscallarg(int) flags;
};

struct netbsd32_sendmsg_args {
	syscallarg(int) s;
	syscallarg(const netbsd32_msghdrp_t) msg;
	syscallarg(int) flags;
};

struct netbsd32_recvfrom_args {
	syscallarg(int) s;
	syscallarg(netbsd32_voidp) buf;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) flags;
	syscallarg(netbsd32_sockaddrp_t) from;
	syscallarg(netbsd32_intp) fromlenaddr;
};

struct netbsd32_accept_args {
	syscallarg(int) s;
	syscallarg(netbsd32_sockaddrp_t) name;
	syscallarg(netbsd32_intp) anamelen;
};

struct netbsd32_getpeername_args {
	syscallarg(int) fdes;
	syscallarg(netbsd32_sockaddrp_t) asa;
	syscallarg(netbsd32_intp) alen;
};

struct netbsd32_getsockname_args {
	syscallarg(int) fdes;
	syscallarg(netbsd32_sockaddrp_t) asa;
	syscallarg(netbsd32_intp) alen;
};

struct netbsd32_access_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(int) flags;
};

struct netbsd32_chflags_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(netbsd32_u_long) flags;
};

struct netbsd32_fchflags_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_u_long) flags;
};

struct netbsd32_kill_args {
	syscallarg(int) pid;
	syscallarg(int) signum;
};

struct compat_43_netbsd32_stat43_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(netbsd32_stat43p_t) ub;
};

struct compat_43_netbsd32_lstat43_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(netbsd32_stat43p_t) ub;
};

struct netbsd32_dup_args {
	syscallarg(int) fd;
};

struct netbsd32_profil_args {
	syscallarg(netbsd32_caddr_t) samples;
	syscallarg(netbsd32_size_t) size;
	syscallarg(netbsd32_u_long) offset;
	syscallarg(u_int) scale;
};
#if defined(KTRACE) || !defined(_KERNEL)

struct netbsd32_ktrace_args {
	syscallarg(const netbsd32_charp) fname;
	syscallarg(int) ops;
	syscallarg(int) facs;
	syscallarg(int) pid;
};
#else
#endif

struct netbsd32_sigaction_args {
	syscallarg(int) signum;
	syscallarg(const netbsd32_sigactionp_t) nsa;
	syscallarg(netbsd32_sigactionp_t) osa;
};

struct compat_13_netbsd32_sigprocmask_args {
	syscallarg(int) how;
	syscallarg(int) mask;
};

struct netbsd32___getlogin_args {
	syscallarg(netbsd32_charp) namebuf;
	syscallarg(u_int) namelen;
};

struct netbsd32_setlogin_args {
	syscallarg(const netbsd32_charp) namebuf;
};

struct netbsd32_acct_args {
	syscallarg(const netbsd32_charp) path;
};

struct compat_13_netbsd32_sigaltstack13_args {
	syscallarg(const netbsd32_sigaltstack13p_t) nss;
	syscallarg(netbsd32_sigaltstack13p_t) oss;
};

struct netbsd32_ioctl_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_u_long) com;
	syscallarg(netbsd32_voidp) data;
};

struct compat_12_netbsd32_reboot_args {
	syscallarg(int) opt;
};

struct netbsd32_revoke_args {
	syscallarg(const netbsd32_charp) path;
};

struct netbsd32_symlink_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(const netbsd32_charp) link;
};

struct netbsd32_readlink_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(netbsd32_charp) buf;
	syscallarg(netbsd32_size_t) count;
};

struct netbsd32_execve_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(netbsd32_charpp) argp;
	syscallarg(netbsd32_charpp) envp;
};

struct netbsd32_umask_args {
	syscallarg(mode_t) newmask;
};

struct netbsd32_chroot_args {
	syscallarg(const netbsd32_charp) path;
};

struct compat_43_netbsd32_fstat43_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_stat43p_t) sb;
};

struct compat_43_netbsd32_ogetkerninfo_args {
	syscallarg(int) op;
	syscallarg(netbsd32_charp) where;
	syscallarg(netbsd32_intp) size;
	syscallarg(int) arg;
};

struct compat_12_netbsd32_msync_args {
	syscallarg(netbsd32_caddr_t) addr;
	syscallarg(netbsd32_size_t) len;
};

struct netbsd32_sbrk_args {
	syscallarg(netbsd32_intptr_t) incr;
};

struct netbsd32_sstk_args {
	syscallarg(int) incr;
};

struct compat_43_netbsd32_ommap_args {
	syscallarg(netbsd32_caddr_t) addr;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) prot;
	syscallarg(int) flags;
	syscallarg(int) fd;
	syscallarg(netbsd32_long) pos;
};

struct netbsd32_ovadvise_args {
	syscallarg(int) anom;
};

struct netbsd32_munmap_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
};

struct netbsd32_mprotect_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) prot;
};

struct netbsd32_madvise_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) behav;
};

struct netbsd32_mincore_args {
	syscallarg(netbsd32_caddr_t) addr;
	syscallarg(netbsd32_size_t) len;
	syscallarg(netbsd32_charp) vec;
};

struct netbsd32_getgroups_args {
	syscallarg(int) gidsetsize;
	syscallarg(netbsd32_gid_tp) gidset;
};

struct netbsd32_setgroups_args {
	syscallarg(int) gidsetsize;
	syscallarg(const netbsd32_gid_tp) gidset;
};

struct netbsd32_setpgid_args {
	syscallarg(int) pid;
	syscallarg(int) pgid;
};

struct netbsd32_setitimer_args {
	syscallarg(int) which;
	syscallarg(const netbsd32_itimervalp_t) itv;
	syscallarg(netbsd32_itimervalp_t) oitv;
};

struct compat_12_netbsd32_oswapon_args {
	syscallarg(const netbsd32_charp) name;
};

struct netbsd32_getitimer_args {
	syscallarg(int) which;
	syscallarg(netbsd32_itimervalp_t) itv;
};

struct compat_43_netbsd32_ogethostname_args {
	syscallarg(netbsd32_charp) hostname;
	syscallarg(u_int) len;
};

struct compat_43_netbsd32_osethostname_args {
	syscallarg(netbsd32_charp) hostname;
	syscallarg(u_int) len;
};

struct netbsd32_dup2_args {
	syscallarg(int) from;
	syscallarg(int) to;
};

struct netbsd32_fcntl_args {
	syscallarg(int) fd;
	syscallarg(int) cmd;
	syscallarg(netbsd32_voidp) arg;
};

struct netbsd32_select_args {
	syscallarg(int) nd;
	syscallarg(netbsd32_fd_setp_t) in;
	syscallarg(netbsd32_fd_setp_t) ou;
	syscallarg(netbsd32_fd_setp_t) ex;
	syscallarg(netbsd32_timevalp_t) tv;
};

struct netbsd32_fsync_args {
	syscallarg(int) fd;
};

struct netbsd32_setpriority_args {
	syscallarg(int) which;
	syscallarg(int) who;
	syscallarg(int) prio;
};

struct netbsd32_socket_args {
	syscallarg(int) domain;
	syscallarg(int) type;
	syscallarg(int) protocol;
};

struct netbsd32_connect_args {
	syscallarg(int) s;
	syscallarg(const netbsd32_sockaddrp_t) name;
	syscallarg(int) namelen;
};

struct compat_43_netbsd32_oaccept_args {
	syscallarg(int) s;
	syscallarg(netbsd32_caddr_t) name;
	syscallarg(netbsd32_intp) anamelen;
};

struct netbsd32_getpriority_args {
	syscallarg(int) which;
	syscallarg(int) who;
};

struct compat_43_netbsd32_osend_args {
	syscallarg(int) s;
	syscallarg(netbsd32_caddr_t) buf;
	syscallarg(int) len;
	syscallarg(int) flags;
};

struct compat_43_netbsd32_orecv_args {
	syscallarg(int) s;
	syscallarg(netbsd32_caddr_t) buf;
	syscallarg(int) len;
	syscallarg(int) flags;
};

struct compat_13_netbsd32_sigreturn_args {
	syscallarg(netbsd32_sigcontextp_t) sigcntxp;
};

struct netbsd32_bind_args {
	syscallarg(int) s;
	syscallarg(const netbsd32_sockaddrp_t) name;
	syscallarg(int) namelen;
};

struct netbsd32_setsockopt_args {
	syscallarg(int) s;
	syscallarg(int) level;
	syscallarg(int) name;
	syscallarg(const netbsd32_voidp) val;
	syscallarg(int) valsize;
};

struct netbsd32_listen_args {
	syscallarg(int) s;
	syscallarg(int) backlog;
};

struct compat_43_netbsd32_osigvec_args {
	syscallarg(int) signum;
	syscallarg(netbsd32_sigvecp_t) nsv;
	syscallarg(netbsd32_sigvecp_t) osv;
};
#if defined(COMPAT_43) || defined(COMPAT_SUNOS)

struct compat_43_netbsd32_sigblock_args {
	syscallarg(int) mask;
};

struct compat_43_netbsd32_sigsetmask_args {
	syscallarg(int) mask;
};
#else
#endif

struct compat_13_netbsd32_sigsuspend_args {
	syscallarg(int) mask;
};

struct compat_43_netbsd32_osigstack_args {
	syscallarg(netbsd32_sigstackp_t) nss;
	syscallarg(netbsd32_sigstackp_t) oss;
};

struct compat_43_netbsd32_orecvmsg_args {
	syscallarg(int) s;
	syscallarg(netbsd32_omsghdrp_t) msg;
	syscallarg(int) flags;
};

struct compat_43_netbsd32_osendmsg_args {
	syscallarg(int) s;
	syscallarg(netbsd32_caddr_t) msg;
	syscallarg(int) flags;
};

struct netbsd32_gettimeofday_args {
	syscallarg(netbsd32_timevalp_t) tp;
	syscallarg(netbsd32_timezonep_t) tzp;
};

struct netbsd32_getrusage_args {
	syscallarg(int) who;
	syscallarg(netbsd32_rusagep_t) rusage;
};

struct netbsd32_getsockopt_args {
	syscallarg(int) s;
	syscallarg(int) level;
	syscallarg(int) name;
	syscallarg(netbsd32_voidp) val;
	syscallarg(netbsd32_intp) avalsize;
};

struct netbsd32_readv_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_iovecp_t) iovp;
	syscallarg(int) iovcnt;
};

struct netbsd32_writev_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_iovecp_t) iovp;
	syscallarg(int) iovcnt;
};

struct netbsd32_settimeofday_args {
	syscallarg(const netbsd32_timevalp_t) tv;
	syscallarg(const netbsd32_timezonep_t) tzp;
};

struct netbsd32_fchown_args {
	syscallarg(int) fd;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct netbsd32_fchmod_args {
	syscallarg(int) fd;
	syscallarg(mode_t) mode;
};

struct compat_43_netbsd32_orecvfrom_args {
	syscallarg(int) s;
	syscallarg(netbsd32_caddr_t) buf;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) flags;
	syscallarg(netbsd32_caddr_t) from;
	syscallarg(netbsd32_intp) fromlenaddr;
};

struct netbsd32_setreuid_args {
	syscallarg(uid_t) ruid;
	syscallarg(uid_t) euid;
};

struct netbsd32_setregid_args {
	syscallarg(gid_t) rgid;
	syscallarg(gid_t) egid;
};

struct netbsd32_rename_args {
	syscallarg(const netbsd32_charp) from;
	syscallarg(const netbsd32_charp) to;
};

struct compat_43_netbsd32_otruncate_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(netbsd32_long) length;
};

struct compat_43_netbsd32_oftruncate_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_long) length;
};

struct netbsd32_flock_args {
	syscallarg(int) fd;
	syscallarg(int) how;
};

struct netbsd32_mkfifo_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(mode_t) mode;
};

struct netbsd32_sendto_args {
	syscallarg(int) s;
	syscallarg(const netbsd32_voidp) buf;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) flags;
	syscallarg(const netbsd32_sockaddrp_t) to;
	syscallarg(int) tolen;
};

struct netbsd32_shutdown_args {
	syscallarg(int) s;
	syscallarg(int) how;
};

struct netbsd32_socketpair_args {
	syscallarg(int) domain;
	syscallarg(int) type;
	syscallarg(int) protocol;
	syscallarg(netbsd32_intp) rsv;
};

struct netbsd32_mkdir_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(mode_t) mode;
};

struct netbsd32_rmdir_args {
	syscallarg(const netbsd32_charp) path;
};

struct netbsd32_utimes_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(const netbsd32_timevalp_t) tptr;
};

struct netbsd32_adjtime_args {
	syscallarg(const netbsd32_timevalp_t) delta;
	syscallarg(netbsd32_timevalp_t) olddelta;
};

struct compat_43_netbsd32_ogetpeername_args {
	syscallarg(int) fdes;
	syscallarg(netbsd32_caddr_t) asa;
	syscallarg(netbsd32_intp) alen;
};
#if defined(COMPAT_43) || defined(COMPAT_SUNOS)

struct compat_43_netbsd32_sethostid_args {
	syscallarg(int32_t) hostid;
};
#else
#endif

struct compat_43_netbsd32_ogetrlimit_args {
	syscallarg(int) which;
	syscallarg(netbsd32_orlimitp_t) rlp;
};

struct compat_43_netbsd32_osetrlimit_args {
	syscallarg(int) which;
	syscallarg(const netbsd32_orlimitp_t) rlp;
};
#if defined(COMPAT_43) || defined(COMPAT_SUNOS)

struct compat_43_netbsd32_killpg_args {
	syscallarg(int) pgid;
	syscallarg(int) signum;
};
#else
#endif

struct netbsd32_quotactl_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(int) cmd;
	syscallarg(int) uid;
	syscallarg(netbsd32_caddr_t) arg;
};

struct compat_43_netbsd32_ogetsockname_args {
	syscallarg(int) fdec;
	syscallarg(netbsd32_caddr_t) asa;
	syscallarg(netbsd32_intp) alen;
};
#if defined(NFS) || defined(NFSSERVER) || !defined(_KERNEL)

struct netbsd32_nfssvc_args {
	syscallarg(int) flag;
	syscallarg(netbsd32_voidp) argp;
};
#else
#endif

struct compat_43_netbsd32_ogetdirentries_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_charp) buf;
	syscallarg(u_int) count;
	syscallarg(netbsd32_longp) basep;
};

struct netbsd32_statfs_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(netbsd32_statfsp_t) buf;
};

struct netbsd32_fstatfs_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_statfsp_t) buf;
};
#if defined(NFS) || defined(NFSSERVER) || !defined(_KERNEL)

struct netbsd32_getfh_args {
	syscallarg(const netbsd32_charp) fname;
	syscallarg(netbsd32_fhandlep_t) fhp;
};
#else
#endif

struct compat_09_netbsd32_ogetdomainname_args {
	syscallarg(netbsd32_charp) domainname;
	syscallarg(int) len;
};

struct compat_09_netbsd32_osetdomainname_args {
	syscallarg(netbsd32_charp) domainname;
	syscallarg(int) len;
};

struct compat_09_netbsd32_uname_args {
	syscallarg(netbsd32_outsnamep_t) name;
};

struct netbsd32_sysarch_args {
	syscallarg(int) op;
	syscallarg(netbsd32_voidp) parms;
};
#if defined(SYSVSEM) || !defined(_KERNEL)

struct compat_10_netbsd32_sys_semsys_args {
	syscallarg(int) which;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
	syscallarg(int) a5;
};
#else
#endif
#if defined(SYSVMSG) || !defined(_KERNEL)

struct compat_10_netbsd32_sys_msgsys_args {
	syscallarg(int) which;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
	syscallarg(int) a5;
	syscallarg(int) a6;
};
#else
#endif
#if defined(SYSVSHM) || !defined(_KERNEL)

struct compat_10_netbsd32_sys_shmsys_args {
	syscallarg(int) which;
	syscallarg(int) a2;
	syscallarg(int) a3;
	syscallarg(int) a4;
};
#else
#endif

struct netbsd32_pread_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_voidp) buf;
	syscallarg(netbsd32_size_t) nbyte;
	syscallarg(int) pad;
	syscallarg(off_t) offset;
};

struct netbsd32_pwrite_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_voidp) buf;
	syscallarg(netbsd32_size_t) nbyte;
	syscallarg(int) pad;
	syscallarg(off_t) offset;
};

struct netbsd32_ntp_gettime_args {
	syscallarg(netbsd32_ntptimevalp_t) ntvp;
};

struct netbsd32_ntp_adjtime_args {
	syscallarg(netbsd32_timexp_t) tp;
};

struct netbsd32_setgid_args {
	syscallarg(gid_t) gid;
};

struct netbsd32_setegid_args {
	syscallarg(gid_t) egid;
};

struct netbsd32_seteuid_args {
	syscallarg(uid_t) euid;
};
#if defined(LFS) || !defined(_KERNEL)

struct netbsd32_sys_lfs_bmapv_args {
	syscallarg(netbsd32_fsid_tp_t) fsidp;
	syscallarg(netbsd32_block_infop_t) blkiov;
	syscallarg(int) blkcnt;
};

struct netbsd32_sys_lfs_markv_args {
	syscallarg(netbsd32_fsid_tp_t) fsidp;
	syscallarg(netbsd32_block_infop_t) blkiov;
	syscallarg(int) blkcnt;
};

struct netbsd32_sys_lfs_segclean_args {
	syscallarg(netbsd32_fsid_tp_t) fsidp;
	syscallarg(netbsd32_u_long) segment;
};

struct netbsd32_sys_lfs_segwait_args {
	syscallarg(netbsd32_fsid_tp_t) fsidp;
	syscallarg(netbsd32_timevalp_t) tv;
};
#else
#endif

struct compat_12_netbsd32_stat12_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(netbsd32_stat12p_t) ub;
};

struct compat_12_netbsd32_fstat12_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_stat12p_t) sb;
};

struct compat_12_netbsd32_lstat12_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(netbsd32_stat12p_t) ub;
};

struct netbsd32_pathconf_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(int) name;
};

struct netbsd32_fpathconf_args {
	syscallarg(int) fd;
	syscallarg(int) name;
};

struct netbsd32_getrlimit_args {
	syscallarg(int) which;
	syscallarg(netbsd32_rlimitp_t) rlp;
};

struct netbsd32_setrlimit_args {
	syscallarg(int) which;
	syscallarg(const netbsd32_rlimitp_t) rlp;
};

struct compat_12_netbsd32_getdirentries_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_charp) buf;
	syscallarg(u_int) count;
	syscallarg(netbsd32_longp) basep;
};

struct netbsd32_mmap_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) prot;
	syscallarg(int) flags;
	syscallarg(int) fd;
	syscallarg(netbsd32_long) pad;
	syscallarg(off_t) pos;
};

struct netbsd32_lseek_args {
	syscallarg(int) fd;
	syscallarg(int) pad;
	syscallarg(off_t) offset;
	syscallarg(int) whence;
};

struct netbsd32_truncate_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(int) pad;
	syscallarg(off_t) length;
};

struct netbsd32_ftruncate_args {
	syscallarg(int) fd;
	syscallarg(int) pad;
	syscallarg(off_t) length;
};

struct netbsd32___sysctl_args {
	syscallarg(netbsd32_intp) name;
	syscallarg(u_int) namelen;
	syscallarg(netbsd32_voidp) old;
	syscallarg(netbsd32_size_tp) oldlenp;
	syscallarg(netbsd32_voidp) new;
	syscallarg(netbsd32_size_t) newlen;
};

struct netbsd32_mlock_args {
	syscallarg(const netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
};

struct netbsd32_munlock_args {
	syscallarg(const netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
};

struct netbsd32_undelete_args {
	syscallarg(const netbsd32_charp) path;
};

struct netbsd32_futimes_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_timevalp_t) tptr;
};

struct netbsd32_getpgid_args {
	syscallarg(pid_t) pid;
};

struct netbsd32_reboot_args {
	syscallarg(int) opt;
	syscallarg(netbsd32_charp) bootstr;
};

struct netbsd32_poll_args {
	syscallarg(netbsd32_pollfdp_t) fds;
	syscallarg(u_int) nfds;
	syscallarg(int) timeout;
};
#if defined(LKM) || !defined(_KERNEL)
#else	/* !LKM || !_KERNEL */
#endif	/* !LKM || !_KERNEL */
#if defined(SYSVSEM) || !defined(_KERNEL)

struct compat_14_netbsd32___semctl_args {
	syscallarg(int) semid;
	syscallarg(int) semnum;
	syscallarg(int) cmd;
	syscallarg(netbsd32_semunu_t) arg;
};

struct netbsd32_semget_args {
	syscallarg(netbsd32_key_t) key;
	syscallarg(int) nsems;
	syscallarg(int) semflg;
};

struct netbsd32_semop_args {
	syscallarg(int) semid;
	syscallarg(netbsd32_sembufp_t) sops;
	syscallarg(netbsd32_size_t) nsops;
};

struct netbsd32_semconfig_args {
	syscallarg(int) flag;
};
#else
#endif
#if defined(SYSVMSG) || !defined(_KERNEL)

struct compat_14_netbsd32_msgctl_args {
	syscallarg(int) msqid;
	syscallarg(int) cmd;
	syscallarg(netbsd32_msqid_dsp_t) buf;
};

struct netbsd32_msgget_args {
	syscallarg(netbsd32_key_t) key;
	syscallarg(int) msgflg;
};

struct netbsd32_msgsnd_args {
	syscallarg(int) msqid;
	syscallarg(const netbsd32_voidp) msgp;
	syscallarg(netbsd32_size_t) msgsz;
	syscallarg(int) msgflg;
};

struct netbsd32_msgrcv_args {
	syscallarg(int) msqid;
	syscallarg(netbsd32_voidp) msgp;
	syscallarg(netbsd32_size_t) msgsz;
	syscallarg(netbsd32_long) msgtyp;
	syscallarg(int) msgflg;
};
#else
#endif
#if defined(SYSVSHM) || !defined(_KERNEL)

struct netbsd32_shmat_args {
	syscallarg(int) shmid;
	syscallarg(const netbsd32_voidp) shmaddr;
	syscallarg(int) shmflg;
};

struct compat_14_netbsd32_shmctl_args {
	syscallarg(int) shmid;
	syscallarg(int) cmd;
	syscallarg(netbsd32_shmid_dsp_t) buf;
};

struct netbsd32_shmdt_args {
	syscallarg(const netbsd32_voidp) shmaddr;
};

struct netbsd32_shmget_args {
	syscallarg(netbsd32_key_t) key;
	syscallarg(netbsd32_size_t) size;
	syscallarg(int) shmflg;
};
#else
#endif

struct netbsd32_clock_gettime_args {
	syscallarg(netbsd32_clockid_t) clock_id;
	syscallarg(netbsd32_timespecp_t) tp;
};

struct netbsd32_clock_settime_args {
	syscallarg(netbsd32_clockid_t) clock_id;
	syscallarg(const netbsd32_timespecp_t) tp;
};

struct netbsd32_clock_getres_args {
	syscallarg(netbsd32_clockid_t) clock_id;
	syscallarg(netbsd32_timespecp_t) tp;
};

struct netbsd32_nanosleep_args {
	syscallarg(const netbsd32_timespecp_t) rqtp;
	syscallarg(netbsd32_timespecp_t) rmtp;
};

struct netbsd32_fdatasync_args {
	syscallarg(int) fd;
};

struct netbsd32___posix_rename_args {
	syscallarg(const netbsd32_charp) from;
	syscallarg(const netbsd32_charp) to;
};

struct netbsd32_swapctl_args {
	syscallarg(int) cmd;
	syscallarg(const netbsd32_voidp) arg;
	syscallarg(int) misc;
};

struct netbsd32_getdents_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_charp) buf;
	syscallarg(netbsd32_size_t) count;
};

struct netbsd32_minherit_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) inherit;
};

struct netbsd32_lchmod_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(mode_t) mode;
};

struct netbsd32_lchown_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct netbsd32_lutimes_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(const netbsd32_timevalp_t) tptr;
};

struct netbsd32___msync13_args {
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
	syscallarg(int) flags;
};

struct netbsd32___stat13_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(netbsd32_statp_t) ub;
};

struct netbsd32___fstat13_args {
	syscallarg(int) fd;
	syscallarg(netbsd32_statp_t) sb;
};

struct netbsd32___lstat13_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(netbsd32_statp_t) ub;
};

struct netbsd32___sigaltstack14_args {
	syscallarg(const netbsd32_sigaltstackp_t) nss;
	syscallarg(netbsd32_sigaltstackp_t) oss;
};

struct netbsd32___posix_chown_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct netbsd32___posix_fchown_args {
	syscallarg(int) fd;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct netbsd32___posix_lchown_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(uid_t) uid;
	syscallarg(gid_t) gid;
};

struct netbsd32_getsid_args {
	syscallarg(pid_t) pid;
};
#if defined(KTRACE) || !defined(_KERNEL)

struct netbsd32_fktrace_args {
	syscallarg(const int) fd;
	syscallarg(int) ops;
	syscallarg(int) facs;
	syscallarg(int) pid;
};
#else
#endif

struct netbsd32_preadv_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_iovecp_t) iovp;
	syscallarg(int) iovcnt;
	syscallarg(int) pad;
	syscallarg(off_t) offset;
};

struct netbsd32_pwritev_args {
	syscallarg(int) fd;
	syscallarg(const netbsd32_iovecp_t) iovp;
	syscallarg(int) iovcnt;
	syscallarg(int) pad;
	syscallarg(off_t) offset;
};

struct netbsd32___sigaction14_args {
	syscallarg(int) signum;
	syscallarg(const netbsd32_sigactionp_t) nsa;
	syscallarg(netbsd32_sigactionp_t) osa;
};

struct netbsd32___sigpending14_args {
	syscallarg(netbsd32_sigsetp_t) set;
};

struct netbsd32___sigprocmask14_args {
	syscallarg(int) how;
	syscallarg(const netbsd32_sigsetp_t) set;
	syscallarg(netbsd32_sigsetp_t) oset;
};

struct netbsd32___sigsuspend14_args {
	syscallarg(const netbsd32_sigsetp_t) set;
};

struct compat_16_netbsd32___sigreturn14_args {
	syscallarg(netbsd32_sigcontextp_t) sigcntxp;
};

struct netbsd32___getcwd_args {
	syscallarg(netbsd32_charp) bufp;
	syscallarg(netbsd32_size_t) length;
};

struct netbsd32_fchroot_args {
	syscallarg(int) fd;
};

struct netbsd32_fhopen_args {
	syscallarg(const netbsd32_fhandlep_t) fhp;
	syscallarg(int) flags;
};

struct netbsd32_fhstat_args {
	syscallarg(const netbsd32_fhandlep_t) fhp;
	syscallarg(netbsd32_statp_t) sb;
};

struct netbsd32_fhstatfs_args {
	syscallarg(netbsd32_fhandlep_t) fhp;
	syscallarg(netbsd32_statp_t) buf;
};
#if defined(SYSVSEM) || !defined(_KERNEL)

struct netbsd32___semctl14_args {
	syscallarg(int) semid;
	syscallarg(int) semnum;
	syscallarg(int) cmd;
	syscallarg(union netbsd32_semun3 *) arg;
};
#else
#endif
#if defined(SYSVMSG) || !defined(_KERNEL)

struct netbsd32___msgctl13_args {
	syscallarg(int) msqid;
	syscallarg(int) cmd;
	syscallarg(netbsd32_msqid_dsp_t) buf;
};
#else
#endif
#if defined(SYSVSHM) || !defined(_KERNEL)

struct netbsd32___shmctl13_args {
	syscallarg(int) shmid;
	syscallarg(int) cmd;
	syscallarg(netbsd32_shmid_dsp_t) buf;
};
#else
#endif

struct netbsd32_lchflags_args {
	syscallarg(const netbsd32_charp) path;
	syscallarg(netbsd32_u_long) flags;
};

struct netbsd32_utrace_args {
	syscallarg(const netbsd32_charp) label;
	syscallarg(netbsd32_voidp) addr;
	syscallarg(netbsd32_size_t) len;
};

struct netbsd32_getcontext_args {
	syscallarg(netbsd32_ucontextp) ucp;
};

struct netbsd32_setcontext_args {
	syscallarg(netbsd32_ucontextp) ucp;
	syscallarg(uint32_t) flags;
	syscallarg(netbsd32_lwpidp) new_lwp;
};

struct netbsd32___sigaction_sigtramp_args {
	syscallarg(int) signum;
	syscallarg(const netbsd32_sigactionp_t) nsa;
	syscallarg(netbsd32_sigactionp_t) osa;
	syscallarg(netbsd32_voidp) tramp;
	syscallarg(int) vers;
};

/*
 * System call prototypes.
 */

int	netbsd32_exit(struct lwp *, void *, register_t *);

int	sys_fork(struct lwp *, void *, register_t *);

int	netbsd32_read(struct lwp *, void *, register_t *);

int	netbsd32_write(struct lwp *, void *, register_t *);

int	netbsd32_open(struct lwp *, void *, register_t *);

int	netbsd32_close(struct lwp *, void *, register_t *);

int	netbsd32_wait4(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_ocreat(struct lwp *, void *, register_t *);

int	netbsd32_link(struct lwp *, void *, register_t *);

int	netbsd32_unlink(struct lwp *, void *, register_t *);

int	netbsd32_chdir(struct lwp *, void *, register_t *);

int	netbsd32_fchdir(struct lwp *, void *, register_t *);

int	netbsd32_mknod(struct lwp *, void *, register_t *);

int	netbsd32_chmod(struct lwp *, void *, register_t *);

int	netbsd32_chown(struct lwp *, void *, register_t *);

int	netbsd32_break(struct lwp *, void *, register_t *);

int	netbsd32_getfsstat(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_olseek(struct lwp *, void *, register_t *);

int	sys_getpid(struct lwp *, void *, register_t *);

int	netbsd32_mount(struct lwp *, void *, register_t *);

int	netbsd32_unmount(struct lwp *, void *, register_t *);

int	netbsd32_setuid(struct lwp *, void *, register_t *);

int	sys_getuid(struct lwp *, void *, register_t *);

int	sys_geteuid(struct lwp *, void *, register_t *);

int	netbsd32_ptrace(struct lwp *, void *, register_t *);

int	netbsd32_recvmsg(struct lwp *, void *, register_t *);

int	netbsd32_sendmsg(struct lwp *, void *, register_t *);

int	netbsd32_recvfrom(struct lwp *, void *, register_t *);

int	netbsd32_accept(struct lwp *, void *, register_t *);

int	netbsd32_getpeername(struct lwp *, void *, register_t *);

int	netbsd32_getsockname(struct lwp *, void *, register_t *);

int	netbsd32_access(struct lwp *, void *, register_t *);

int	netbsd32_chflags(struct lwp *, void *, register_t *);

int	netbsd32_fchflags(struct lwp *, void *, register_t *);

int	sys_sync(struct lwp *, void *, register_t *);

int	netbsd32_kill(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_stat43(struct lwp *, void *, register_t *);

int	sys_getppid(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_lstat43(struct lwp *, void *, register_t *);

int	netbsd32_dup(struct lwp *, void *, register_t *);

int	sys_pipe(struct lwp *, void *, register_t *);

int	sys_getegid(struct lwp *, void *, register_t *);

int	netbsd32_profil(struct lwp *, void *, register_t *);

#if defined(KTRACE) || !defined(_KERNEL)
int	netbsd32_ktrace(struct lwp *, void *, register_t *);

#else
#endif
int	netbsd32_sigaction(struct lwp *, void *, register_t *);

int	sys_getgid(struct lwp *, void *, register_t *);

int	compat_13_netbsd32_sigprocmask(struct lwp *, void *, register_t *);

int	netbsd32___getlogin(struct lwp *, void *, register_t *);

int	netbsd32_setlogin(struct lwp *, void *, register_t *);

int	netbsd32_acct(struct lwp *, void *, register_t *);

int	compat_13_sys_sigpending(struct lwp *, void *, register_t *);

int	compat_13_netbsd32_sigaltstack13(struct lwp *, void *, register_t *);

int	netbsd32_ioctl(struct lwp *, void *, register_t *);

int	compat_12_netbsd32_reboot(struct lwp *, void *, register_t *);

int	netbsd32_revoke(struct lwp *, void *, register_t *);

int	netbsd32_symlink(struct lwp *, void *, register_t *);

int	netbsd32_readlink(struct lwp *, void *, register_t *);

int	netbsd32_execve(struct lwp *, void *, register_t *);

int	netbsd32_umask(struct lwp *, void *, register_t *);

int	netbsd32_chroot(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_fstat43(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_ogetkerninfo(struct lwp *, void *, register_t *);

int	compat_43_sys_getpagesize(struct lwp *, void *, register_t *);

int	compat_12_netbsd32_msync(struct lwp *, void *, register_t *);

int	sys_vfork(struct lwp *, void *, register_t *);

int	netbsd32_sbrk(struct lwp *, void *, register_t *);

int	netbsd32_sstk(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_ommap(struct lwp *, void *, register_t *);

int	netbsd32_ovadvise(struct lwp *, void *, register_t *);

int	netbsd32_munmap(struct lwp *, void *, register_t *);

int	netbsd32_mprotect(struct lwp *, void *, register_t *);

int	netbsd32_madvise(struct lwp *, void *, register_t *);

int	netbsd32_mincore(struct lwp *, void *, register_t *);

int	netbsd32_getgroups(struct lwp *, void *, register_t *);

int	netbsd32_setgroups(struct lwp *, void *, register_t *);

int	sys_getpgrp(struct lwp *, void *, register_t *);

int	netbsd32_setpgid(struct lwp *, void *, register_t *);

int	netbsd32_setitimer(struct lwp *, void *, register_t *);

int	compat_43_sys_wait(struct lwp *, void *, register_t *);

int	compat_12_netbsd32_oswapon(struct lwp *, void *, register_t *);

int	netbsd32_getitimer(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_ogethostname(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_osethostname(struct lwp *, void *, register_t *);

int	compat_43_sys_getdtablesize(struct lwp *, void *, register_t *);

int	netbsd32_dup2(struct lwp *, void *, register_t *);

int	netbsd32_fcntl(struct lwp *, void *, register_t *);

int	netbsd32_select(struct lwp *, void *, register_t *);

int	netbsd32_fsync(struct lwp *, void *, register_t *);

int	netbsd32_setpriority(struct lwp *, void *, register_t *);

int	netbsd32_socket(struct lwp *, void *, register_t *);

int	netbsd32_connect(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_oaccept(struct lwp *, void *, register_t *);

int	netbsd32_getpriority(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_osend(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_orecv(struct lwp *, void *, register_t *);

int	compat_13_netbsd32_sigreturn(struct lwp *, void *, register_t *);

int	netbsd32_bind(struct lwp *, void *, register_t *);

int	netbsd32_setsockopt(struct lwp *, void *, register_t *);

int	netbsd32_listen(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_osigvec(struct lwp *, void *, register_t *);

#if defined(COMPAT_43) || defined(COMPAT_SUNOS)
int	compat_43_netbsd32_sigblock(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_sigsetmask(struct lwp *, void *, register_t *);

#else
#endif
int	compat_13_netbsd32_sigsuspend(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_osigstack(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_orecvmsg(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_osendmsg(struct lwp *, void *, register_t *);

int	netbsd32_gettimeofday(struct lwp *, void *, register_t *);

int	netbsd32_getrusage(struct lwp *, void *, register_t *);

int	netbsd32_getsockopt(struct lwp *, void *, register_t *);

int	netbsd32_readv(struct lwp *, void *, register_t *);

int	netbsd32_writev(struct lwp *, void *, register_t *);

int	netbsd32_settimeofday(struct lwp *, void *, register_t *);

int	netbsd32_fchown(struct lwp *, void *, register_t *);

int	netbsd32_fchmod(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_orecvfrom(struct lwp *, void *, register_t *);

int	netbsd32_setreuid(struct lwp *, void *, register_t *);

int	netbsd32_setregid(struct lwp *, void *, register_t *);

int	netbsd32_rename(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_otruncate(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_oftruncate(struct lwp *, void *, register_t *);

int	netbsd32_flock(struct lwp *, void *, register_t *);

int	netbsd32_mkfifo(struct lwp *, void *, register_t *);

int	netbsd32_sendto(struct lwp *, void *, register_t *);

int	netbsd32_shutdown(struct lwp *, void *, register_t *);

int	netbsd32_socketpair(struct lwp *, void *, register_t *);

int	netbsd32_mkdir(struct lwp *, void *, register_t *);

int	netbsd32_rmdir(struct lwp *, void *, register_t *);

int	netbsd32_utimes(struct lwp *, void *, register_t *);

int	netbsd32_adjtime(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_ogetpeername(struct lwp *, void *, register_t *);

int	compat_43_sys_gethostid(struct lwp *, void *, register_t *);

#if defined(COMPAT_43) || defined(COMPAT_SUNOS)
int	compat_43_netbsd32_sethostid(struct lwp *, void *, register_t *);

#else
#endif
int	compat_43_netbsd32_ogetrlimit(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_osetrlimit(struct lwp *, void *, register_t *);

#if defined(COMPAT_43) || defined(COMPAT_SUNOS)
int	compat_43_netbsd32_killpg(struct lwp *, void *, register_t *);

#else
#endif
int	sys_setsid(struct lwp *, void *, register_t *);

int	netbsd32_quotactl(struct lwp *, void *, register_t *);

int	compat_43_sys_quota(struct lwp *, void *, register_t *);

int	compat_43_netbsd32_ogetsockname(struct lwp *, void *, register_t *);

#if defined(NFS) || defined(NFSSERVER) || !defined(_KERNEL)
int	netbsd32_nfssvc(struct lwp *, void *, register_t *);

#else
#endif
int	compat_43_netbsd32_ogetdirentries(struct lwp *, void *, register_t *);

int	netbsd32_statfs(struct lwp *, void *, register_t *);

int	netbsd32_fstatfs(struct lwp *, void *, register_t *);

#if defined(NFS) || defined(NFSSERVER) || !defined(_KERNEL)
int	netbsd32_getfh(struct lwp *, void *, register_t *);

#else
#endif
int	compat_09_netbsd32_ogetdomainname(struct lwp *, void *, register_t *);

int	compat_09_netbsd32_osetdomainname(struct lwp *, void *, register_t *);

int	compat_09_netbsd32_uname(struct lwp *, void *, register_t *);

int	netbsd32_sysarch(struct lwp *, void *, register_t *);

#if defined(SYSVSEM) || !defined(_KERNEL)
int	compat_10_netbsd32_sys_semsys(struct lwp *, void *, register_t *);

#else
#endif
#if defined(SYSVMSG) || !defined(_KERNEL)
int	compat_10_netbsd32_sys_msgsys(struct lwp *, void *, register_t *);

#else
#endif
#if defined(SYSVSHM) || !defined(_KERNEL)
int	compat_10_netbsd32_sys_shmsys(struct lwp *, void *, register_t *);

#else
#endif
int	netbsd32_pread(struct lwp *, void *, register_t *);

int	netbsd32_pwrite(struct lwp *, void *, register_t *);

int	netbsd32_ntp_gettime(struct lwp *, void *, register_t *);

int	netbsd32_ntp_adjtime(struct lwp *, void *, register_t *);

int	netbsd32_setgid(struct lwp *, void *, register_t *);

int	netbsd32_setegid(struct lwp *, void *, register_t *);

int	netbsd32_seteuid(struct lwp *, void *, register_t *);

#if defined(LFS) || !defined(_KERNEL)
int	netbsd32_sys_lfs_bmapv(struct lwp *, void *, register_t *);

int	netbsd32_sys_lfs_markv(struct lwp *, void *, register_t *);

int	netbsd32_sys_lfs_segclean(struct lwp *, void *, register_t *);

int	netbsd32_sys_lfs_segwait(struct lwp *, void *, register_t *);

#else
#endif
int	compat_12_netbsd32_stat12(struct lwp *, void *, register_t *);

int	compat_12_netbsd32_fstat12(struct lwp *, void *, register_t *);

int	compat_12_netbsd32_lstat12(struct lwp *, void *, register_t *);

int	netbsd32_pathconf(struct lwp *, void *, register_t *);

int	netbsd32_fpathconf(struct lwp *, void *, register_t *);

int	netbsd32_getrlimit(struct lwp *, void *, register_t *);

int	netbsd32_setrlimit(struct lwp *, void *, register_t *);

int	compat_12_netbsd32_getdirentries(struct lwp *, void *, register_t *);

int	netbsd32_mmap(struct lwp *, void *, register_t *);

int	netbsd32_lseek(struct lwp *, void *, register_t *);

int	netbsd32_truncate(struct lwp *, void *, register_t *);

int	netbsd32_ftruncate(struct lwp *, void *, register_t *);

int	netbsd32___sysctl(struct lwp *, void *, register_t *);

int	netbsd32_mlock(struct lwp *, void *, register_t *);

int	netbsd32_munlock(struct lwp *, void *, register_t *);

int	netbsd32_undelete(struct lwp *, void *, register_t *);

int	netbsd32_futimes(struct lwp *, void *, register_t *);

int	netbsd32_getpgid(struct lwp *, void *, register_t *);

int	netbsd32_reboot(struct lwp *, void *, register_t *);

int	netbsd32_poll(struct lwp *, void *, register_t *);

#if defined(LKM) || !defined(_KERNEL)
int	sys_lkmnosys(struct lwp *, void *, register_t *);

#else	/* !LKM || !_KERNEL */
#endif	/* !LKM || !_KERNEL */
#if defined(SYSVSEM) || !defined(_KERNEL)
int	compat_14_netbsd32___semctl(struct lwp *, void *, register_t *);

int	netbsd32_semget(struct lwp *, void *, register_t *);

int	netbsd32_semop(struct lwp *, void *, register_t *);

int	netbsd32_semconfig(struct lwp *, void *, register_t *);

#else
#endif
#if defined(SYSVMSG) || !defined(_KERNEL)
int	compat_14_netbsd32_msgctl(struct lwp *, void *, register_t *);

int	netbsd32_msgget(struct lwp *, void *, register_t *);

int	netbsd32_msgsnd(struct lwp *, void *, register_t *);

int	netbsd32_msgrcv(struct lwp *, void *, register_t *);

#else
#endif
#if defined(SYSVSHM) || !defined(_KERNEL)
int	netbsd32_shmat(struct lwp *, void *, register_t *);

int	compat_14_netbsd32_shmctl(struct lwp *, void *, register_t *);

int	netbsd32_shmdt(struct lwp *, void *, register_t *);

int	netbsd32_shmget(struct lwp *, void *, register_t *);

#else
#endif
int	netbsd32_clock_gettime(struct lwp *, void *, register_t *);

int	netbsd32_clock_settime(struct lwp *, void *, register_t *);

int	netbsd32_clock_getres(struct lwp *, void *, register_t *);

int	netbsd32_nanosleep(struct lwp *, void *, register_t *);

int	netbsd32_fdatasync(struct lwp *, void *, register_t *);

int	netbsd32___posix_rename(struct lwp *, void *, register_t *);

int	netbsd32_swapctl(struct lwp *, void *, register_t *);

int	netbsd32_getdents(struct lwp *, void *, register_t *);

int	netbsd32_minherit(struct lwp *, void *, register_t *);

int	netbsd32_lchmod(struct lwp *, void *, register_t *);

int	netbsd32_lchown(struct lwp *, void *, register_t *);

int	netbsd32_lutimes(struct lwp *, void *, register_t *);

int	netbsd32___msync13(struct lwp *, void *, register_t *);

int	netbsd32___stat13(struct lwp *, void *, register_t *);

int	netbsd32___fstat13(struct lwp *, void *, register_t *);

int	netbsd32___lstat13(struct lwp *, void *, register_t *);

int	netbsd32___sigaltstack14(struct lwp *, void *, register_t *);

int	sys___vfork14(struct lwp *, void *, register_t *);

int	netbsd32___posix_chown(struct lwp *, void *, register_t *);

int	netbsd32___posix_fchown(struct lwp *, void *, register_t *);

int	netbsd32___posix_lchown(struct lwp *, void *, register_t *);

int	netbsd32_getsid(struct lwp *, void *, register_t *);

#if defined(KTRACE) || !defined(_KERNEL)
int	netbsd32_fktrace(struct lwp *, void *, register_t *);

#else
#endif
int	netbsd32_preadv(struct lwp *, void *, register_t *);

int	netbsd32_pwritev(struct lwp *, void *, register_t *);

int	netbsd32___sigaction14(struct lwp *, void *, register_t *);

int	netbsd32___sigpending14(struct lwp *, void *, register_t *);

int	netbsd32___sigprocmask14(struct lwp *, void *, register_t *);

int	netbsd32___sigsuspend14(struct lwp *, void *, register_t *);

int	compat_16_netbsd32___sigreturn14(struct lwp *, void *, register_t *);

int	netbsd32___getcwd(struct lwp *, void *, register_t *);

int	netbsd32_fchroot(struct lwp *, void *, register_t *);

int	netbsd32_fhopen(struct lwp *, void *, register_t *);

int	netbsd32_fhstat(struct lwp *, void *, register_t *);

int	netbsd32_fhstatfs(struct lwp *, void *, register_t *);

#if defined(SYSVSEM) || !defined(_KERNEL)
int	netbsd32___semctl14(struct lwp *, void *, register_t *);

#else
#endif
#if defined(SYSVMSG) || !defined(_KERNEL)
int	netbsd32___msgctl13(struct lwp *, void *, register_t *);

#else
#endif
#if defined(SYSVSHM) || !defined(_KERNEL)
int	netbsd32___shmctl13(struct lwp *, void *, register_t *);

#else
#endif
int	netbsd32_lchflags(struct lwp *, void *, register_t *);

int	sys_issetugid(struct lwp *, void *, register_t *);

int	netbsd32_utrace(struct lwp *, void *, register_t *);

int	netbsd32_getcontext(struct lwp *, void *, register_t *);

int	netbsd32_setcontext(struct lwp *, void *, register_t *);

int	netbsd32___sigaction_sigtramp(struct lwp *, void *, register_t *);

#endif /* _netbsd32_SYS__SYSCALLARGS_H_ */
