/* $NetBSD: lkminit_emul.c,v 1.3.18.1 2004/05/23 10:45:33 tron Exp $ */

/*-
 * Copyright (c) 1996 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Michael Graff <explorer@flame.org>.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: lkminit_emul.c,v 1.3.18.1 2004/05/23 10:45:33 tron Exp $");

#include <sys/param.h>
#include <sys/sysctl.h>
#include <sys/systm.h>
#include <sys/conf.h>
#include <sys/exec.h>
#include <sys/proc.h>
#include <sys/lkm.h>

#include <compat/linux/common/linux_sysctl.h>

extern const struct emul emul_linux;

int compat_linux_lkmentry __P((struct lkm_table *, int, int));

/*
 * declare the emulation
 */
MOD_COMPAT("compat_linux", -1, &emul_linux);

/*
 * take care of emulation specific sysctl nodes
 */
static int load __P((struct lkm_table *, int));
static int unload __P((struct lkm_table *, int));
static struct sysctllog *_compat_linux_log, *_emul_linux_log;
extern struct sysctlnode linux_sysctl_root;

/*
 * entry point
 */
int
compat_linux_lkmentry(lkmtp, cmd, ver)
	struct lkm_table *lkmtp;	
	int cmd;
	int ver;
{

	DISPATCH(lkmtp, cmd, ver, load, unload, lkm_nofunc);
}

int
load(lkmtp, cmd)
	struct lkm_table *lkmtp;	
	int cmd;
{

	linux_sysctl_setup(&_compat_linux_log); /* we "own" this entire tree */
	sysctl_emul_linux_setup(&_emul_linux_log);
	return (0);
}

int
unload(lkmtp, cmd)
	struct lkm_table *lkmtp;	
	int cmd;
{

	sysctl_teardown(&_emul_linux_log);
	sysctl_teardown(&_compat_linux_log);
	sysctl_free(&linux_sysctl_root); /* we "own" this entire tree */
	return (0);
}
