/*	$OpenBSD: sony8x16.h,v 1.2 2003/06/02 23:28:05 millert Exp $ */
/*	$NetBSD: sony8x16.h,v 1.1 2000/11/21 11:44:45 tsutsui Exp $	*/
/*
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Sony Corp. and Kazumasa Utashiro of Software Research Associates, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * from: $Hdr: fnt.c,v 4.300 91/06/09 06:14:43 root Rel41 $ SONY
 *
 *	@(#)fnt.c	8.1 (Berkeley) 6/10/93
 */

/* This font data is generated from sys/arch/newsmips/dev/fnt.c */

extern u_char sony8x16_data[];

struct wsdisplay_font sony8x16 = {
	"sony8x16",			/* typeface name */
	0,				/* index */
	' ',				/* firstchar */
	0xff - ' ' + 1,			/* numchars */
	WSDISPLAY_FONTENC_SONY,		/* encoding */
	8,				/* width */
	16,				/* height */
	1,				/* stride */
	WSDISPLAY_FONTORDER_L2R,	/* bit order */
	WSDISPLAY_FONTORDER_L2R,	/* byte order */
	NULL,				/* cookie */
	sony8x16_data			/* data */
};

static u_char sony8x16_data[] = {

#if 0
	/* 0x00 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x01 */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x38,	/* ..***... */
	0x38,	/* ..***... */
	0x7c,	/* .*****.. */
	0x7c,	/* .*****.. */
	0xfe,	/* *******. */
	0xfe,	/* *******. */
	0x7c,	/* .*****.. */
	0x7c,	/* .*****.. */
	0x38,	/* ..***... */
	0x38,	/* ..***... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x02 */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x03 */
	0x00,	/* ........ */
	0x88,	/* *...*... */
	0x88,	/* *...*... */
	0x88,	/* *...*... */
	0xf8,	/* *****... */
	0x88,	/* *...*... */
	0x88,	/* *...*... */
	0x88,	/* *...*... */
	0x00,	/* ........ */
	0x3e,	/* ..*****. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */

	/* 0x04 */
	0x00,	/* ........ */
	0xf8,	/* *****... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0xf0,	/* ****.... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x3e,	/* ..*****. */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x3c,	/* ..****.. */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x00,	/* ........ */

	/* 0x05 */
	0x00,	/* ........ */
	0x70,	/* .***.... */
	0x88,	/* *...*... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x88,	/* *...*... */
	0x70,	/* .***.... */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x22,	/* ..*...*. */
	0x22,	/* ..*...*. */
	0x3c,	/* ..****.. */
	0x28,	/* ..*.*... */
	0x24,	/* ..*..*.. */
	0x22,	/* ..*...*. */

	/* 0x06 */
	0x00,	/* ........ */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0xf8,	/* *****... */
	0x00,	/* ........ */
	0x3e,	/* ..*****. */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x3c,	/* ..****.. */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */

	/* 0x07 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x08 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0xfe,	/* *******. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x09 */
	0x00,	/* ........ */
	0x84,	/* *....*.. */
	0xc4,	/* **...*.. */
	0xa4,	/* *.*..*.. */
	0xa4,	/* *.*..*.. */
	0x94,	/* *..*.*.. */
	0x94,	/* *..*.*.. */
	0x8c,	/* *...**.. */
	0x84,	/* *....*.. */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x3e,	/* ..*****. */

	/* 0x0A */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x88,	/* *...*... */
	0x88,	/* *...*... */
	0x88,	/* *...*... */
	0x50,	/* .*.*.... */
	0x50,	/* .*.*.... */
	0x20,	/* ..*..... */
	0x00,	/* ........ */
	0x3e,	/* ..*****. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x00,	/* ........ */

	/* 0x0B */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0xf0,	/* ****.... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x0C */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xf0,	/* ****.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */

	/* 0x0D */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x1f,	/* ...***** */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */

	/* 0x0E */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x1f,	/* ...***** */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x0F */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0xff,	/* ******** */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */

	/* 0x10 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xff,	/* ******** */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x11 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xff,	/* ******** */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x12 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xff,	/* ******** */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x13 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xff,	/* ******** */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x14 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xff,	/* ******** */
	0x00,	/* ........ */

	/* 0x15 */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x1f,	/* ...***** */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */

	/* 0x16 */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0xf0,	/* ****.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */

	/* 0x17 */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0xff,	/* ******** */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x18 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xff,	/* ******** */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */

	/* 0x19 */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */

	/* 0x1A */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x02,	/* ......*. */
	0x0c,	/* ....**.. */
	0x30,	/* ..**.... */
	0xc0,	/* **...... */
	0x30,	/* ..**.... */
	0x0c,	/* ....**.. */
	0x02,	/* ......*. */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x1B */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x80,	/* *....... */
	0x60,	/* .**..... */
	0x18,	/* ...**... */
	0x06,	/* .....**. */
	0x18,	/* ...**... */
	0x60,	/* .**..... */
	0x80,	/* *....... */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x1C */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x44,	/* .*...*.. */
	0x84,	/* *....*.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x1D */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x02,	/* ......*. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0xfe,	/* *******. */
	0x10,	/* ...*.... */
	0xfe,	/* *******. */
	0x20,	/* ..*..... */
	0x40,	/* .*...... */
	0x80,	/* *....... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x1E */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x0c,	/* ....**.. */
	0x12,	/* ...*..*. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x7c,	/* .*****.. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x3c,	/* ..****.. */
	0x52,	/* .*.*..*. */
	0x20,	/* ..*..... */
	0x00,	/* ........ */

	/* 0x1F */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
#endif

	/* 0x20 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x21 */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x38,	/* ..***... */
	0x38,	/* ..***... */
	0x38,	/* ..***... */
	0x38,	/* ..***... */
	0x38,	/* ..***... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x38,	/* ..***... */
	0x10,	/* ...*.... */

	/* 0x22 */
	0x6c,	/* .**.**.. */
	0x6c,	/* .**.**.. */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x48,	/* .*..*... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x23 */
	0x00,	/* ........ */
	0x12,	/* ...*..*. */
	0x12,	/* ...*..*. */
	0x12,	/* ...*..*. */
	0x7f,	/* .******* */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0xfe,	/* *******. */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x00,	/* ........ */

	/* 0x24 */
	0x10,	/* ...*.... */
	0x38,	/* ..***... */
	0x54,	/* .*.*.*.. */
	0x92,	/* *..*..*. */
	0x96,	/* *..*.**. */
	0x90,	/* *..*.... */
	0x50,	/* .*.*.... */
	0x38,	/* ..***... */
	0x14,	/* ...*.*.. */
	0x12,	/* ...*..*. */
	0xd2,	/* **.*..*. */
	0x92,	/* *..*..*. */
	0x94,	/* *..*.*.. */
	0x78,	/* .****... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */

	/* 0x25 */
	0x02,	/* ......*. */
	0x62,	/* .**...*. */
	0x94,	/* *..*.*.. */
	0x94,	/* *..*.*.. */
	0x94,	/* *..*.*.. */
	0x98,	/* *..**... */
	0x68,	/* .**.*... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x2c,	/* ..*.**.. */
	0x32,	/* ..**..*. */
	0x52,	/* .*.*..*. */
	0x52,	/* .*.*..*. */
	0x52,	/* .*.*..*. */
	0x8c,	/* *...**.. */
	0x80,	/* *....... */

	/* 0x26 */
	0x00,	/* ........ */
	0x30,	/* ..**.... */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x50,	/* .*.*.... */
	0x20,	/* ..*..... */
	0x2e,	/* ..*.***. */
	0x54,	/* .*.*.*.. */
	0x54,	/* .*.*.*.. */
	0x94,	/* *..*.*.. */
	0x88,	/* *...*... */
	0x8c,	/* *...**.. */
	0x72,	/* .***..*. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x27 */
	0xe0,	/* ***..... */
	0xe0,	/* ***..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0xc0,	/* **...... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x28 */
	0x02,	/* ......*. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x04,	/* .....*.. */
	0x02,	/* ......*. */

	/* 0x29 */
	0x80,	/* *....... */
	0x40,	/* .*...... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x40,	/* .*...... */
	0x80,	/* *....... */

	/* 0x2A */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x38,	/* ..***... */
	0x92,	/* *..*..*. */
	0xd6,	/* **.*.**. */
	0x38,	/* ..***... */
	0xd6,	/* **.*.**. */
	0x92,	/* *..*..*. */
	0x38,	/* ..***... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x2B */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0xfe,	/* *******. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x2C */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xe0,	/* ***..... */
	0xe0,	/* ***..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0xc0,	/* **...... */

	/* 0x2D */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x2E */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x40,	/* .*...... */
	0xe0,	/* ***..... */
	0xe0,	/* ***..... */
	0x40,	/* .*...... */
	0x00,	/* ........ */

	/* 0x2F */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x80,	/* *....... */
	0x80,	/* *....... */

	/* 0x30 */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x18,	/* ...**... */
	0x00,	/* ........ */

	/* 0x31 */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x70,	/* .***.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x7c,	/* .*****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x32 */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x24,	/* ..*..*.. */
	0x42,	/* .*....*. */
	0x62,	/* .**...*. */
	0x02,	/* ......*. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x22,	/* ..*...*. */
	0x42,	/* .*....*. */
	0x7e,	/* .******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x33 */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x02,	/* ......*. */
	0x04,	/* .....*.. */
	0x38,	/* ..***... */
	0x04,	/* .....*.. */
	0x02,	/* ......*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x34 */
	0x00,	/* ........ */
	0x08,	/* ....*... */
	0x18,	/* ...**... */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x88,	/* *...*... */
	0x88,	/* *...*... */
	0xfe,	/* *******. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x35 */
	0x00,	/* ........ */
	0xfc,	/* ******.. */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0xb8,	/* *.***... */
	0xc4,	/* **...*.. */
	0x82,	/* *.....*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0xc2,	/* **....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x36 */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x42,	/* .*....*. */
	0x46,	/* .*...**. */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0xb8,	/* *.***... */
	0xc4,	/* **...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x37 */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */

	/* 0x38 */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x39 */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x46,	/* .*...**. */
	0x3a,	/* ..***.*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x3A */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x3B */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x38,	/* ..***... */
	0x18,	/* ...**... */
	0x10,	/* ...*.... */
	0x30,	/* ..**.... */

	/* 0x3C */
	0x02,	/* ......*. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x02,	/* ......*. */

	/* 0x3D */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x3E */
	0x80,	/* *....... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x80,	/* *....... */

	/* 0x3F */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0xc2,	/* **....*. */
	0x02,	/* ......*. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x38,	/* ..***... */
	0x10,	/* ...*.... */

	/* 0x40 */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x42,	/* .*....*. */
	0x82,	/* *.....*. */
	0x9a,	/* *..**.*. */
	0xa6,	/* *.*..**. */
	0xa2,	/* *.*...*. */
	0xa2,	/* *.*...*. */
	0xa2,	/* *.*...*. */
	0xa6,	/* *.*..**. */
	0x9a,	/* *..**.*. */
	0x80,	/* *....... */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x41 */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x7c,	/* .*****.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x42 */
	0x00,	/* ........ */
	0xf8,	/* *****... */
	0x44,	/* .*...*.. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x44,	/* .*...*.. */
	0x78,	/* .****... */
	0x44,	/* .*...*.. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0xfc,	/* ******.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x43 */
	0x00,	/* ........ */
	0x3a,	/* ..***.*. */
	0x46,	/* .*...**. */
	0x42,	/* .*....*. */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x82,	/* *.....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x44 */
	0x00,	/* ........ */
	0xf8,	/* *****... */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0xf8,	/* *****... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x45 */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x40,	/* .*...... */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x78,	/* .****... */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x46 */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x40,	/* .*...... */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x78,	/* .****... */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0xf0,	/* ****.... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x47 */
	0x00,	/* ........ */
	0x1a,	/* ...**.*. */
	0x26,	/* ..*..**. */
	0x42,	/* .*....*. */
	0x40,	/* .*...... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x8f,	/* *...**** */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x42,	/* .*....*. */
	0x66,	/* .**..**. */
	0x1a,	/* ...**.*. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x48 */
	0x00,	/* ........ */
	0xe7,	/* ***..*** */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x7e,	/* .******. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0xe7,	/* ***..*** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x49 */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x4A */
	0x00,	/* ........ */
	0x1f,	/* ...***** */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x4B */
	0x00,	/* ........ */
	0xe6,	/* ***..**. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x70,	/* .***.... */
	0x50,	/* .*.*.... */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x42,	/* .*....*. */
	0xe3,	/* ***...** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x4C */
	0x00,	/* ........ */
	0xf0,	/* ****.... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x4D */
	0x00,	/* ........ */
	0x82,	/* *.....*. */
	0xc6,	/* **...**. */
	0xaa,	/* *.*.*.*. */
	0xaa,	/* *.*.*.*. */
	0xaa,	/* *.*.*.*. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x4E */
	0x00,	/* ........ */
	0x87,	/* *....*** */
	0xc2,	/* **....*. */
	0xa2,	/* *.*...*. */
	0xa2,	/* *.*...*. */
	0xa2,	/* *.*...*. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x8a,	/* *...*.*. */
	0x8a,	/* *...*.*. */
	0x8a,	/* *...*.*. */
	0x86,	/* *....**. */
	0xc2,	/* **....*. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x4F */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x50 */
	0x00,	/* ........ */
	0xf8,	/* *****... */
	0x44,	/* .*...*.. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x44,	/* .*...*.. */
	0x78,	/* .****... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0xf0,	/* ****.... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x51 */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0xba,	/* *.***.*. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x08,	/* ....*... */
	0x06,	/* .....**. */

	/* 0x52 */
	0x00,	/* ........ */
	0xf8,	/* *****... */
	0x44,	/* .*...*.. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x44,	/* .*...*.. */
	0x78,	/* .****... */
	0x48,	/* .*..*... */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x42,	/* .*....*. */
	0xe3,	/* ***...** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x53 */
	0x00,	/* ........ */
	0x34,	/* ..**.*.. */
	0x4c,	/* .*..**.. */
	0x84,	/* *....*.. */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x60,	/* .**..... */
	0x18,	/* ...**... */
	0x04,	/* .....*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0xc4,	/* **...*.. */
	0xb8,	/* *.***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x54 */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x7c,	/* .*****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x55 */
	0x00,	/* ........ */
	0xe7,	/* ***..*** */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x56 */
	0x00,	/* ........ */
	0xc6,	/* **...**. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x57 */
	0x00,	/* ........ */
	0xc6,	/* **...**. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0xaa,	/* *.*.*.*. */
	0xaa,	/* *.*.*.*. */
	0xaa,	/* *.*.*.*. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x58 */
	0x00,	/* ........ */
	0xee,	/* ***.***. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x10,	/* ...*.... */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x59 */
	0x00,	/* ........ */
	0xc6,	/* **...**. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x7c,	/* .*****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x5A */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x84,	/* *....*.. */
	0x88,	/* *...*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x82,	/* *.....*. */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x5B */
	0x1e,	/* ...****. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x1e,	/* ...****. */

	/* 0x5C */
	0x00,	/* ........ */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x00,	/* ........ */

	/* 0x5D */
	0xf0,	/* ****.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0xf0,	/* ****.... */

	/* 0x5E */
	0x10,	/* ...*.... */
	0x28,	/* ..*.*... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x5F */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xfe,	/* *******. */

	/* 0x60 */
	0x30,	/* ..**.... */
	0x30,	/* ..**.... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x61 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x42,	/* .*....*. */
	0x02,	/* ......*. */
	0x3e,	/* ..*****. */
	0x42,	/* .*....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x86,	/* *....**. */
	0x7b,	/* .****.** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x62 */
	0x00,	/* ........ */
	0xc0,	/* **...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x78,	/* .****... */
	0x44,	/* .*...*.. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x44,	/* .*...*.. */
	0x78,	/* .****... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x63 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x3a,	/* ..***.*. */
	0x46,	/* .*...**. */
	0x82,	/* *.....*. */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x82,	/* *.....*. */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x64 */
	0x00,	/* ........ */
	0x06,	/* .....**. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x3c,	/* ..****.. */
	0x44,	/* .*...*.. */
	0x84,	/* *....*.. */
	0x84,	/* *....*.. */
	0x84,	/* *....*.. */
	0x84,	/* *....*.. */
	0x84,	/* *....*.. */
	0x44,	/* .*...*.. */
	0x3e,	/* ..*****. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x65 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0xfe,	/* *******. */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x82,	/* *.....*. */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x66 */
	0x00,	/* ........ */
	0x0e,	/* ....***. */
	0x11,	/* ...*...* */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0xfe,	/* *******. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x7c,	/* .*****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x67 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x3b,	/* ..***.** */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x40,	/* .*...... */
	0x78,	/* .****... */
	0x84,	/* *....*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x7c,	/* .*****.. */

	/* 0x68 */
	0x00,	/* ........ */
	0xc0,	/* **...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x5c,	/* .*.***.. */
	0x62,	/* .**...*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0xe7,	/* ***..*** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x69 */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0xff,	/* ******** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x6A */
	0x06,	/* .....**. */
	0x06,	/* .....**. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x3e,	/* ..*****. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */

	/* 0x6B */
	0x00,	/* ........ */
	0xc0,	/* **...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x42,	/* .*....*. */
	0x44,	/* .*...*.. */
	0x48,	/* .*..*... */
	0x58,	/* .*.**... */
	0x64,	/* .**..*.. */
	0x44,	/* .*...*.. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0xe3,	/* ***...** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x6C */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0xff,	/* ******** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x6D */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x6c,	/* .**.**.. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0xdb,	/* **.**.** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x6E */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xdc,	/* **.***.. */
	0x62,	/* .**...*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0xe7,	/* ***..*** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x6F */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x70 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xf8,	/* *****... */
	0x44,	/* .*...*.. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x44,	/* .*...*.. */
	0x78,	/* .****... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0xf0,	/* ****.... */

	/* 0x71 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x3e,	/* ..*****. */
	0x44,	/* .*...*.. */
	0x84,	/* *....*.. */
	0x84,	/* *....*.. */
	0x84,	/* *....*.. */
	0x84,	/* *....*.. */
	0x44,	/* .*...*.. */
	0x3c,	/* ..****.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x1e,	/* ...****. */

	/* 0x72 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xec,	/* ***.**.. */
	0x32,	/* ..**..*. */
	0x22,	/* ..*...*. */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0xfc,	/* ******.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x73 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x3a,	/* ..***.*. */
	0x46,	/* .*...**. */
	0x42,	/* .*....*. */
	0x40,	/* .*...... */
	0x3c,	/* ..****.. */
	0x02,	/* ......*. */
	0x82,	/* *.....*. */
	0xc2,	/* **....*. */
	0xbc,	/* *.****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x74 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0xfc,	/* ******.. */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x22,	/* ..*...*. */
	0x22,	/* ..*...*. */
	0x1c,	/* ...***.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x75 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xc6,	/* **...**. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x46,	/* .*...**. */
	0x39,	/* ..***..* */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x76 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xc6,	/* **...**. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x77 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0xaa,	/* *.*.*.*. */
	0xaa,	/* *.*.*.*. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x78 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xee,	/* ***.***. */
	0x44,	/* .*...*.. */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x10,	/* ...*.... */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x44,	/* .*...*.. */
	0xee,	/* ***.***. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x79 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xe7,	/* ***..*** */
	0x42,	/* .*....*. */
	0x22,	/* ..*...*. */
	0x24,	/* ..*..*.. */
	0x14,	/* ...*.*.. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x90,	/* *..*.... */
	0xa0,	/* *.*..... */
	0x40,	/* .*...... */

	/* 0x7A */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x7e,	/* .******. */
	0x44,	/* .*...*.. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x22,	/* ..*...*. */
	0x42,	/* .*....*. */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x7B */
	0x06,	/* .....**. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x10,	/* ...*.... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x06,	/* .....**. */

	/* 0x7C */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */

	/* 0x7D */
	0xc0,	/* **...... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x10,	/* ...*.... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0xc0,	/* **...... */

	/* 0x7E */
	0x60,	/* .**..... */
	0x92,	/* *..*..*. */
	0x0c,	/* ....**.. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x7F */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x80 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x81 */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x38,	/* ..***... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x38,	/* ..***... */
	0x38,	/* ..***... */
	0x38,	/* ..***... */
	0x38,	/* ..***... */
	0x38,	/* ..***... */
	0x38,	/* ..***... */

	/* 0x82 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x3c,	/* ..****.. */
	0x52,	/* .*.*..*. */
	0x92,	/* *..*..*. */
	0x90,	/* *..*.... */
	0x90,	/* *..*.... */
	0x90,	/* *..*.... */
	0x90,	/* *..*.... */
	0x90,	/* *..*.... */
	0x92,	/* *..*..*. */
	0x52,	/* .*.*..*. */
	0x3c,	/* ..****.. */
	0x10,	/* ...*.... */
	0x00,	/* ........ */

	/* 0x83 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x0c,	/* ....**.. */
	0x12,	/* ...*..*. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x7c,	/* .*****.. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x3c,	/* ..****.. */
	0x52,	/* .*.*..*. */
	0x20,	/* ..*..... */
	0x00,	/* ........ */

	/* 0x84 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x81,	/* *......* */
	0xc3,	/* **....** */
	0x7e,	/* .******. */
	0x66,	/* .**..**. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x66,	/* .**..**. */
	0x7e,	/* .******. */
	0xc3,	/* **....** */
	0x81,	/* *......* */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x85 */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0xfe,	/* *******. */
	0x28,	/* ..*.*... */
	0x10,	/* ...*.... */
	0xfe,	/* *******. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x86 */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x87 */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x42,	/* .*....*. */
	0x40,	/* .*...... */
	0x20,	/* ..*..... */
	0x3c,	/* ..****.. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x04,	/* .....*.. */
	0x02,	/* ......*. */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x88 */
	0x00,	/* ........ */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x89 */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x42,	/* .*....*. */
	0x99,	/* *..**..* */
	0xa5,	/* *.*..*.* */
	0xc3,	/* **....** */
	0xc1,	/* **.....* */
	0xc1,	/* **.....* */
	0xc1,	/* **.....* */
	0xc3,	/* **....** */
	0xa5,	/* *.*..*.* */
	0x99,	/* *..**..* */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x8A */
	0x00,	/* ........ */
	0x1c,	/* ...***.. */
	0x22,	/* ..*...*. */
	0x1e,	/* ...****. */
	0x22,	/* ..*...*. */
	0x26,	/* ..*..**. */
	0x1a,	/* ...**.*. */
	0x00,	/* ........ */
	0x3e,	/* ..*****. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x8B */
	0x00,	/* ........ */
	0x12,	/* ...*..*. */
	0x12,	/* ...*..*. */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x90,	/* *..*.... */
	0x90,	/* *..*.... */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x12,	/* ...*..*. */
	0x12,	/* ...*..*. */
	0x00,	/* ........ */

	/* 0x8C */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0xfe,	/* *******. */
	0x06,	/* .....**. */
	0x06,	/* .....**. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x8D */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x8E */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x42,	/* .*....*. */
	0x81,	/* *......* */
	0xf9,	/* *****..* */
	0xc5,	/* **...*.* */
	0xc5,	/* **...*.* */
	0xf9,	/* *****..* */
	0xc5,	/* **...*.* */
	0xc5,	/* **...*.* */
	0xc5,	/* **...*.* */
	0x81,	/* *......* */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x8F */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x90 */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x91 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0xfe,	/* *******. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x92 */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x24,	/* ..*..*.. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x93 */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x24,	/* ..*..*.. */
	0x04,	/* .....*.. */
	0x18,	/* ...**... */
	0x04,	/* .....*.. */
	0x24,	/* ..*..*.. */
	0x18,	/* ...**... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x94 */
	0x00,	/* ........ */
	0x0c,	/* ....**.. */
	0x18,	/* ...**... */
	0x30,	/* ..**.... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x95 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x22,	/* ..*...*. */
	0x22,	/* ..*...*. */
	0x22,	/* ..*...*. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x6c,	/* .**.**.. */
	0x54,	/* .*.*.*.. */
	0x82,	/* *.....*. */
	0x80,	/* *....... */

	/* 0x96 */
	0x00,	/* ........ */
	0x7f,	/* .******* */
	0xfa,	/* *****.*. */
	0xfa,	/* *****.*. */
	0xfa,	/* *****.*. */
	0xfa,	/* *****.*. */
	0xfa,	/* *****.*. */
	0x7a,	/* .****.*. */
	0x0a,	/* ....*.*. */
	0x0a,	/* ....*.*. */
	0x0a,	/* ....*.*. */
	0x0a,	/* ....*.*. */
	0x0a,	/* ....*.*. */
	0x1b,	/* ...**.** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x97 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x98 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x0c,	/* ....**.. */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */

	/* 0x99 */
	0x00,	/* ........ */
	0x08,	/* ....*... */
	0x18,	/* ...**... */
	0x28,	/* ..*.*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x9A */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x18,	/* ...**... */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x9B */
	0x00,	/* ........ */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x12,	/* ...*..*. */
	0x12,	/* ...*..*. */
	0x09,	/* ....*..* */
	0x09,	/* ....*..* */
	0x12,	/* ...*..*. */
	0x12,	/* ...*..*. */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x00,	/* ........ */

	/* 0x9C */
	0x00,	/* ........ */
	0x40,	/* .*...... */
	0xc0,	/* **...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x41,	/* .*.....* */
	0x46,	/* .*...**. */
	0x08,	/* ....*... */
	0x32,	/* ..**..*. */
	0xc6,	/* **...**. */
	0x0a,	/* ....*.*. */
	0x12,	/* ...*..*. */
	0x1f,	/* ...***** */
	0x02,	/* ......*. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x9D */
	0x00,	/* ........ */
	0x40,	/* .*...... */
	0xc0,	/* **...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x41,	/* .*.....* */
	0x46,	/* .*...**. */
	0x08,	/* ....*... */
	0x36,	/* ..**.**. */
	0xc9,	/* **..*..* */
	0x01,	/* .......* */
	0x06,	/* .....**. */
	0x08,	/* ....*... */
	0x0f,	/* ....**** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x9E */
	0x00,	/* ........ */
	0x60,	/* .**..... */
	0x90,	/* *..*.... */
	0x10,	/* ...*.... */
	0x60,	/* .**..... */
	0x11,	/* ...*...* */
	0x96,	/* *..*.**. */
	0x68,	/* .**.*... */
	0x32,	/* ..**..*. */
	0xc6,	/* **...**. */
	0x0a,	/* ....*.*. */
	0x12,	/* ...*..*. */
	0x1f,	/* ...***** */
	0x02,	/* ......*. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0x9F */
	0x08,	/* ....*... */
	0x1c,	/* ...***.. */
	0x08,	/* ....*... */
	0x00,	/* ........ */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x40,	/* .*...... */
	0x43,	/* .*....** */
	0x41,	/* .*.....* */
	0x22,	/* ..*...*. */
	0x1c,	/* ...***.. */
	0x00,	/* ........ */

	/* 0xA0 */
	0x30,	/* ..**.... */
	0x10,	/* ...*.... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x7c,	/* .*****.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xA1 */
	0x18,	/* ...**... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x10,	/* ...*.... */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x7c,	/* .*****.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xA2 */
	0x10,	/* ...*.... */
	0x28,	/* ..*.*... */
	0x44,	/* .*...*.. */
	0x10,	/* ...*.... */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x7c,	/* .*****.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xA3 */
	0x24,	/* ..*..*.. */
	0x58,	/* .*.**... */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x7c,	/* .*****.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xA4 */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x7c,	/* .*****.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xA5 */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x10,	/* ...*.... */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x7c,	/* .*****.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0xc6,	/* **...**. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xA6 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x1f,	/* ...***** */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x4e,	/* .*..***. */
	0xf8,	/* *****... */
	0x88,	/* *...*... */
	0x88,	/* *...*... */
	0x88,	/* *...*... */
	0x8f,	/* *...**** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xA7 */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x42,	/* .*....*. */
	0x40,	/* .*...... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x40,	/* .*...... */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */

	/* 0xA8 */
	0x30,	/* ..**.... */
	0x10,	/* ...*.... */
	0x08,	/* ....*... */
	0xfe,	/* *******. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x40,	/* .*...... */
	0x48,	/* .*..*... */
	0x78,	/* .****... */
	0x48,	/* .*..*... */
	0x40,	/* .*...... */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xA9 */
	0x18,	/* ...**... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0xfe,	/* *******. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x40,	/* .*...... */
	0x48,	/* .*..*... */
	0x78,	/* .****... */
	0x48,	/* .*..*... */
	0x40,	/* .*...... */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xAA */
	0x30,	/* ..**.... */
	0x48,	/* .*..*... */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x40,	/* .*...... */
	0x48,	/* .*..*... */
	0x78,	/* .****... */
	0x48,	/* .*..*... */
	0x40,	/* .*...... */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xAB */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x40,	/* .*...... */
	0x48,	/* .*..*... */
	0x78,	/* .****... */
	0x48,	/* .*..*... */
	0x40,	/* .*...... */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xAC */
	0x30,	/* ..**.... */
	0x10,	/* ...*.... */
	0x08,	/* ....*... */
	0xfe,	/* *******. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xAD */
	0x18,	/* ...**... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0xfe,	/* *******. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xAE */
	0x10,	/* ...*.... */
	0x28,	/* ..*.*... */
	0x44,	/* .*...*.. */
	0xfe,	/* *******. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xAF */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xB0 */
	0x00,	/* ........ */
	0xf8,	/* *****... */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0xf2,	/* ****..*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0xf8,	/* *****... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xB1 */
	0x24,	/* ..*..*.. */
	0x58,	/* .*.**... */
	0x00,	/* ........ */
	0x87,	/* *....*** */
	0xc2,	/* **....*. */
	0xa2,	/* *.*...*. */
	0xa2,	/* *.*...*. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x8a,	/* *...*.*. */
	0x8a,	/* *...*.*. */
	0x86,	/* *....**. */
	0xc2,	/* **....*. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xB2 */
	0x30,	/* ..**.... */
	0x10,	/* ...*.... */
	0x08,	/* ....*... */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xB3 */
	0x18,	/* ...**... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xB4 */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xB5 */
	0x24,	/* ..*..*.. */
	0x58,	/* .*.**... */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xB6 */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xB7 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x81,	/* *......* */
	0x42,	/* .*....*. */
	0x24,	/* ..*..*.. */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x24,	/* ..*..*.. */
	0x42,	/* .*....*. */
	0x81,	/* *......* */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xB8 */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x3c,	/* ..****.. */
	0x44,	/* .*...*.. */
	0x86,	/* *....**. */
	0x8a,	/* *...*.*. */
	0x8a,	/* *...*.*. */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0xa2,	/* *.*...*. */
	0xa2,	/* *.*...*. */
	0xc2,	/* **....*. */
	0x44,	/* .*...*.. */
	0x78,	/* .****... */
	0x80,	/* *....... */
	0x80,	/* *....... */

	/* 0xB9 */
	0x30,	/* ..**.... */
	0x10,	/* ...*.... */
	0x08,	/* ....*... */
	0xe7,	/* ***..*** */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xBA */
	0x0c,	/* ....**.. */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0xe7,	/* ***..*** */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xBB */
	0x18,	/* ...**... */
	0x24,	/* ..*..*.. */
	0x00,	/* ........ */
	0xe7,	/* ***..*** */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xBC */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x00,	/* ........ */
	0xe7,	/* ***..*** */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xBD */
	0x0c,	/* ....**.. */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0xc6,	/* **...**. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x7c,	/* .*****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xBE */
	0xe0,	/* ***..... */
	0x40,	/* .*...... */
	0x78,	/* .****... */
	0x44,	/* .*...*.. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x44,	/* .*...*.. */
	0x78,	/* .****... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0xf0,	/* ****.... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xBF */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x84,	/* *....*.. */
	0x98,	/* *..**... */
	0x84,	/* *....*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x9c,	/* *..***.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xC0 */
	0x00,	/* ........ */
	0x30,	/* ..**.... */
	0x10,	/* ...*.... */
	0x08,	/* ....*... */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x42,	/* .*....*. */
	0x02,	/* ......*. */
	0x3e,	/* ..*****. */
	0x42,	/* .*....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x86,	/* *....**. */
	0x7b,	/* .****.** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xC1 */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x42,	/* .*....*. */
	0x02,	/* ......*. */
	0x3e,	/* ..*****. */
	0x42,	/* .*....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x86,	/* *....**. */
	0x7b,	/* .****.** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xC2 */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x24,	/* ..*..*.. */
	0x42,	/* .*....*. */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x42,	/* .*....*. */
	0x02,	/* ......*. */
	0x3e,	/* ..*****. */
	0x42,	/* .*....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x86,	/* *....**. */
	0x7b,	/* .****.** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xC3 */
	0x00,	/* ........ */
	0x32,	/* ..**..*. */
	0x4c,	/* .*..**.. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x42,	/* .*....*. */
	0x02,	/* ......*. */
	0x3e,	/* ..*****. */
	0x42,	/* .*....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x86,	/* *....**. */
	0x7b,	/* .****.** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xC4 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x42,	/* .*....*. */
	0x02,	/* ......*. */
	0x3e,	/* ..*****. */
	0x42,	/* .*....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x86,	/* *....**. */
	0x7b,	/* .****.** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xC5 */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x24,	/* ..*..*.. */
	0x18,	/* ...**... */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x42,	/* .*....*. */
	0x02,	/* ......*. */
	0x3e,	/* ..*****. */
	0x42,	/* .*....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x86,	/* *....**. */
	0x7b,	/* .****.** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xC6 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x6c,	/* .**.**.. */
	0x92,	/* *..*..*. */
	0x12,	/* ...*..*. */
	0x3e,	/* ..*****. */
	0x50,	/* .*.*.... */
	0x90,	/* *..*.... */
	0x92,	/* *..*..*. */
	0x92,	/* *..*..*. */
	0x6c,	/* .**.**.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xC7 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x3a,	/* ..***.*. */
	0x46,	/* .*...**. */
	0x82,	/* *.....*. */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x82,	/* *.....*. */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */

	/* 0xC8 */
	0x00,	/* ........ */
	0x30,	/* ..**.... */
	0x10,	/* ...*.... */
	0x08,	/* ....*... */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0xfe,	/* *******. */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x82,	/* *.....*. */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xC9 */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0xfe,	/* *******. */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x82,	/* *.....*. */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xCA */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0xfe,	/* *******. */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x82,	/* *.....*. */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xCB */
	0x00,	/* ........ */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0xfe,	/* *******. */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x80,	/* *....... */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xCC */
	0x00,	/* ........ */
	0x30,	/* ..**.... */
	0x10,	/* ...*.... */
	0x08,	/* ....*... */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0xff,	/* ******** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xCD */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0xff,	/* ******** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xCE */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x24,	/* ..*..*.. */
	0x42,	/* .*....*. */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0xff,	/* ******** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xCF */
	0x00,	/* ........ */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x78,	/* .****... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0xff,	/* ******** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xD0 */
	0x00,	/* ........ */
	0x64,	/* .**..*.. */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x24,	/* ..*..*.. */
	0x3c,	/* ..****.. */
	0x42,	/* .*....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x42,	/* .*....*. */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xD1 */
	0x00,	/* ........ */
	0x32,	/* ..**..*. */
	0x4c,	/* .*..**.. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xdc,	/* **.***.. */
	0x62,	/* .**...*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0xe7,	/* ***..*** */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xD2 */
	0x00,	/* ........ */
	0x30,	/* ..**.... */
	0x10,	/* ...*.... */
	0x08,	/* ....*... */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xD3 */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xD4 */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x28,	/* ..*.*... */
	0x44,	/* .*...*.. */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xD5 */
	0x00,	/* ........ */
	0x32,	/* ..**..*. */
	0x4c,	/* .*..**.. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xD6 */
	0x00,	/* ........ */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x44,	/* .*...*.. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x82,	/* *.....*. */
	0x44,	/* .*...*.. */
	0x38,	/* ..***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xD7 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0xfe,	/* *******. */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xD8 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x3a,	/* ..***.*. */
	0x44,	/* .*...*.. */
	0x8a,	/* *...*.*. */
	0x8a,	/* *...*.*. */
	0x92,	/* *..*..*. */
	0xa2,	/* *.*...*. */
	0xa2,	/* *.*...*. */
	0x44,	/* .*...*.. */
	0xb8,	/* *.***... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xD9 */
	0x00,	/* ........ */
	0x30,	/* ..**.... */
	0x10,	/* ...*.... */
	0x08,	/* ....*... */
	0x00,	/* ........ */
	0xc6,	/* **...**. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x46,	/* .*...**. */
	0x39,	/* ..***..* */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xDA */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x00,	/* ........ */
	0xc6,	/* **...**. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x46,	/* .*...**. */
	0x39,	/* ..***..* */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xDB */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x28,	/* ..*.*... */
	0x44,	/* .*...*.. */
	0x00,	/* ........ */
	0xc6,	/* **...**. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x46,	/* .*...**. */
	0x39,	/* ..***..* */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xDC */
	0x00,	/* ........ */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xc6,	/* **...**. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x46,	/* .*...**. */
	0x39,	/* ..***..* */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xDD */
	0x00,	/* ........ */
	0x0c,	/* ....**.. */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0xe7,	/* ***..*** */
	0x42,	/* .*....*. */
	0x22,	/* ..*...*. */
	0x24,	/* ..*..*.. */
	0x14,	/* ...*.*.. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x90,	/* *..*.... */
	0xa0,	/* *.*..... */
	0x40,	/* .*...... */

	/* 0xDE */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xc0,	/* **...... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0x78,	/* .****... */
	0x44,	/* .*...*.. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x44,	/* .*...*.. */
	0x78,	/* .****... */
	0x40,	/* .*...... */
	0x40,	/* .*...... */
	0xf0,	/* ****.... */

	/* 0xDF */
	0x00,	/* ........ */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xe7,	/* ***..*** */
	0x42,	/* .*....*. */
	0x22,	/* ..*...*. */
	0x24,	/* ..*..*.. */
	0x14,	/* ...*.*.. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x90,	/* *..*.... */
	0xa0,	/* *.*..... */
	0x40,	/* .*...... */

	/* 0xE0 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xE1 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x20,	/* ..*..... */
	0x50,	/* .*.*.... */
	0x50,	/* .*.*.... */
	0x20,	/* ..*..... */

	/* 0xE2 */
	0x1e,	/* ...****. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xE3 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x3c,	/* ..****.. */

	/* 0xE4 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x40,	/* .*...... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */

	/* 0xE5 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xE6 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x7e,	/* .******. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x7e,	/* .******. */
	0x02,	/* ......*. */
	0x06,	/* .....**. */
	0x04,	/* .....*.. */
	0x0c,	/* ....**.. */
	0x08,	/* ....*... */
	0x18,	/* ...**... */
	0x30,	/* ..**.... */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xE7 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x7e,	/* .******. */
	0x02,	/* ......*. */
	0x16,	/* ...*.**. */
	0x14,	/* ...*.*.. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x30,	/* ..**.... */
	0x20,	/* ..*..... */

	/* 0xE8 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x02,	/* ......*. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0x18,	/* ...**... */
	0x68,	/* .**.*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */

	/* 0xE9 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x7e,	/* .******. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x02,	/* ......*. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */

	/* 0xEA */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x7c,	/* .*****.. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x7e,	/* .******. */
	0x00,	/* ........ */

	/* 0xEB */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x7e,	/* .******. */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x48,	/* .*..*... */
	0x08,	/* ....*... */
	0x18,	/* ...**... */

	/* 0xEC */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x20,	/* ..*..... */
	0x22,	/* ..*...*. */
	0x16,	/* ...*.**. */
	0x1a,	/* ...**.*. */
	0x32,	/* ..**..*. */
	0x48,	/* .*..*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */

	/* 0xED */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x38,	/* ..***... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x7e,	/* .******. */
	0x00,	/* ........ */

	/* 0xEE */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x3c,	/* ..****.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */

	/* 0xEF */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x10,	/* ...*.... */
	0x52,	/* .*.*..*. */
	0x4a,	/* .*..*.*. */
	0x22,	/* ..*...*. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */

	/* 0xF0 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x3c,	/* ..****.. */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xF1 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0xff,	/* ******** */
	0x01,	/* .......* */
	0x12,	/* ...*..*. */
	0x14,	/* ...*.*.. */
	0x14,	/* ...*.*.. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x40,	/* .*...... */
	0x00,	/* ........ */

	/* 0xF2 */
	0x00,	/* ........ */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0x18,	/* ...**... */
	0x28,	/* ..*.*... */
	0xc8,	/* **..*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x00,	/* ........ */

	/* 0xF3 */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x7e,	/* .******. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x00,	/* ........ */

	/* 0xF4 */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x7e,	/* .******. */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0xff,	/* ******** */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xF5 */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0xff,	/* ******** */
	0x08,	/* ....*... */
	0x18,	/* ...**... */
	0x18,	/* ...**... */
	0x28,	/* ..*.*... */
	0x28,	/* ..*.*... */
	0x48,	/* .*..*... */
	0x48,	/* .*..*... */
	0x88,	/* *...*... */
	0x08,	/* ....*... */
	0x18,	/* ...**... */
	0x00,	/* ........ */

	/* 0xF6 */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x7e,	/* .******. */
	0x12,	/* ...*..*. */
	0x12,	/* ...*..*. */
	0x12,	/* ...*..*. */
	0x12,	/* ...*..*. */
	0x12,	/* ...*..*. */
	0x22,	/* ..*...*. */
	0x22,	/* ..*...*. */
	0x22,	/* ..*...*. */
	0x42,	/* .*....*. */
	0x4e,	/* .*..***. */
	0x00,	/* ........ */

	/* 0xF7 */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x16,	/* ...*.**. */
	0x18,	/* ...**... */
	0x30,	/* ..**.... */
	0xd0,	/* **.*.... */
	0x13,	/* ...*..** */
	0x0c,	/* ....**.. */
	0x38,	/* ..***... */
	0x68,	/* .**.*... */
	0x08,	/* ....*... */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */

	/* 0xF8 */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x1e,	/* ...****. */
	0x12,	/* ...*..*. */
	0x22,	/* ..*...*. */
	0x22,	/* ..*...*. */
	0x44,	/* .*...*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x40,	/* .*...... */
	0x00,	/* ........ */

	/* 0xF9 */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x3f,	/* ..****** */
	0x44,	/* .*...*.. */
	0x44,	/* .*...*.. */
	0x84,	/* *....*.. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x00,	/* ........ */

	/* 0xFA */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x7e,	/* .******. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x02,	/* ......*. */
	0x7e,	/* .******. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xFB */
	0x00,	/* ........ */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0xff,	/* ******** */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x24,	/* ..*..*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x00,	/* ........ */

	/* 0xFC */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x20,	/* ..*..... */
	0x30,	/* ..**.... */
	0x10,	/* ...*.... */
	0x00,	/* ........ */
	0x41,	/* .*.....* */
	0x61,	/* .**....* */
	0x22,	/* ..*...*. */
	0x02,	/* ......*. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x40,	/* .*...... */
	0x00,	/* ........ */

	/* 0xFD */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x7c,	/* .*****.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x18,	/* ...**... */
	0x14,	/* ...*.*.. */
	0x24,	/* ..*..*.. */
	0x22,	/* ..*...*. */
	0x42,	/* .*....*. */
	0x81,	/* *......* */
	0x00,	/* ........ */

	/* 0xFE */
	0x00,	/* ........ */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x2e,	/* ..*.***. */
	0x32,	/* ..**..*. */
	0xe2,	/* ***...*. */
	0x24,	/* ..*..*.. */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x20,	/* ..*..... */
	0x3e,	/* ..*****. */
	0x00,	/* ........ */
	0x00,	/* ........ */

	/* 0xFF */
	0x00,	/* ........ */
	0x00,	/* ........ */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x42,	/* .*....*. */
	0x22,	/* ..*...*. */
	0x22,	/* ..*...*. */
	0x02,	/* ......*. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x04,	/* .....*.. */
	0x08,	/* ....*... */
	0x08,	/* ....*... */
	0x10,	/* ...*.... */
	0x20,	/* ..*..... */
	0x00,	/* ........ */
};
