/*	$NetBSD: pcf8583reg.h,v 1.1 2003/09/30 00:35:31 thorpej Exp $	*/

/*
 * Ben Harris, 2000
 *
 * This file is in the public domain
 */

/*
 * Philips PCF8583 RTC registers
 */

/* We only have clock mode registers here */

#ifndef _PCF8583REG_H
#define _PCF8583REG_H

/*
 * PCF8583 RTC I2C address:
 *
 *	101 0000
 */
#define PCF8583_ADDRMASK	0x7f
#define PCF8583_ADDR		0x50

#define PCF8583_REG_CSR		0x00
#define PCF8583_REG_CENTI	0x01
#define PCF8583_REG_SEC		0x02
#define PCF8583_REG_MIN		0x03
#define PCF8583_REG_HOUR	0x04
#define PCF8583_REG_YEARDATE	0x05
#define PCF8583_REG_WKDYMON	0x06
#define PCF8583_REG_TIMER	0x07
#define PCF8583_REG_ALMCTL	0x08
#define PCF8583_REG_ALMCENTI	0x09
#define PCF8583_REG_ALMSEC	0x0a
#define PCF8583_REG_ALMMIN	0x0b
#define PCF8583_REG_ALMHOUR	0x0c
#define PCF8583_REG_ALMDAY	0x0d
#define PCF8583_REG_ALMMON	0x0e
#define PCF8583_REG_ALMTIMER	0x0f

#define	PCF8583_NVRAM_START	0x10
#define	PCF8583_NVRAM_SIZE	240

#define PCF8583_CSR_TIMER	0x01
#define PCF8583_CSR_SECTICK	0x01
#define PCF8583_CSR_ALARM	0x02
#define PCF8583_CSR_MINTICK	0x02
#define PCF8583_CSR_ALARMENABLE	0x04
#define PCF8583_CSR_MASK	0x08
#define PCF8583_CSR_FN_MASK	0x30
#define PCF8583_CSR_FN_32768HZ	0x00
#define PCF8583_CSR_FN_50HZ	0x10
#define PCF8583_CSR_FN_EVENT	0x20
#define PCF8583_CSR_FN_TEST	0x30
#define PCF8583_CSR_HOLD	0x40
#define PCF8583_CSR_STOP	0x80

#define PCF8583_HOUR_MASK	0x3f
#define PCF8583_HOUR_PM		0x40
#define PCF8583_HOUR_12H	0x80

#define PCF8583_DATE_MASK	0x3f
#define PCF8583_YEAR_MASK	0xc0
#define PCF8583_YEAR_SHIFT	6

#define PCF8583_MON_MASK	0x1f
#define PCF8583_WKDY_MASK	0xe0
#define PCF8583_WKDY_SHIFT	5

#define PCF8583_ALMCTL_TIMER_MASK	0x07
#define PCF8583_ALMCTL_TIMER_OFF	0x00
#define PCF8583_ALMCTL_TIMER_CENTI	0x01
#define PCF8583_ALMCTL_TIMER_SEC	0x02
#define PCF8583_ALMCTL_TIMER_MIN	0x03
#define PCF8583_ALMCTL_TIMER_HOUR	0x04
#define PCF8583_ALMCTL_TIMER_DAY	0x05
#define PCF8583_ALMCTL_TIMER_TEST	0x07
#define PCF8583_ALMCTL_TIMERINT		0x08
#define PCF8583_ALMCTL_CLKALM_MASK	0x30
#define PCF8583_ALMCTL_CLKALM_NONE	0x00
#define PCF8583_ALMCTL_CLKALM_DAILY	0x10
#define PCF8583_ALMCTL_CLKALM_WKDY	0x20
#define PCF8583_ALMCTL_CLKALM_DATED	0x30
#define PCF8583_ALMCTL_TIMERALM		0x40
#define PCF8583_ALMCTL_ALMINT		0x80

#endif	/* _PCF8583REG_H */
