# 
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer. 
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
#
# 3. The name "Carnegie Mellon University" must not be used to
#    endorse or promote products derived from this software without
#    prior written permission. For permission or any other legal
#    details, please contact  
#      Office of Technology Transfer
#      Carnegie Mellon University
#      5000 Forbes Avenue
#      Pittsburgh, PA  15213-3890
#      (412) 268-4387, fax: (412) 268-7395
#      tech-transfer@andrew.cmu.edu
#
# 4. Redistributions of any form whatsoever must retain the following
#    acknowledgment:
#    "This product includes software developed by Computing Services
#     at Carnegie Mellon University (http://www.cmu.edu/computing/)."
#
# CARNEGIE MELLON UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO
# THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS, IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
# FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
# OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

use ExtUtils::MakeMaker;
use Config;

my $LIB_SASL = " -lsasl2" || "-lsasl2";

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
$libs = "-lcyrus";

# override default xs.c rule with a VPATH-aware version
sub MY::xs_c
{
    return <<'EOT';

.xs.c: .xs
	$(XSUBPPRUN) $(XSPROTOARG) $(XSUBPPARGS) $(XSUBPP_EXTRA_ARGS) $< > $*.xsc && $(MV) $*.xsc $@

EOT
}

# xs_c above is adequate, override this to get it out of the way
sub MY::xs_o
{
    ;
}

sub MY::postamble
{
    return <<'EOT';

VPATH=../../perl/imap

cyradm: cyradm.sh
	perl /home/partha/fastmail/cyrus-imapd/tools/fixsearchpath.pl NONE ${exec_prefix}/bin < $< > $@

check:

dvi:

installcheck:

EOT
}

WriteMakefile( 
    'NAME'	=> 'Cyrus::IMAP',
    'ABSTRACT'  => 'Cyrus administrative interface',
    'VERSION_FROM' => "../../perl/imap/IMAP.pm", # finds $VERSION
    'macro'	=> {
		    'IMCLIENT_LIBS' => '',	# hack
		},
    'clean'	=> {'FILES' => 'libcyrperl.a cyradm'},
    'OBJECT'    => 'IMAP.o',
    'MYEXTLIB'  => '../../perl/.libs/libcyrus.a ../../perl/.libs/libcyrus_min.a',
    'LIBS'	=> [ "$LIB_SASL -lssl -lcrypto -lssl -lcrypto  @LIB_RT@ -luuid -lz"],
    'DEFINE'	=> '-DPERL_POLLUTE',    # e.g., '-DHAVE_SOMETHING' 
    'INC'	=> "-I../.. -I../../com_err/et   -I../../perl/imap", 
    'EXE_FILES' => [cyradm],
    # This is a disgusting hack to effectively disable the stupid
    # behaviour of the generated Makefile which moves itself aside
    # on a 'make clean' instead of on 'make distclean'.
    'MAKEFILE_OLD' => 'Makefile',
);
