#!/bin/sh
# $Id: b-net.sh,v 1.8 2005/05/31 21:00:28 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#

test -s stop && exit 1              

# time file operations via network
test -s stop && exit 1
SRV="error.srv"
CLT="error.clt"
TSRV="times.srv"
TCLT="times.clt"
# verbose?
VERBOSE=false
#
rm -f ${SRV} ${CLT}
rm -f ${TSRV} ${TCLT}
${VERBOSE} && echo "server/client: timing tests"
ITER=100000
for NET in "" "-u"
do
for BYTES in 32 64 128 256 512 1024
do
  echo "Iter: ${ITER}, Bytes: ${BYTES}, ${NET}" >> ${TSRV}
  echo "Iter: ${ITER}, Bytes: ${BYTES}, ${NET}" >> ${TCLT}
  ${VALGRIND} ./t-net-0 ${NET} -s ${BYTES} -T -R ${ITER} 2> ${SRV} | grep 'function time' >> ${TSRV} &
  sleep 1
  ${VALGRIND} ./t-net-0 ${NET} -c ${BYTES} -T -R ${ITER} 2> ${CLT} | grep 'function time' >> ${TCLT}
  wait
  sleep 1
  rm -f ${SRV} ${CLT}
done
done
exit 0
