/*
 * Copyright (c) 2002, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-st-cond1.c,v 1.6 2004/12/29 23:47:29 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/test.h"
#include "statethreads/st.h"

#include <stdio.h>

extern char *optarg;
extern int optind;
extern int optopt;
extern int opterr;

int Verbose;

#define SEC2USEC(s) ((s)*1000000LL)
static st_utime_t tmo = SEC2USEC(5);
static st_utime_t slp1 = 10;
static st_utime_t slp2 = 100;

st_cond_t	cond1;

static void
usage(const char *prg)
{
	fprintf(stderr, "usage: %s [options]\n", prg);
	exit(0);
}

/*
**  TASK1 -- signal cond1
**
**	Parameters:
**		arg -- unused (except for printf)
**
**	Returns:
**		none
*/

static void *
task1(void *arg)
{
	int r;

	if (Verbose > 2)
		fprintf(stderr, "task1: sleep(%ld)\n", (long) slp2);
	r = st_usleep(slp2);
	SM_TEST(r == 0);
	if (Verbose > 1)
		fprintf(stderr, "task1: arg=%d, cond_signal\n", *(int *)arg);
	r = st_cond_signal(cond1);
	SM_TEST(r == 0);
	return NULL;
}

/*
**  TEST -- control tests
**
**	Parameters:
**		none
**
**	Returns:
**		0: success
**		!= 0: failure
*/

static int
test(void)
{
	int r, arg1;
	st_thread_t tsk1;

	/* Initialize the ST library */
	if (st_init() < 0)
	{
		perror("st_init");
		return -1;
	}

	cond1 = st_cond_new();
	SM_TEST(cond1 != NULL);
	if (cond1 == NULL)
	{
		perror("cond_new failed");
		return -1;
	}

	arg1 = 1;
	tsk1 = st_thread_create(task1, (void *) &arg1, 0, 0);
	SM_TEST(tsk1 != NULL);
	if (tsk1 == NULL)
	{
		perror("thread_create task1 failed");
		return -1;
	}
	if (Verbose > 2)
		fprintf(stderr, "test: sleep(%ld)\n", (long) slp1);
	r = st_usleep(slp1);
	SM_TEST(r == 0);
	if (Verbose > 1)
		fprintf(stderr, "test: st_cond_timedwait\n");
	r = st_cond_timedwait(cond1, tmo);
	SM_TEST(r == 0);

	r = st_cond_destroy(cond1);
	SM_TEST(r == 0);
	return 0;
}

int
main(int argc, char *argv[])
{
	int c;
	char *prg;

	opterr = 0;
	Verbose = 0;
	prg = argv[0];
	while ((c = getopt(argc, argv, "V")) != -1)
	{
		switch (c)
		{
		  case 'V':
			++Verbose;
			break;
		  default:
			usage(prg);
		}
	}
	sm_test_begin(argc, argv, "state threads cond test 1");
	argc -= optind;
	argv += optind;
	c = test();
	SM_TEST(c == 0);
	return sm_test_end();
}
