/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: greycnf.h,v 1.2 2005/08/05 20:52:29 ca Exp $
 */

#ifndef SM_GREYCNF_H
#define SM_GREYCNF_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/net.h"

#define GREY_LIMIT	10000
#define GREY_MIN_WAIT	60
#define GREY_MAX_WAIT	24 *60*60
#define GREY_WHITE_EXPIRE	33 *60*60*24
#define GREY_WHITE_RECONFIRM	40 *60*60*24

#define GREY_MAIN_DB	"grey_grey_m.db"
#define GREY_SEC_DB	"grey_grey_s.db"

struct greycnf_S
{
	uint		 greycnf_limit;	/* max # of entries */

	/* how long before greylisted can be "confirmed"? */
	uint		 greycnf_min_grey_wait;

	/* timeout for greylisted entries (didn't "confirm" within that time) */
	uint		 greycnf_max_grey_wait;

	/* expiration timeout for whitelisted entries */
	uint		 greycnf_white_expire;

	/* reconfirmation timeout for whitelisted entries */
	uint		 greycnf_white_reconfirm;

	/* netmask to apply */
	ipv4_T		 greycnf_netmask;

	char		*greycnf_grey_name;
	char		*greycnf_grey_sname;
};
typedef struct greycnf_S	greycnf_T, *greycnf_P;

#endif /* SM_GREYCNF_H */
