/*
 * Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: maps.h,v 1.6 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_MAPS_H
#define SM_MAPS_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/magic.h"
#include "sm/bhtable.h"
#include "sm/cstr.h"
#include "sm/map-str.h"

struct sm_maps_S
{
#if SM_MAPS_CHECK
	sm_magic_T	 sm_magic;
#endif /* SM_MAPS_CHECK */

	/*
	**  It might be useful to use a tagged cache instead of two hash tables.
	**  See sm/rsct.h.
	*/

	bht_P		 sm_maps_ht_mapc;	/* hash table for mapc */
	bht_P		 sm_maps_ht_map;	/* hash table for map */
};

sm_ret_T sm_maps_term(sm_maps_P _maps);
sm_ret_T sm_maps_init(sm_maps_P *_pmaps);
sm_ret_T sm_maps_create(sm_maps_P _maps);
sm_ret_T sm_maps_add(sm_maps_P _maps, sm_mapc_P mapc);
sm_ret_T sm_maps_rm(sm_maps_P _maps, sm_mapc_P mapc);
sm_ret_T sm_maps_find(sm_maps_P _maps, const sm_cstr_P _mapc_type, sm_mapc_P *_pmapc);

#if SM_MAPS_CHECK
# define SM_IS_MAPS(maps)	SM_REQUIRE_ISA((maps), SM_MAPS_MAGIC)
#else
# define SM_IS_MAPS(maps)	SM_REQUIRE((maps) != NULL)
#endif

#endif /* SM_MAPS_H */
