/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: rsct.h,v 1.8 2005/09/29 17:17:50 ca Exp $
 */

#ifndef SM_RSCT_H
#define SM_RSCT_H 1

#define SM_RSC_TYPED 1

/*
**  This is the Typed version of RSC (Restricted Size Cache)
**  It is only used by IQDB (right now at least).
*/

#define sm_rsc_S rsct_S
#define sm_rsc_T rsct_T
#define sm_rsc_P rsct_P
#define sm_rsc_entry_S rsct_entry_S
#define sm_rsc_entry_T rsct_entry_T
#define sm_rsc_entry_P rsct_entry_P
#define sm_rsc_create_F rsct_create_F
#define sm_rsc_delete_F rsct_delete_F
#define sm_rsc_walk_F rsct_walk_F
#define sm_rsc_new rsct_new
#define sm_rsc_free rsct_free
#define sm_rsc_walk rsct_walk
#define sm_rsc_add rsct_add
#define sm_rsc_lookup rsct_lookup
#define sm_rsc_rm rsct_rm
#define sm_rsc_usage rsct_usage
#define sm_rsc_entries rsct_entries
#define sm_rsc_stats rsct_stats

#include "sm/rsc-int.h"

#ifndef RSC_COMPILE
#undef sm_rsc_S
#undef sm_rsc_T
#undef sm_rsc_P
#undef sm_rsc_create_F
#undef sm_rsc_delete_F
#undef sm_rsc_walk_F
#undef sm_rsc_new
#undef sm_rsc_free
#undef sm_rsc_walk
#undef sm_rsc_add
#undef sm_rsc_lookup
#undef sm_rsc_rm
#undef sm_rsc_usage
#undef sm_rsc_entries
#undef sm_rsc_stats
#undef SM_RSC_TYPED
#endif /* ! RSC_COMPILE */

#endif /* SM_RSCT_H */
