/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 * $Id: scdef.h,v 1.1 2005/07/21 20:35:04 ca Exp $
 */

#ifndef SM_SCDEF_H
#define SM_SCDEF_H 1

#include "sm/generic.h"
#include "sm/units.h"

#define SMTPC_PORT 25	/* default port to use */

/* Default SMTPC Id */
#define SMTPC_ID	1

/*
**  RFC 2821:
**     Initial 220 Message: 5 minutes
**     MAIL Command: 5 minutes
**     RCPT Command: 5 minutes
**     DATA Initiation: 2 minutes
**     Data Block: 3 minutes
**     DATA Termination: 10 minutes.
**  The value below is the minimum of all of these.
**  It seems we need different values according to RFC 2821.
*/

#define SC_IO_TIMEOUT 120	/* I/O with SMTP server */

/* Max number of "spare" threads per process per socket */
#define MAX_WAIT_THREADS_DEFAULT 8

/* Min number of "spare" threads per process per socket */
#define MIN_WAIT_THREADS_DEFAULT 2

/* Max number of threads per process per socket */
#define MAX_THREADS_DEFAULT 0	/* determined by system */


#endif /* SM_SCDEF_H */
