/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: sm-conf-u32.h,v 1.4 2005/06/16 00:39:03 ca Exp $
 */

#ifndef SM_CONF_U32_H
#define SM_CONF_U32_H 1

#if SM_LIBCONF_ALONE
#include "sm-conf.h"
#else
#include "sm/sm-conf.h"
#endif

int sm_memtou32(
	char const		*_text,
	size_t			_text_n,
	char			**_endptr,
	int			_base,
	unsigned long		*_val_out);

int sm_conf_u32_scan(
	sm_conf_T		*_smc,
	sm_conf_node_T const	*_node,
	sm_conf_definition_T const *_def,
	char const		*_text,
	size_t			_text_n,
	unsigned long		*_val_out);

int sm_conf_u32_store(
	void			*_data,
	size_t			_size,
	unsigned long		_val);

int sm_conf_u32_load(
	void const		*_data,
	size_t			_size,
	unsigned long		*_val);

#endif	/* SM_CONF_U32_H */
