/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: sm-conf-util.h,v 1.9 2005/06/16 00:39:03 ca Exp $
 */

#ifndef SM_CONF_UTIL_H
#define SM_CONF_UTIL_H 1

#if SM_LIBCONF_ALONE
#include <stdlib.h>
#else
#include "sm/generic.h"
#include "sm/limits.h"
#endif

/* Keep the maximum at 2^32-1, even if we have 64-bit longs. */
#ifndef UINT32_MAX
# define UINT32_MAX 4294967295UL
#endif

#if SM_LIBCONF_ALONE
bool sm_memncaseeq(
	char const	*_a,
	size_t		_a_size,
	char const	*_b,
	size_t		_b_size);
#endif /* SM_LIBCONF_ALONE */

struct sm_conf_definition_S;
struct sm_conf_type_S;

struct sm_conf_definition_S const * sm_conf_subdef(
	struct sm_conf_definition_S const *_def,
	struct sm_conf_type_S const	*_type,
	char const			*_name,
	size_t				_name_n);

struct sm_conf_definition_S const * sm_conf_subdef_prefix(
	struct sm_conf_definition_S const *_def,
	struct sm_conf_type_S const	*_type,
	char const			*_name,
	size_t				_name_n,
	size_t				*_len);

#endif /* ! SM_CONF_UTIL_H */
