/*
 * Copyright (c) 2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: evthr-int.h,v 1.19 2005/10/14 17:48:38 ca Exp $
 */

#ifndef SM_EVTHR_INT_H
#define SM_EVTHR_INT_H 1

#include "sm/generic.h"
#include "sm/evthr.h"

/* maximum size of command sent via pipe: currently only one char */
#define EVTHR_REQ_SIZE	SM_ALIGN4(1)

#define rdpipe(evthr_ctx) ((evthr_ctx)->evthr_c_pipe[0])
#define wrpipe(evthr_ctx) ((evthr_ctx)->evthr_c_pipe[1])
#define SET_MAX(m, n)	do { if ((m) < (n)) (m) = (n); } while (0)
#define SET_MIN(m, n)	do { if ((m) > (n)) (m) = (n); } while (0)

/* Signal Handler Errors; values for evthr_sige_where */
#define EVTHR_SHE_SIGWAIT	1	/* error in sigwait() */
#define EVTHR_SHE_UNKSIG	2	/* unknown signal */

#if EVTHR_DEBUG
# include <stdio.h>
# define DPRINTF(lev, x)	do {				\
	if ((lev) < evthr_ctx->evthr_c_dbglvl)			\
	{							\
		timeval_T tv;					\
		evthr_timeval(evthr_ctx, &tv);			\
		fprintf(stderr, "%ld.%06ld: ", (tv).tv_sec, (tv).tv_usec);\
		fprintf x;					\
	}							\
	} while (0)
#else /* EVTHR_DEBUG */
# define DPRINTF(lev, x)
#endif /* EVTHR_DEBUG */

#endif /* SM_EVTHR_INT_H */
