/*
 * Copyright (c) 2000-2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: assert.c,v 1.8 2005/01/27 00:29:17 ca Exp $")
#include "sm/assert.h"
#include "sm/io.h"
#include "sm/varargs.h"
#include "sm/syslog.h"
#if HAVE_SNPRINTF
# include <stdio.h>	/* for snprintf() */
#endif

/*
**  SM_ABORT -- Call it when you have detected a logic bug.
**
**	Parameters:
**		fmt -- format string.
**		... -- arguments.
**
**	Returns:
**		doesn't.
*/

void
sm_abort(char *fmt, ...)
{
	static bool beenhere = false;
	char msg[128];
	va_list ap;

	if (beenhere)
		abort();

	beenhere = true;
	va_start(ap, fmt);
	sm_vsnprintf(msg, sizeof msg, fmt, ap);
	va_end(ap);
	sm_abort_at(NULL, 0, msg);
}

/*
**  SM_ABORT_AT -- Initiate abnormal program termination.
**
**	This is the low level function that is called to initiate abnormal
**	program termination.  It prints an error message and terminates the
**	program.  It is called by sm_abort and by the assertion macros.
**	If filename != NULL then filename and lineno specify the line of source
**	code at which the bug was detected.
**
**	Parameters:
**		filename -- filename (can be NULL).
**		lineno -- line number.
**		msg -- message.
**
**	Returns:
**		doesn't.
*/

void
sm_abort_at(const char *filename, int lineno, const char *msg)
{
	static bool beenhere = false;

	if (beenhere)
		abort();

	beenhere = true;
	/* XXX */
	syslog(LOG_EMERG, "abort: file: %s, line: %d, msg: %s",
		filename == NULL ? "unknown" : filename, lineno, msg);
	abort();
}
