/*
 * Copyright (c) 2002, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: fputn.c,v 1.7 2005/06/02 19:00:36 ca Exp $")
#include "sm/error.h"
#include "sm/io.h"
#include "sm/assert.h"
#include "io-int.h"
#include "fvwrite.h"

/*
**  SM_IO_FPUTN -- add a string to the buffer for the file pointer
**
**	Parameters:
**		fp -- the file pointer for the buffer to be written to
**		s -- string to be placed in the buffer
**		n -- length of string
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_io_fputn(sm_file_T *fp, const uchar *s, size_t l)
{
	sm_uio_T uio;
	sm_iov_T iov;
	size_t i;
	sm_ret_T ret;

	SM_REQUIRE_ISA(fp, SM_FILE_MAGIC);
	iov.iov_base = (void *) s;
	iov.iov_len = uio.uio_resid = l;
	uio.uio_iov = &iov;
	uio.uio_iovcnt = 1;
	ret = sm_fvwrite(fp, &uio);
	if (sm_is_err(ret))
		return ret;
	for (i = l; i < SM_ALIGN4_SIZE(l); i++)
	{
		ret = sm_putc(fp, '\0');
		if (sm_is_err(ret))
			return ret;
	}
	return SM_SUCCESS;
}
