/*
 * Copyright (c) 2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strputstr.c,v 1.7 2005/06/02 19:00:37 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/varargs.h"
#include "sm/limits.h"
#include "sm/strrcb.h"
#include "sm/str-int.h"
#include "sm/str2rcb.h"

/*
**  SM_STR_CAT -- Append a copy of src to the end of a sm_str_P.
**
**	Parameters:
**		str -- sm_str_P object to append onto.
**		src -- sm_str_P object to append.
**
**	Returns:
**		usual sm_error code; ENOMEM, SM_E_OVFLW_SC, SM_E_OVFLW_NS
*/

sm_ret_T
sm_str_cat(sm_str_P dst, const sm_str_P src)
{
	uint newl;

	SM_IS_BUF(src);
	SM_IS_BUF(dst);
	if (src->sm_str_len == 0)
		return SM_SUCCESS;
	newl = dst->sm_str_len + src->sm_str_len;
	if (newl > dst->sm_str_max || newl < dst->sm_str_len)
		return sm_error_perm(SM_EM_STR, SM_E_OVFLW_SC);
	if (newl > dst->sm_str_size)
		SM_STR_INCREASE_R(dst, newl);
	sm_memcpy(dst->sm_str_base + dst->sm_str_len, src->sm_str_base,
		src->sm_str_len);
	dst->sm_str_len += src->sm_str_len;
	return SM_SUCCESS;
}
