/*
 * Copyright (c) 2000-2002, 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Donn Seeley at UUNET Technologies, Inc.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: vsscanf.c,v 1.9 2004/12/29 23:47:35 ca Exp $")
#include "sm/string.h"
#include "sm/io.h"

/*
**  SM_EOFREAD -- dummy read function for faked file below
**
**	Parameters:
**		fp -- file pointer
**		buf -- location to place read data
**		len -- number of bytes to read
**
**	Returns:
**		0 (zero) always
*/

/* ARGSUSED0 */
static sm_ret_T
sm_eofread(sm_file_T *fp, uchar *buf, size_t len, ssize_t *bytesread)
{
	*bytesread = 0;
	return 0;
}

/*
**  SM_VSSCANF -- scan a string to find data units
**
**	Parameters:
**		str -- strings containing data
**		fmt -- format directive for finding data units
**		ap -- memory locations to place format found data units
**
**	Returns:
**		Failure: SM_IO_EOF
**		Success: number of data units found
**
**	Side Effects:
**		Attempts to strlen() 'str'; if not a '\0' terminated string
**			then the call may SEGV/fail.
**		Faking the string 'str' as a file.
*/

int
sm_vsscanf(const char *str, const char *fmt, va_list ap)
{
	sm_file_T fake;

	fake.sm_magic = SM_FILE_MAGIC;
	fake.f_timeout = SM_TIME_FOREVER;
	f_fd(fake) = -1;
	f_flags(fake) = SMRD;
	f_bfbase(fake) = f_p(fake) = (uchar *)str;
	f_bfsize(fake) = f_r(fake) = strlen(str);
	f_read(fake) = sm_eofread;
	f_write(fake) = NULL;
	f_close(fake) = NULL;
	f_open(fake) = NULL;
	f_seek(fake) = NULL;
	f_setinfo(fake) = f_getinfo(fake) = NULL;
	return sm_vfscanf(&fake, fmt, ap);
}
